library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from ssremote.bin
-- On 1/ 5/2026

entity ssremote is
	port (
	addr: in std_logic_vector(11 downto 0);
	clk: in std_logic;
	din: in std_logic_vector(15 downto 0);
	dout: out std_logic_vector(15 downto 0);
	we: in std_logic);
end ssremote;

architecture syn of ssremote is
   type ram_type is array (0 to 4095) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"60A5", x"01FF", x"B07B", x"7020", x"7021",
   x"E0E7", x"C0CD", x"E0EA", x"500F", x"0000", x"0000", x"609B", x"01A0",
   x"0B00", x"0107", x"0B80", x"0000", x"C0CD", x"01E1", x"E701", x"401B",
   x"0110", x"0000", x"8897", x"C0CD", x"01E1", x"E703", x"4022", x"0110",
   x"0000", x"8897", x"C0CD", x"011C", x"E701", x"5029", x"0120", x"0000",
   x"8897", x"C0CD", x"011C", x"E703", x"5030", x"0120", x"0000", x"8897",
   x"7097", x"3036", x"0000", x"01FF", x"B079", x"1038", x"0100", x"B079",
   x"70E9", x"0300", x"B07A", x"7087", x"3040", x"0000", x"0000", x"6096",
   x"011F", x"A02F", x"3006", x"0000", x"0000", x"604F", x"2006", x"0000",
   x"0000", x"6585", x"2006", x"0000", x"0000", x"607A", x"1006", x"B03C",
   x"6123", x"013F", x"A029", x"B0D1", x"B0D3", x"306E", x"B023", x"0000",
   x"7028", x"B022", x"B400", x"01FF", x"C8D1", x"0C01", x"2058", x"0000",
   x"0000", x"0101", x"B02F", x"7082", x"3070", x"70D3", x"C0D0", x"B0D3",
   x"7022", x"3070", x"0101", x"8881", x"0101", x"C883", x"01FF", x"1F00",
   x"0101", x"C8DA", x"C0CD", x"0101", x"C8E8", x"0100", x"D8E9", x"0100",
   x"B03D", x"1F00", x"6128", x"B023", x"70D4", x"308B", x"0101", x"B037",
   x"70D4", x"B0D1", x"7580", x"B022", x"B030", x"0D01", x"01FF", x"C8D1",
   x"2082", x"0000", x"0000", x"7082", x"3092", x"7022", x"B030", x"0101",
   x"C0D4", x"1093", x"70D4", x"3095", x"B031", x"1F00", x"0100", x"B087",
   x"B097", x"64FA", x"1F00", x"0101", x"8897", x"64FA", x"6532", x"654D",
   x"0100", x"B0E8", x"B0E9", x"B07A", x"1F00", x"60AD", x"60C4", x"6120",
   x"6142", x"6495", x"612D", x"64CA", x"1F00", x"0100", x"B0CD", x"0101",
   x"B0CE", x"0102", x"B0CF", x"01FF", x"B0D0", x"0100", x"B0DA", x"01FF",
   x"B07B", x"0100", x"B079", x"0180", x"B0DB", x"01C1", x"B0EA", x"703F",
   x"0103", x"A03F", x"B0A0", x"1F00", x"0100", x"B080", x"B081", x"01FF",
   x"B082", x"0100", x"B083", x"B084", x"B085", x"B086", x"B087", x"B088",
   x"B089", x"0100", x"B08A", x"0114", x"B08B", x"0100", x"B08C", x"B08D",
   x"B08E", x"B08F", x"0137", x"B090", x"0169", x"B091", x"0137", x"B092",
   x"0131", x"B093", x"0105", x"B094", x"0102", x"B095", x"0100", x"B096",
   x"B097", x"B098", x"B099", x"B09A", x"0101", x"B09A", x"0100", x"B09B",
   x"B09C", x"B09D", x"B09E", x"015A", x"B09F", x"017F", x"B0D9", x"01FC",
   x"0B00", x"0102", x"0B80", x"68CE", x"0100", x"B0F2", x"0100", x"B0F3",
   x"011F", x"B0F4", x"688D", x"70ED", x"B0E2", x"B700", x"70EE", x"B0E3",
   x"B701", x"70EF", x"B0E4", x"B702", x"70F0", x"B0E5", x"B703", x"68CE",
   x"01BC", x"0B00", x"0107", x"0B80", x"0000", x"0000", x"0000", x"0110",
   x"B700", x"0100", x"B701", x"0100", x"B702", x"0100", x"B703", x"1F00",
   x"6123", x"6128", x"1F00", x"0100", x"0800", x"0101", x"0880", x"1F00",
   x"0180", x"0900", x"0101", x"0980", x"1F00", x"7040", x"B02A", x"B032",
   x"7041", x"B02B", x"B033", x"7042", x"B02C", x"B034", x"0100", x"B036",
   x"0101", x"B02F", x"B037", x"0140", x"B035", x"0108", x"B02D", x"708B",
   x"B02E", x"1F00", x"0140", x"B220", x"0102", x"B221", x"0190", x"B222",
   x"0102", x"B223", x"0120", x"B224", x"0104", x"B225", x"0140", x"B226",
   x"0104", x"B227", x"0160", x"B228", x"0104", x"B229", x"0180", x"B22A",
   x"0104", x"B22B", x"01A0", x"B22C", x"0104", x"B22D", x"01C0", x"B22E",
   x"0104", x"B22F", x"01E0", x"B230", x"0104", x"B231", x"0100", x"B232",
   x"0105", x"B233", x"0100", x"B234", x"B235", x"0120", x"0B00", x"0104",
   x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701",
   x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01AA", x"B70C", x"0107",
   x"B70D", x"0175", x"B70E", x"0100", x"B70F", x"014F", x"B710", x"0175",
   x"B711", x"0174", x"B712", x"0170", x"B713", x"0175", x"B714", x"0174",
   x"B715", x"015F", x"B716", x"0153", x"B717", x"016F", x"B718", x"0175",
   x"B719", x"0172", x"B71A", x"0163", x"B71B", x"0165", x"B71C", x"0141",
   x"B71D", x"0100", x"B71E", x"0140", x"0B00", x"0104", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701", x"0102", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01AE", x"B70C", x"0107", x"B70D", x"0175",
   x"B70E", x"0100", x"B70F", x"014F", x"B710", x"0175", x"B711", x"0174",
   x"B712", x"0170", x"B713", x"0175", x"B714", x"0174", x"B715", x"015F",
   x"B716", x"0153", x"B717", x"016F", x"B718", x"0175", x"B719", x"0172",
   x"B71A", x"0163", x"B71B", x"0165", x"B71C", x"0142", x"B71D", x"0100",
   x"B71E", x"0160", x"0B00", x"0104", x"0B80", x"0000", x"0000", x"0000",
   x"01A0", x"B700", x"0120", x"B701", x"0102", x"B702", x"0180", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"01B2", x"B70C", x"0107", x"B70D", x"0175", x"B70E", x"0100",
   x"B70F", x"014F", x"B710", x"0175", x"B711", x"0174", x"B712", x"0170",
   x"B713", x"0175", x"B714", x"0174", x"B715", x"015F", x"B716", x"0153",
   x"B717", x"0169", x"B718", x"016E", x"B719", x"016B", x"B71A", x"0141",
   x"B71B", x"0100", x"B71C", x"0180", x"0B00", x"0104", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701", x"0102", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01B6", x"B70C", x"0107", x"B70D", x"0175",
   x"B70E", x"0100", x"B70F", x"014F", x"B710", x"0175", x"B711", x"0174",
   x"B712", x"0170", x"B713", x"0175", x"B714", x"0174", x"B715", x"015F",
   x"B716", x"0153", x"B717", x"0169", x"B718", x"016E", x"B719", x"016B",
   x"B71A", x"0142", x"B71B", x"0100", x"B71C", x"01A0", x"0B00", x"0104",
   x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0130", x"B701",
   x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01A4", x"B70C", x"0107",
   x"B70D", x"0175", x"B70E", x"0100", x"B70F", x"014F", x"B710", x"0175",
   x"B711", x"0174", x"B712", x"0170", x"B713", x"0175", x"B714", x"0174",
   x"B715", x"0100", x"B716", x"01C0", x"0B00", x"0104", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01BC", x"B70C", x"0107", x"B70D", x"0162",
   x"B70E", x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0173",
   x"B712", x"0177", x"B713", x"0172", x"B714", x"0165", x"B715", x"0176",
   x"B716", x"0169", x"B717", x"0173", x"B718", x"0169", x"B719", x"016F",
   x"B71A", x"016E", x"B71B", x"0100", x"B71C", x"0100", x"B71D", x"01E0",
   x"0B00", x"0104", x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700",
   x"0110", x"B701", x"0102", x"B702", x"0180", x"B703", x"0100", x"B704",
   x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01BE",
   x"B70C", x"0107", x"B70D", x"0162", x"B70E", x"0169", x"B70F", x"0174",
   x"B710", x"0100", x"B711", x"0168", x"B712", x"0177", x"B713", x"0172",
   x"B714", x"0165", x"B715", x"0176", x"B716", x"0169", x"B717", x"0173",
   x"B718", x"0169", x"B719", x"016F", x"B71A", x"016E", x"B71B", x"0100",
   x"B71C", x"0100", x"B71D", x"0100", x"0B00", x"0105", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701", x"0104", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01FC", x"B70C", x"0102", x"B70D", x"0162",
   x"B70E", x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"016E",
   x"B712", x"0176", x"B713", x"0175", x"B714", x"016E", x"B715", x"0169",
   x"B716", x"0174", x"B717", x"016E", x"B718", x"0175", x"B719", x"016D",
   x"B71A", x"0162", x"B71B", x"0165", x"B71C", x"0172", x"B71D", x"0100",
   x"B71E", x"0100", x"B71F", x"0120", x"0B00", x"0105", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701", x"0108", x"B702",
   x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01E9", x"B70C", x"0102", x"B70D", x"0175",
   x"B70E", x"0100", x"B70F", x"0144", x"B710", x"0165", x"B711", x"0162",
   x"B712", x"0175", x"B713", x"0167", x"B714", x"0133", x"B715", x"0132",
   x"B716", x"0100", x"B717", x"0140", x"B200", x"0102", x"B201", x"0190",
   x"B202", x"0102", x"B203", x"0100", x"B204", x"0103", x"B205", x"0120",
   x"B206", x"0103", x"B207", x"0140", x"B208", x"0103", x"B209", x"0100",
   x"B20A", x"B20B", x"01B0", x"B240", x"0100", x"B241", x"0100", x"B242",
   x"0100", x"B243", x"0173", x"B244", x"0174", x"B245", x"0161", x"B246",
   x"016E", x"B247", x"0164", x"B248", x"0161", x"B249", x"0172", x"B24A",
   x"0164", x"B24B", x"0100", x"B24C", x"01B0", x"B290", x"0100", x"B291",
   x"0101", x"B292", x"0100", x"B293", x"0173", x"B294", x"0174", x"B295",
   x"0161", x"B296", x"016E", x"B297", x"0164", x"B298", x"0161", x"B299",
   x"0172", x"B29A", x"0164", x"B29B", x"0100", x"B29C", x"0100", x"0B00",
   x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0130", x"B701",
   x"0101", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01A4", x"B70C", x"0107",
   x"B70D", x"0162", x"B70E", x"0169", x"B70F", x"0174", x"B710", x"0100",
   x"B711", x"014F", x"B712", x"0175", x"B713", x"0174", x"B714", x"0170",
   x"B715", x"0175", x"B716", x"0174", x"B717", x"0100", x"B718", x"0120",
   x"0B00", x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0110",
   x"B701", x"0102", x"B702", x"0100", x"B703", x"0100", x"B704", x"B705",
   x"B706", x"B707", x"0133", x"B708", x"0133", x"B709", x"0111", x"B70A",
   x"0142", x"B70B", x"01A0", x"B70C", x"0107", x"B70D", x"0176", x"B70E",
   x"016F", x"B70F", x"016C", x"B710", x"0174", x"B711", x"0173", x"B712",
   x"0100", x"B713", x"0156", x"B714", x"0146", x"B715", x"0169", x"B716",
   x"0165", x"B717", x"016C", x"B718", x"0164", x"B719", x"0141", x"B71A",
   x"0100", x"B71B", x"0140", x"0B00", x"0103", x"0B80", x"0000", x"0000",
   x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702", x"0100", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"0133", x"B708", x"0133",
   x"B709", x"0111", x"B70A", x"0142", x"B70B", x"01A2", x"B70C", x"0107",
   x"B70D", x"0176", x"B70E", x"016F", x"B70F", x"016C", x"B710", x"0174",
   x"B711", x"0173", x"B712", x"0100", x"B713", x"0156", x"B714", x"0146",
   x"B715", x"0169", x"B716", x"0165", x"B717", x"016C", x"B718", x"0164",
   x"B719", x"0142", x"B71A", x"0100", x"B71B", x"0160", x"0B00", x"0103",
   x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701", x"0108",
   x"B702", x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707",
   x"B708", x"B709", x"B70A", x"B70B", x"01E9", x"B70C", x"0102", x"B70D",
   x"0175", x"B70E", x"0100", x"B70F", x"0144", x"B710", x"0165", x"B711",
   x"0162", x"B712", x"0175", x"B713", x"0167", x"B714", x"0133", x"B715",
   x"0132", x"B716", x"0100", x"B71B", x"1F00", x"0100", x"E086", x"349B",
   x"0101", x"E086", x"34A8", x"0100", x"B0E0", x"0102", x"B0E1", x"0120",
   x"B0DE", x"0102", x"B0DF", x"0105", x"B0DC", x"0106", x"B0DD", x"1F00",
   x"1F00", x"01EE", x"B060", x"B061", x"B062", x"0101", x"B063", x"0100",
   x"B068", x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"01EE", x"B060", x"B061", x"B062", x"0100", x"B063", x"0100",
   x"B068", x"0112", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"1F00", x"64A9", x"64FA", x"6512", x"651F", x"6532", x"654D",
   x"1F00", x"C0CD", x"0200", x"0200", x"B0D2", x"018F", x"B060", x"0100",
   x"B061", x"0100", x"B062", x"B063", x"70D2", x"B068", x"0152", x"B069",
   x"0000", x"B06D", x"0118", x"B060", x"0100", x"B061", x"B062", x"B063",
   x"70D2", x"B068", x"0153", x"B069", x"0000", x"B06D", x"1F00", x"B0A2",
   x"7020", x"B0A1", x"7020", x"C0CD", x"E0A1", x"E0A2", x"24F2", x"0000",
   x"0000", x"1F00", x"0100", x"B063", x"B068", x"0110", x"B069", x"0000",
   x"B06D", x"0164", x"64EF", x"0101", x"B063", x"0100", x"B068", x"0110",
   x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000", x"0164",
   x"64EF", x"1F00", x"0100", x"64D1", x"0101", x"64D1", x"0102", x"64D1",
   x"0103", x"64D1", x"0104", x"64D1", x"0105", x"64D1", x"1F00", x"010F",
   x"B060", x"0180", x"B061", x"0100", x"B062", x"0100", x"B063", x"0100",
   x"B068", x"0190", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"1F00", x"01AA", x"0B00", x"0107", x"0B80", x"01FF", x"0000",
   x"0000", x"B700", x"B701", x"B702", x"B704", x"B705", x"B706", x"01B2",
   x"0B00", x"0107", x"0B80", x"0100", x"0000", x"0000", x"B700", x"B701",
   x"B702", x"B704", x"B705", x"B706", x"1F00", x"01A4", x"0B00", x"0107",
   x"0B80", x"0100", x"0000", x"0000", x"B700", x"B701", x"B702", x"B703",
   x"B704", x"B705", x"1F00", x"68CE", x"0100", x"B0F2", x"B0F3", x"011F",
   x"B0F4", x"0100", x"B0ED", x"B0EE", x"B0EF", x"011B", x"B0F0", x"68AF",
   x"68CE", x"1F00", x"68CE", x"0100", x"B0F2", x"B0F3", x"011F", x"B0F4",
   x"68C3", x"68CE", x"1F00", x"C0CD", x"0200", x"C0CD", x"0200", x"C0CD",
   x"0200", x"C0CD", x"0200", x"C0CD", x"0200", x"C0CD", x"0200", x"1F00",
   x"C0CD", x"0300", x"C0CD", x"0300", x"1F00", x"6120", x"7400", x"B0D5",
   x"01C0", x"A400", x"B0D6", x"0C01", x"3788", x"0140", x"E0D6", x"2598",
   x"0104", x"A0D5", x"3598", x"7400", x"B098", x"7401", x"B099", x"0C02",
   x"01C0", x"E0D6", x"3652", x"0180", x"E0D6", x"36A0", x"0103", x"A0D5",
   x"B0D7", x"01EE", x"E08C", x"B0D8", x"0120", x"A0D5", x"3603", x"70D8",
   x"35EF", x"0101", x"E099", x"4783", x"0107", x"E099", x"5783", x"7098",
   x"0A00", x"7099", x"0A80", x"0103", x"E0D7", x"35DB", x"0102", x"E0D7",
   x"35CA", x"0101", x"E0D7", x"35C2", x"7400", x"B600", x"7001", x"B09A",
   x"0C01", x"1768", x"7400", x"B600", x"7401", x"B601", x"7002", x"B09A",
   x"0C02", x"1768", x"7400", x"B600", x"7401", x"B601", x"7402", x"B602",
   x"7403", x"B603", x"7004", x"B09A", x"0C04", x"0101", x"E08C", x"36AC",
   x"0000", x"0000", x"1768", x"7400", x"B600", x"7401", x"B601", x"7402",
   x"B602", x"7403", x"B603", x"7404", x"B604", x"7405", x"B605", x"7406",
   x"B606", x"7407", x"B607", x"0108", x"B09A", x"0C08", x"1768", x"0102",
   x"E0D7", x"2788", x"7098", x"B068", x"7099", x"B069", x"7400", x"B060",
   x"7401", x"B061", x"7402", x"B062", x"7403", x"B063", x"B06D", x"7004",
   x"B09A", x"0C04", x"1769", x"70D8", x"3646", x"0101", x"E099", x"4783",
   x"0107", x"E099", x"5783", x"7098", x"0A00", x"7099", x"0A80", x"0103",
   x"E0D7", x"3632", x"0102", x"E0D7", x"3626", x"0101", x"E0D7", x"361E",
   x"7600", x"B580", x"0101", x"B09A", x"0D01", x"1769", x"7600", x"B580",
   x"7601", x"B581", x"0102", x"B09A", x"0D02", x"1769", x"7600", x"B580",
   x"7601", x"B581", x"7602", x"B582", x"7603", x"B583", x"0104", x"B09A",
   x"0D04", x"1769", x"7600", x"B580", x"7601", x"B581", x"7602", x"B582",
   x"7603", x"B583", x"7604", x"B584", x"7605", x"B585", x"7606", x"B586",
   x"7607", x"B587", x"0108", x"B09A", x"0D08", x"1769", x"7098", x"B068",
   x"7099", x"B069", x"B06C", x"0102", x"E0D7", x"2788", x"0104", x"B09A",
   x"0D04", x"1769", x"011F", x"A0D5", x"C0DB", x"0A00", x"0100", x"0A80",
   x"0120", x"A0D5", x"369C", x"0110", x"A0D5", x"266A", x"7400", x"B600",
   x"0C01", x"01EB", x"E0D5", x"3667", x"0000", x"0000", x"1772", x"708B",
   x"B02E", x"1772", x"01F7", x"E0D5", x"367E", x"01F8", x"E0D5", x"3682",
   x"01F9", x"E0D5", x"3686", x"01FA", x"E0D5", x"368A", x"01FE", x"E0D5",
   x"3691", x"01FF", x"E0D5", x"3699", x"0C01", x"1772", x"7400", x"B097",
   x"0C01", x"1772", x"7400", x"B098", x"0C01", x"1772", x"7400", x"B099",
   x"0C01", x"1772", x"C0CD", x"7400", x"C898", x"0100", x"D899", x"0C01",
   x"1772", x"7400", x"E09F", x"2697", x"0000", x"0000", x"1000", x"0C01",
   x"1772", x"6120", x"0100", x"1F00", x"7600", x"B580", x"0D01", x"1772",
   x"01BD", x"E0D5", x"36C0", x"01BC", x"E0D5", x"374F", x"01BB", x"E0D5",
   x"3759", x"0000", x"0000", x"1772", x"01FF", x"E0E5", x"26BF", x"68CE",
   x"0100", x"B0F2", x"B0F3", x"011F", x"B0F4", x"72FC", x"B0ED", x"72FD",
   x"B0EE", x"72FE", x"B0EF", x"72FF", x"B0F0", x"68AF", x"68CE", x"1768",
   x"7097", x"B580", x"0100", x"B068", x"0190", x"B069", x"B06C", x"01A0",
   x"0B00", x"0107", x"0B80", x"7060", x"B581", x"B700", x"7061", x"B582",
   x"B701", x"0104", x"B068", x"0190", x"B069", x"B06C", x"0000", x"0000",
   x"0000", x"0000", x"7060", x"B583", x"B702", x"7061", x"B584", x"B703",
   x"0D05", x"01A4", x"0B00", x"0107", x"0B80", x"0000", x"0000", x"7400",
   x"B700", x"7401", x"B701", x"7402", x"B702", x"7403", x"B703", x"7404",
   x"B704", x"7405", x"B705", x"0100", x"679E", x"0101", x"679E", x"0102",
   x"679E", x"0103", x"679E", x"0104", x"679E", x"0105", x"679E", x"678F",
   x"0100", x"67D5", x"0101", x"67D5", x"0102", x"67D5", x"0103", x"67D5",
   x"0104", x"67D5", x"0105", x"67D5", x"678F", x"0105", x"64EF", x"0100",
   x"681C", x"0101", x"681C", x"0102", x"681C", x"0103", x"681C", x"0104",
   x"681C", x"0105", x"681C", x"0100", x"6806", x"0101", x"6806", x"0102",
   x"6806", x"0103", x"6806", x"0104", x"6806", x"0105", x"6806", x"678F",
   x"0105", x"64EF", x"0100", x"67EC", x"0101", x"67EC", x"0102", x"67EC",
   x"0103", x"67EC", x"0104", x"67EC", x"0105", x"67EC", x"0100", x"B2E5",
   x"B2E6", x"0100", x"6836", x"0101", x"6836", x"0102", x"6836", x"0103",
   x"6836", x"0104", x"6836", x"0105", x"6836", x"72E5", x"374A", x"0000",
   x"0108", x"8897", x"010C", x"A2E6", x"8897", x"0C06", x"1772", x"70E2",
   x"B580", x"70E3", x"B581", x"70E4", x"B582", x"70E5", x"B583", x"0D04",
   x"1772", x"6495", x"70DC", x"B580", x"70DD", x"B581", x"70E0", x"B582",
   x"70E1", x"B583", x"70DE", x"B584", x"70DF", x"B585", x"0D06", x"1772",
   x"6853", x"0108", x"A0D5", x"3772", x"C0CD", x"709A", x"C898", x"0100",
   x"D899", x"1772", x"0500", x"A0D9", x"B0D4", x"0580", x"E0CE", x"2786",
   x"0140", x"C0CD", x"E0D4", x"5786", x"0400", x"E0D3", x"5586", x"0000",
   x"678A", x"0100", x"1F00", x"0120", x"8881", x"1788", x"0110", x"8881",
   x"01FF", x"1F00", x"7020", x"B0E6", x"7021", x"B0E7", x"1F00", x"0114",
   x"B068", x"0152", x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000",
   x"0140", x"A063", x"278F", x"0000", x"0000", x"1F00", x"B2E7", x"0000",
   x"0000", x"01A4", x"C2E7", x"0B00", x"0107", x"0B80", x"0000", x"0000",
   x"0000", x"7700", x"B2E8", x"B2B0", x"0102", x"E2E7", x"57B5", x"0000",
   x"7706", x"B2B1", x"770E", x"B2B2", x"17B9", x"7707", x"B2B1", x"770F",
   x"B2B2", x"0000", x"92B1", x"AAE8", x"72B1", x"A2B2", x"0000", x"82E8",
   x"B010", x"72B0", x"A2B1", x"B011", x"01B4", x"C2E7", x"0B00", x"0102",
   x"0B80", x"0000", x"0000", x"0000", x"7010", x"B700", x"7011", x"B706",
   x"7012", x"B70C", x"7013", x"B712", x"1F00", x"B2E7", x"0000", x"0000",
   x"01B4", x"C2E7", x"0B00", x"0102", x"0B80", x"72E7", x"C0CD", x"0200",
   x"0200", x"B068", x"0151", x"B069", x"7700", x"B060", x"7706", x"B061",
   x"0000", x"0000", x"B06D", x"1F00", x"B2E7", x"0000", x"0000", x"01CC",
   x"C2E7", x"0B00", x"0102", x"0B80", x"72E7", x"C0CD", x"0200", x"0200",
   x"B068", x"0151", x"B069", x"0000", x"B06C", x"0000", x"0000", x"0000",
   x"0000", x"7060", x"B700", x"7061", x"B706", x"1F00", x"B2E7", x"0000",
   x"0000", x"01C0", x"C2E7", x"0B00", x"0102", x"0B80", x"72E7", x"C0CD",
   x"0200", x"0200", x"B068", x"0151", x"B069", x"7700", x"B060", x"7706",
   x"B061", x"0000", x"B06D", x"1F00", x"B2E7", x"0000", x"0000", x"01D8",
   x"C2E7", x"0B00", x"0102", x"0B80", x"72E7", x"C0CD", x"0200", x"0200",
   x"B068", x"0151", x"B069", x"0000", x"B06C", x"0000", x"0000", x"0000",
   x"0000", x"7060", x"B700", x"7061", x"B706", x"1F00", x"B2E7", x"0000",
   x"0000", x"01CC", x"C2E7", x"0B00", x"0102", x"0B80", x"0000", x"0000",
   x"0000", x"7700", x"B014", x"7706", x"B015", x"770C", x"B016", x"7712",
   x"B017", x"0000", x"0000", x"0000", x"0000", x"7014", x"9015", x"8AE5",
   x"7016", x"8AE6", x"1F00", x"0108", x"B068", x"0111", x"B069", x"01FF",
   x"B060", x"B061", x"B062", x"B063", x"0000", x"0000", x"B06D", x"1F00",
   x"B0D2", x"0108", x"B068", x"0110", x"B069", x"70D2", x"B060", x"0100",
   x"B061", x"B062", x"B063", x"B06D", x"70D2", x"1F00", x"0B00", x"0100",
   x"0B80", x"0108", x"B068", x"0110", x"B069", x"7700", x"B060", x"7701",
   x"B061", x"7702", x"B062", x"0100", x"B063", x"B06D", x"1F00", x"0108",
   x"B068", x"0110", x"B069", x"72ED", x"B060", x"72EE", x"B061", x"72EF",
   x"B062", x"0100", x"B063", x"B06D", x"1F00", x"0102", x"E0EC", x"3897",
   x"0102", x"B0EC", x"0100", x"B07D", x"0103", x"68F8", x"6900", x"0100",
   x"68F8", x"B0ED", x"0100", x"68F8", x"B0EE", x"0100", x"68F8", x"B0EF",
   x"0100", x"68F8", x"B0F0", x"1F00", x"0100", x"B07D", x"01AB", x"68F8",
   x"6900", x"0100", x"68F8", x"B0ED", x"01FF", x"B07D", x"1F00", x"0103",
   x"E0EC", x"38BA", x"0103", x"B0EC", x"6911", x"0100", x"B07D", x"0102",
   x"68F8", x"6900", x"70ED", x"68F8", x"70EE", x"68F8", x"70EF", x"68F8",
   x"70F0", x"68F8", x"1F00", x"6911", x"0100", x"B07D", x"01D8", x"68F8",
   x"6900", x"01FF", x"68DB", x"0101", x"B0EC", x"1F00", x"0103", x"E0EC",
   x"38D6", x"01FF", x"B07D", x"0101", x"B0EC", x"1F00", x"0101", x"68DB",
   x"0101", x"B0EC", x"1F00", x"B0F6", x"010A", x"B0F7", x"01FF", x"B07D",
   x"693C", x"6907", x"A0CE", x"38F2", x"0000", x"0101", x"6921", x"01FF",
   x"C8F7", x"28E1", x"0000", x"0000", x"01FF", x"C8F6", x"28E1", x"0000",
   x"0000", x"18F5", x"6919", x"0000", x"1F00", x"0104", x"8881", x"1F00",
   x"B07E", x"0000", x"0102", x"A07D", x"28F9", x"707E", x"B0F1", x"1F00",
   x"70F4", x"68F8", x"70F3", x"68F8", x"70F2", x"68F8", x"1F00", x"0100",
   x"B07D", x"0105", x"68F8", x"0100", x"68F8", x"01FF", x"B07D", x"70F1",
   x"1F00", x"0100", x"B07D", x"0106", x"68F8", x"0101", x"B07D", x"693C",
   x"1F00", x"0100", x"B07D", x"0104", x"68F8", x"0101", x"B07D", x"693C",
   x"1F00", x"B0F8", x"0132", x"B0F9", x"01C8", x"B0FA", x"0000", x"0000",
   x"0000", x"01FF", x"C8FA", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"2929", x"01FF", x"C8F9", x"2924", x"01FF", x"C8F8",
   x"2922", x"0000", x"0000", x"1F00", x"010C", x"B0F9", x"0000", x"0000",
   x"01FF", x"C8F9", x"0000", x"0000", x"0000", x"2940", x"0000", x"0000",
   x"1F00", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"CDAB"
);

signal daddr: std_logic_vector(11 downto 0);

begin
   assremote: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (we = '1') then
            RAM(conv_integer(addr)) <= din;
         end if;
         daddr <= addr;
      end if; -- clk 
   end process;

   dout <= RAM(conv_integer(daddr));
end;
