library IEEE;
use IEEE.std_logic_1164.all;  -- defines std_logic types
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

use work.IDROMConst.all;

package PIN_georgeconf_96 is
	constant ModuleID : ModuleIDType :=( 
--		Module tag				Version	Clock tag		Count		Base Address					Number of regs 			Strides	MPBitMask
		(WatchDogTag,			x"00",	ClockLowTag,	x"01",	WatchDogTimeAddr&PadT,		WatchDogNumRegs,			x"00",	WatchDogMPBitMask),
		(IOPortTag,				x"00",	ClockLowTag,	x"04",	PortAddr&PadT,					IOPortNumRegs,				x"00",	IOPortMPBitMask),
		(SSerialTag,			x"00",	ClockLowTag,	x"01",	SSerialCommandAddr&PadT,	SSerialNumRegs,			x"10",	SSerialMPBitMask),
		(MuxedQcountTag,		x"02",	ClockLowTag,	x"0E",	MuxedQcounterAddr&PadT,		MuxedQCounterNumRegs,	x"00",	MuxedQCounterMPBitMask),
		(MuxedQCountSelTag,	x"00",	ClockLowTag,	x"01",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(PWMTag,					x"00",	ClockHighTag,	x"04",	PWMValAddr&PadT,				PWMNumRegs,					x"00",	PWMMPBitMask),
		(LEDTag,					x"00",	ClockLowTag,	x"01",	LEDAddr&PadT,					LEDNumRegs,					x"00",	LEDMPBitMask),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000"),
		(NullTag,				x"00",	NullTag,			x"00",	NullAddr&PadT,					x"00",						x"00",	x"00000000")
		);
		
	constant PinDesc : PinDescType :=(
-- 	Base func  sec unit sec func 	 sec pin		

		IOPortTag & x"01" & MuxedQCountTag & x"02",
		IOPortTag & x"01" & MuxedQCountTag & x"01",
		IOPortTag & x"00" & MuxedQCountTag & x"02",
		IOPortTag & x"00" & MuxedQCountTag & x"01",
		IOPortTag & x"01" & MuxedQCountTag & x"03",
		IOPortTag & x"00" & MuxedQCountTag & x"03",
		IOPortTag & x"01" & PWMTag & x"81",
		IOPortTag & x"00" & PWMTag & x"81",
		IOPortTag & x"01" & PWMTag & x"82",
		IOPortTag & x"00" & PWMTag & x"82",
		IOPortTag & x"01" & PWMTag & x"83",
		IOPortTag & x"00" & PWMTag & x"83",
		IOPortTag & x"03" & MuxedQCountTag & x"02",
		IOPortTag & x"03" & MuxedQCountTag & x"01",
		IOPortTag & x"02" & MuxedQCountTag & x"02",
		IOPortTag & x"02" & MuxedQCountTag & x"01",
		IOPortTag & x"03" & MuxedQCountTag & x"03",
		IOPortTag & x"02" & MuxedQCountTag & x"03",
		IOPortTag & x"03" & PWMTag & x"81",
		IOPortTag & x"02" & PWMTag & x"81",
		IOPortTag & x"03" & PWMTag & x"82",
		IOPortTag & x"02" & PWMTag & x"82",
		IOPortTag & x"03" & PWMTag & x"83",
		IOPortTag & x"02" & PWMTag & x"83",

		IOPortTag & x"00" & SSerialTag & SSerialTXEN3Pin,
		IOPortTag & x"04" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"04" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"04" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"05" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"05" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"05" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"06" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"06" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"06" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"08" & MuxedQCountSelTag & MuxedQCountSel0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX5Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX5Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX4Pin,
		IOPortTag & x"00" & SSerialTag & SSerialRX4Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX3Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX3Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialTX2Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX2Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX1Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX1Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialTX0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialRX0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTXEN0Pin,
					
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",

		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin, -- added for IDROM v3
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin);					

end package PIN_georgeconf_96;

