library IEEE;
use IEEE.std_logic_1164.all;  -- defines std_logic types
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

use work.IDROMConst.all;

package PIN_georgeconf is
	constant ModuleID : ModuleIDType :=( 
		(WatchDogTag,		x"00",	ClockLowTag,			x"01",	WatchDogTimeAddr&PadT,			WatchDogNumRegs,			x"00",	WatchDogMPBitMask),
		(IOPortTag,		x"00",	ClockLowTag,			x"03",	PortAddr&PadT,				IOPortNumRegs,				x"00",	IOPortMPBitMask),
		(SSerialTag,		x"00",	ClockLowTag,			x"01",	SSerialCommandAddr&PadT,		SSerialNumRegs,				x"00",	SSerialMPBitMask),
		(MuxedQcountTag,	x"02",	ClockLowTag,			x"06",	MuxedQcounterAddr&PadT,			MuxedQCounterNumRegs,x"00",		MuxedQCounterMPBitMask),
		(MuxedQCountSelTag,	x"00",	ClockLowTag,			x"01",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(PWMTag,		x"00",	ClockHighTag,			x"0C",	PWMValAddr&PadT,			PWMNumRegs,				x"00",	PWMMPBitMask),
		(QcountTag,		x"02",	ClockLowTag,			x"08",	QcounterAddr&PadT,			QCounterNumRegs,			x"00",	QCounterMPBitMask),
		(LEDTag,		x"00",	ClockLowTag,			x"01",	LEDAddr&PadT,				LEDNumRegs,				x"00",	LEDMPBitMask),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000"),
		(NullTag,		x"00",	NullTag,			x"00",	NullAddr&PadT,				x"00",					x"00",	x"00000000")
		);
		
	constant PinDesc : PinDescType :=(
-- 	Base func  sec unit sec func 	 sec pin		

		IOPortTag & x"01" & QCountTag & x"02",
		IOPortTag & x"01" & QCountTag & x"01",
		IOPortTag & x"00" & QCountTag & x"02",
		IOPortTag & x"00" & QCountTag & x"01",
		IOPortTag & x"01" & QCountTag & x"03",
		IOPortTag & x"00" & QCountTag & x"03",
		IOPortTag & x"01" & PWMTag & x"81",
		IOPortTag & x"00" & PWMTag & x"81",
		IOPortTag & x"01" & PWMTag & x"82",
		IOPortTag & x"00" & PWMTag & x"82",
		IOPortTag & x"01" & PWMTag & x"83",
		IOPortTag & x"00" & PWMTag & x"83",
		IOPortTag & x"03" & QCountTag & x"02",
		IOPortTag & x"03" & QCountTag & x"01",
		IOPortTag & x"02" & QCountTag & x"02",
		IOPortTag & x"02" & QCountTag & x"01",
		IOPortTag & x"03" & QCountTag & x"03",
		IOPortTag & x"02" & QCountTag & x"03",
		IOPortTag & x"03" & PWMTag & x"81",
		IOPortTag & x"02" & PWMTag & x"81",
		IOPortTag & x"03" & PWMTag & x"82",
		IOPortTag & x"02" & PWMTag & x"82",
		IOPortTag & x"03" & PWMTag & x"83",
		IOPortTag & x"02" & PWMTag & x"83",

		IOPortTag & x"00" & SSerialTag & SSerialTXEN3Pin,
		IOPortTag & x"00" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"00" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"00" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"01" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"01" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"01" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"02" & MuxedQCountTag & MuxedQCountQAPin,
		IOPortTag & x"02" & MuxedQCountTag & MuxedQCountQBPin,
		IOPortTag & x"02" & MuxedQCountTag & MuxedQCountIDXPin,
		IOPortTag & x"00" & MuxedQCountSelTag & MuxedQCountSel0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX5Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX5Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX4Pin,
		IOPortTag & x"00" & SSerialTag & SSerialRX4Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX3Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX3Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialTX2Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX2Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTX1Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialRX1Pin,
 		IOPortTag & x"00" & SSerialTag & SSerialTX0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialRX0Pin,
		IOPortTag & x"00" & SSerialTag & SSerialTXEN0Pin,
					
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",
		IOPortTag & x"00" & NullTag & x"00",

		emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,
		emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin,emptypin);

end package PIN_georgeconf;

