library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from sslbp.bin
-- On 10/27/2023

entity sslbpb is
	port (
	addra: in std_logic_vector(11 downto 0);
	addrb: in std_logic_vector(11 downto 0);
	clk: in std_logic;
	dina: in std_logic_vector(15 downto 0);
	douta: out std_logic_vector(15 downto 0);
	doutb: out std_logic_vector(15 downto 0);
	wea: in std_logic);
end sslbpb;

architecture syn of sslbpb is
   type ram_type is array (0 to 4095) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"0100", x"0800", x"0880", x"0002", x"0100",
   x"B400", x"0C01", x"0480", x"0300", x"0300", x"4007", x"0100", x"0800",
   x"0104", x"0880", x"0002", x"0100", x"B400", x"0C01", x"0480", x"0300",
   x"0300", x"0300", x"0300", x"4013", x"B203", x"0101", x"B02A", x"01FF",
   x"B02C", x"7234", x"B008", x"0138", x"B009", x"0149", x"B00A", x"0132",
   x"B00B", x"0130", x"B00C", x"0137", x"B00D", x"0149", x"B00E", x"0136",
   x"B00F", x"0134", x"B010", x"0112", x"B000", x"0102", x"B002", x"0131",
   x"B003", x"0108", x"B001", x"0100", x"B004", x"0104", x"B005", x"0140",
   x"B006", x"01D8", x"B007", x"0100", x"0800", x"0104", x"0880", x"0002",
   x"7008", x"B045", x"01A0", x"B438", x"0125", x"B439", x"0126", x"B43A",
   x"0100", x"B43B", x"0C40", x"0002", x"0002", x"01FF", x"C845", x"204A",
   x"0100", x"B04F", x"B200", x"7049", x"3729", x"704F", x"8053", x"8059",
   x"3728", x"7222", x"E05D", x"B066", x"7222", x"B05D", x"0100", x"0800",
   x"0104", x"0880", x"0180", x"0A00", x"0102", x"0A80", x"0100", x"0B00",
   x"0103", x"0B80", x"0101", x"B050", x"01FE", x"B051", x"7008", x"B044",
   x"7053", x"A050", x"309D", x"01FF", x"01C1", x"B421", x"680A", x"0100",
   x"B41E", x"B41F", x"B420", x"B42B", x"B432", x"B720", x"B721", x"B722",
   x"B723", x"B740", x"B741", x"B742", x"B743", x"B760", x"B761", x"B762",
   x"B763", x"B620", x"B628", x"7051", x"A853", x"7051", x"A852", x"7050",
   x"8855", x"7050", x"8854", x"7051", x"A856", x"7052", x"A050", x"36D6",
   x"01A7", x"C41E", x"0D80", x"0000", x"0000", x"0000", x"1F00", x"11B3",
   x"11BC", x"11C0", x"11CC", x"11D2", x"15B8", x"15C0", x"126D", x"1275",
   x"127C", x"1282", x"128A", x"129C", x"12A2", x"12B8", x"12BE", x"12C6",
   x"12CE", x"12D6", x"12DE", x"12E6", x"12EE", x"12F6", x"132C", x"135E",
   x"1369", x"1371", x"137B", x"1382", x"1388", x"13BC", x"13CE", x"13D9",
   x"13E1", x"13E8", x"13EE", x"1401", x"1407", x"140F", x"1424", x"1431",
   x"1438", x"1442", x"1450", x"145A", x"1462", x"1474", x"1481", x"1488",
   x"1495", x"149C", x"14A6", x"14AE", x"14B7", x"14C1", x"14C9", x"14DC",
   x"14EA", x"1129", x"1141", x"10EB", x"1100", x"1174", x"1189", x"14F1",
   x"1565", x"15C7", x"1670", x"7056", x"A050", x"30FF", x"741F", x"8C20",
   x"0100", x"B41F", x"68D2", x"01BD", x"68F3", x"7720", x"68F3", x"7721",
   x"68F3", x"7722", x"68F3", x"7723", x"68F6", x"013D", x"B41E", x"16D6",
   x"743C", x"6862", x"3122", x"7051", x"A856", x"7400", x"B740", x"7401",
   x"B741", x"7402", x"B742", x"7403", x"B743", x"8402", x"3111", x"0101",
   x"8C21", x"7406", x"B720", x"7407", x"B721", x"7404", x"B722", x"7405",
   x"B723", x"741F", x"211D", x"7051", x"A857", x"7051", x"A858", x"013C",
   x"B41E", x"1128", x"68AF", x"5128", x"7051", x"A856", x"013C", x"B41E",
   x"16D6", x"741F", x"8C20", x"0100", x"B41F", x"7050", x"8859", x"68D2",
   x"01BD", x"68F3", x"743D", x"B04E", x"313D", x"0003", x"0100", x"68F3",
   x"01FF", x"C84E", x"2136", x"0003", x"0003", x"68F8", x"013B", x"B41E",
   x"16D6", x"743C", x"6862", x"3167", x"7222", x"E42F", x"B43E", x"017F",
   x"AC21", x"7051", x"A854", x"7051", x"A855", x"7056", x"A050", x"3164",
   x"0114", x"C43E", x"B431", x"7432", x"3158", x"0142", x"B41E", x"1163",
   x"0180", x"E42B", x"215E", x"013C", x"B41E", x"1163", x"0174", x"E42B",
   x"2163", x"013E", x"B41E", x"1166", x"013A", x"B41E", x"1173", x"68AF",
   x"5173", x"7056", x"A050", x"316E", x"7051", x"A856", x"0180", x"A420",
   x"2173", x"013A", x"B41E", x"16D6", x"7056", x"A050", x"3188", x"741F",
   x"8C20", x"0100", x"B41F", x"68D2", x"01BD", x"68F3", x"7720", x"68F3",
   x"7721", x"68F3", x"7722", x"68F3", x"68F2", x"68F8", x"013F", x"B41E",
   x"16D6", x"743C", x"6862", x"31AC", x"7051", x"A856", x"7400", x"B720",
   x"7401", x"B721", x"7402", x"B722", x"0108", x"A403", x"3199", x"0101",
   x"8C21", x"0100", x"B723", x"7404", x"B740", x"7405", x"B741", x"7406",
   x"B742", x"7407", x"B743", x"741F", x"21A7", x"7051", x"A857", x"7051",
   x"A858", x"013E", x"B41E", x"11B2", x"68AF", x"51B2", x"7051", x"A856",
   x"013E", x"B41E", x"16D6", x"680A", x"0100", x"B628", x"B620", x"0101",
   x"B41E", x"7064", x"B431", x"16D6", x"68FD", x"0102", x"B41E", x"16D6",
   x"7222", x"E42F", x"B031", x"7223", x"F430", x"B032", x"7431", x"E031",
   x"41CB", x"0103", x"B41E", x"16D6", x"68D2", x"01DF", x"68F6", x"0104",
   x"B41E", x"16D6", x"68AF", x"51D7", x"0101", x"B41E", x"126C", x"0101",
   x"6862", x"326C", x"015A", x"E400", x"21E0", x"0105", x"B41E", x"126C",
   x"7423", x"E429", x"41E6", x"0101", x"CC23", x"11E8", x"0180", x"6921",
   x"0102", x"6921", x"0100", x"E42E", x"21F5", x"01A0", x"B438", x"0125",
   x"B439", x"0126", x"B43A", x"0100", x"B43B", x"0101", x"E42E", x"2200",
   x"0140", x"B438", x"014B", x"B439", x"014C", x"B43A", x"0100", x"B43B",
   x"0102", x"E42E", x"220B", x"0180", x"B438", x"0196", x"B439", x"0198",
   x"B43A", x"0100", x"B43B", x"0103", x"E42E", x"2218", x"0100", x"B438",
   x"012D", x"B439", x"0131", x"B43A", x"0101", x"B43B", x"01FF", x"B42E",
   x"7438", x"B035", x"7439", x"B036", x"743A", x"B037", x"743B", x"B038",
   x"6815", x"6815", x"6815", x"6815", x"0100", x"B033", x"B034", x"B039",
   x"B03A", x"7230", x"B03B", x"7231", x"B03C", x"7232", x"B03D", x"7233",
   x"B03E", x"6827", x"7033", x"B608", x"7034", x"B610", x"7035", x"B618",
   x"0100", x"B037", x"B038", x"B039", x"B03A", x"7230", x"B033", x"7231",
   x"B034", x"7232", x"B035", x"7233", x"B036", x"7438", x"B03B", x"7439",
   x"B03C", x"743A", x"B03D", x"743B", x"B03E", x"681E", x"6827", x"7034",
   x"3253", x"01FF", x"B033", x"0001", x"0001", x"0120", x"B638", x"7033",
   x"B640", x"B620", x"0100", x"B628", x"0101", x"B41E", x"0101", x"CC2E",
   x"7423", x"E429", x"4266", x"0101", x"CC23", x"1268", x"0180", x"6921",
   x"0102", x"6921", x"0101", x"B41E", x"16D6", x"68D2", x"01E1", x"68F3",
   x"68F2", x"68F8", x"0108", x"B41E", x"16D6", x"6861", x"327A", x"0109",
   x"B41E", x"127B", x"68BE", x"16D6", x"68D2", x"01C1", x"68F6", x"010A",
   x"B41E", x"16D6", x"0101", x"6862", x"3288", x"010B", x"B41E", x"1289",
   x"68BE", x"16D6", x"7400", x"228F", x"010C", x"B41E", x"129B", x"0140",
   x"6921", x"7428", x"E429", x"4297", x"0101", x"CC28", x"1299", x"0180",
   x"6921", x"0101", x"B41E", x"16D6", x"68D2", x"01BC", x"68F6", x"010D",
   x"B41E", x"16D6", x"0104", x"6862", x"32B0", x"7400", x"B720", x"7401",
   x"B721", x"7402", x"B722", x"7403", x"B723", x"010E", x"B41E", x"12B7",
   x"68AF", x"52B7", x"010F", x"E048", x"22B7", x"010E", x"B41E", x"16D6",
   x"68D2", x"01D0", x"68F6", x"010F", x"B41E", x"16D6", x"0101", x"6862",
   x"32C4", x"0110", x"B41E", x"12C5", x"68BE", x"16D6", x"7400", x"B434",
   x"68D2", x"01D1", x"68F6", x"0111", x"B41E", x"16D6", x"0101", x"6862",
   x"32D4", x"0112", x"B41E", x"12D5", x"68BE", x"16D6", x"7400", x"B435",
   x"68D2", x"01D2", x"68F6", x"0113", x"B41E", x"16D6", x"0101", x"6862",
   x"32E4", x"0114", x"B41E", x"12E5", x"68BE", x"16D6", x"7400", x"B436",
   x"68D2", x"01D3", x"68F6", x"0115", x"B41E", x"16D6", x"0101", x"6862",
   x"32F4", x"0116", x"B41E", x"12F5", x"68BE", x"16D6", x"0117", x"B41E",
   x"7434", x"B740", x"7435", x"B741", x"7436", x"B742", x"7400", x"B437",
   x"B743", x"7009", x"E434", x"B030", x"0001", x"700A", x"F435", x"8830",
   x"0001", x"700B", x"F436", x"8830", x"0001", x"700C", x"F437", x"8030",
   x"232B", x"0180", x"B42B", x"0108", x"B43C", x"0104", x"B43D", x"0109",
   x"E048", x"231E", x"01BF", x"AC21", x"0127", x"B41E", x"010F", x"E048",
   x"232B", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"16D6", x"7400", x"B437", x"700D", x"E434",
   x"B030", x"0001", x"700E", x"F435", x"8830", x"0001", x"700F", x"F436",
   x"8830", x"0001", x"7010", x"F437", x"8030", x"2359", x"0174", x"B42B",
   x"0108", x"B43C", x"0104", x"B43D", x"0109", x"E048", x"234B", x"01BE",
   x"AC21", x"0118", x"B41E", x"010F", x"E048", x"2358", x"013E", x"AC21",
   x"7051", x"A854", x"7051", x"A855", x"7065", x"B431", x"0140", x"B41E",
   x"135D", x"01FF", x"B432", x"011A", x"B41E", x"16D6", x"68D2", x"01BD",
   x"68F3", x"68F2", x"68F2", x"68F2", x"0108", x"68F6", x"0119", x"B41E",
   x"16D6", x"743C", x"6862", x"336F", x"013A", x"B41E", x"1370", x"68BE",
   x"16D6", x"68D2", x"01E6", x"68F3", x"7700", x"7703", x"68F3", x"68F8",
   x"011B", x"B41E", x"16D6", x"6861", x"3380", x"011C", x"B41E", x"1381",
   x"68BE", x"16D6", x"68D2", x"01BB", x"68F6", x"011D", x"B41E", x"16D6",
   x"0106", x"6862", x"33AC", x"7400", x"B43C", x"7401", x"B43D", x"7402",
   x"B760", x"7403", x"B761", x"7404", x"B762", x"7405", x"B763", x"0109",
   x"E048", x"239E", x"01BF", x"AC21", x"011E", x"B41E", x"010F", x"E048",
   x"23AB", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"13BB", x"68AF", x"53BB", x"010F", x"E048",
   x"23BB", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"16D6", x"68D2", x"01BD", x"68F3", x"743D",
   x"B04E", x"33CA", x"0003", x"0100", x"68F3", x"01FF", x"C84E", x"23C3",
   x"0003", x"0003", x"68F8", x"011F", x"B41E", x"16D6", x"743C", x"6862",
   x"33D4", x"0120", x"B41E", x"13D8", x"68AF", x"53D8", x"011E", x"B41E",
   x"16D6", x"68D2", x"01E7", x"68F3", x"68F0", x"68F8", x"0121", x"B41E",
   x"16D6", x"6861", x"33E6", x"0122", x"B41E", x"13E7", x"68BE", x"16D6",
   x"68D2", x"01C7", x"68F6", x"0123", x"B41E", x"16D6", x"0101", x"6862",
   x"33FF", x"7400", x"23F6", x"0124", x"B41E", x"13FE", x"0101", x"CC2D",
   x"23FC", x"7051", x"A855", x"13FE", x"0122", x"B41E", x"1400", x"68BE",
   x"16D6", x"68D2", x"01D7", x"68F6", x"0125", x"B41E", x"16D6", x"0101",
   x"6862", x"340D", x"0126", x"B41E", x"140E", x"68BE", x"16D6", x"7400",
   x"2416", x"01FE", x"AC21", x"013A", x"B41E", x"1423", x"B433", x"7428",
   x"E429", x"441D", x"0101", x"CC28", x"141F", x"0180", x"6921", x"0140",
   x"6921", x"0124", x"B41E", x"16D6", x"68D2", x"0165", x"68F3", x"0154",
   x"68F3", x"0108", x"68F3", x"68F0", x"68F0", x"68F8", x"0128", x"B41E",
   x"16D6", x"6861", x"3436", x"0129", x"B41E", x"1437", x"68BE", x"16D6",
   x"68D2", x"0145", x"68F3", x"0154", x"68F3", x"0108", x"68F6", x"012A",
   x"B41E", x"16D6", x"0102", x"6862", x"344E", x"7400", x"8401", x"244B",
   x"012B", x"B41E", x"144D", x"0129", x"B41E", x"144F", x"68BE", x"16D6",
   x"68D2", x"0145", x"68F3", x"0152", x"68F3", x"0108", x"68F6", x"012C",
   x"B41E", x"16D6", x"0102", x"6862", x"3460", x"012D", x"B41E", x"1461",
   x"68BE", x"16D6", x"7400", x"8401", x"B433", x"2469", x"012E", x"B41E",
   x"1473", x"7428", x"E429", x"446F", x"0101", x"CC28", x"1471", x"0180",
   x"6921", x"0140", x"6921", x"16D6", x"68D2", x"0165", x"68F3", x"0160",
   x"68F3", x"0108", x"68F3", x"68F2", x"68F2", x"68F8", x"012F", x"B41E",
   x"16D6", x"6861", x"3486", x"0130", x"B41E", x"1487", x"68BE", x"16D6",
   x"68D2", x"0165", x"68F3", x"0104", x"68F3", x"0108", x"68F3", x"68F0",
   x"68F0", x"68F8", x"0131", x"B41E", x"16D6", x"6861", x"349A", x"0132",
   x"B41E", x"149B", x"68BE", x"16D6", x"68D2", x"0145", x"68F3", x"01FE",
   x"68F3", x"0108", x"68F6", x"0133", x"B41E", x"16D6", x"0102", x"6862",
   x"34AC", x"0134", x"B41E", x"14AD", x"68BE", x"16D6", x"7400", x"8401",
   x"24B4", x"0132", x"B41E", x"14B6", x"0135", x"B41E", x"16D6", x"68D2",
   x"0145", x"68F3", x"0152", x"68F3", x"0108", x"68F6", x"0136", x"B41E",
   x"16D6", x"0102", x"6862", x"34C7", x"0137", x"B41E", x"14C8", x"68BE",
   x"16D6", x"7400", x"8401", x"24D1", x"01FE", x"AC21", x"0138", x"B41E",
   x"14DB", x"7428", x"E429", x"44D7", x"0101", x"CC28", x"14D9", x"0180",
   x"6921", x"0140", x"6921", x"16D6", x"68D2", x"0165", x"68F3", x"015C",
   x"68F3", x"0108", x"68F3", x"01F4", x"68F3", x"0101", x"68F6", x"0139",
   x"B41E", x"16D6", x"6861", x"34EF", x"013A", x"B41E", x"14F0", x"68BE",
   x"16D6", x"7056", x"A050", x"3564", x"741F", x"8C20", x"0100", x"B41F",
   x"7700", x"B04C", x"7703", x"B04B", x"7701", x"B04D", x"0140", x"A04B",
   x"2504", x"7051", x"A856", x"16D6", x"68D2", x"704B", x"68F3", x"0103",
   x"A04B", x"B046", x"0001", x"0101", x"B047", x"7046", x"3514", x"01FF",
   x"C846", x"7047", x"C847", x"150D", x"01BF", x"E04B", x"5556", x"0104",
   x"A04B", x"351F", x"0003", x"704C", x"68F3", x"704D", x"68F3", x"0120",
   x"A04B", x"3553", x"0100", x"B42A", x"0108", x"E047", x"2538", x"0003",
   x"7720", x"68F3", x"7721", x"68F3", x"7722", x"68F3", x"7723", x"68F3",
   x"7740", x"68F3", x"7741", x"68F3", x"7742", x"68F3", x"7743", x"68F3",
   x"0104", x"E047", x"2544", x"0003", x"7720", x"68F3", x"7721", x"68F3",
   x"7722", x"68F3", x"7723", x"68F3", x"0102", x"E047", x"254C", x"0003",
   x"7720", x"68F3", x"7721", x"68F3", x"0101", x"E047", x"2552", x"0003",
   x"7720", x"68F3", x"1555", x"7047", x"B42A", x"1561", x"0120", x"A04B",
   x"355F", x"0003", x"7720", x"68F3", x"0100", x"B42A", x"1561", x"0101",
   x"B42A", x"68F8", x"0141", x"B41E", x"16D6", x"742A", x"6862", x"35B1",
   x"7051", x"A856", x"0108", x"E42A", x"257D", x"7400", x"B720", x"7401",
   x"B721", x"7402", x"B722", x"7403", x"B723", x"7404", x"B740", x"7405",
   x"B741", x"7406", x"B742", x"7407", x"B743", x"0104", x"E42A", x"258D",
   x"7400", x"B720", x"7401", x"B721", x"7402", x"B722", x"7403", x"B723",
   x"0100", x"B740", x"B741", x"B742", x"B743", x"0102", x"E42A", x"259B",
   x"7400", x"B720", x"7401", x"B721", x"0100", x"B722", x"B723", x"B740",
   x"B741", x"B742", x"B743", x"0101", x"E42A", x"25A8", x"7400", x"B720",
   x"0100", x"B721", x"B722", x"B723", x"B740", x"B741", x"B742", x"B743",
   x"741F", x"25AC", x"7051", x"A857", x"7051", x"A858", x"0140", x"B41E",
   x"15B7", x"68AF", x"55B7", x"7051", x"A856", x"0140", x"B41E", x"16D6",
   x"68D2", x"01EB", x"68F3", x"0128", x"68F6", x"0106", x"B41E", x"16D6",
   x"6861", x"35C5", x"0107", x"B41E", x"15C6", x"68BE", x"16D6", x"7056",
   x"A050", x"366F", x"741F", x"8C20", x"0100", x"B41F", x"743D", x"902C",
   x"0900", x"68D2", x"01BD", x"68F3", x"743D", x"366C", x"0D02", x"7720",
   x"68F3", x"0500", x"366C", x"0D01", x"7721", x"68F3", x"0500", x"366C",
   x"0D01", x"7722", x"68F3", x"0500", x"366C", x"0D01", x"7723", x"68F3",
   x"0500", x"366C", x"0D01", x"7740", x"68F3", x"0500", x"366C", x"0D01",
   x"7741", x"68F3", x"0500", x"366C", x"0D01", x"7742", x"68F3", x"0500",
   x"366C", x"0D01", x"7743", x"68F3", x"0500", x"366C", x"0D01", x"7760",
   x"68F3", x"0500", x"366C", x"0D01", x"7761", x"68F3", x"0500", x"366C",
   x"0D01", x"7762", x"68F3", x"0500", x"366C", x"0D01", x"7763", x"68F3",
   x"0500", x"366C", x"0700", x"B067", x"0780", x"B068", x"0000", x"0000",
   x"0F40", x"0F40", x"0D01", x"7700", x"68F3", x"0500", x"366C", x"0D01",
   x"7701", x"68F3", x"0500", x"366C", x"0D01", x"7702", x"68F3", x"0500",
   x"366C", x"0D01", x"7703", x"68F3", x"0500", x"366C", x"0D01", x"7720",
   x"68F3", x"0500", x"366C", x"0D01", x"7721", x"68F3", x"0500", x"366C",
   x"0D01", x"7722", x"68F3", x"0500", x"366C", x"0D01", x"7723", x"68F3",
   x"0500", x"366C", x"0D01", x"7740", x"68F3", x"0500", x"366C", x"0D01",
   x"7741", x"68F3", x"0500", x"366C", x"0D01", x"7742", x"68F3", x"0500",
   x"366C", x"0D01", x"7743", x"68F3", x"0500", x"366C", x"0D01", x"7760",
   x"68F3", x"0500", x"366C", x"0D01", x"7761", x"68F3", x"0500", x"366C",
   x"0D01", x"7762", x"68F3", x"0500", x"366C", x"0003", x"7763", x"68F3",
   x"7067", x"0B00", x"7068", x"0B80", x"68F8", x"0143", x"B41E", x"16D6",
   x"743C", x"6862", x"36CF", x"7051", x"A856", x"7400", x"B433", x"367D",
   x"0101", x"8C21", x"0140", x"6921", x"167F", x"01BF", x"AC21", x"7401",
   x"B720", x"7402", x"B721", x"7403", x"B722", x"7404", x"B723", x"7405",
   x"B740", x"7406", x"B741", x"7407", x"B742", x"7408", x"B743", x"7409",
   x"B760", x"740A", x"B761", x"740B", x"B762", x"740C", x"B763", x"010D",
   x"E43C", x"46C6", x"0700", x"B067", x"0780", x"B068", x"0000", x"0000",
   x"0F40", x"0F40", x"740D", x"B700", x"740E", x"B701", x"740F", x"B702",
   x"7410", x"B703", x"7411", x"B720", x"7412", x"B721", x"7413", x"B722",
   x"7414", x"B723", x"7415", x"B740", x"7416", x"B741", x"7417", x"B742",
   x"7418", x"B743", x"7419", x"B760", x"741A", x"B761", x"741B", x"B762",
   x"741C", x"B763", x"7067", x"0B00", x"7068", x"0B80", x"741F", x"26CA",
   x"7051", x"A857", x"7051", x"A858", x"0142", x"B41E", x"16D5", x"68AF",
   x"56D5", x"7051", x"A856", x"0142", x"B41E", x"16D6", x"7420", x"B700",
   x"7421", x"B701", x"741E", x"B702", x"7433", x"B703", x"0C40", x"0E01",
   x"0F04", x"7050", x"C850", x"902C", x"B051", x"01FF", x"C844", x"2078",
   x"0110", x"E04F", x"26FC", x"7054", x"902C", x"A052", x"A04A", x"A056",
   x"A058", x"26FC", x"7050", x"885A", x"7051", x"A859", x"7057", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"0109", x"E04F", x"270C", x"7055",
   x"A054", x"A04A", x"270C", x"7054", x"902C", x"A852", x"7054", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"010F", x"E04F", x"271C", x"7055",
   x"A054", x"A04A", x"271C", x"7054", x"902C", x"A852", x"7054", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"0108", x"E04F", x"2728", x"7200",
   x"3728", x"7053", x"B202", x"A04A", x"2728", x"0100", x"B04F", x"B200",
   x"179C", x"0100", x"B203", x"B048", x"01AA", x"B202", x"01FF", x"B053",
   x"0101", x"B050", x"01FE", x"B051", x"0100", x"0800", x"0104", x"0880",
   x"0180", x"0A00", x"0102", x"0A80", x"0100", x"B04A", x"7008", x"B045",
   x"01FF", x"C02C", x"704A", x"0200", x"B04A", x"7050", x"C850", x"902C",
   x"B051", x"7438", x"B035", x"7439", x"B036", x"743A", x"B037", x"743B",
   x"B038", x"6815", x"6815", x"6815", x"6815", x"0100", x"B033", x"B034",
   x"B039", x"B03A", x"7230", x"B03B", x"7231", x"B03C", x"7232", x"B03D",
   x"7233", x"B03E", x"6827", x"7033", x"B608", x"7034", x"B610", x"7035",
   x"B618", x"0100", x"B037", x"B038", x"B039", x"B03A", x"7230", x"B033",
   x"7231", x"B034", x"7232", x"B035", x"7233", x"B036", x"7438", x"B03B",
   x"7439", x"B03C", x"743A", x"B03D", x"743B", x"B03E", x"681E", x"6827",
   x"7034", x"3784", x"01FF", x"B033", x"0001", x"0001", x"0120", x"B638",
   x"7033", x"B640", x"B620", x"0100", x"B628", x"0C40", x"0E01", x"01FF",
   x"C845", x"2740", x"01FF", x"B049", x"0108", x"E04F", x"279C", x"7200",
   x"279C", x"0100", x"B04F", x"B200", x"0101", x"A203", x"3809", x"704F",
   x"2803", x"7201", x"0980", x"B04F", x"7200", x"0900", x"B203", x"0110",
   x"A201", x"37B3", x"7054", x"902C", x"A200", x"B056", x"B057", x"B058",
   x"01DE", x"AC21", x"1802", x"0109", x"E201", x"27CB", x"0120", x"B03B",
   x"01A1", x"B03C", x"0107", x"B03D", x"0100", x"B03E", x"6902", x"01C8",
   x"B064", x"7201", x"B048", x"7052", x"902C", x"A200", x"B054", x"B055",
   x"7200", x"8852", x"1802", x"0108", x"E201", x"27D4", x"7200", x"B053",
   x"27D3", x"0100", x"B049", x"1802", x"010F", x"E201", x"27EE", x"0188",
   x"B03B", x"0113", x"B03C", x"0100", x"B03D", x"0100", x"B03E", x"6902",
   x"0106", x"B064", x"01FA", x"B065", x"7201", x"B048", x"7052", x"902C",
   x"A200", x"B054", x"B055", x"7200", x"8852", x"1802", x"0120", x"A201",
   x"37FD", x"0180", x"A201", x"37F7", x"7202", x"B580", x"17F9", x"7580",
   x"B202", x"0100", x"B04F", x"B200", x"1802", x"01FF", x"B202", x"0100",
   x"B04F", x"B200", x"1809", x"0108", x"E201", x"2809", x"7201", x"B04F",
   x"B203", x"105B", x"0100", x"B422", x"B423", x"B424", x"B425", x"B426",
   x"B427", x"B428", x"0114", x"B429", x"1F00", x"7035", x"C835", x"7036",
   x"D836", x"7037", x"D837", x"7038", x"D838", x"1F00", x"703B", x"C83B",
   x"703C", x"D83C", x"703D", x"D83D", x"703E", x"D83E", x"1F00", x"0120",
   x"B03F", x"7033", x"C833", x"7034", x"D834", x"7035", x"D835", x"7036",
   x"D836", x"7037", x"D837", x"7038", x"D838", x"7039", x"D839", x"703A",
   x"D83A", x"5853", x"7037", x"E03B", x"B037", x"7038", x"F03C", x"B038",
   x"7039", x"F03D", x"B039", x"703A", x"F03E", x"B03A", x"4850", x"703B",
   x"C837", x"703C", x"D838", x"703D", x"D839", x"703E", x"D83A", x"1852",
   x"0101", x"C833", x"185B", x"7037", x"E03B", x"B037", x"7038", x"F03C",
   x"B038", x"0101", x"C833", x"01FF", x"C83F", x"2829", x"0003", x"0003",
   x"1F00", x"0100", x"B02E", x"0D80", x"742C", x"286B", x"0C80", x"C02A",
   x"B02F", x"B225", x"1872", x"0C80", x"3870", x"B02F", x"0001", x"1872",
   x"01FF", x"1F00", x"7620", x"E02F", x"58AD", x"0102", x"A628", x"3884",
   x"7427", x"E429", x"487E", x"0101", x"CC27", x"1880", x"0180", x"6921",
   x"0120", x"6921", x"0100", x"1F00", x"702E", x"3898", x"0400", x"B05B",
   x"0480", x"B05C", x"0003", x"0003", x"7600", x"B400", x"B224", x"0C01",
   x"01FF", x"C82E", x"288A", x"705B", x"0800", x"705C", x"0880", x"0003",
   x"742C", x"28AA", x"7600", x"E224", x"38A9", x"7422", x"E429", x"48A3",
   x"0101", x"CC22", x"18A5", x"0180", x"6921", x"0101", x"6921", x"0100",
   x"1F00", x"18AB", x"C029", x"01FF", x"18AE", x"0100", x"1F00", x"7222",
   x"E42F", x"E431", x"5F00", x"7425", x"E429", x"48B9", x"0101", x"CC25",
   x"18BB", x"0180", x"6921", x"0108", x"6921", x"1F00", x"7222", x"E42F",
   x"E431", x"5F00", x"7425", x"E429", x"48C8", x"0101", x"CC25", x"18CA",
   x"0180", x"6921", x"0108", x"6921", x"0180", x"A420", x"28D1", x"0101",
   x"B41E", x"1F00", x"0003", x"7630", x"28D2", x"B225", x"7620", x"38E2",
   x"7426", x"E429", x"48DE", x"0101", x"CC26", x"18E0", x"0180", x"6921",
   x"0110", x"6921", x"0101", x"A620", x"38EF", x"7424", x"E429", x"48EB",
   x"0101", x"CC24", x"18ED", x"0180", x"6921", x"0104", x"6921", x"1F00",
   x"01FF", x"18F3", x"0100", x"B224", x"B600", x"1F00", x"B224", x"B600",
   x"742C", x"28FD", x"0003", x"7224", x"B600", x"7222", x"B42F", x"7223",
   x"B430", x"1F00", x"7230", x"B033", x"7231", x"B034", x"7232", x"B035",
   x"7233", x"B036", x"0100", x"B037", x"B038", x"B039", x"B03A", x"6827",
   x"7033", x"B062", x"7034", x"B063", x"01FF", x"C862", x"01FF", x"D863",
   x"01FF", x"C862", x"01FF", x"D863", x"7062", x"B222", x"7063", x"B223",
   x"1F00", x"8C20", x"7051", x"A858", x"0180", x"A420", x"3929", x"7051",
   x"A855", x"0120", x"8C21", x"B620", x"0100", x"B628", x"1F00", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"ABCD"
);

signal daddra: std_logic_vector(11 downto 0);
signal daddrb: std_logic_vector(11 downto 0);

begin
   asslbpb: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (wea = '1') then
            RAM(conv_integer(addra)) <= dina;
         end if;
         daddra <= addra;
         daddrb <= addrb;
      end if; -- clk 
   end process;

   douta <= RAM(conv_integer(daddra));
   doutb <= RAM(conv_integer(daddrb));
end;
