library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--
-- Copyright (C) 2011, Peter C. Wallace, Mesa Electronics
-- http://www.mesanet.com
--
-- This program is is licensed under a disjunctive dual license giving you
-- the choice of one of the two following sets of free software/open source
-- licensing terms:
--
--    * GNU General Public License (GPL), version 2.0 or later
--    * 3-clause BSD License
-- 
--
-- The GNU GPL License:
-- 
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
-- 
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
-- 
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
-- 
-- 
-- The 3-clause BSD License:
-- 
--     Redistribution and use in source and binary forms, with or without
--     modification, are permitted provided that the following conditions
--     are met:
-- 
--         * Redistributions of source code must retain the above copyright
--           notice, this list of conditions and the following disclaimer.
-- 
--         * Redistributions in binary form must reproduce the above
--           copyright notice, this list of conditions and the following
--           disclaimer in the documentation and/or other materials
--           provided with the distribution.
-- 
--         * Neither the name of Mesa Electronics nor the names of its
--           contributors may be used to endorse or promote products
--           derived from this software without specific prior written
--           permission.
-- 
-- 
-- Disclaimer:
-- 
--     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
--     "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
--     LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
--     FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
--     COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
--     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
--     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
--     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
--     CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
--     LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
--     ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
--     POSSIBILITY OF SUCH DAMAGE.
-- 
--Library UNISIM;
--use UNISIM.vcomponents.all;

-- dont change these:
use work.IDROMConst.all;	
use work.decodedstrobe2.all;	
use work.parity.all;


-------------------- option selection area ----------------------------


-------------------- select one card type------------------------------
--use work.@Card@.all;
use work.i25t_x20card.all;                -- needs 5i25.ucf and SP6 x9 144 pin
--use work.i74_x9card.all;   	-- needs 4I74.ucf and SP6 x9 144 pin
--use work.Sixi25_x9card.all;	-- needs 6i25.ucf and SP6 x9 144 pin
--use work.i24_x16card.all; 	-- needs 5I24.ucf and SP6 x16 256 pin
--use work.i24_x25card.all;   -- needs 5I24.ucf and SP6 x25 256 pin

-----------------------------------------------------------------------


-------------------- select (or add) one pinout -----------------------
--use work.@Pin@.all;

-- 34 I/O pinouts for 5I25 and 6I25:

--use work.PIN_5ABOBx2D_34.all;			-- Cheap Ebay 5 Axis BOB

use work.PIN_FALLBACK_34.all;			-- IO only configuration for fast compiles whilst debugging PCI and fallback config


entity TopPCIHostMot2 is -- for 5I24,5I25, 5I26, 6I25 PCI target mode
	generic 
	(
		ThePinDesc: PinDescType := PinDesc;
		TheModuleID: ModuleIDType := ModuleID;
		PWMRefWidth: integer := 13;			-- PWM resolution is PWMRefWidth-1 bits 
		IDROMType: integer := 3;		
		UseIRQLogic: boolean := true;			--- note this will pull in PWM ref
		UseWatchDog: boolean := true;
		OffsetToModules: integer := 64;
		OffsetToPinDesc: integer := 448;
		BusWidth: integer := 32;
		AddrWidth: integer := 16;
		InstStride0: integer := 4;			-- instance stride 0 = 4 bytes = 1 x 32 bit
		InstStride1: integer := 64;		-- instance stride 1 = 64 bytes = 16 x 32 bit registers !! UARTS need 0x10
--		InstStride1: integer := 16;		-- instance stride 1 = 64 bytes = 16 x 32 bit registers !! UARTS need 0x10
		RegStride0: integer := 256;		-- register stride 0 = 256 bytes = 64 x 32 bit registers
		RegStride1: integer := 256;      -- register stride 1 = 256 bytes - 64 x 32 bit
		FallBack: boolean := false			-- is this a fallback config?
	);    
	port 
	( 
      clkmed : in  std_logic;
      fclk : in  std_logic;
      ADIN : in  std_logic_vector (31 downto 0);
		ADOUT : out  std_logic_vector (31 downto 0);
		ADENAS : out  std_logic_vector (31 downto 0);
		NCBE : in  std_logic_vector (3 downto 0);
		PARIN : in  std_logic;
		PAROUT : out  std_logic;
		PAR_ENA : out  std_logic;
		NFRAME : in  std_logic;
		NIRDY : in  std_logic;
		NTRDY : out  std_logic;
      NTRDYENA : out  std_logic;
		NSTOP : out  std_logic;
		NSTOPENA : out  std_logic;
		NLOCK : in  std_logic;
		IDSEL : in  std_logic;
		NDEVSEL : out  std_logic; -- inout is kludge
		NDEVSELENA : out  std_logic; -- inout is kludge
		NPERR : out  std_logic;
		NPERRENA : out  std_logic;
      NSERR : out  std_logic;
      NSERRENA : out  std_logic;
      NINTA : out  std_logic;
      NINTAENA : out  std_logic;
		NRST : in  std_logic;
		NREQ : out std_logic;
		NREQENA : out std_logic;
		PCLK  : in	 std_logic; -- PCI clock
		IOINS : in std_logic_vector(IOWidth -1 downto 0);		-- external inputs
		IOOUTS : out std_logic_vector(IOWidth -1 downto 0);	-- external outputs
      IOENAS : out std_logic_vector(IOWidth -1 downto 0);	-- external output enables
		LIOINS: in std_logic_vector (LIOWidth -1 downto 0);	-- local I/O inputs	
		LIOOUTS: out std_logic_vector (LIOWidth -1 downto 0);	-- local I/O outputs
		XCLK: in std_logic;		-- Xtal clock
		LEDS: out std_logic_vector(LEDCount -1 downto 0);
		NINIT: out std_logic;
		SPICLK : out std_logic;
		SPIDI : in std_logic;
		SPIDO : out std_logic;
		SPICS  : out std_logic;
      ConfigOut : out std_logic_vector(1 downto 0);
      ConfigStatus : in std_logic;
      ConfigEnable : out std_logic;
      ConfigStart  : out std_logic
		);
		
end TopPCIHostMot2;

architecture Behavioral of TopPCIHostMot2 is 

-- PCI constants
constant InterruptAck 		: std_logic_vector(3 downto 0) := x"0";
constant SpecialCycle 		: std_logic_vector(3 downto 0) := x"1";
constant IORead 				: std_logic_vector(3 downto 0) := x"2";
constant IOWrite 				: std_logic_vector(3 downto 0) := x"3";
constant MemRead 				: std_logic_vector(3 downto 0) := x"6";
constant MemWrite 			: std_logic_vector(3 downto 0) := x"7";
constant ConfigRead 			: std_logic_vector(3 downto 0) := x"A";
constant ConfigWrite 		: std_logic_vector(3 downto 0) := x"B";
constant MemReadMultiple 	: std_logic_vector(3 downto 0) := x"C";
constant DualAddressCycle 	: std_logic_vector(3 downto 0) := x"D";
constant MemReadLine 		: std_logic_vector(3 downto 0) := x"E";
constant MemWriteandInv 	: std_logic_vector(3 downto 0) := x"F";


constant DIDVIDAddr : std_logic_vector(7 downto 0) := x"00";	
constant StatComAddr : std_logic_vector(7 downto 0) := x"04";
constant ClassRevAddr : std_logic_vector(7 downto 0) := x"08"; 
constant ClassRev : std_logic_vector(31 downto 0) := x"11000001";  -- data acq & rev 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
--constant ClassRev : std_logic_vector(31 downto 0) := x"07010000";    -- parallel port                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
constant MiscAddr : std_logic_vector(7 downto 0) := x"0C";
constant MiscReg : std_logic_vector(31 downto 0) := x"00000000";
constant SSIDAddr : std_logic_vector(7 downto 0) := x"2C";
constant BAR0Addr : std_logic_vector(7 downto 0) := x"10";
constant IntAddr : std_logic_vector(7 downto 0) := x"3C";


-- Misc global signals --
signal DH: std_logic_vector (BusWidth-1 downto 0);							-- internal hm2 data bus
signal DC: std_logic_vector (BusWidth-1 downto 0);							-- internal config register data bus
signal DR: std_logic_vector (BusWidth-1 downto 0);							-- internal reconfiguration data bus
signal DS: std_logic_vector (BusWidth-1 downto 0);							-- internal SPI interface data bus
signal A: std_logic_vector (BusWidth-1 downto 0);

signal DataStrobe: std_logic;
signal ReadStb: std_logic;
signal WriteStb: std_logic;
signal ConfigReadStb: std_logic;
signal ConfigWriteStb: std_logic;

-- PCI bus interface signals
signal NFrame1 : std_logic;
signal IDevSel : std_logic;
signal IDevSel1 : std_logic;
signal IDevSel2 : std_logic;
signal LIDSel : std_logic;
signal Lint : std_logic;
signal PerrStb : std_logic;
signal PerrStb1 : std_logic;
signal PerrStb2 : std_logic;
signal StatPerr : std_logic;
signal SerrStb : std_logic;
signal SerrStb1 : std_logic;
--signal SerrStb2 : std_logic;
signal StatSerr : std_logic;
signal PCIFrame : std_logic;
signal ITRDY : std_logic;
signal IStop : std_logic;    
signal Selected : std_logic;  
signal ConfigSelect : std_logic;
signal NormalSelect : std_logic;  
signal IPar : std_logic;
signal CPar : std_logic;
signal PAR1 : std_logic;
signal BusCmd : std_logic_vector(3 downto 0);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
signal ADDrive : std_logic;  
signal ParDrive : std_logic; 
signal BusRead : std_logic; 
-- signal BusRead1 : std_logic; 
-- signal BusRead2 : std_logic; 
signal BusWrite : std_logic; 
signal BusWrite1 : std_logic; 
signal BusWrite2 : std_logic; 

-- PCI configuration space registers
signal StatComReg : std_logic_vector(31 downto 0) := x"02000000"; -- medium devsel
alias MemEna : std_logic is StatComReg(1);
alias ParEna : std_logic is StatComReg(6);
alias SerrEna : std_logic is StatComReg(8);
alias IntDis : std_logic is StatComReg(10);
signal BAR0Reg : std_logic_vector(31 downto 0) := x"00000000";
signal IntReg : std_logic_vector(31 downto 0) := x"00000100";

-- debug

signal ledff0 : std_logic := '0'; 
signal ledff1 : std_logic := '0'; 
signal blinkcount : std_logic_vector(24 downto 0);
signal WDLBite: std_logic;

-- configuration flash SPI interface		

signal LoadSPIReg : std_logic;
signal ReadSPIReg : std_logic;
signal LoadSPICS : std_logic;
signal ReadSPICS : std_logic;

-- ICap interface		

signal LoadConfig : std_logic;
signal ReadConfig : std_logic;
signal Config : std_logic_vector(3 downto 0) := "0000";
signal ConfigOK : std_logic := '0';
signal ReConfigState : std_logic_vector(3 downto 0) := "0000";

begin


ahostmot2: entity work.HostMot2
	generic map (
		thepindesc => ThePinDesc,
		themoduleid => TheModuleID,
		idromtype  => IDROMType,		
	   sepclocks  => SepClocks,
		onews  => OneWS,
		useirqlogic  => UseIRQLogic,
		pwmrefwidth  => PWMRefWidth,
		usewatchdog  => UseWatchDog,
		offsettomodules  => OffsetToModules,
		offsettopindesc  => OffsetToPinDesc,
		clockhigh  => ClockHigh,
		clockmed => ClockMed,
		clocklow  => ClockLow,
		boardnamelow => BoardNameLow,
		boardnamehigh => BoardNameHigh,
		fpgasize  => FPGASize,
		fpgapins  => FPGAPins,
		ioports  => IOPorts,
		iowidth  => IOWidth,
		liowidth  => LIOWidth,
		portwidth  => PortWidth,
		buswidth  => BusWidth,
		addrwidth  => AddrWidth,
		inststride0 => InstStride0,
		inststride1 => InstStride1,
		regstride0 => RegStride0,
		regstride1 => RegStride1,
		ledcount  => LEDCount		)
	port map (
		ibus =>  ADIN,
		obus => DH,
		addr => A(AddrWidth-1 downto 2),
		readstb => ReadStb,
		writestb => WriteStb,
		clklow => PCLK,				-- PCI clock
		clkmed  => clkmed,			-- Processor clock
		clkhigh =>  fclk,				-- High speed clock
		int => LINT, 
		ioins => IOINS,					
	   ioouts => IOOUTS,					
      ioenas => IOENAS,			
		lioins => LIOINS,			
		lioouts => LIOOUTS,			
		leds => LEDS,	
      wdlatchedbite => WDLBite 
		);
	
   ReConfigDecode : process(A,WriteStb,NCBE) 
	begin
		LoadConfig <= decodedstrobe2(A(15 downto 0),x"0078",WriteStb,not (NCBE(0) or NCBE(1)));
	   ReadConfig <= decodedstrobe2(A(15 downto 0),x"0078",ReadStb,not (NCBE(0) or NCBE(1) or NCBE(2) or NCBE(3)));
	end process ReConfigDecode;

	ReConfigSupport: process (PCLK,LoadConfig,ReadConfig)
	begin
		if rising_edge(PCLK) then
			if LoadConfig = '1' then
				Config <= ADIN(3 downto 0);
			end if;		
			if ReConfigState /= "1111" then
				ReConfigState <= ReConfigState +1;  
			end if;         
			if fallback = true then      					-- only done if a fallback configuration
				if ConfigStatus = '0' then  				-- and config status indicates configuration OK
					if ReConfigState = "0010" then
						Config <= "0101";					-- load user image (1) + enable
					end if;
					if ReConfigState = "0100" then 	-- load user image (1) + enable + start    
						Config <= "1101";
					end if;
				end if; --configstatus
			end if; --fallback 
		end if; -- clk			
		if ReadConfig = '1' then
			DR(0) <= ConfigStatus;
			DR(31 downto 1) <= (others => '0');
		end if; 
      ConfigOut <= Config(1 downto 0);    	-- image select    
      ConfigEnable <= Config(2);          	-- enable configuration    
		ConfigStart <= Config(3);	        		-- start configuration
	end process ReConfigSupport; 


	ADDrivers: process (DC,DH,DR,DS,ADDrive)
	begin 
		DS(BusWidth-1 downto 8) <= (others => '1');
		if ADDrive ='1' then	
			if (ConfigSelect = '1') and (BusCmd = ConfigRead) then  	--Config read else hostmot2 or local:
				ADOUT <= DC;														
			else
				if ReadStb = '1' then
					ADOUT <= DH;					-- hostmot2 unless notched by:				

					if ReadConfig = '1' then
						ADOUT <= DR;				-- reconfig
					end if;

					if (ReadSPICS = '1' or ReadSPIReg ='1') then
						ADOUT <= DS;				-- local config SPI
					end if;
	
				else
					ADOUT <= (others => '1');
				end if;
			end if;					         
         ADENAS <= (others => '1');
		else
			ADENAS <= (others => '0');	
			ADOUT <= (others => '1');
		end if;
	end process ADDrivers;

	BusCycleGen: process (PCLK, NIRDY, DataStrobe, ConfigSelect, PCIFrame, A, 
								 IDevSel, IdevSel1, IDevSel2, ITRDY, ISTOP, ParDrive, IPar, CPar, 
								 LIDSel, Bar0Reg, BusCmd, LInt, IntReg, ConfigSelect, BusRead,Selected,
								 NCBE, NormalSelect, SerrStb1, PerrStb2, StatComReg, BusWrite1,BusWrite2)		-- to do: parity error reporting in status
	begin 
		if rising_edge(PCLK) then
			if  NFRAME = '0' and Nframe1 = '1' then 	-- falling edge of NFRAME = start of frame
				A <= ADIN;											-- so latch address and PCI command	
				BusCmd <= NCBE;
				PCIFrame <= '1';
				SerrStb <= '1';
				LIDSel <= IDSEL;
			else
				SerrStb <= '0';
			end if;

			if PCIFrame = '1' then							-- if we are in a PCI frame, check if we are selected
				if Selected = '1' then
					IDevSel <= '1';							-- if so assert DEVSEL
				end if;
			end if;

			if IDevSel = '1' then
				if NIRDY = '0' then
					ITRDY <= '1';								-- note one clock delay for one wait state;
				end if;
				if ITRDY = '1' then 							-- only asserted for one clock
					ITRDY <= '0';
				end if;
			end if;

			if	(NFRAME = '1') then		-- any time frame is high end frame
				PCIFrame <= '0';
				if (NIRDY= '0') and (ITRDY = '1') then	-- if frame is de-asserted and we have a data transfer, we're done
					IDevSel <= '0';
				end if;	
			end if;			

			if (NIRDY = '0') and (ITRDY = '1') and (NCBE /= x"F") then 	-- increment address after every transfer
				A <= A + 4;
			end if;	
			
			IDevSel2 <= IDevSel1;
			IDevSel1 <= IDevSel;

--			BusRead2 <= BusRead1;
--			BusRead1 <= BusRead;

			BusWrite2 <= BusWrite1;
			BusWrite1 <= BusWrite;

			PerrStb2 <= PerrStb1;
			PerrStb1 <= PerrStb;

--			SerrStb2 <= SerrStb1;
			SerrStb1 <= SerrStb;
						
					
			NFrame1 <= NFRAME;
			PAR1 <= PARIN;

			IStop <= '0';			-- for  now
			
			IPar <= parity(ADIN&NCBE&'0');		-- Parity generation 1 clock behind data (0 is even reminder)
			CPar <= IPar xor PAR1;			   -- Parity check 2 clocks behind data (high = error)
			ParDrive <= ADDrive;					-- 1 clock behind AD Tristate

			if NRST = '0' then
				PCIFrame <= '0';
				IDevSel <= '0';
				ITRDY <= '0';
			end if;			
		end if; -- clk


		if NIRDY = '0' and ITRDY = '1' and (NCBE /= x"F") then -- data cycle when IRDY AND TRDY and a least one byte enable
			DataStrobe <= '1';
		else
			DataStrobe <= '0';
		end if;	
		
		if (DataStrobe = '1') and ((BusCmd = MemRead) or (BusCmd = MemReadMultiple)) then
			ReadStb<= '1';
		else
			ReadStb <= '0';
		end if;	

		if (DataStrobe = '1') and (BusCmd = MemWrite) then
			WriteStb <= '1';
		else
			WriteStb <= '0';
		end if;	

		if DataStrobe = '1' and (BusCmd = ConfigRead) then
			ConfigReadStb <= '1';
		else
			ConfigReadStb <= '0';
		end if;	

		if DataStrobe = '1' and (BusCmd = ConfigWrite) then
			ConfigWriteStb <= '1';
		else
			ConfigWriteStb <= '0';
		end if;	

		if DataStrobe = '1' and ((BusCmd = MemWrite) or (BusCmd = ConfigWrite)) then
			PErrStb <= '1';
		else
			PErrStb <= '0';
		end if;			
		
		Selected <= (ConfigSelect or (NormalSelect and MemEna));
				
		if ((PCIFrame = '1') and (Selected='1')) or (IDevSel= '1') or (IDevSel1 = '1') then					-- keep driving NDEVSEL/NTRDY/NSTOP one clock after IDevsel de-sasserted	
			NDEVSELENA <= '1';
			NTRDYENA <= '1';
			NSTOPENA <= '1';
			NDEVSEL <= not IDevSel;
			NTRDY <= not ITRDY;
			NSTOP <= not IStop;
		else
			NDEVSELENA <= '0';
			NTRDYENA <= '0';
			NSTOPENA <= '0';
		end if;	
		
		if (IdevSel = '1') and (busread = '1') then
			ADDrive <= '1';
		else
			ADDrive <= '0';
		end if;	

		if ParDrive = '1' then				-- PAR is driven with the AD buffer enable signal but one clock later
			PAROUT <= IPar;
         PAR_ENA <='1';
		else
			PAR_ENA <= '0';
		end if;	
		
		if ((IDevSel1 = '1') or (IdevSel2 = '1')) and ((BusWrite1 = '1') or (BusWrite2 = '1')) then
			NPERR <= not (CPar and PerrStb2 and ParEna);
			StatPerr <= (CPar and PerrStb2);
         NPERRENA <= '1';
		else
			NPERRENA <= '0';
			StatPerr <= '0';
		end if;	

		if ((IDevSel = '1') and (SerrStb1 = '1') and (SerrEna = '1') and (ParEna = '1')) then
			NSERR <= not CPar;
         NSERRENA <= '1';
			StatSerr <= CPar;
		else
			NSERRENA <= '0';
			StatSerr <= '0';
			
		end if;	
				
		if (LIDSel = '1') and ((BusCmd = ConfigRead) or (BusCmd = ConfigWrite)) then
			ConfigSelect <= '1';
		else
			ConfigSelect <= '0';
		end if;		
		
		if (Bar0Reg(31 downto 16) = A(31 downto 16)) and (MemEna = '1') and ((BusCmd = MemRead) or (BusCmd = MemReadMultiple) or (BusCmd = MemWrite)) then			-- hard wired for 64 K select
			NormalSelect <= '1';
		else
			NormalSelect <= '0';
		end if;	
	
		if (BusCmd = MemRead) or (BusCmd = MemReadMultiple) or (BusCmd = ConfigRead) then
			BusRead <= '1';
		else
			BusRead <= '0';
		end if;	

		if ((BusCmd = MemWrite) or (BusCmd = ConfigWrite)) then
			BusWrite <= '1';
		else
			BusWrite <= '0';
		end if;	
		
		if (LINT = '0') and IntDis = '0' then
			NINTA <= '0';
         NINTAENA <= '1';
		else
			NINTAENA <= '0';
		end if;	
			
	end process BusCycleGen;

	
	PCIConfig : process (PCLK, A, ConfigSelect, BusCmd, LInt, StatComReg, Bar0Reg, IntReg)
	begin

		-- first the config space reads
		if (ConfigSelect = '1') and (BusCmd = ConfigRead) then
			case A(7 downto 0) is
				when DIDVIDAddr  	=> DC <= DIDVID;
				when StatComAddr  => DC <= StatComReg;
				when ClassRevAddr => DC <= ClassRev;
				when MiscAddr		=>	DC <= MiscReg;
				when BAR0Addr		=>	DC <= BAR0Reg;
				when SSIDAddr		=>	DC <= SSID;
				when IntAddr		=> DC <= IntReg;	
				when others			=>	DC <= (others => '0'); 	-- all unused config space reads as 0s
			end case;
		end if;		
		
		-- then the config space writes
		if rising_edge(PCLK) then
			StatComReg(19) <= not LINT;		-- moved to clocked for EFX
			if StatPerr = '1' then
				StatComReg(31) <= '1'; -- signal data parity error in status reg
			end if;	
			if StatSerr = '1' then
				StatComReg(30) <= '1'; -- signal address parity error in status reg
			end if;	
			if (ConfigSelect = '1') and (BusCmd = ConfigWrite) and (DataStrobe = '1') then			
				case A(7 downto 0) is
					when StatComAddr  => 
						if NCBE(0) = '0' then 
							StatComReg(1) <= ADIN(1);	-- MemEna
							StatComReg(6) <= ADIN(6); -- ParEna
						end if;	
						if NCBE(1) = '0' then	
							StatComReg(8) <= ADIN(8); -- SerrEna
							StatComReg(10) <= ADIN(10); -- IntDis
						end if;	
						if NCBE(3) = '0' then
							StatComReg(27) <= StatComReg(27) and not ADIN(27);  	-- status bits cleared when a 1 is written
							StatComReg(30) <= StatComReg(30) and not ADIN(30);
							StatComReg(31) <= StatComReg(31) and not ADIN(31);
						end if;
					when BAR0Addr		=>													-- 64K range so only top 16 bits used
						if NCBE(2) = '0' then 
							BAR0Reg(23 downto 16) <= ADIN(23 downto 16);
						end if;                                       
						if NCBE(3) = '0' then 
							BAR0Reg(31 downto 24) <= ADIN(31 downto 24);
						end if;				
					when IntAddr		=> 												-- only R/W byte of int reg supported
						if NCBE(0) = '0' then			
							IntReg(7 downto 0) <= ADIN(7 downto 0);
						end if;			
					when others			=>	null;
				end case;
			end if;		
			if NRST = '0' then
				BAR0Reg(31 downto 16) <= (others => '0');
				StatComReg <= x"02000000";
				IntReg <= x"00000100";
--				ledff0 <= '0';
--				ledff1 <= '0';
			end if;		
		end if; -- clk
	end process PCIConfig;

	SPIDecode : process(A,ReadStb,WriteStb,NCBE) 
	begin
		LoadSPICS <= decodedstrobe2(A(15 downto 0),x"0070",WriteStb,not NCBE(0));
		ReadSPICS <= decodedstrobe2(A(15 downto 0),x"0070",ReadStb,not NCBE(0));
		LoadSPIReg <= decodedstrobe2(A(15 downto 0),x"0074",WriteStb,not NCBE(0));
		ReadSPIReg <= decodedstrobe2(A(15 downto 0),x"0074",ReadStb,not NCBE(0));
	end process SPIDecode;

	
	asimplspi: entity work.simplespi8	-- configuration serial EEPROM access SPI port
	generic map
	(
		buswidth => 8,
		div => 2,	-- for divide by 6	-- 5.5 MHz
		bits => 8
	)	
	port map 
	( 
		clk  => PCLK,
		ibus => ADIN(7 downto 0),
		obus => DS(7 downto 0),
		loaddata => LoadSPIReg,
		readdata => ReadSPIReg,
		loadcs => LoadSPICS,
		readcs => ReadSPICS,
		spiclk => SPICLK,
		spiin => SPIDI,
		spiout => SPIDO,
		spics =>SPICS 
	);

	
	PCILooseEnds : process (PCLK)
	begin
		NREQ <= '1';
		NREQENA <= '0';	
	end process PCILooseEnds;
	
	dofallback: if fallback generate -- do blinky red light to indicate failure to load primary bitfile
		Fallbackmode : process(clkmed)
		begin
			if rising_edge(clkmed) then 
				blinkcount <= blinkcount +1;
			end if;
			NINIT <= blinkcount(23);
		end process;	
	end generate;	
		
	donormal: if not fallback generate
		NormalMode : process(WDLBite)
		begin
			NINIT <= not WDLBite;
		end process;	
	end generate;		
		
	
end Behavioral;
