{for fifo'ed 7I60}
{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

type buffer = array[1.. FlashBlockSize] of byte; { largest size }
     bufptr = ^buffer;
     DataBuffertype = array[0..255] of word;
     DataBuffPtr = ^DataBuffertype;

var  DataBuffer : DataBuffertype;

{*****************************************************************************}
procedure SerMesaStart;
var
sstring : string;
begin
  ForceRTSHigh(TheComPort);
  sstring := CR {sync} + SerMesaStartCom + CR;
  SendString(sstring);
end;

procedure SerMesaStop;
var
sstring : string;
begin
  ForceRTSLow(TheComPort);
  sstring := SerMesaStopCom + CR;
  SendString(sstring);
end;

procedure SerListen(addr : byte);
var
sstring : string;
begin
  sstring := SerListenCom + HexString(addr,2) + CR;
  SendString(sstring);
end;

function InquireID : string;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerInquireIDCom +CR;
  SendString(sstring);
  sstring := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  InquireID := sstring;
end;

function SerProbe(addr : byte) : boolean;
var
sstring : string;
begin
  SerProbe := false;
  SerListen(addr);
  sstring := InquireID;
  if sstring = '3C20' then SerProbe := true;
end;

procedure CloseSerialPort;
begin
{$IFDEF DSPIC}
  SerMesaStop;
{$ENDIF}
end;

procedure InitializeSerInterface;
begin
  DefaultComInit(TheComPort);
  EnableFifos(TheComPort); { don't check if fifos are there because it sends garbage }
  SetBaudRate(TheComPort,UartBaudrate);
  TossChars(TheComPort,130);
end;

procedure SerWritePicWord(address:word; data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWritePicWordCom+HexString(address,4)+HexString(data,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteDirectByte(address:byte; data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWritedirectByteCom+HexString(address,2)+HexString(data,2)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteDirectWord(address:byte; data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWritedirectWordCom+HexString(address,2)+HexString(data,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure WriteGroup( group : word;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteGroupCom+ HexString(group,4)+CR;
  SendString(sstring);
  for index := 1 to GroupSize do SendString(HexString(ourbuffer^[index],2));
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function SerCountICDFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerCountICDFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerCountICDFIFO := data;
end;
function SerCountIRBFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerCountIRBFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerCountIRBFIFO := data;
end;
function SerCountQCDFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerCountQCDFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerCountQCDFIFO := data;
end;
function SerCountQRBFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerCountQRBFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerCountQRBFIFO := data;
end;

function SerReadIFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadIFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadIFIFO := data;
end;

procedure SerReadQFIFOMultiple(n : word; bufptr : DataBuffPtr);
var
data : word;
index : byte;
sstring : string;
retchar : char;
begin
  sstring := SerReadQFIFOMultipleCom + HexString(n,2) + CR;
  SendString(sstring);
  for index := 0 to n-1 do
  begin
    HexWordRead(RecvString(4),data);
    bufptr^[index] := data;
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
end;

function SerReadQFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadQFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadQFIFO := data;
end;

function SerReadDirectByte(address: byte) : byte;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadDirectByteCom + HexString(address,2) +CR;
  SendString(sstring);
  sstring := RecvString(2);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadDirectByte := data;
end;

function SerReadDirectWord(address: byte) : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadDirectWordCom + HexString(address,2) +CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadDirectWord := data;
end;

function SerReadParamWord(command:word) : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  sstring := SerReadIFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeOut(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadParamWord := data;
end;

function SerReadParam(command:word) : longint;
var
sstring : string;
rlstring : string;
rhstring : string;
ldata : longint;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerReadIFIFOCom + CR;
  SendString(sstring);
  rlstring := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  rhstring := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexLongRead(rhstring+rlstring,ldata);
  SerReadParam := ldata;
end;

function SerReadParamDouble(command:word) : comp;
var
sstring : string;
r0string,r1string,r2string,r3string : string;
cdata : comp;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerReadIFIFOCom + CR;
  SendString(sstring);
  r0string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r1string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r2string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r3string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexLongRead(r1string+r0string,DoubleLongRec(cdata).Long0);
  HexLongRead(r3string+r2string,DoubleLongRec(cdata).Long1);
  SerReadParamDouble := cdata;
end;

procedure SerWriteParamWord(command:word;data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom+HexString(command,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom+HexString(data,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteWaitToken(command:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom+HexString(command,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteWaitTokenQ(command:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom+HexString(command,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteParam(command: word;ldata:longint);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4)+ CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(LongIntRec(ldata).LowWord,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(LongIntRec(ldata).HighWord,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteParamDouble(command: word;cdata:comp);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4)+ CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word0,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word1,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word2,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word3,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function SerReadParamWordQ(command:word) : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  sstring := SerReadQFIFOCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadParamWordQ := data;
end;

function SerReadParamQ(command:word) : longint;
var
sstring : string;
rlstring : string;
rhstring : string;
ldata : longint;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerReadQFIFOCom + CR;
  SendString(sstring);
  rlstring := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  rhstring := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexLongRead(rhstring+rlstring,ldata);
  SerReadParamQ := ldata;
end;

function SerReadParamDoubleQ(command:word) : comp;
var
sstring : string;
r0string,r1string,r2string,r3string : string;
cdata : comp;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerReadQFIFOCom + CR;
  SendString(sstring);
  r0string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r1string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r2string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  SendString(sstring);
  r3string := RecvString(4);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexLongRead(r0string+r1string,DoubleLongRec(cdata).Long0);
  HexLongRead(r2string+r3string,DoubleLongRec(cdata).Long1);
  SerReadParamDoubleQ := cdata;
end;

procedure SerWriteParamWordQ(command:word;data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom+HexString(command,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom+HexString(data,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteParamQ(command: word;ldata:longint);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4)+ CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(LongIntRec(ldata).LowWord,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(LongIntRec(ldata).HighWord,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerWriteParamDoubleQ(command: word;cdata:comp);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4)+ CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word0,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word1,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word2,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word3,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure ReadGroup( group : word;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadGroupCom+ HexString(group,4)+CR;
  SendString(sstring);
  for index := 1 to GroupSize do
  begin
    HexByteRead(RecvString(2),ourbuffer^[index]);
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure ClearChecksum;
var
sstring : string;
retchar : char;
begin
  sstring := SerEraseChecksumCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function ReadChecksum : byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerReadChecksumCom + CR;
  SendString(sstring);
  sstring := RecvString(2);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexbyteRead(sstring,data);
  ReadChecksum := data;
end;

procedure SerUnlock;
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteProtectCom+'00'+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerLock;
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteProtectCom+ 'FF'+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerPicGo(address:word);
var
sstring : string;
retchar : char;
begin
  SerUnlock;
  sstring := SerPicGoCom+HexString(address,4)+CR;
  SendString(sstring);
 { if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;}
end;

procedure SerClearICDFIFO;
var
sstring : string;
retchar : char;
begin
  sstring := SerClearICDFIFOCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerClearQCDFIFO;
var
sstring : string;
retchar : char;
begin
  sstring := SerClearQCDFIFOCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerClearIRBFIFO;
var
sstring : string;
retchar : char;
begin
  sstring := SerClearIRBFIFOCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure SerClearQRBFIFO;
var
sstring : string;
retchar : char;
begin
  sstring := SerClearQRBFIFOCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure WriteFlashBlock( block : byte;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteFlashCom + HexString(block,2)+CR;
  SendString(sstring);
  for index := 1 to FlashBlockSize do
  begin
    SendString(HexString(ourbuffer^[index],2))
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure WriteNewFlashBlock( block : word; size : word; ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteFlashCom+ HexString(block,4)+CR;
  SendString(sstring);
  for index := 1 to size do
  begin
    SendString(HexString(ourbuffer^[index],2));
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) = 0 then SerError := true;
end;

procedure EraseFlashBlock( block : byte);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerEraseFlashCom+ HexString(block,2)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure ReadFlashBlock( block : byte;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadFlashCom+ HexString(block,2)+CR;
  SendString(sstring);
  for index := 1 to FlashBlockSize do
  begin
    HexByteRead(RecvString(2),ourbuffer^[index]);
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure ReadNewFlashBlock( block : byte; size : word; ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadFlashCom+ HexString(block,4)+CR;
  SendString(sstring);
  for index := 1 to size do
  begin
    HexByteRead(RecvString(2),ourbuffer^[index]);
  end;
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function InquireRev : byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerInquireRevCom +CR;
  SendString(sstring);
  sstring := RecvString(2);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexbyteRead(sstring,data);
  InquireRev := data;
end;

procedure WriteEEPROM(addr: byte;data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteEEPROMCom + HexString(addr,2)+ HexString(data,2) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function ReadEEPROM(add:byte) : byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerReadEEPROMCom +HexString(add,2)+ CR;
  SendString(sstring);
  sstring := RecvString(2);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
  HexbyteRead(sstring,data);
  ReadEEPROM := data;
end;

procedure WriteEEPROMWord(addr: word;data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteEEPROMWordCom + HexString(addr,4)+ HexString(data,4) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure EraseGroup(block : word);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerEraseGroupCom+ HexString(block,4)+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure WritePLL(data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteOscCom + HexString(data,2) + CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

procedure ConfigureFPGA;
var
sstring : string;
retchar : char;
begin
  sstring := SerConfigCom+CR;
  SendString(sstring);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true;
end;

function SerSync : boolean;
var
retchar : char;
sstring : string;
begin
  SerSync := false;
  ForceRTSHigh(TheComPort);
  PolledPutComChar(TheComPort,'x'); { send invalid command or data }
  PolledPutComChar(TheComPort,CR);
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) <> 0 then
  begin
    TossChars(TheComPort,130);
    PolledPutComChar(TheComPort,'x'); { send invalid command or data }
    PolledPutComChar(TheComPort,CR);
    if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) <> 0 then
    begin
      TossChars(TheComPort,130);
      if retchar = '?' then
      begin
        sstring := SerWriteProtectCom +'AA' + CR;
        SendString(sstring);
        if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) <> 0 then
        begin
          if retchar = CR then
          begin
            SerSync := true;
            SerError := false;
          end
        end;
      end;
    end;
  end;
end;

function SerialCheck : boolean;
begin
  SerialCheck := true;
  if SerError then
  begin
    SerialCheck := false;
    SerSync;
  end;
end;

{ changed group size to word 11-30-06 ge }
