program program3c20;
{$R-}
{$N+}
{$DEFINE DSPIC} { for 3C20 }
{DEFINE WINDOWS}

{$IFDEF WINDOWS}
uses synaser,graph,wincrt,dos;
var GraphDriver : smallint;
{$ELSE}
uses graph,crt,dos;
var GraphDriver : integer;
{$ENDIF}

type
cardtypes =  (PC104,PCI,SevenI60,ThreeC20);

var
CardType : cardtypes;

{$IFDEF WINDOWS}
TheComPort : string;
{$ELSE}
TheComPort : word;
{$ENDIF}

Message : string;

{$I Parsep.pas}

type configfile = file;

const
{block addresses are in wordaddress / 32}
StartAltVectorTableBlock = 2;
EndAltVectorTableBlock = 4;
StartBlock = 128; {2nd half}
BufferSize = 32*4;  {32 instructions of 4 bytes each}

var
Count : word;
FileName : string;
CFile : configfile;
BBuf: array[1..BufferSize] of byte;
RBuf: array[1..BufferSize] of byte;
BChecksum, RChecksum : byte;
DoReadback : boolean;


{$I MotLow4.pas}     { include low level routines }

procedure BarfOut(s: string);
begin
  writeln;
  writeln(s,chr(7));
  halt(2);
end;

function OpenForRead(var fp: configfile; name: string): boolean;
begin
  Assign(fp,Name);
  {$I-}
  Reset(fp);
  {$I+}
  OpenForRead := IOResult = 0;
end { Open };

procedure Usage;
begin
  writeln;
  writeln(' PRG3C20 - Writes ROM data to 3C20');
  writeln;
  writeln(' USAGE - PRG3C20 file [-r] ');
  writeln(' Where file is a Programming file');
  writeln(' optional -r parameter does block readback for checking');
  writeln;
  halt(2);
end;

function ReadString(var idx: word) : string;
var
sleng,count,index : word;
tstring : string;
begin
  index := idx;
  sleng := BBuf[index] * 256 + BBuf[index+1];
  index := index +2; {skip over string length}
  if sleng >255 then sleng := 255;
  tstring := '';
  for count := 1 to sleng do
  begin
    if BBuf[index] <> 0 then tstring := tstring + chr(BBuf[index]);
    index := index +1;
  end;
  idx := index;
  ReadString := tstring;
end;

procedure GetParms;
var
theport : word;
tempstr : string;
templong : longint;
retcode : integer;
  begin
  if ParamCount < 1 then Usage;
  Filename := paramStr(1);
  if not OpenForRead(CFile,FileName) then
  begin
    writeln('Can''t open configuration file');
    halt(2);
  end;
  if length(ParamStr(2)) <> 0 then DoReadBack := true else DoReadback := false;
end;

Procedure ShowErrors;
var
index : word;
foostr : string;
begin
  for index := 1 to BufferSize do
  begin
    if BBuf[index] <> Rbuf[index] then
    begin
      write('Data Error at byte ');
      HexPrint(index,2);
      write(': Expected ');
      HexPrint(BBuf[index],2);
      write(' but got back ');
      Hexprint(RBuf[index],2);
      writeln;
      writeln('Press return to continue');
      readln(foostr);
    end;
  end;
end;

function CalcCheckSum(block: word) : byte;
var
index: word;
sum : byte;
hexstr : string;
begin
  hexstr := Hexstring(block,4);
  sum := byte(hexstr[1]);
  sum := sum + byte(hexstr[2]);
  sum := sum + byte(hexstr[3]);
  sum := sum + byte(hexstr[4]);
  for index := 1 to BufferSize do
  begin
    hexstr := Hexstring(BBuf[index],2);
    sum := sum + byte(hexstr[1]);
    sum := sum + byte(hexstr[2]);
  end;
  CalcCheckSum := sum;
end;

procedure DoIt;
var
bytesread,index : word;
bytecount : longint;
blocknum : byte;
retchar : char;
hstring : string;
begin
  if not SerSync then Barfout('3C20 Communication error');
  writeln;
  begin
    reset(CFile,1);
    blocknum := 0;
    Count := 0;
    while not EOF(CFile) do
    begin
      bytesread := 0;
      blockread(CFile,BBuf,BufferSize,bytesread);
      if bytesread > 0 then
      begin
      if ((blocknum >= StartAltVectorTableBlock) and (blocknum < EndAltVectorTableBlock)) or (blocknum >= StartBlock) then
        begin
          SerUnlock;
          EraseGroup(blocknum);
          Write('EG# ',blocknum,'  ');
          ClearChecksum;
          BChecksum := CalcChecksum(blocknum);
          WriteGroup(blocknum,@BBuf);
          Writeln('WG# ',blocknum,'  ',chr(13));
          RChecksum := ReadChecksum;
          if Rchecksum <> BChecksum then
          begin
            writeln('Checksum error');
            writeln('BCS= ',BChecksum,' RCS= ',RChecksum);
          end;
          if DoReadback then
          begin
            Write('RG# ',blocknum,'  ',chr(13));
            ReadGroup(blocknum,@RBuf);
            ShowErrors;
          end;
        end
      else Writeln('Skipping Block# ',blocknum,chr(13));
      end;
      blocknum := blocknum +1;
    end;
    SerLock;
  end;
  writeln;
end;

begin
  GetParms;
  GetOurEnv;
  TheBaudRate := 115200 div TheBaudRateMul;
  if BusIntfc = true then barfout(' BusIntfc environment must be false');
  InitializeInterface(Message);

  SerMesaStart;             { for rev 2 }
  SerListen(0);
  if not SerSync then Barfout('3C20 Communication error') else writeln('3C20 OK') ;
  writeln;
  SerUnlock;
  {SerWritePicWord($0082,0);} { back to low interrupt vector }
  Writeln('Low Level Rev = ',InquireRev);
  DoIt;
  Writeln('Programming done');
  if not SerSync then Barfout('3C20 Communication error');
  writeln;
  SerPicGo($2000); { run top }
  delay(10); { for startup }
  SerMesaStart;
  SerListen(0);
  if not SerSync then Barfout('3C20 Communication error');
  writeln;
  SerLock;
  writeln('Programming complete!');
  halt(0);
end.
