/* The functional interface to the motor controller is done by a dual port ram */
/* sample:	the time between iterations of the pid loop, see prescale and postscale */
/* counts:	encoder counts ppr*4 */
/* UNITS */
/* despos		encoder counts                     BBBB.        B=byte S=signextend */
/* desposf	fractional encoder counts               BBB0    B=byte S=signextend */
/* velocity	8.24 counts per sample 		   SSSB.BBB     (127 max motor counts per sample) */
/* velocityf	8.24 counts per sample 		      0.000BB   (127 max motor counts per sample) */
/* accel		8.24 counts per sample per sample     B.BBB */
/* accelf		is the fractional part of accel       0.000BB */
/* jerk		added to accel.accelf each sample     S.SBBBB */
/* avgvel		8.8 velocity units */
/* pwm		8.8 signed number, only integer part used for output */
/* TYPES (contents of ram address) */
/* 	<blank>	number of bits is hardware dependent	 */
/* 	byte	8 bit unsigned value */
/* 	ptr	10 bit address pointer */
/* 	flag	16 bit value 0 is false, nonzero is true */
/* 	mask	16 bit mask bit true enables */
/* 	uint	16 bit unsigned value 0..65535 */
/* 	int	16 bit signed value -32768..32767 */
/* 	ulong	32 bit unsigned value 0..4294967295 */
/* 	long	32 bit signed value -2147483648..2147483647 */
/* 	double	64 bit signed value -1.8E19..1.8E19 */
/* 	ebyte	8 bit unsigned value in eeprom */
/* PARAMETER	VALUE	TYPE	FUNCTION */
#define nullLoc                                 0           /* (ptr) uninitialized pointers point to dummy */
#define dummyLoc                                0           /* (uint) default 16bit pointers point here  */
#define dummyhiLoc                              1           /* (uint) default 32bit pointers point here  */
#define goLoc                                   2           /* (flag) set true to start move */
#define pidLoc                                  3           /* (flag) set true to enable pid  */
#define profileLoc                              4           /* (uint) 0=off, 1=trapezoidal profile, 2=host profile */
#define drivemodeLoc                            5           /* (flag) false for voltage control, true for current control */
#define dirinvLoc                               6           /* (flag) set true to invert motor drive polarity */
#define proctimerLoc                            7           /* (uint) read sample timer */
#define stepdirLoc                              8           /* (flag) true for step/direction inputs */
#define homeLoc                                 9           /* (flag) becomes true when home has occured */
#define motionLoc                               10          /* (flag) becomes false when velocity = 0 */
#define slewLoc                                 11          /* (flag) true when maximum velocity is reached */
#define errorLoc                                12          /* (uint) non-zero when excessive position, or drive error */
#define errormaskLoc                            13          /* (mask) mask for error, default enabled */
#define eventsLoc                               14          /* (uint) number of events, 24 max */
#define maxpwmLoc                               15          /* (uint) pwm limited to this value */
#define avgvelLoc                               16          /* (int) average velocity 8.8 */
#define exposerrLoc                             17          /* (uint) excessive position error limit <32767 */
#define maxnegerrLoc                            18          /* (int) max negative error */
#define maxposerrLoc                            19          /* (int) max positive error */
#define driveerrorLoc                           20          /* (uint) variable to count, */
#define posencLoc                               21          /* (ptr) pointer to position encoder */
#define velencLoc                               22          /* (ptr) pointer to velocity encoder */
#define actvelLoc                               23          /* (int) actual velocity */
#define bnderrLoc                               24          /* (int) bounded (@follow-@posenc) */
#define extvelocityLoc                          25          /* (ptr) pointer to actvel, for external velocity */
#define followLoc                               26          /* (ptr) pointer to desired position */
#define pwmLoc                                  27          /* (int) pwm value */
/* 32bit user parameters */
#define homepospLoc                             28          /* (long) position loaded when primary index occurs */
#define phasekLoc                               30          /* (long) phase konstant */
#define phaseaLoc                               32          /* (long) phase accumulator, phasek is added to phasea each sample */
#define encpLoc                                 34          /* (long) primary encoder, read only */
#define desvelLoc                               36          /* (long) desired velocity, set by slewlimit */
/* 16bit user parameters */
#define timeoutLoc                              38          /* (uint) incremented each time we haven't finished before the next sample */
#define syncLoc                                 39          /* (flag) set before host, cleared after */
/* filter param */
#define kkLoc                                   40          /* (int) pwm offset, initial pwm value */
#define kffLoc                                  41          /* (uint) friction in the direction of motion */
#define kpLoc                                   42          /* (uint) kpd*error added to pwm */
#define kdLoc                                   43          /* (uint) kdd*actualvelocity added to pwm */
#define kaLoc                                   44          /* (uint) unused accel error */
#define kiLoc                                   45          /* (ulong) ki*error added to integralq each sample, high word added to pwm */
#define kihLoc                                  46          /* (uint) high word of ki not used */
#define kilLoc                                  47          /* (uint) high word limit of ki, 32767 max */
#define kf0Loc                                  48          /* (uint) (unimplemented) spring */
#define kf1Loc                                  49          /* (uint) velocity ff */
#define kf2Loc                                  50          /* (uint) accel ff */
#define kf3Loc                                  51          /* (uint) phasor velocity feedforward unused */
#define kdfilLoc                                52          /* (uint) amount of filtering */
#define driveplusLoc                            53          /* (uint) amount added to driveerror if maxpwm, generates error if overflow */
#define driveminusLoc                           54          /* (uint) amount subtracted from driveerror if not maxpwm, bounded at 0 */
/* profile parameters with breakpoint registers */
#define desposdLoc                              56          /* (double) 32.32 profile position */
#define desposfLoc                              56          /* (long) fractional part of profile position */
#define desposLoc                               58          /* (long) integer part of profile position */
#define velocityLoc                             60          /* (long) profile velocity		 */
#define accelfLoc                               62          /* (int) fractional part of accel for jerk */
#define accelLoc                                63          /* (long) acceleration, if 0 then no motion */
#define jerkLoc                                 65          /* (long) added to accel each sample */
#define breakpointLoc                           67          /* (long) block breakpoint value */
#define nextproblockLoc                         69          /* (ptr) pointer to next profile block */
#define nextposLoc                              70          /* (long) where we want to go next */
#define slewlimitLoc                            72          /* (long) slew speed limit, 2^23-1 max for kf1,kf2 */
/* 32bit internal use only */
#define startposLoc                             74          /* (long) begining of move */
#define deltaLoc                                76          /* (long) velq - velocityq  */
#define velocityfLoc                            78          /* (int) fractional part of velocity */
/* free		79	%uint	 */
#define checkposLoc                             80          /* (long) checking position for done */
#define decelposLoc                             82          /* (long) position to start decel */
#define fixupLoc                                84          /* (long) profile generator error */
#define preslewvelLoc                           86          /* (long) velocity before slew starts or maximum velocity */
#define preslewposLoc                           88          /* (long) position before slew starts or maximum velocity */
/* 48bit number internal use only */
#define integralLoc                             90          /* (long) integral error accumulator */
#define integralovfLoc                          92          /* (int) overflow for integral */
/* 16bit internal use only */
#define stopathomeLoc                           93          /* (flag) if true desvel and go are cleared at home */
#define skipLoc                                 94          /* (flag) skip position update once only */
#define lastposLoc                              95          /* (uint) last actual position low half */
#define lastvelocityLoc                         96          /* (int) old velocity */
#define gphasefLoc                              97          /* (flag) set true on carry of gphasea */
#define gphasekLoc                              98          /* (long) gphase konstant */
#define gphaseaLoc                              100         /* (long) gphase accumulator, gphasek is added to gphasea each sample */
#define prescaleLoc                             102         /* (uint) samplerate is sysclk/prescale  */
#define slowLoc                                 103         /* (flag) set true for dot 32 velocity */
#define flagxorLoc                              104         /* (uint) wait for flag xor invert */
#define flagandLoc                              105         /* (uint) wait for flag and mask  */
#define userstatusLoc                           106         /* (uint) low byte read by read status command */
/* ************************* PORTS ********************************************* */
#define cntcntlpLoc                             107         /* (uint) counter control register */
#define cntclrpLoc                              108         /* (flag) set true to clear counter */
#define pwmgenaLoc                              109         /* (uint) motor pwm */
#define motoriLoc                               110         /* (uint) motor current limit */
#define diraLoc                                 111         /* (uint) motor direction */
#define enaLoc                                  112         /* (uint) motor on */
#define outportLoc                              113         /* (uint)  */
#define inportLoc                               114         /* (uint) user port */
#define analog0Loc                              115         /* (uint) analog inputs */
#define analog1Loc                              116         /* (uint) analog inputs */
#define analog2Loc                              117         /* (uint) analog inputs */
/* user ram */
#define eventfirstLoc                           118         /* (uint)  */
#define event1Loc                               118         /* (uint)  */
#define event2Loc                               124         /* (uint)  */
#define event3Loc                               130         /* (uint)  */
#define event4Loc                               135         /* (uint)  */
#define event5Loc                               142         /* (uint)  */
#define event6Loc                               148         /* (uint)  */
#define event7Loc                               154         /* (uint)  */
#define event8Loc                               160         /* (uint)  */
#define event9Loc                               166         /* (uint)  */
#define event10Loc                              172         /* (uint)  */
#define event11Loc                              178         /* (uint)  */
#define event12Loc                              184         /* (uint)  */
#define event13Loc                              190         /* (uint)  */
#define event14Loc                              196         /* (uint)  */
#define event15Loc                              202         /* (uint)  */
#define event16Loc                              208         /* (uint)  */
#define event17Loc                              214         /* (uint)  */
#define event18Loc                              220         /* (uint)  */
#define event19Loc                              226         /* (uint)  */
#define event20Loc                              232         /* (uint)  */
#define eventlastLoc                            232         /* (uint)  */
/* ************************* FIFOS ********************************************** */
#define icdfifocountLoc                         238         /* (uint) count of data in icdfifo */
#define irbfifocountLoc                         239         /* (uint) count of data in irbfifo */
#define ififowriteLoc                           0x400       /* (uint) marker for event logic */
#define qcdfifocountLoc                         240         /* (uint)  */
#define qrbfifocountLoc                         241         /* (uint)  */
#define qfifowriteLoc                           0x800       /* (uint) marker for event logic */
#define icdfifosizeLoc                          242         /* (uint) immediate command\data fifo size  */
#define qcdfifosizeLoc                          243         /* (uint) queued command\data fifo size  */
#define irbfifosizeLoc                          244         /* (uint) immediate readback fifo size  */
#define qrbfifosizeLoc                          245         /* (uint) queued readback fifo size  */
/* ************************* SYSTEM CONSTANTS ********************************** */
/* software constants */
#define cputypeLoc                              246         /* (uint) CPU type */
#define controltypeLoc                          247         /* (uint) number of motor phases */
#define swrevisionLoc                           248         /* (uint) majorrev hibyte minorrev lobyte */
/* hardware constants */
#define naxisLoc                                249         /* (uint) 1 */
#define zeroLoc                                 250         /* (int) 0 */
#define falseLoc                                250         /* (flag) false */
#define oneLoc                                  251         /* (int) 1 */
#define trueLoc                                 252         /* (flag) true */
#define minusoneLoc                             252         /* (int) -1 */
#define sysclkLoc                               253         /* (long) CPU clock frequency */
#define hwrevisionLoc                           255         /* (uint) hwtype in hi byte revision in low byte */
/* ******************* BOGUS STUFF FOR DCMTUNE ******************************* */
#define ififoreadLoc                            0           /* (uint) immediate fifo */
#define ififoreadcountLoc                       0           /* (uint) count of data */
#define ififoparamLoc                           0           /* (uint) parameter */
#define ififoaxisLoc                            0           /* (uint) axis */
#define ififowritecountLoc                      0           /* (uint)  */
#define qfiforeadLoc                            0           /* (uint) queued fifo */
#define qfiforeadcountLoc                       0           /* (uint)  */
#define qfifoparamLoc                           0           /* (uint)  */
#define qfifoaxisLoc                            0           /* (uint)  */
#define qfifowritecountLoc                      0           /* (uint)  */
/* multiphase motor parameters internal use only */
#define phaseleadLoc                            0           /* (int) lead angle */
#define motorangleLoc                           0           /* (uint) sintablesize / angle between phases */
#define motorphaseLoc                           0           /* (uint) encp mod encodercnt */
#define homeoffsetLoc                           0           /* (int) offset from home position */
#define postscaleLoc                            0           /* (uint) sample rate = pwm rate/postscale, write only */
#define ledaxisLoc                              0           /* (ptr) axis for leds to monitor */
#define ledLoc                                  0           /* (ptr) parameter for leds to monitor, if not zero */
#define geventsLoc                              0           /* (uint) number of global events 36 max */
/* global ram */
#define firstgeventLoc                          0           /* (uint)  */
#define geventfirstLoc                          0           /* (uint)  */
#define gevent1Loc                              0           /* (uint)  */
#define geventlastLoc                           0           /* (uint)  */
#define lastgeventLoc                           0           /* (uint)  */
#define endofglobalramLoc                       0           
#define addressLoc                              1           /* (ebyte)  */
#define baudselLoc                              2           /* (ebyte)  */
#define serialmodeLoc                           3           /* (ebyte)  */
#define loadparamLoc                            6           /* (ebyte)  */
#define stepdirenaLoc                           7           /* (ebyte)  */
