{ These are are machine created parameter location (smotcons) and }
{ bit mask (smotbits) include files... do not edit these files directly }
{ they are created from the source files with MAKEINC }

const
{$IFDEF DSPIC}
{$I MOTPARMD.PAS} { for 3C20 }
{$I MOTBITSD.PAS}
{$ELSE}
{$I MOTPARM4.PAS}
{$I MOTBITS4.PAS}
{$ENDIF}

{$I SerCmds4.pas}    { softdmc commands }

{$IFDEF WINDOWS}
var
ser:TBlockSerial;
{$ELSE}
{$I Serial.pas}      { include low level serial routines }
{$ENDIF}

type DoubleIntRec = record
  Word0  : word;
  Word1  : word;
  Word2  : word;
  Word3  : word;
end;

type DoublelongRec = record
  long0  : longint;
  long1  : longint;
end;

type LongIntRec = record
  LowWord  : word;
  HighWord : word;
end;

type WordRec = record
  LowByte : byte;
  HighByte : byte;
end;

ParamArray = array[1..1024] of word;

var
Sysclk: longint;
BusIntfc : boolean;
SerError : boolean;
CharTimeOut : longint;
PollTimeOut : longint;
UARTBaudRate : longint;
TheBaudRate : longint;
TheBaudRateMul : integer;

{$I hread.pas}
{$I hprint.pas}

procedure Timeouterror(S:string);
begin
  writeln('Timeout error while waiting for ',S);
  halt(2);
end;

const
TimeOutSeconds = 3;
BusTimeout = 500000*TimeOutSeconds;
BitsPerChar = 10;
PollChars = 8;
TwoToThe31 = 2147483647;
TwoToThe32 = 4294967296.0;
VelocityConstant = $01000000; { 2^24 }
DefaultSysClk = 50000000;
AxisOffset = 10;
ProcResetBit : word = $8000;
ClrIRQBit : word = $4000;
LongFlag : word = $2000;
WaitTokenFlag : word = $4000;
DoubleFlag : word = $6000;
WriteFlag : word = $8000;
BlockFlag : word = $C000;
ROMSize1 = 1024;
ROMSize2 = 2048;
SignatureOffset = -1;
Signature = $CAFE;
DefaultPC104BasePort0 = $220;
DefaultPC104BasePort1 = $230;
DefaultPC104BasePort2 = $240;
DefaultPC104BasePort3 = $250;

DefaultPC104BasePort = DefaultPC104BasePort0;

IFIFOPortOffset = 0;
QFIFOPortOffset = 4;
ROMAddOffset =  8;
StatusRegOffset = 8;
ROMDataOffset  = 12;

var
PC104Port,PCIPort : word;
IFIFOPort : word;
QFIFOPort : word;
ROMAddPort : word;
StatusPort : word;
ROMDataPort : word;

{$IFNDEF WINDOWS}
function BusReadStatus : word;
begin
    BusReadStatus := portw[StatusPort]
end;

procedure SendString(s: string);
var index : word;
begin
  for index := 1 to length(s) do
  begin
    PolledPutComChar(TheComPort,s[index]);
  end;
end;


procedure SendStringWithCTSHandshakeAndTimeout(s: string);
var index : word;
begin
  for index := 1 to length(s) do
  begin
    PolledPutComCharWithCTSHandshakeAndTimeout(TheComPort,s[index],CharTimeOut);
  end;
end;

function RecvString(sz: word) : string;
var
index : word;
tstring : string;
achar : char;
begin
  tstring := '';
  index := 1;
  while (index <= sz) and (not SerError) do
  begin
    if PolledGetComCharWithTimeout(TheComPort,achar,CharTimeOut) = 0 then SerError := true;
    if achar = NAK then SerError := true;
    tstring := tstring + achar;
    index := index + 1
  end;
  RecvString := tstring;
end;

function SerReadStatus: word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadFifoStatusCom + CR;
  SendString(sstring);
  sstring := RecvString(4);  { get 4 char hex string }
  if PolledGetComCharWithTimeout(TheComPort,retchar,CharTimeOut) =0 then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadStatus := data;
end;


function ReadFIFOStatus : word;
begin
   if BusIntfc then ReadFIFOStatus := BusReadStatus else ReadFIFOStatus := SerReadStatus;
end;

{$ELSE}   {WINDOWS}

function SerReceiveChar(timeout : longint) : char;
begin
  SerReceiveChar := char(ser.RecvByte(timeout));
end;



function SerReadStatus : word;
var
data : word;
sstring : string;
begin
  sstring := SerReadFifoStatusCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeout);  { get 4 char hex string }
  if SerReceiveChar(CharTimeout) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadStatus := data;
end;


function ReadFIFOStatus : word;
begin
  ReadFIFOStatus := SerReadStatus;
end;

{$ENDIF}


procedure WaitForIRBFIFONotEmpty;
var loop : word;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and IRE = 0) or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' IRB data');
end;


procedure WaitForICDFIFONotFull;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and IFF = 0) or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' ICD FIFO not full');
end;

procedure WaitForICDFIFONotHalfFull;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and IFH = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' ICD FIFO not half full');
end;

procedure WaitForQRBFIFONotEmpty;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and QRE = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' QRB data');
end;

procedure WaitForQCDFIFONotFull;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and QFF = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' QCD FIFO not full');
end;

procedure WaitForQCDFIFONotHalfFull;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and QFH = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' QCD FIFO not half full');
end;

procedure WaitForQRBFIFOHalfFull;
var loop : longint;
begin
  loop := 0;
  repeat
    loop := loop +1;
  until ((ReadFIFOStatus and QRH <> 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Timeouterror(' QRB FIFO half full');
end;

{$IFDEF WINDOWS}
{$I serhst4w.pas}
{$I parhstw.pas}
{$ELSE}
{$I parhost4.pas}
{$I serhost4.pas}
{$ENDIF}

{$IFNDEF WINDOWS}
function InitBusInterface(var message : string) : boolean;
var hstring : string;
begin
  InitBusInterface := false;
  if not SetupPCIWithMessage(PCIPort,message) then
  begin
    hstring := HexString(PC104Port,4);
    CardType := PC104;
    message := 'Using PC104 Port '+ hstring;
    BusInitSoftDMC(PC104Port);
    InitBusInterface := true;
  end
  else
  begin
    CardType := PCI;
    hstring := HexString(PCIPort,4);
    BusInitSoftDMC(PCIPort);
    InitBusInterface := true;
  end;
end;
{$ENDIF}


function InitializeInterface(var message : string) : boolean;
begin
  InitializeInterface := false;
 {$IFNDEF WINDOWS}
  if BusIntfc = true then
  begin
      InitializeInterface := InitBusInterface(message);
  end;
{$ENDIF}
  if BusIntfc = false then
  begin         {serial}
{$IFDEF WINDOWS}
    if not SerialInit then message := 'COMport Open Failed !' else
    begin
      TossChars;
{$IFDEF DSPIC}
      SerMesaStart;
      SerListen(0);
{$ENDIF}
      if SerSync then
      begin
        InitializeInterface := true;
        message := 'Using Serial Interface';
      end
      else message := 'Serial Communication failed !';
    end;
  end;
{$ELSE} {NOT WINDOWS}
    if not ComPortThere(TheComPort) then message := 'COMport not found !' else
    begin
      InitializeSerInterface;
{$IFDEF DSPIC}
      SerMesaStart;
      SerListen(0);
{$ENDIF} {DSPIC}
      if SerSync then
      begin
        InitializeInterface := true;
        message := 'Using Serial Interface';
      end
      else message := 'Serial Communication failed !';
    end;
  end;
{$ENDIF} {WINDOWS}
end;

procedure GetOurEnv;
var
retcode : integer;
portstr,baudstr,baudmulstr,busstr,pc104addstr : string;
baud : longint;
port : word;
comport : longint;
scomport : string;
begin
  PollTimeout := BusTimeOut;
  portstr := UpString(GetEnv('COMPORT'));
  baudstr := GetEnv('BAUDRATE');
  baudmulstr := GetEnv('BAUDRATEMUL');
  busstr := GetEnv('BUSINTFC');
  pc104Addstr := GetEnv('PC104ADD');
  BusIntfc := False;
{$IFNDEF WINDOWS}
  Pc104Port := DefaultPC104BasePort;
  if length(busstr) = 0 then
  begin
    writeln('Busintfc not in Environment, assuming true');
    BusIntfc := true;
  end;
  if upcase(busstr[1]) = 'Y' then BusIntfc := true;
  if upcase(busstr[1]) = 'T' then BusIntfc := true;
  if length(pc104addstr) <> 0 then
    if HexWordRead(pc104addstr,Pc104Port) then
    begin
      if (Pc104Port < $220) or (Pc104Port >$250) or (Pc104Port and $000F <> 0) then
      begin
        writeln('Invalid PC104 address');
        halt(2);
      end;
    end
    else
    begin
      writeln('Can''t parse PC/104 address');
      halt(2);
    end;
{$ENDIF}
  if BusIntfc = false then
  begin
    if length(portstr) = 0 then
    begin
      Writeln('Comport not in Environment, assuming COM1');
{$IFDEF WINDOWS}
      scomport := 'COM1';
{$ELSE}
      comport := COM1;
{$ENDIF}
    end;
    if length(baudmulstr) = 0 then
    begin
      Writeln('Baudrate Multiplier not in Environment, assuming 1');
      TheBaudRateMul := 1;
    end;
    if length(baudstr) = 0 then
    begin
      Writeln('Baudrate not in Environment, assuming 115200');
      baud := 115200;
    end;
    if length(portstr) <> 0 then
    begin
      if not (HexLongRead(portstr,comport)) then
      begin
{$IFDEF WINDOWS}
        scomport := '';
        if portstr = 'COM1' then scomport := 'COM1';
        if portstr = 'COM2' then scomport := 'COM2';
        if portstr = 'COM3' then scomport := 'COM3';
        if portstr = 'COM4' then scomport := 'COM4';
        if scomport = '' then
{$ELSE}
       comport := 0;
        if portstr = 'COM1' then comport := COM1;
        if portstr = 'COM2' then comport := COM2;
        if portstr = 'COM3' then comport := COM3;
        if portstr = 'COM4' then comport := COM4;
        if comport = 0 then
{$ENDIF}
        begin
          Writeln('Undecipherable COM port - bail out!');
          halt(2);
        end;
      end
      else
      begin
        if (comport <$100) or (comport >$3F8) then
        begin
          writeln('Out of range COM port address - bail out!');
          halt(2);
        end;
        if (comport and 7) <> 0 then
        begin
          Writeln('Illegal COM port address - bail out!');
          halt(2);
        end;
      end;
    end;
    if length(baudmulstr) <> 0 then
    begin
      val(baudmulstr,TheBaudRateMul,retcode);
      if (TheBaudRateMul <1) or (TheBaudRateMul >64) or (retcode <> 0) then
      begin
        Writeln('Illegal Baud rate Multiplier - bail out!');
        halt(2);
      end;
    end;
    if length(baudstr) <> 0 then
    begin
      val(baudstr,baud,retcode);
      if (baud < (300 * TheBaudrateMul)) or (baud > (115200 * TheBaudRateMul)) or (retcode <> 0) then
      begin
        Writeln('Illegal Baud rate - bail out!');
        halt(2);
      end;
    end;
    UARTBaudRate := baud div TheBaudRateMul;
    TheBaudRate := baud;
{$IFDEF WINDOWS}
    CharTimeout := TimeOutSeconds*1000;
    TheComPort := scomport;
{$ELSE}
    CharTimeout := BusTimeOut;
    TheComPort := word(comport);
{$ENDIF}
    PollTimeOut := trunc((TimeOutSeconds*TheBaudRate*TheBaudRateMul)/(BitsPerChar*PollChars));
  end; { serial }
end;

type
Event = record
  ER_Opcode : word;
  ER_Src1 : word;
  ER_Src2 : word;
  ER_Logand : word;
  ER_Logor : word;
  ER_Dest : word;
end;

{$IFNDEF WINDOWS}

function KeyPressed : boolean;
var flag : boolean;
begin
  asm
    mov ah,01
    int $16
    mov flag,false
    jz @nokey
    mov flag,true
    @nokey:
  end;
  KeyPressed := flag;
end;

{$ENDIF}

function ReadQFIFO :word;
begin
    if BusIntfc then
     ReadQFIFO := portw[QFIFOPort]
    else
     ReadQFIFO := SerReadQFIFO;
end;

procedure WriteCommand(theaxis: byte;theparm: word);
var command : word;
{ 16 bit parameter write }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteWaitToken(command)
  else
    SerWriteWaitToken(command);
end;

procedure WriteCommandQ(theaxis: byte;theparm: word);
var command : word;
{ 16 bit parameter write }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteWaitTokenQ(command)
  else
    SerWriteWaitTokenQ(command);
end;

procedure WriteParamWord(theaxis: byte;theparm: word;thedata : word);
var command : word;
{ 16 bit parameter write }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or WriteFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParamWord(command,thedata)
  else
    SerWriteParamWord(command,thedata);
end;

procedure WriteParam(theaxis: byte;theparm: word;thedata : longint);
var command : word;
{ full 32 bit parameter write - 2 words }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or WriteFlag or LongFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParam(command,thedata)
  else
    SerWriteParam(command,thedata);
end;

procedure WriteWaitToken(theaxis: byte;theparm: word);
var command : word;
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or WaitTokenFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteWaitToken(command)
  else
    SerWriteWaitToken(command);
end;

procedure WriteParamDouble(theaxis: byte;theparm: word;thedata : comp);
var command : word;
{64 bit parameter write - 4 words }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or WriteFlag or DoubleFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParamDouble(command,thedata)
  else
    SerWriteParamDouble(command,thedata);
end;

function ReadParamWord(theaxis: byte;theparm: word):word;
var command : word;
{16 bit parameter read }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParamWord := BusReadParamWord(command)
  else
    ReadParamWord := SerReadParamWord(command);
end;

function ReadParam(theaxis: byte;theparm: word):longint;
var command : word;
{ 32 bit parameter read }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or LongFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParam := BusReadParam(command)
  else
    ReadParam := SerReadParam(command);
end;

function ReadParamDouble(theaxis: byte;theparm: word): comp;
var command : word;
{ 64 bit parameter read }
begin
  WaitForICDFIFONotHalfFull;
  command := (theparm or DoubleFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParamDouble := BusReadParamDouble(command)
  else
    ReadParamDouble := SerReadParamDouble(command);
end;

procedure WriteParamWordQ(theaxis: byte;theparm: word;thedata : word);
var command : word;
{ 16 bit parameter write }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or WriteFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParamWordQ(command,thedata)
  else
    SerWriteParamWordQ(command,thedata);
end;

procedure WriteParamQ(theaxis: byte;theparm: word;thedata : longint);
var command : word;
{ full 32 bit parameter write - 2 words }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or WriteFlag or LongFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParamQ(command,thedata)
  else
    SerWriteParamQ(command,thedata);
end;

procedure WriteWaitTokenQ(theaxis: byte;theparm: word);
var command : word;
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or WaitTokenFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteWaitTokenQ(command)
  else
    SerWriteWaitTokenQ(command);
end;

procedure WriteParamDoubleQ(theaxis: byte;theparm: word;thedata : comp);
var command : word;
{ 64 bit parameter write - 4 words }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or WriteFlag or DoubleFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    BusWriteParamDoubleQ(command,thedata)
  else
    SerWriteParamDoubleQ(command,thedata);
end;

function ReadParamWordQ(theaxis: byte;theparm: word):word;
var command : word;
{16 bit parameter read }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParamWordQ := BusReadParamWordQ(command)
  else
    ReadParamWordQ := SerReadParamWordQ(command);
end;

function ReadParamQ(theaxis: byte;theparm: word):longint;
var command : word;
{ 32 bit parameter read }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or LongFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParamQ := BusReadParamQ(command)
  else
    ReadParamQ := SerReadParamQ(command);
end;

function ReadParamDoubleQ(theaxis: byte;theparm: word): comp;
var command : word;
{ 64 bit parameter read }
begin
  WaitForQCDFIFONotHalfFull;
  command := (theparm or LongFlag or (theaxis shl AxisOffset));
  if BusIntfc then
    ReadParamDoubleQ := BusReadParamDoubleQ(command)
  else
    ReadParamDoubleQ := SerReadParamDoubleQ(command);
end;

procedure ClearICDFIFO;
begin
  if CardType = ThreeC20 then SerClearICDFIFO else WriteParamWord(0,IFIFOReadCountLoc,0);
end;

procedure ClearQCDFIFO;
begin
  if CardType = ThreeC20 then SerClearQCDFIFO else WriteParamWord(0,QFIFOReadCountLoc,0);
end;

procedure ClearIRBFIFO;
begin
  if CardType = ThreeC20 then SerClearIRBFIFO else WriteParamWord(0,IFIFOWriteCountLoc,0);
end;

procedure ClearQRBFIFO;
begin
  if CardType = ThreeC20 then SerClearQRBFIFO else WriteParamWord(0,QFIFOWriteCountLoc,0);
end;

procedure ClearFIFOs;
begin
  ClearQCDFIFO;
  ClearIRBFIFO;
  ClearQRBFIFO;
  ClearICDFIFO;
end;

procedure WaitforMoveDone(axis : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,GoLoc);
  until (temp = 0);
end;

procedure Move(axis : word;nextpos : longint; acc : longint; maxv : longint);
begin
  WriteParamword(axis,MaxNegErrLoc,0);
  WriteParamword(axis,MaxPosErrLoc,0);
  WriteParam(axis,NextPosLoc,nextpos);
  WriteParam(axis,AccelLoc,acc);
  WriteParam(axis,SlewLimitLoc,maxv);
  WriteParamWord(axis,GoLoc,TrueF);
  WaitForMoveDone(axis);
end;

procedure VMove(axis : word; acc : longint; maxv : longint);
begin
  {Move in velocity mode}
  WriteParamword(axis,MaxNegErrLoc,0);
  WriteParamword(axis,MaxPosErrLoc,0);
  WriteParam(axis,AccelLoc,acc);
  WriteParam(axis,DesvelLoc,maxv);
end;

procedure WaitforTrue(axis : word; flag : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,flag);
  until (temp <> 0);
end;

procedure WaitforFalse(axis : word; flag : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,flag);
  until (temp = 0);
end;


procedure WaitTillStopped(axis : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,MotionLoc);
  until (temp = 0);
end;

procedure WaitforMoveDoneWithStats(axis : word);
var
temp : word;
cyctime,maxcyc : word;
begin
  { wait for motors to be done and sample loop time statistics}
  maxcyc := 0;
  repeat
    cyctime := ReadParamWord(0,ProcTimerLoc);
    if (cyctime > maxcyc) then maxcyc := cyctime;
    temp := ReadParamWord(axis,GoLoc);
  until ((temp and $00FF) = 0);  { check low byte for done-a-tude }
  writeln('Maximum cycle time = ',maxcyc*1e6*(1/SysClk):4:0,'uS');
  writeln('MaxNegErr = ',Integer(ReadParamWord(axis,MaxNegErrLoc)),' MaxPosErr = ',ReadParamWord(axis,MaxPosErrLoc));
end;

(* procedure ResetAxis(axis : byte);
begin
  WriteParamWord(axis,ResetLoc,FalseF);
  while ReadParamWord(axis,ResetLoc) = 0 do;
end; *)

function HomeQ(axis: byte) : boolean;
var
temp : word;
begin
 HomeQ:= (ReadParamWord(axis,HomeLoc) <> 0);
end;

procedure ClearHome(Axis : byte);
begin
 WriteParamWord(axis,HomeLoc,0);
end;

procedure SetHomePos(axis:word);
begin
  ClearHome(axis);
  WriteParamWord(axis,PIDLoc,FalseF); { turn off PID loop whilst futzing }
  WriteParam(axis,DesVelLoc,0); { stop any motion }
  WriteParamWord(axis,GoLoc,FalseF);    { turn off profile whilst futzing }
  WriteParam(axis,HomePosPLoc,0);  { clear home location}

  WriteParamWord(axis,CntClrPLoc,$FFFF); {clear}

(*  WriteParam(axis,DesPosLoc,0);  { clear Desired Pos reg }
  WriteParam(axis,NextPosLoc,0); { clear Next Pos reg }
  WriteParam(axis,LastPosLoc,0); { clear Last Pos reg }
  WriteParam(axis,EncPLoc,0);    { clear software encoder counter } *)
  WriteParamWord(axis,ErrorLoc,0); { clear any expe }
  WriteParamWord(axis,PIDLoc,TrueF); { re-enable PID }
  WriteParamWord(axis,EnaLoc,TrueF); { re-enable }
  while not HomeQ(axis) do;
  end;

procedure SeekHomePos(axis:word;nextpos : longint; acc : longint; maxv : longint);
begin
  WriteParamWord(axis,CntCntlPLoc,CCFilterBit or CCClrOnIDXBit); {Quad filter and clear-on-index}
  { You need to set the CCIdxPol bit if you want rising edge }
  { index detection instead of falling edge detection }
  WriteParam(axis,HomePosPLoc,0);   { home is 0 }
  WriteParamWord(axis,HomeLoc,FalseF); { clear the home flag }
  Move(axis,nextpos,acc,maxv);
  WaitForTrue(axis,HomeLoc);
  WriteParamWord(axis,HomeLoc,FalseF); { now that we're done, reset the home flag }
  WriteParam(axis,DesVelLoc,0); { controlled stop }
  WaitForFalse(axis,MotionLoc);
end;


function IndexHighQ(axis: byte;indexhigh : boolean) : boolean;
var
temp : word;
begin
 temp := ReadParamWord(axis,CntCntlPLoc);
 if (temp and CCidxbit) <> 0 then IndexHighQ := indexhigh else IndexHighQ := not indexhigh;
end;


procedure SetCOI(Axis : byte;indexhigh: boolean);
var temp : word;
begin
 temp := CCFilterBit or CCclrOnIDXBit or CCcntclroncebit;
 if indexhigh then temp := temp or CCIDXPolBit;
 WriteParamWord(axis,CntCntlPLoc,temp);
 ClearHome(Axis);
end;

procedure ClearCOI(Axis : byte);
begin
 WriteParamWord(axis,CntCntlPLoc,CCFilterBit);
end;

procedure WaitTillHome(axis : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,HomeLoc);
  until (temp <> 0);
end;

procedure SetStopAtHome(axis : word);
begin
  WriteParamWord(axis,StopAtHomeLoc,$FFFF);
end;

procedure ForceHome(axis : byte);
begin
  SetCOI(axis,true);
  WriteParamWord(axis,CntCntlPLoc,CCFilterBit); {quad filter}
  WriteParamWord(axis,CntClrPLoc,$FFFF); {clear}
end;

procedure Stop(axis:word);
begin
  WriteParamWord(axis,GoLoc,FalseF);
  WriteParam(axis,desvelloc,0);
  WaitTillStopped(axis);
end;

procedure QuickStop(axis:word;acc :longint);
begin
  WriteParam(axis,AccelLoc,acc);  { set accel up to stop quick }
  Stop(Axis);
end;

procedure RecoverFromExpe(axis:word);
var
realpos : longint;
begin
  if ReadParamWord(axis,ErrorLoc) <> 0 then
  begin
    writeln('Axis ',Axis,' stopped due to position error > ',ReadParam(Axis,MaxPosErrLoc));
    RealPos := ReadParam(Axis,EncPLoc); { get current actual position }
    writeln('Setting DesPos = Real Position: ',RealPos:12);
    WriteParam(Axis,DesPosLoc,RealPos);  { store it into desired Pos reg }
    WriteParam(Axis,LastPosLoc,RealPos); { store it into Last Pos reg so we dont  }
                                         { so we dont get a large KD generated thunk }
                                         { when we re-enable the PID loop }
    WriteParam(Axis,IntegralLoc,0);      { clear accumulated error (anti-thunk) }
    writeln('Clearing error and re-enabling PID on stopped channel');
    WriteParamWord(Axis,ErrorLoc,0);
    WriteParamWord(Axis,PIDLoc,1);
  end;
end;

function ReadError(Axis:byte): word;
begin
  ReadError := ReadParamWord(axis,ErrorLoc);
end;

function ReadRealPosition(Axis:byte): longint;
begin
  ReadRealPosition := ReadParam(axis,EncPLoc);
end;

function ReadFixup(Axis:byte): longint;
begin
  ReadFixup := ReadParam(axis,FixupLoc);
end;

function ReadDesVelocity(Axis:byte): longint;
begin
  ReadDesVelocity := ReadParam(axis,DesVelLoc);
end;

function ReadVelocity(Axis:byte): longint;
begin
  ReadVelocity := ReadParam(axis,VelocityLoc);
end;

function ReadDesPosition(Axis:byte): longint;
begin
  ReadDesPosition := ReadParam(axis,DesPosLoc);
end;

function ReadRealPositionShort(Axis:byte): integer;
begin
  ReadRealPositionShort := ReadParamWord(axis,EncPLoc);
end;

function ReadDesPositionShort(Axis:byte): integer;
begin
  ReadDesPositionShort := ReadParamWord(axis,DesPosLoc);
end;

function ReadDrive(Axis:byte): integer;
begin
  ReadDrive := ReadParamWord(axis,PWMLoc);
end;

function ReadNegError(axis : byte) : word;
begin
  ReadNegError := ReadParamWord(axis,MaxNegErrLoc);
end;

function ReadPosError(axis : byte) : word;
begin
  ReadPosError := (ReadParamWord(axis,MaxPosErrLoc));
end;

function ReadMotorAngle(axis : byte) : word;
begin
  ReadMotorAngle := (ReadParamWord(axis,MotorAngleLoc));
end;

function ReadMotorPhaseLead(axis : byte) : integer;
begin
  ReadMotorPhaseLead := (ReadParamWord(axis,PhaseLeadLoc));
end;

function ReadMotorType : word;
begin
  ReadMotorType := (ReadParamWord(0,ControlTypeLoc));
end;

procedure ClearPosErrs(axis: byte);
begin
  WriteParamWord(axis,MaxPosErrLoc,0);
  WriteParamWord(axis,MaxNegErrLoc,0);
end;

procedure LoadKP(Axis:byte;kp:word);
begin
  WriteParamWord(axis,KPLOC,kp);
end;

procedure LoadKD(Axis:byte;kd:word);
begin
  WriteParamWord(axis,KDLOC,kd);
end;

procedure LoadKDFIL(Axis:byte;kdfil:word);
begin
  WriteParamWord(axis,KDFILLOC,kdfil);
end;

procedure LoadKK(Axis:byte;kk:word);
begin
  WriteParamWord(axis,KKLOC,kk);
end;

procedure LoadKT(Axis:byte;kt:word);
begin
{$IFDEF DSPIC}
  WriteParamWord(axis,SlowLOC,kt);
{$ELSE}
  WriteParamWord(axis,PhaseleadLOC,kt);
{$ENDIF}
end;

procedure LoadKFF(Axis:byte;kff:word);
begin
  WriteParamWord(axis,KFFLOC,kff);
end;

procedure LoadKI(Axis:byte;ki:longint);
begin
  WriteParam(axis,KILOC,ki);
end;

procedure LoadKIL(Axis:byte;kil:word);
begin
  WriteParamWord(axis,KILLOC,kil);
end;

procedure LoadKF1(Axis:byte;kf1:word);
begin
  WriteParamWord(axis,KF1LOC,kf1);
end;

procedure LoadKF2(Axis:byte;kf2:word);
begin
  WriteParamWord(axis,KF2LOC,kf2);
end;

procedure LoadPostScale(sint : word);
begin
  WriteParamWord(0,PostScaleLoc,sint);
end;

procedure LoadPreScale(sint : word);
begin
  WriteParamWord(0,PreScaleLoc,sint);
end;

procedure LoadPosition(axis:byte;pos:longint);
begin
  WriteParam(axis,NextPosLoc,pos);
end;

procedure LoadVelocity(axis:byte;velo:longint);
begin
  WriteParam(axis,SlewLimitLoc,velo);
end;

procedure LoadAcceleration(axis:byte;accel:longint);
begin
  WriteParam(axis,AccelLoc,accel);
end;

procedure ProfileOff(axis: byte);
begin
  WriteParamWord(axis,ProfileLoc,FalseF);
end;

procedure ProfileOn(axis: byte);
begin
  WriteParamWord(axis,ProfileLoc,TrapezoidalMode);
end;

procedure PIDOff(axis : byte);
begin
  WriteParamWord(axis,PIDLoc,FalseF);
end;

procedure PIDOn(axis : byte);
begin
  WriteParamWord(axis,PIDLoc,TrueF);
end;

function ProfileOnQ(axis : byte): boolean;
begin
  if ReadParamWord(axis,ProFileLoc) <> 0 then ProfileOnQ := true else ProfileOnQ := false;
end;

procedure TurnOffMotor(axis:byte);
begin
  WriteParamWord(axis,EnaLoc,FalseF);
  WriteParamWord(axis,PIDLoc,FalseF);
  WriteParamWord(axis,ProfileLoc,FalseF);
end;

procedure TurnOnMotor(axis:byte);
begin
  WriteParamWord(axis,EnaLoc,TrueF);
  WriteParamWord(axis,PIDLoc,TrueF);
  ProfileOn(axis);
end;

procedure LoadDirectionFlag(axis:byte;flag:word);
begin
  WriteParamWord(axis,DirInvloc,flag);
end;

procedure LoadProctimer(val:word);
begin
  WriteParamWord(0,ProcTimerLoc,val);
end;

function ReadProctimer :word;
begin
  ReadProcTimer := ReadParamWord(0,ProcTimerLoc);
end;

procedure LoadTimeout(val:word);
begin
  WriteParamWord(0,TimeOutLoc,val);
end;

function ReadTimeout :word;
begin
  ReadTimeOut := ReadParamWord(0,TimeOutLoc);
end;

procedure StartTrajectory(axis:byte);
begin
  WriteParamWord(axis,GoLoc,TrueF);
end;

procedure ResetMot(Mot : byte);
begin
  TurnOffMotor(Mot);
end;

procedure LoadPosErrForStop(axis: byte;pos:longint);
begin
  WriteParamWord(axis,ExPosErrLoc,pos);
end;

function ReadMinorSWVersion: byte;
begin
  ReadMinorSWVersion := lo(ReadParamWord(0,swrevisionloc));
end;

function ReadMajorSWVersion: byte;
begin
  ReadMajorSWVersion := hi(ReadParamWord(0,swrevisionloc));
end;

function ReadSysClockFreq: longint;
begin
  ReadSysClockFreq := (ReadParam(0,SysClkLoc));
end;

function ReadHWVersion: word;
begin
  ReadHWVersion := ReadParamWord(0,hwrevisionLoc) and $00FF;
end;

function ReadQRBFIFOSize: word;
begin
  ReadQRBFIFOSize := ReadParamWord(0,qrbfifosizeLoc);
end;

function ReadNaxis: word;
begin
  ReadNaxis := ReadParamWord(0,NaxisLoc);
end;

function HardwareThere : boolean;
var idcode : string;
begin
  HardWareThere := false;
  if BusIntfc then
  begin
    portw[ROMAddPort] := ROMSize1 + SignatureOffset + ProcResetBit;
    if portw[ROMDataPort] = Signature then
    begin
      HardwareThere := true;
      portw[ROMAddPort] := 0; { remove reset }
    end;
  end
  else
  begin
{$IFDEF DSPIC}
    SerListen(0);
{$ENDIF}
    if SerSync then
    begin
      idcode := InquireID;
      if idcode = '7I60' then
      begin
        CardType := SevenI60;
        HardwareThere := true;
      end;
      if idcode = '3C20' then
      begin
        CardType := ThreeC20;
        HardwareThere := true;
        ClearFifos;
      end;
    end;
  end;
end;

procedure LEDs(Axis : byte; Param : word);
begin
  writeParamWord(0,LEDAxisLoc,Axis);
  writeParamWord(0,LEDLoc,Param);
end;

function EventLoc(num : byte) : word;
begin
  EventLoc := event1loc + eventblocksize*(num-1);
end;

function GEventLoc(num : byte) : word;
begin
  GEventLoc := GEvent1Loc + eventblocksize*(num-1);
end;

function AxisEvent(axis,num : byte;evrec : Event) : boolean;
var
eventptr : word;
begin
  AxisEvent := false;
  eventptr := EventLoc(num);
  if (eventptr >= EventFirstLoc) and (eventptr <= EventLastLoc) then
  begin
    with evrec do
    begin
      WriteParamWord(axis,eventptr+eventopcode,ER_opcode);
      WriteParamWord(axis,eventptr+eventsource1,ER_src1);
      WriteParamWord(axis,eventptr+eventsource2,ER_src2);
      WriteParamWord(axis,eventptr+eventand,ER_logand);
      WriteParamWord(axis,eventptr+eventor,ER_logor);
      WriteParamWord(axis,eventptr+eventdest,ER_dest);  {do last}
    end;
    AxisEvent := true;
  end;
end;

procedure AxisEventProc(axis: byte;var num: byte; opcode,src1,src2,logand,logor,dest : word);
var
eventptr : word;
begin
  eventptr := event1loc + eventblocksize*(num-1);
  WriteParamWord(axis,eventptr+eventopcode,opcode);
  WriteParamWord(axis,eventptr+eventsource1,src1);
  WriteParamWord(axis,eventptr+eventsource2,src2);
  WriteParamWord(axis,eventptr+eventand,logand);
  WriteParamWord(axis,eventptr+eventor,logor);
  WriteParamWord(axis,eventptr+eventdest,dest);  {do last}
  num := num + 1;
end;

function GlobalEvent(num : byte;evrec : Event) : boolean;
var
eventptr : word;
begin
  GlobalEvent := false;
  eventptr := GEventLoc(num);
  if (eventptr >= GEventFirstLoc) and (eventptr <= GEventLastLoc) then
  begin
    with evrec do
    begin
      WriteParamWord(0,eventptr+eventopcode,ER_opcode);
      WriteParamWord(0,eventptr+eventsource1,ER_src1);
      WriteParamWord(0,eventptr+eventsource2,ER_src2);
      WriteParamWord(0,eventptr+eventand,ER_logand);
      WriteParamWord(0,eventptr+eventor,ER_logor);
      WriteParamWord(0,eventptr+eventdest,ER_dest);  {do last}
    end;
    GlobalEvent := false;
  end;
end;

procedure GlobalEventProc(var num: byte; opcode,src1,src2,logand,logor,dest : word);
var
eventptr : word;
begin
  eventptr := gevent1loc + eventblocksize*(num-1);
  WriteParamWord(0,eventptr+eventopcode,opcode);
  WriteParamWord(0,eventptr+eventsource1,src1);
  WriteParamWord(0,eventptr+eventsource2,src2);
  WriteParamWord(0,eventptr+eventand,logand);
  WriteParamWord(0,eventptr+eventor,logor);
  WriteParamWord(0,eventptr+eventdest,dest);  {do last}
  num := num+1;
end;

{ changed hardwarethere checking for serial to get ID }
{ moved bus stuff to parhost4.pas }
{ changed getenv for hi baudrates using multiplier }
{ added initializeinterface = false to initializeinterface }
{ added comportthere to initializeinterface }
