/* Copyright (C) 2006 MESA Electronics.  All rights reserved. */
/* bitsd.inc */
#define majorrev                                64          /* (byte) updated when parameters change, hi byte */
#define minorrev                                2           /* (byte) lo byte */
#define truef                                   65535       /* (flag) value for flag types */
#define falsef                                  0           /* (flag) value for flag types */
/* profile modes */
#define noprofile                               0           /* (unit) value for profile_uint */
#define trapezoidalmode                         1           /* (uint) value for profile_uint */
#define externalprofile                         2           /* (unit) value for profile_uint */
#define IFF                                     0x8000      /* Immediate Command/data FIFO full flag */
#define IFH                                     0x4000      /* Immediate Command/data FIFO half full flag */
#define QFF                                     0x2000      /* Queued Command/data FIFO full flag */
#define QFH                                     0x1000      /* Queued Command/data FIFO half full flag */
#define IRE                                     0x800       /* Immediate Readback FIFO empty flag */
#define IRH                                     0x400       /* Immediate Readback FIFO half full flag */
#define QRE                                     0x200       /* Queued Readback FIFO empty flag */
#define QRH                                     0x100       /* Queued Readback FIFO half full flag */
/* parammask	03FFh */
/* ************************* EVENT BLOCK ************************************** */
/* register offsets */
#define eventopcode                             0           /* opcode */
#define eventsource1                            1           /* (ptr) type:pointer to operand */
#define eventsource2                            2           /* (ptr) pointer to second operand */
#define eventxor                                2           /* polarity */
#define eventsource2xor                         2           /* alias for either */
#define eventand                                3           /* mask */
#define eventfree1                              3           /* for arithmetic events */
#define eventor                                 4           /* or */
#define eventfree2                              3           /* for arithmetic events */
#define event2directlo                          3           /* space for source2 */
#define event2directhi                          4           /* space for source2 */
#define eventdest                               5           /* (ptr) destination pointer */
#define eventblocksize                          6           /* size of event block */
/* low byte */
#define eventresultcarryxor                     0x1         
#define eventresultzeroxor                      0x2         
/* hibyte */
#define eventresultcarryand                     0x100       
#define eventresultzeroand                      0x200       
/* logical events */
#define eventzero                               0x200       /* zeroand */
#define eventnotzero                            0x202       /* zeroand | zeroxor */
/* 1-2 */
#define eventcarry                              0x100       /* carryand  */
#define eventnotcarry                           0x101       /* carryand | carryxor */
#define eventgt                                 0x303       /* carryand | carryxor | zeroand | zeroxor */
#define eventlt                                 0x100       /* carryand */
#define eventgteq                               0x101       /* carryand | carryxor */
#define eventlteq                               0x300       /* carryand | zeroand */
#define eventeq                                 0x200       /* zeroand			 */
#define eventneq                                0x202       /* zeroand  | zeroxor */
#define eventdisable                            0x0         
/* eventopcode0            1000H	see initd.asm */
/* eventopcode1            2000H */
/* eventopcode2            4000H */
/* flags */
#define eventalways                             0x8000      /* always event (not if) */
#define eventedge                               0x800       /* edge event (del) */
#define eventsize0                              0x4         /* 32 bit operation */
#define eventsize1                              0x8         /* 64 bit operation */
#define eventhistory                            0x80        /* old result stored here */
/* conditional */
#define EventAddIf                              0x0         
#define EventAdd32If                            0x4         
#define EventSubIf                              0x1000      
#define EventSub32If                            0x1004      
#define EventMul16x16to16If                     0x2000      
#define EventCopyIf                             0x5000      
#define EventLogicalIf                          0x6000      
/* change events (Del) */
#define EventAddIfDel                           0x800       
#define EventAdd32IfDel                         0x804       
#define EventSubIfDel                           0x1800      
#define EventSub32IfDel                         0x1804      
#define EventMul16x16to16IfDel                  0x2800      
#define EventCopyIfDel                          0x5800      
#define EventLogicalIfDel                       0x6800      
/* always */
#define EventAdd                                0x8000      
#define EventAdd32                              0x8004      
#define EventSub                                0x9000      
#define EventSub32                              0x9004      
#define EventMul16x16to16                       0xA000      
#define EventCopy                               0xD000      
#define EventLogical                            0xE000      
/* ************************* QUAD COUNTER CONSTANTS *************************** */
/* cntcntl register */
#define CCinputabit                             0x1         /* read only input a  */
#define CCinputbbit                             0x2         /* read only input b  */
#define CCidxbit                                0x4         /* read only index input */
#define CCidxpolbit                             0x8         /* index polarity */
#define CCclronidxbit                           0x10        /* clear counter at index if set */
#define CCclrdflagbit                           0x20        /* set if count has been cleared (a 0 write will clear flag) */
#define CCfilterbit                             0x40        /* set for filter  */
#define CCcntdirbit                             0x100       /* set for reverse count direction */
#define CCcntclroncebit                         0x200       /* if set clear once */
/* status register */
#define samplebit                               1           /* lsb */
#define commandpending                          2           
/* ***************************** BLOCK OFFSETS ******************************** */
/* profilesize	18		size of block */
/* profilestart	56		beginning of motion block */
/* filtersize	16		size of filter block */
/* filterstart	40		begining of filter block */
/* ***************************** ERROR BITS ******************************** */
#define excessiveposition                       1           /* (err)  */
#define drivelimit                              2           /* (err)  */
/* ***************************** I\O BITS ******************************** */
#define in0                                     0x1         /* (mask)  */
#define in1                                     0x2         /* (mask)  */
#define inlimit                                 0x8000      /* (mask)  */
#define out0                                    0x1         /* (mask)  */
#define out1                                    0x2         /* (mask)  */
/* ***************************** MOTOR ************************************ */
#define onephasemotor                           1           /* (byte) software control type */
/* ***************************** BAUDRATES ******************************** */
#define baud110                                 0           /* (byte)  */
#define baud150                                 1           /* (byte)  */
#define baud300                                 2           /* (byte)  */
#define baud600                                 3           /* (byte)  */
#define baud1200                                4           /* (byte)  */
#define baud2400                                5           /* (byte)  */
#define baud4800                                6           /* (byte)  */
#define baud9600                                7           /* (byte)  */
#define baud19200                               8           /* (byte)  */
#define baud38400                               9           /* (byte)  */
#define baud57600                               10          /* (byte)  */
#define baud115200                              11          /* (byte)  */
#define baud230400                              12          /* (byte)  */
#define baud460800                              13          /* (byte)  */
#define baud921600                              14          /* (byte)  */
#define baud1843200                             15          /* (byte)  */
