program SDMCWriteParam;

{$DEFINE COPROC}
{$IFDEF COPROC}
{$N+}
{$ELSE}
{$N-}
{$ENDIF}

{$IFDEF WINDOWS}
uses synaser,dos,wincrt;
var TheComPort : string;
    ser:TBlockSerial;
{$ELSE}
uses dos,crt;
var TheComPort : word;
{$ENDIF}

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP} { for 3C20 }
{$I SELECTPR}
{$I INTERFCE}

var
Parameter : comp;
Retcode : integer;
UseQ : boolean;
UseHex : boolean;
ParmLoc : integer;
ByteData : byte;
WordData : word;
ParmName : string;
Message : string;

var
Parmtype : ParameterType;

procedure Error(err : integer);
begin
  writeln(errorrecord[err].errstr);
  halt(2);
end;

procedure Usage;
begin
  writeln('Usage: wp parm data [axis] [q] [h]');
  writeln;
  halt(2);
end;

function FindParm(aname : string) : boolean;
var
index : integer;
cname : string;
offset : word;
retcode : integer;
begin
  cname := StripTillChar(aname,'+');
  offset := 0;
  if length(aname) >0 then
  begin
    val(aname,offset,retcode);
    if retcode <> 0 then BumOut('Can''t parse offset');
  end;
  index := 1;
  while (upstring(cname) <> upstring(SDMCParams[index].ParmName)) and (index <= LastParm) do index := index +1;
  ParmLoc := SDMCParams[index].ParmLoc + offset;
  ParmType := SDMCParams[index].ParmType;
  ParmName := SDMCParams[index].ParmName; {so it will have the cannonical name}
  if index > LastParm then FindParm := false else findparm := true;
end;

procedure Pause;
var foo : string;
begin
  writeln;
  writeln('Press return to continue');
  readln(foo);
end;

procedure ShowParameters(s : string);
var index,lc : integer;
begin
  writeln('No such parameter: '+s);
  writeln('Valid parameters are: ');
  lc := 0;
  for index := 1 to LastParm do
  begin
    if (index mod 4) = 0 then
    begin
      writeln;
      lc := lc +1;
    end;
    if lc > 19 then
    begin
      Pause;
      lc := 0;
    end;
    write(PadWithSpaces(SDMCParams[index].ParmName,19));
  end;
  writeln;
  halt(2);
end;

procedure GetParameter;
var
temp : comp;
wtemp : word;
index : word;
begin
  GetOurEnv;
  UseQ := false;
  UseHex := false;
  if length(ParamStr(2)) = 0 then Usage;
  for index := 3 to 5 do
  begin
    if length(ParamStr(index)) > 0 then
    begin
      if upstring(ParamStr(index)) = 'Q' then UseQ := true;
      if upstring(ParamStr(index)) = 'H' then UseHex := true;
    end;
  end;
  if not FindParm(ParamStr(1)) then ShowParameters(ParamStr(1));
  Axis := 0;
  if UseHex = false then
  begin
    val(ParamStr(2),temp,Retcode);
    if retcode = 0 then Parameter := temp else Usage;
  end
  else
  begin
   if not HexDoubleRead(ParamStr(2),Parameter) then Usage;
  end;
  if length(ParamStr(3)) > 0 then
  begin
    val(ParamStr(3),wtemp,Retcode);
    if retcode = 0 then Axis := wtemp;
  end;
end;  { GetParameter }

begin
  GetParameter;
  if not InitializeInterface(Message) then bumout(Message);
  ClearFifos;
  if (parmtype = type_uint) or (parmtype = type_int) or (parmtype = type_byte)
  or (parmtype = type_ptr) or (parmtype = type_mask) or (parmtype = type_flag) then
  begin
    if Parameter > 65535 then Bumout('Parameter is too big for '+ParmName);
    if UseQ then WriteParamWordQ(Axis,ParmLoc,DoubleIntRec(Parameter).word0)
    else         WriteParamWord(Axis,ParmLoc,DoubleIntRec(Parameter).word0);
  end;
{$R-}
  if (ParmType = type_ulong) or (ParmType = type_long) then
  begin
    if UseQ then
    begin
      WriteParamQ(Axis,ParmLoc,DoubleLongRec(Parameter).Long0);
    end
    else
    begin
      WriteParam(Axis,ParmLoc,DoubleLongRec(Parameter).long0);
    end;
  end;
{$R+}
  if ParmType = type_Double then
  begin
    if UseQ then
    begin
      WriteParamDoubleQ(Axis,ParmLoc,Parameter);
    end
    else
    begin
      WriteParamDouble(Axis,ParmLoc,Parameter);
    end;
  end;
{$IFDEF EEPROM}
  if ParmType = type_ebyte then
  begin
    SerUnLock;
    ByteData := lo(DoubleIntRec(Parameter).word0);
    WriteEEPROM(byte(ParmLoc),ByteData);
    SerLock;
  end;
  if ParmType = type_eword then
  begin
    SerUnLock;
    WordData := (DoubleIntRec(Parameter).word0);
    WriteEEPROMWord(word(ParmLoc),WordData);
    SerLock;
  end;
{$ENDIF}
  halt(0);
end.
