{$N+}
program SDMCWaitOnFLag;

{DEFINE DSPIC} { for 3C20 }
{DEFINE WINDOWS}

{$IFDEF WINDOWS}
uses synaser,dos,wincrt;
var TheComPort : string;
ser:TBlockSerial;
{$ELSE}
uses dos,crt;
var TheComPort : word;
{$ENDIF}

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP}
{$I SELECTPR}
{$I INTERFCE}

var
Retcode : integer;
temp : word;
ParmLoc : integer;
ParmName : string;
UseQ : boolean;
Message : string;

procedure Error(err : integer);
begin
  writeln(errorrecord[err].errstr);
  halt(2);
end;

procedure Usage;
begin
  writeln('Usage: wf parm [q]');
  writeln;
  halt(2);
end;

procedure Pause;
var foo : string;
begin
  writeln;
  writeln('Press return to continue');
  readln(foo);
end;

function FindParm(aname : string) : boolean;
var
index : integer;
cname : string;
offset : word;
retcode : integer;
begin
  cname := StripTillChar(aname,'+');
  offset := 0;
  if length(aname) >0 then
  begin
    val(aname,offset,retcode);
    if retcode <> 0 then BumOut('Can''t parse offset');
  end;
  index := 1;
  while (upstring(cname) <> upstring(SDMCParams[index].ParmName)) and (index <= LastParm) do index := index +1;
  ParmLoc := SDMCParams[index].ParmLoc + offset;
  ParmName := SDMCParams[index].ParmName; {so it will have the cannonical name}
  if index > LastParm then FindParm := false else findparm := true;
end;

procedure ShowParameters(s : string);
var index,lc : integer;
begin
  writeln('No such parameter: '+s);
  writeln('Valid parameters are: ');
  lc := 0;
  for index := 1 to LastParm do
  begin
    if (index mod 4) = 0 then
    begin
      writeln;
      lc := lc +1;
    end;
    if lc > 19 then
    begin
      Pause;
      lc := 0;
    end;
    write(PadWithSpaces(SDMCParams[index].ParmName,19));
  end;
  writeln;
  halt(2);
end;

procedure GetParameter;
var
index : word;
begin
  GetOurEnv;
  if length(ParamStr(1)) = 0 then Usage;
  if not FindParm(ParamStr(1)) then ShowParameters(ParamStr(1));
  Axis := 0;
  if length(ParamStr(2)) > 0 then
  begin
    val(ParamStr(2),temp,Retcode);
    if retcode = 0 then Axis := temp;
  end;
  for index := 2 to 3 do
  begin
    if length(ParamStr(index)) > 0 then
    begin
      if upstring(ParamStr(index)) = 'Q' then UseQ := true;
    end;
  end;
end;  { GetParameter }

begin
  GetParameter;
  if not InitializeInterface(Message) then bumout(Message);
  { if ReadMajorSWVersion <> MajorRev then BumOut('SoftDMC Software version mis-match'); }
  { can't ClearFifos;}
  if UseQ then WriteWaitTokenQ(Axis,ParmLoc) else WriteWaitToken(Axis,ParmLoc);
  if SerError then bumout('Serial Timeout Error');
  halt(0);
end.
