{$N+}
program SDMCWaitOnFIFO;

{DEFINE DSPIC} { for 3C20 }
{DEFINE WINDOWS}

{$IFDEF WINDOWS}
uses synaser,dos,wincrt;
var TheComPort : string;
ser:TBlockSerial;
{$ELSE}
uses dos,crt;
var TheComPort : word;
{$ENDIF}

var
Message : string;
UseQ : boolean;
Done : boolean;
Limit : word;
Count : word;

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP}
{$I INTERFCE}

procedure Error(err : integer);
begin
  writeln(errorrecord[err].errstr);
  halt(2);
end;

procedure Usage;
begin
  writeln('Usage: WAITFIFO N [q]');
  writeln('Waits till Command/Data FIFO has N or fewer entries');
  writeln('ICDFIFO is default, Q specifies to wait for QCDFIFO');
  writeln('Access is always through other FIFO');

  halt(2);
end;

procedure GetParameter;
var
retcode : integer;
begin
  GetOurEnv;
  if length(ParamStr(1)) = 0 then Usage;
  val(ParamStr(1),Limit,retcode);
  if retcode <> 0 then Usage;
  if Limit < 0 then usage;
  if Limit > 8192 then usage;
  if length(ParamStr(2)) > 0 then
  begin
    if upstring(ParamStr(2)) = 'Q' then UseQ := true;
  end;
end;  { GetParameter }

begin
  GetParameter;
  if not InitializeInterface(Message) then bumout(Message);
  Done := false;
  while (not keypressed) and (not Done) do
  begin
    if UseQ then
    begin
      Count := ReadParam(0,QFIFOReadCountLoc);
      if Count <= Limit then Done := true;
    end
    else
    begin
      Count := ReadParamQ(0,IFIFOReadCountLoc);
      if Count <= Limit then Done := true;
    end;
    write(Count,'      ',chr(13));
  end;
  writeln;
  halt(0);
end.
