{for LBP}

{$I LBP.pas}
{$I CRC8.pas}
{DEFINE DEBUG}

const
XmitBufferSize = 1024;
NullCRC = char(0);

type
LBPDataBuffertype = array[0..4095] of word;
LBPDataBuffPtr = ^LBPDataBuffertype;

var
LBPDataBuffer : LBPDataBuffertype;
XmitBuffer : array[1 .. XmitBufferSize] of byte;
XmitBufferIndex : integer;
ExitOnCRCError : boolean;
LBPCRCEnabled, LBPCRCError : boolean;
LBPCRC : byte;

type
WordByteRec = record
  Byte0  : byte;
  Byte1  : byte;
end;

CompByteRec = record
  Byte0  : byte;
  Byte1  : byte;
  Byte2  : byte;
  Byte3  : byte;
  Byte4  : byte;
  Byte5  : byte;
  Byte6  : byte;
  Byte7  : byte;
end;

procedure AppendCRC(var s : string);
var i : integer;
thebyte,lookupbyte : byte;
begin
  if LBPCRCEnabled then
  begin
    LBPCRC := 0;
    for i := 1 to length(s) do
    begin
      thebyte := byte(s[i]);
      lookupbyte := LBPCRC xor thebyte;
      LBPCRC := GetCRC8(lookupbyte);
    end;
    s := s + char(LBPCRC);
{$IFDEF DEBUG}
    write('Appended ');
    hexprint(LBPCRC,2);
    Writeln
{$ENDIF DEBUG}
  end;
end;

function CheckCRC(is : string) : boolean;
var i : integer;
thebyte,lookupbyte : byte;
begin
  LBPCRCError := false;
  if LBPCRCEnabled then
  begin
    LBPCRC := 0;
    for i := 1 to length(is) do
    begin
      thebyte := byte(is[i]);
      lookupbyte := LBPCRC xor thebyte;
      LBPCRC := GetCRC8(lookupbyte);
    end;
    SerRecvChar(char(thebyte));
    CheckCRC := (theByte = LBPCRC);
{$IFDEF DEBUG}
      write(' Got  ');
      HexPrint(thebyte,2);
      write(' should be  ');
      HexPrint(LBPCRC,2);
      writeln;
{$ENDIF DEBUG}
    if theByte <> LBPCRC then
    begin
      LBPCRCError := true;
      if ExitOnCRCError then Bumout('CRC Error!');
    end;
  end;
end;

procedure AddByteToXmitBuffer(d: byte);
begin
  XmitBuffer[XmitBufferIndex] := d;
  XmitBufferIndex := XmitBufferIndex + 1;
end;

function LBPReadByte(add : word) : byte;
var s, is : string;
begin
  s := char(LBPCOMMAND_byte or LBPA2_byte or LBPD1_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  AppendCRC(s);
  SerSendString(s);
  SerRecvString(1,is);
  LBPCRCError := CheckCRC(is);
  LBPReadByte := byte(is[1]);
end;

function LBPReadWord(add : word) : word;
var
s, is : string;
data : word;
begin
  s := char(LBPCOMMAND_byte or LBPA2_byte or LBPD2_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  AppendCRC(s);
  SerSendString(s);
  SerRecvString(2,is);
  WordByteRec(data).Byte0 := byte(is[1]);
  WordByteRec(data).Byte1 := byte(is[2]);
  LBPCRCError := CheckCRC(is);
  LBPReadWord := data;
end;

function LBPReadLong(add : word) : longint;
var data : longint;
s, is : string;
begin
  s := char(LBPCOMMAND_byte or LBPA2_byte or LBPD4_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  AppendCRC(s);
  SerSendString(s);
  SerRecvString(4,is);
  LongIntByteRec(data).Byte0 := byte(is[1]);
  LongIntByteRec(data).Byte1 := byte(is[2]);
  LongIntByteRec(data).Byte2 := byte(is[3]);
  LongIntByteRec(data).Byte3 := byte(is[4]);
  LBPCRCError := CheckCRC(is);
  LBPReadLong := data;
end;

function LBPReadDouble(add : word) : comp;
var data : comp;
s, is : string;
begin
  s := char(LBPCOMMAND_byte or LBPA2_byte or LBPD8_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  AppendCRC(s);
  SerSendString(s);
  SerRecvString(8,is);
  CompByteRec(data).Byte0 := byte(is[1]);
  CompByteRec(data).Byte1 := byte(is[2]);
  CompByteRec(data).Byte2 := byte(is[3]);
  CompByteRec(data).Byte3 := byte(is[4]);
  CompByteRec(data).Byte4 := byte(is[5]);
  CompByteRec(data).Byte5 := byte(is[6]);
  CompByteRec(data).Byte6 := byte(is[7]);
  CompByteRec(data).Byte7 := byte(is[8]);
  LBPCRCError := CheckCRC(is);
  LBPReadDouble := data;
end;

procedure LBPWriteByte(add:word; data: byte);
var s : string;
begin
  s := char(LBPCOMMAND_byte or LBPWRITE_byte or LBPA2_byte or LBPD1_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  s := s + char(data);
  AppendCRC(s);
  SerSendString(s);
  CheckCRC(NullCRC);
end;

procedure LBPWriteWord(add:word; data: word);
var s : string;
begin
  s := char(LBPCOMMAND_byte or LBPWRITE_byte or LBPA2_byte or LBPD2_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  s := s + char(WordByteRec(data).Byte0);
  s := s + char(WordByteRec(data).Byte1);
  AppendCRC(s);
  SerSendString(s);
  CheckCRC(NullCRC);
end;

procedure LBPWriteLong(add:word; data: longint);
var s : string;
begin
  s := char(LBPCOMMAND_byte or LBPWRITE_byte or LBPA2_byte or LBPD4_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  s := s + char(LongIntByteRec(data).Byte0);
  s := s + char(LongIntByteRec(data).Byte1);
  s := s + char(LongIntByteRec(data).Byte2);
  s := s + char(LongIntByteRec(data).Byte3);
  AppendCRC(s);
  SerSendString(s);
  CheckCRC(NullCRC);
end;

procedure LBPWriteDouble(add:word; data: comp);
var s : string;
begin
  s := char(LBPCOMMAND_byte or LBPWRITE_byte or LBPA2_byte or LBPD8_byte);
  s := s + char(WordByteRec(add).Byte0);
  s := s + char(WordByteRec(add).Byte1);
  s := s + char(CompByteRec(data).Byte0);
  s := s + char(CompByteRec(data).Byte1);
  s := s + char(CompByteRec(data).Byte2);
  s := s + char(CompByteRec(data).Byte3);
  s := s + char(CompByteRec(data).Byte4);
  s := s + char(CompByteRec(data).Byte5);
  s := s + char(CompByteRec(data).Byte6);
  s := s + char(CompByteRec(data).Byte7);
  AppendCRC(s);
  SerSendString(s);
  CheckCRC(NullCRC);
end;

function LBPLocalRead(command : byte) : byte;
var s,is : string;
begin
  s := char(command);
  AppendCRC(s);
  SerSendString(s);
  SerRecvString(1,is);
  LBPCRCError := CheckCRC(is);
  LBPLocalRead := byte(is[1]);
end;

procedure LBPLocalWrite(command,data : byte);
var s : string;
begin
  s := char(LBPWRITE_byte or command);
  s := s + char(data);
  AppendCRC(s);
  SerSendString(s);
  CheckCRC(NullCRC);
end;

function LBPReadCookie: byte;
begin
  LBPReadCookie := LBPLocalRead(LBPREADCOOKIE_byte);
end;

function LBPReadRPCPitch: byte;
begin
  LBPReadRPCPitch := LBPLocalRead(LBPRPCPITCH_byte);
end;

function LBPReadCardName : string;
var
s : string[4];
begin
  s[1] := char(LBPLocalRead(LBPCARDNAME0_byte));
  s[2] := char(LBPLocalRead(LBPCARDNAME1_byte));
  s[3] := char(LBPLocalRead(LBPCARDNAME2_byte));
  s[4] := char(LBPLocalRead(LBPCARDNAME3_byte));
  LBPReadCardName := s;
end;

procedure LBPEnableCRC;
begin { do manually because crcs are enable after command }
  SerSendChar(char(LBPWRITE_byte or LBPENACRC_FLAG));
  SerSendChar(char(LBPTRUE_flag));
  LBPCRCEnabled := true;
  CheckCRC(NullCRC);
end;

procedure LBPDisableCRC;
begin
  LBPLocalWrite(LBPENACRC_flag,LBPFALSE_flag);
end;

function LBPReadVersion : byte;
begin
  LBPReadVersion := LBPLocalRead(LBPVERSION_byte);
end;

function LBPReadStatus: byte;
begin
  LBPReadStatus := LBPLocalRead(LBPSTATUS_byte);
end;

procedure LBPWriteStatus(data : byte);
begin
  LBPLocalWrite(LBPSTATUS_byte,data);
end;

procedure LBPClearStatus;
begin
  LBPLocalWrite(LBPSTATUS_byte,0);
end;

function LBPReadRPCSize : word;
var data : word;
begin
  WordByteRec(data).Byte0 := LBPLocalRead(LBPRPCSIZEL_byte);
  WordByteRec(data).Byte1 := LBPLocalRead(LBPRPCSIZEH_byte);
  LBPReadRPCSize := data;
end;

procedure LBPWriteLEDS(data : byte);
begin
  LBPLocalWrite(LBPSETLEDS_byte,data);
end;

procedure LBPWriteAddToAddress(n : byte);
begin
  LBPLocalWrite(LBPADDADDRESS_byte,n);
end;

procedure LBPProcReset;
begin
  LBPLocalWrite(LBPPROCRESET_byte,LBPRESETCODE_byte);
end;

procedure LBPSoftDMCResetOn;
begin
  LBPWriteWord(ROMAddPort,$8000); { Reset on }
end;

procedure LBPSoftDMCResetOff;
begin
  LBPWriteWord(ROMAddPort,$0000); { Reset Off }
end;

procedure LBPWriteRom(add : word;data : word);
begin
  LBPWriteWord(ROMAddPort,(add or ProcResetBit));
  LBPWriteWord(ROMDataPort,data);
end;

function LBPReadRom(add : word): word;
begin
  LBPWriteWord(ROMAddPort,(add or ProcResetBit));
  LBPReadRom := LBPReadWord(ROMDataPort);
end;

procedure LBPWriteEEPROM(add : word;data : byte);
begin
  LBPLocalWrite(LBPNONVOL_flag,LBPNONVOLEEPROM_byte);
  LBPWriteByte(add,data);
  LBPLocalWrite(LBPNONVOL_flag,0);
end;

function LBPReadEEPROM(add : word): byte;
begin
  LBPLocalWrite(LBPNONVOL_flag,LBPNONVOLEEPROM_byte);
  LBPReadEEPROM := LBPReadByte(add);
  LBPLocalWrite(LBPNONVOL_flag,0);
end;

procedure LBPWriteEEPROMWord(add : word;data : word);
begin
  LBPLocalWrite(LBPNONVOL_flag,LBPNONVOLEEPROM_byte);
  LBPWriteWord(add,data);
  LBPLocalWrite(LBPNONVOL_flag,0);
end;

function LBPReadEEPROMWord(add : word): word;
begin
  LBPLocalWrite(LBPNONVOL_flag,LBPNONVOLEEPROM_byte);
  LBPReadEEPROMWord := LBPReadWord(add);
  LBPLocalWrite(LBPNONVOL_flag,0);
end;

procedure FlashStart;
begin
  LBPLocalWrite(LBPNONVOL_flag,LBPNONVOLFLASH_byte);
end;

procedure FlashStop;
begin
  LBPLocalWrite(LBPNONVOL_flag,0);
end;

function GetWriteSize : word;
begin
  GetWriteSize := 1 shl LBPReadByte(LBPFLASHWRITESIZE_ptr);
end;

function GetEraseSize : word;
begin
  GetEraseSize := 1 shl LBPReadByte(LBPFLASHERASESIZE_ptr);
end;

procedure SetOffset(off : longint);
begin
  LBPWriteLong(LBPFLASHOFFSET_ptr,off);
end;

function GetOffset:  longint;
begin
  GetOffset := LBPReadLong(LBPFLASHOFFSET_ptr);
end;

function ProgSync: boolean;
begin
  ProgSync := not(SerError) and (LBPCOOKIECODE_byte = LBPReadCookie);
end;

procedure CommitErase;
begin
  LBPWriteByte(LBPFLASHCOMMIT_ptr,LBPFLASHERASE_byte);
  if not ProgSync then BumOut('Sync error');
end;

procedure CommitWrite;
begin
  LBPWriteByte(LBPFLASHCOMMIT_ptr,LBPFLASHWRITE_byte);
  if not ProgSync then BumOut('Sync error');
end;

function LBPSync(var message : string) : boolean;
begin
  SerError := false;
  ExitOnTimeout := false;
  ExitOnCRCError := false;
  LBPSync := false;
  LBPCRCEnabled := false;
  LBPCRC := 0;
  message := 'LBP Serial Communication failed !';

  SerTossChars;
  delay(300); { sync}
  SerTossChars;
  CharTimeout := 50*LoopsPerMs;
  if ProgSync then
  begin
    LBPSync := true;
    message := 'Using LBP Serial Interface';
  end
  else
  begin { try with crcs enabled }
    if SerError then
    begin
      SerError := false;
      LBPCRCEnabled := true;
      if ProgSync then
      begin
      {  if not(LBPCRCError) then}
        begin
          LBPWriteByte(2048,$bb);
          LBPClearStatus;
          LBPWriteByte(2048,$aa);
          LBPSync := true;
          message := 'Using LBP Serial Interface With CRCs';
        end;
      end;
    end;
  end;
  CharTimeout := CharTimeOutSeconds*1000*LoopsPerMs;
  ExitOnTimeout := true;
  ExitOnCRCError := true;
end;

