{$R-}
{$Q-}
program SDMCReadParam;
{$S+}    {make sure the stack doesn't deck us}

{$DEFINE COPROC}
{$IFDEF COPROC}
{$N+}
{$ELSE}
{$N-}
{$ENDIF}

{$IFDEF WINDOWS}
uses synaser,dos,wincrt;
var TheComPort : string;
    ser:TBlockSerial;
{$ELSE}
uses dos,crt;
var TheComPort : word;
{$ENDIF}

procedure FixCRT;
{ Fix re-direction when using CRT unit }
begin
  assign(input,'');
  reset(input);
  assign(output,'');
  rewrite(output);
end;

var
Data,OldData,DeltaVal : longint;
IntData : integer;
ByteData : byte;
WordData : word;
BigData : comp;
Retcode : integer;
UseQ : boolean;
UseHex : boolean;
DoRepeat : boolean;
Delta : boolean;

temp : word;
ParmLoc : integer;
ParmName : string;
Message : string;

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP}
{$I SELECTPR}
{$I INTERFCE}

var
Parmtype : ParameterType;

procedure Error(err : integer);
begin
  writeln(errorrecord[err].errstr);
  halt(2);
end;

procedure Usage;
begin
  writeln('Usage: rp parm [axis] [q] [h] [r]');
  writeln;
  halt(2);
end;

function FindParm(aname : string) : boolean;
var
index : integer;
cname : string;
offset : word;
retcode : integer;
begin
  cname := StripTillChar(aname,'+');
  offset := 0;
  if length(aname) >0 then
  begin
    val(aname,offset,retcode);
    if retcode <> 0 then BumOut('Can''t parse offset');
  end;
  index := 1;
  while (upstring(cname) <> upstring(SDMCParams[index].ParmName)) and (index <= LastParm) do index := index +1;
  ParmLoc := SDMCParams[index].ParmLoc + offset;
  ParmType := SDMCParams[index].ParmType;
  ParmName := SDMCParams[index].ParmName; {so it will have the cannonical name}
  if index > LastParm then FindParm := false else findparm := true;
end;

procedure Pause;
var foo : string;
begin
  writeln;
  writeln('Press return to continue');
  readln(foo);
end;

procedure ShowParameters(s : string);
var index,lc : integer;
begin
  writeln('No such parameter: '+s);
  writeln('Valid parameters are: ');
  lc := 0;
  for index := 1 to LastParm do
  begin
    if (index mod 4) = 0 then
    begin
      writeln;
      lc := lc +1;
    end;
    if lc > 19 then
    begin
      Pause;
      lc := 0;
    end;
    write(PadWithSpaces(SDMCParams[index].ParmName,19));
  end;
  writeln;
  halt(2);
end;

procedure GetParameter;
var
index : word;
pstring: string[40];
begin
  GetOurEnv;
  UseQ := false;
  UseHex := false;
  DoRepeat := false;
  for index := 2 to 7 do
  begin
    if length(ParamStr(index)) > 0 then
    begin
      if upstring(ParamStr(index)) = 'Q' then UseQ := true;
      if upstring(ParamStr(index)) = 'H' then UseHex := true;
      if upstring(ParamStr(index)) = 'R' then DoRepeat := true;
      if upstring(ParamStr(index)) = 'D' then Delta := true;
    end;
  end;

  if length(ParamStr(1)) = 0 then Usage;
  pstring := ParamStr(1);
  if not FindParm(pstring) then ShowParameters(pstring);
  Axis := 0;
  if length(ParamStr(2)) > 0 then
  begin
    val(ParamStr(2),temp,Retcode);
    if retcode = 0 then Axis := temp;
  end;
  if Delta then
  begin
    if length(ParamStr(3)) > 0 then
    val(ParamStr(3),temp,Retcode);
    if retcode = 0 then DeltaVal := temp;
  end;
end;  { GetParameter }

begin
  FixCrt;
  GetParameter;
  if not InitializeInterface(message) then bumout(message);
  { if ReadMajorSWVersion <> MajorRev then BumOut('SoftDMC Software version mis-match');}
  ClearFifos;
  OldData := 0;
  if (parmtype = type_uint) or (parmtype = type_byte) or (parmtype = type_ptr)
     or (parmtype = type_mask) or (parmtype = type_flag) then
  begin
    repeat
      if UseQ then Data := ReadParamWordQ(Axis,ParmLoc) else Data := ReadParamWord(Axis,ParmLoc);
      if (not Delta) or (abs(Data - OldData) > Deltaval) then
      begin
        if UseHex then
        begin
          write('Data ');
          HexPrint(Data,4);
          writeln;
        end
        else
        begin
          writeln('Data ',Data:5);
        end;
        if Delta then
        begin
          if UseHex then
          begin
            write('OldData ');
            HexPrint(OldData,4);
            writeln;
          end
          else
          begin
            writeln('OldData ',OldData:5);
          end;
        end;

      end;
      OldData := Data;
    until (not DoRepeat) or KeyPressed
  end;
  if (parmtype = type_int) then
  begin
    repeat
      if UseQ then IntData := ReadParamWordQ(Axis,ParmLoc) else IntData := ReadParamWord(Axis,ParmLoc);
      if (not Delta) or (abs(Data - Olddata) > Deltaval) then
      begin
        if UseHex then
        begin
          write('Data ');
          HexPrint(IntData,4);
          writeln;
        end
        else
        begin
          writeln('Data ',IntData:5);
        end;
      end;
      OldData := Data;
    until (not DoRepeat) or KeyPressed
  end;

  if (ParmType = type_ulong) or (ParmType = type_long) then
  begin
    repeat
    if UseQ then Data := ReadParamQ(Axis,ParmLoc) else Data := ReadParam(Axis,ParmLoc);
      if (not Delta) or (abs(Data - Olddata) > Deltaval) then
      begin
        if UseHex then
        begin
          write('Data ');
          HexPrint(Data,8);
          writeln;
        end
        else
        begin
          writeln('Data ',Data:10);
        end;
        if Delta then
        begin
          if UseHex then
          begin
            write('OldData ');
            HexPrint(OldData,8);
            writeln;
          end
          else
          begin
            writeln('OldData ',OldData:10);
          end;
        end;
      end;
    until (not DoRepeat) or KeyPressed
  end;

  if (ParmType = type_double) then
  begin
    repeat
      if UseQ then
      begin
        Bigdata := ReadParamDoubleQ(Axis,ParmLoc);
      end
      else
      begin
        Bigdata := ReadParamDouble(Axis,ParmLoc);
    end;
      if UseHex then
      begin
        write('Data ');
        HexPrint(DoubleLongRec(BigData).Long1,8);
        HexPrint(DoubleLongRec(BigData).Long0,8);
        writeln;
      end
      else
      begin
        writeln('Data ',BigData:20:0);
      end;
    until (not DoRepeat) or KeyPressed
  end;
{$IFDEF EEPROM}
  if (parmtype = type_ebyte) then
  begin
    repeat
      ByteData := ReadEEPROM(lo(ParmLoc));
      if UseHex then
      begin
        write('Data ');
        HexPrint(ByteData,2);
        writeln;
      end
      else
      begin
        writeln('Data ',ByteData:3);
      end;
    until (not DoRepeat) or KeyPressed
  end;
  if (parmtype = type_eword) then
  begin
    repeat
      WordData := ReadEEPROMWord(ParmLoc);
      if UseHex then
      begin
        write('Data ');
        HexPrint(WordData,4);
        writeln;
      end
      else
      begin
        writeln('Data ',WordData:3);
      end;
    until (not DoRepeat) or KeyPressed
  end;
{$ENDIF}
  halt(0);
end.
