{$I PCI }
{$I pcibrid}

procedure BusInitSoftDMC(TheBasePort : word);
begin
  IFIFOPort   := TheBasePort + IFIFOPortOffset;
  QFIFOPort   := TheBasePort + QFIFOPortOffset;
  StatusPort  := TheBasePort + StatusRegOffset;
  ROMAddPort  := TheBasePort + ROMAddOffset;
  ROMDataPort := TheBasePort + ROMDataOffset;
  Portw[ROMAddPort] := $0000; { enable bottom port }
end;

function BusReadFifoStatus : word;
begin
    BusReadFifoStatus := portw[StatusPort];
end;

function BusReadQFIFO :word;
begin
  BusReadQFIFO := portw[QFIFOPort];
end;

procedure BusWaitForIRBFIFONotEmpty;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
   end
   until ((readstatus and IRE = 0) or (loop > PollTimeOut));
   if loop > PollTimeOut then Error(TimeOutIRBFIFONotEmpty);
end;

procedure BusWaitForICDFIFONotFull;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
  end
  until ((readstatus and IFF = 0) or (loop > PollTimeOut));
  if loop > PollTimeOut then Error(TimeOutICDFIFONotFull);
end;

procedure BusWaitForICDFIFONotHalfFull;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
   begin
     readstatus := BusReadFifoStatus;
     loop := loop +1;
   end
  until ((readstatus and IFH = 0)  or (loop > PollTimeOut));
   if loop > PollTimeOut then Error(TimeOutICDFIFONotHalfFull);
end;

procedure BusWaitForQRBFIFONotEmpty;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
  end
  until ((readstatus and QRE = 0)  or (loop > PollTimeOut));
   if loop > PollTimeOut then Error(TimeOutQRBFIFONotEmpty);
end;

procedure BusWaitForQCDFIFONotFull;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
  end
  until ((readstatus and QFF = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Error(TimeOutQCDFIFONotFull);
end;

procedure BusWaitForQCDFIFONotHalfFull;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
  end
  until ((readstatus and QFH = 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Error(TimeOutQCDFIFONotHalfFull);
end;

procedure BusWaitForQRBFIFOHalfFull;
var loop : longint;
readstatus : word;
begin
  loop := 0;
  repeat
  begin
    readstatus := BusReadFifoStatus;
    loop := loop +1;
  end
  until ((readstatus and QRH <> 0)  or (loop > PollTimeOut));
  if loop > PollTimeOut then Error(TimeOutQRBFIFOHalfFull);
end;

procedure BusWriteParamWord(command,thedata : word);
{16 bit only parameter write}
begin
  portw[IFIFOPort] := command;
  portw[IFIFOPort] := word(thedata);
end;

procedure BusWriteCommand(command: word);
{token write}
begin
  portw[IFIFOPort] := command;
end;

procedure BusWriteParam(command: word;thedata : longint);
{ full 32 bit parameter write - 2 words }
begin
  portw[IFIFOPort] := command;
  portw[IFIFOPort] := LongIntRec(thedata).LowWord;
  portw[IFIFOPort] := LongIntRec(thedata).HighWord;
end;

procedure BusWriteParamDouble(command: word;thedata : comp);
{ 64 bit parameter write - 4 words }
begin
  portw[IFIFOPort] := command;
  portw[IFIFOPort] := DoubleIntRec(thedata).word0;
  portw[IFIFOPort] := DoubleIntRec(thedata).word1;
  portw[IFIFOPort] := DoubleIntRec(thedata).word2;
  portw[IFIFOPort] := DoubleIntRec(thedata).word3;
end;

procedure BusWriteParamBlock(axis : byte;address,length : word; thedata : ParamArray);
var idx : word;
{16 bit multiple parameter write}
begin
  { Note: this will fail horribly if length > (FIFOSize/2 -2) }
  portw[IFIFOPort] := BlockFlag or (length-1) or (axis shl AxisOffset);
  portw[IFIFOPort] := address;
  for idx := 1 to length do
  begin
    portw[IFIFOPort] := thedata[idx];
  end;
end;

function BusReadParamWord(command: word):word;
{ 16 bit parameter read }
var
rdata : longint;
begin
  portw[IFIFOPort] := command;
  BusWaitForIRBFIFONotEmpty;
  rdata := Portw[IFIFOPort];
  BusReadParamWord :=rdata;
end;

function BusReadParam(command: word) : longint;
{full 32 bit parameter read }
var
rdata : longint;
begin
  portw[IFIFOPort] := command;
  BusWaitForIRBFIFONotEmpty;
  LongIntRec(rdata).LowWord := Portw[IFIFOPort];  { read first }
{  WaitForIFIFONotEmpty; }
{ theoretically this is needed but no interface currently is fast }
{ enough to read faster than the DSP can write }
  LongIntRec(rdata).HighWord :=Portw[IFIFOPort];
  BusReadParam:= rdata;
end;

{$IFDEF COPROC}
function BusReadParamDouble(command: word) : comp;
{64 bit parameter read }
var
rdata : comp;
begin
  portw[IFIFOPort] := command;
  BusWaitForIRBFIFONotEmpty;
  DoubleIntRec(rdata).word0 := Portw[IFIFOPort];  { read first }
  DoubleIntRec(rdata).word1 := Portw[IFIFOPort];
  DoubleIntRec(rdata).word2 := Portw[IFIFOPort];
  DoubleIntRec(rdata).word3 := Portw[IFIFOPort];
  BusReadParamDouble := rdata;
end;
{$ENDIF}
procedure BusWriteParamWordQ(command,thedata : word);
{16 bit only parameter write}
begin
  portw[QFIFOPort] := command;
  portw[QFIFOPort] := thedata;
end;

procedure BusWriteCommandQ(command : word);
{token write}
begin
  portw[QFIFOPort] := command;
end;

procedure BusWriteParamQ(command: word;thedata : longint);
{ full 32 bit parameter write - 2 words }
begin
  portw[QFIFOPort] := command;
  portw[QFIFOPort] := word(thedata);
  portw[QFIFOPort] := word(thedata shr 16);
end;

procedure BusWriteParamDoubleQ(command: word;thedata : comp);
{ 64 bit parameter write - 4 words }
begin
  portw[QFIFOPort] := command;
  portw[QFIFOPort] := DoubleIntRec(thedata).word0;
  portw[QFIFOPort] := DoubleIntRec(thedata).word1;
  portw[QFIFOPort] := DoubleIntRec(thedata).word2;
  portw[QFIFOPort] := DoubleIntRec(thedata).word3;
end;

function BusReadParamWordQ(command: word):word;
{ 16 bit parameter read }
var
rdata : longint;
begin
  portw[QFIFOPort] := command;
  BusWaitForQRBFIFONotEmpty;
  rdata := Portw[QFIFOPort];
  BusReadParamWordQ :=rdata;
end;

function BusReadParamQ(command: word) : longint;
{full 32 bit parameter read }
var
rdata : longint;
firstword : word;
begin
  portw[QFIFOPort] := command;
  BusWaitForQRBFIFONotEmpty;
  firstword := Portw[QFIFOPort];  { read first }
{  WaitForQFIFONotEmpty; }
{ theoretically this is needed but no interface currently is fast }
{ enough to read faster than the DSP can write }
  rdata := (Portw[QFIFOPort]) *65536 + firstword;
  BusReadParamQ:= rdata;
end;

{$IFDEF COPROC}
function BusReadParamDoubleQ(command: word) : comp;
{64 bit parameter read }
var
rdata : comp;
begin
  portw[QFIFOPort] := command;
  BusWaitForQRBFIFONotEmpty;
  DoubleIntRec(rdata).word0 := Portw[QFIFOPort];  { read first }
  DoubleIntRec(rdata).word1 := Portw[QFIFOPort];
  DoubleIntRec(rdata).word2 := Portw[QFIFOPort];
  DoubleIntRec(rdata).word3 := Portw[QFIFOPort];
  BusReadParamDoubleQ:= rdata;
end;
{$ENDIF}

procedure BusSoftDMCResetOn;
begin
  Portw[ROMAddPort] := $8000; { Reset on }
end;

procedure BusSoftDMCResetOff;
begin
  Portw[ROMAddPort] := $0000; { Reset Off }
end;

procedure BusWriteRom(add : word;data : word);
begin
  portw[ROMAddPort] := add or ProcResetBit;
  portw[ROMDataPort] := data;
end;

function BusReadRom(add : word): word;
begin
  portw[ROMAddPort] := add or ProcResetBit;
  BusReadRom := portw[ROMDataPort];
end;

{ moved bus stuff to parhost4.pas }
