const
{ The functional interface to the motor controller is done by a dual port ram }
{ sample:	the time between iterations of the pid loop, see prescale and postscale }
{ counts:	encoder counts ppr*4 }
{ UNITS }
{ despos		encoder counts                     BBBB.        B=byte S=signextend }
{ desposf	fractional encoder counts               BBB0    B=byte S=signextend }
{ velocity	8.24 counts per sample 		   SSSB.BBB     (127 max motor counts per sample) }
{ velocityf	8.24 counts per sample 		      0.000BB   (127 max motor counts per sample) }
{ accel		8.24 counts per sample per sample     B.BBB }
{ accelf		is the fractional part of accel       0.000BB }
{ jerk		added to accel.accelf each sample     S.SBBBB }
{ avgvel		8.8 velocity units }
{ pwm		8.8 signed number, only integer part used for output }
{ TYPES (contents of ram address) }
{ 	<blank>	number of bits is hardware dependent	 }
{ 	byte	8 bit unsigned value }
{ 	ptr	10 bit address pointer }
{ 	flag	16 bit value 0 is false, nonzero is true }
{ 	mask	16 bit mask bit true enables }
{ 	uint	16 bit unsigned value 0..65535 }
{ 	int	16 bit signed value -32768..32767 }
{ 	ulong	32 bit unsigned value 0..4294967295 }
{ 	long	32 bit signed value -2147483648..2147483647 }
{ 	double	64 bit signed value -1.8E19..1.8E19 }
{ 	ebyte	8 bit unsigned value in eeprom }
{ PARAMETER	VALUE	TYPE	FUNCTION }
nullLoc                  =      0;              { (ptr) uninitialized pointers point to dummy }
dummyLoc                 =      0;              { (uint) default 16bit pointers point here  }
dummyhiLoc               =      1;              { (uint) default 32bit pointers point here  }
goLoc                    =      2;              { (flag) set true to start move }
pidLoc                   =      3;              { (flag) set true to enable pid  }
profileLoc               =      4;              { (uint) 0=off, 1=trapezoidal profile, 2=host profile }
drivemodeLoc             =      5;              { (flag) false for voltage control, true for current control }
dirinvLoc                =      6;              { (flag) set true to invert motor drive polarity }
proctimerLoc             =      7;              { (uint) read sample timer }
stepdirLoc               =      8;              { (flag) true for step/direction inputs }
homeLoc                  =      9;              { (flag) becomes true when home has occured }
motionLoc                =      10;             { (flag) becomes false when velocity = 0 }
slewLoc                  =      11;             { (flag) true when maximum velocity is reached }
errorLoc                 =      12;             { (uint) non-zero when excessive position, or drive error }
errormaskLoc             =      13;             { (mask) mask for error, default enabled }
eventsLoc                =      14;             { (uint) number of events, 24 max }
maxpwmLoc                =      15;             { (uint) pwm limited to this value }
avgvelLoc                =      16;             { (int) average velocity 8.8 }
exposerrLoc              =      17;             { (uint) excessive position error limit <32767 }
maxnegerrLoc             =      18;             { (int) max negative error }
maxposerrLoc             =      19;             { (int) max positive error }
driveerrorLoc            =      20;             { (uint) variable to count, }
posencLoc                =      21;             { (ptr) pointer to position encoder }
velencLoc                =      22;             { (ptr) pointer to velocity encoder }
actvelLoc                =      23;             { (int) actual velocity }
bnderrLoc                =      24;             { (int) bounded (@follow-@posenc) }
extvelocityLoc           =      25;             { (ptr) pointer to actvel, for external velocity }
followLoc                =      26;             { (ptr) pointer to desired position }
pwmLoc                   =      27;             { (int) pwm value }
{ 32bit user parameters }
homepospLoc              =      28;             { (long) position loaded when primary index occurs }
phasekLoc                =      30;             { (long) phase konstant }
phaseaLoc                =      32;             { (long) phase accumulator, phasek is added to phasea each sample }
encpLoc                  =      34;             { (long) primary encoder, read only }
desvelLoc                =      36;             { (long) desired velocity, set by slewlimit }
{ 16bit user parameters }
timeoutLoc               =      38;             { (uint) incremented each time we haven't finished before the next sample }
syncLoc                  =      39;             { (flag) set before host, cleared after }
{ filter param }
kkLoc                    =      40;             { (int) pwm offset, initial pwm value }
kffLoc                   =      41;             { (uint) friction in the direction of motion }
kpLoc                    =      42;             { (uint) kpd*error added to pwm }
kdLoc                    =      43;             { (uint) kdd*actualvelocity added to pwm }
kaLoc                    =      44;             { (uint) unused accel error }
kiLoc                    =      45;             { (ulong) ki*error added to integralq each sample, high word added to pwm }
kihLoc                   =      46;             { (uint) high word of ki not used }
kilLoc                   =      47;             { (uint) high word limit of ki, 32767 max }
kf0Loc                   =      48;             { (uint) (unimplemented) spring }
kf1Loc                   =      49;             { (uint) velocity ff }
kf2Loc                   =      50;             { (uint) accel ff }
kf3Loc                   =      51;             { (uint) phasor velocity feedforward unused }
kdfilLoc                 =      52;             { (uint) amount of filtering }
driveplusLoc             =      53;             { (uint) amount added to driveerror if maxpwm, generates error if overflow }
driveminusLoc            =      54;             { (uint) amount subtracted from driveerror if not maxpwm, bounded at 0 }
{ profile parameters with breakpoint registers }
desposdLoc               =      56;             { (double) 32.32 profile position }
desposfLoc               =      56;             { (long) fractional part of profile position }
desposLoc                =      58;             { (long) integer part of profile position }
velocityLoc              =      60;             { (long) profile velocity		 }
accelfLoc                =      62;             { (int) fractional part of accel for jerk }
accelLoc                 =      63;             { (long) acceleration, if 0 then no motion }
jerkLoc                  =      65;             { (long) added to accel each sample }
breakpointLoc            =      67;             { (long) block breakpoint value }
nextproblockLoc          =      69;             { (ptr) pointer to next profile block }
nextposLoc               =      70;             { (long) where we want to go next }
slewlimitLoc             =      72;             { (long) slew speed limit, 2^23-1 max for kf1,kf2 }
{ 32bit internal use only }
startposLoc              =      74;             { (long) begining of move }
deltaLoc                 =      76;             { (long) velq - velocityq  }
velocityfLoc             =      78;             { (int) fractional part of velocity }
{ free		79	%uint	 }
checkposLoc              =      80;             { (long) checking position for done }
decelposLoc              =      82;             { (long) position to start decel }
fixupLoc                 =      84;             { (long) profile generator error }
preslewvelLoc            =      86;             { (long) velocity before slew starts or maximum velocity }
preslewposLoc            =      88;             { (long) position before slew starts or maximum velocity }
{ 48bit number internal use only }
integralLoc              =      90;             { (long) integral error accumulator }
integralovfLoc           =      92;             { (int) overflow for integral }
{ 16bit internal use only }
stopathomeLoc            =      93;             { (flag) if true desvel and go are cleared at home }
skipLoc                  =      94;             { (flag) skip position update once only }
lastposLoc               =      95;             { (uint) last actual position low half }
lastvelocityLoc          =      96;             { (int) old velocity }
gphasefLoc               =      97;             { (flag) set true on carry of gphasea }
gphasekLoc               =      98;             { (long) gphase konstant }
gphaseaLoc               =      100;            { (long) gphase accumulator, gphasek is added to gphasea each sample }
prescaleLoc              =      102;            { (uint) samplerate is sysclk/prescale  }
slowLoc                  =      103;            { (flag) set true for dot 32 velocity }
flagxorLoc               =      104;            { (uint) wait for flag xor invert }
flagandLoc               =      105;            { (uint) wait for flag and mask  }
userstatusLoc            =      106;            { (uint) low byte read by read status command }
{ ************************* PORTS ********************************************* }
cntcntlpLoc              =      107;            { (uint) counter control register }
cntclrpLoc               =      108;            { (flag) set true to clear counter }
pwmgenaLoc               =      109;            { (uint) motor pwm }
motoriLoc                =      110;            { (uint) motor current limit }
diraLoc                  =      111;            { (uint) motor direction }
enaLoc                   =      112;            { (uint) motor on }
outportLoc               =      113;            { (uint)  }
inportLoc                =      114;            { (uint) user port }
analog0Loc               =      115;            { (uint) analog inputs }
analog1Loc               =      116;            { (uint) analog inputs }
analog2Loc               =      117;            { (uint) analog inputs }
{ user ram }
eventfirstLoc            =      118;            { (uint)  }
event1Loc                =      118;            { (uint)  }
event2Loc                =      124;            { (uint)  }
event3Loc                =      130;            { (uint)  }
event4Loc                =      135;            { (uint)  }
event5Loc                =      142;            { (uint)  }
event6Loc                =      148;            { (uint)  }
event7Loc                =      154;            { (uint)  }
event8Loc                =      160;            { (uint)  }
event9Loc                =      166;            { (uint)  }
event10Loc               =      172;            { (uint)  }
event11Loc               =      178;            { (uint)  }
event12Loc               =      184;            { (uint)  }
event13Loc               =      190;            { (uint)  }
event14Loc               =      196;            { (uint)  }
event15Loc               =      202;            { (uint)  }
event16Loc               =      208;            { (uint)  }
event17Loc               =      214;            { (uint)  }
event18Loc               =      220;            { (uint)  }
event19Loc               =      226;            { (uint)  }
event20Loc               =      232;            { (uint)  }
eventlastLoc             =      232;            { (uint)  }
{ ************************* FIFOS ********************************************** }
icdfifocountLoc          =      238;            { (uint) count of data in icdfifo }
irbfifocountLoc          =      239;            { (uint) count of data in irbfifo }
ififowriteLoc            =      $400;           { (uint) marker for event logic }
qcdfifocountLoc          =      240;            { (uint)  }
qrbfifocountLoc          =      241;            { (uint)  }
qfifowriteLoc            =      $800;           { (uint) marker for event logic }
icdfifosizeLoc           =      242;            { (uint) immediate command\data fifo size  }
qcdfifosizeLoc           =      243;            { (uint) queued command\data fifo size  }
irbfifosizeLoc           =      244;            { (uint) immediate readback fifo size  }
qrbfifosizeLoc           =      245;            { (uint) queued readback fifo size  }
{ ************************* SYSTEM CONSTANTS ********************************** }
{ software constants }
cputypeLoc               =      246;            { (uint) CPU type }
controltypeLoc           =      247;            { (uint) number of motor phases }
swrevisionLoc            =      248;            { (uint) majorrev hibyte minorrev lobyte }
{ hardware constants }
naxisLoc                 =      249;            { (uint) 1 }
zeroLoc                  =      250;            { (int) 0 }
falseLoc                 =      250;            { (flag) false }
oneLoc                   =      251;            { (int) 1 }
trueLoc                  =      252;            { (flag) true }
minusoneLoc              =      252;            { (int) -1 }
sysclkLoc                =      253;            { (long) CPU clock frequency }
hwrevisionLoc            =      255;            { (uint) hwtype in hi byte revision in low byte }
{ ******************* BOGUS STUFF FOR DCMTUNE ******************************* }
{ ififoread	0	%uint	immediate fifo }
ififoreadcountLoc        =      238;            { (uint) count of data }
{ ififoparam	0	%uint	parameter }
{ ififoaxis	0	%uint	axis }
ififowritecountLoc       =      239;            { (uint)  }
{ qfiforead	0	%uint	queued fifo }
qfiforeadcountLoc        =      240;            { (uint)  }
{ qfifoparam	0	%uint	 }
{ qfifoaxis	0	%uint	 }
qfifowritecountLoc       =      241;            { (uint)  }
{ multiphase motor parameters internal use only }
phaseleadLoc             =      0;              { (int) lead angle }
motorangleLoc            =      0;              { (uint) sintablesize / angle between phases }
motorphaseLoc            =      0;              { (uint) encp mod encodercnt }
homeoffsetLoc            =      0;              { (int) offset from home position }
postscaleLoc             =      0;              { (uint) sample rate = pwm rate/postscale, write only }
ledaxisLoc               =      0;              { (ptr) axis for leds to monitor }
ledLoc                   =      0;              { (ptr) parameter for leds to monitor, if not zero }
geventsLoc               =      0;              { (uint) number of global events 36 max }
{ global ram }
firstgeventLoc           =      0;              { (uint)  }
geventfirstLoc           =      0;              { (uint)  }
gevent1Loc               =      0;              { (uint)  }
geventlastLoc            =      0;              { (uint)  }
lastgeventLoc            =      0;              { (uint)  }
endofglobalram           =      0;              
addressLoc               =      1;              { (ebyte)  }
baudselLoc               =      2;              { (ebyte)  }
serialmodeLoc            =      3;              { (ebyte)  }
loadparamLoc             =      6;              { (ebyte)  }
stepdirenaLoc            =      7;              { (ebyte)  }
