const
{ The functional interface to the motor controller is done by a dual port ram }
{ sample:	the time between iterations of the pid loop, see prescale and postscale }
{ counts:	encoder counts ppr*4 }
{ UNITS }
{ despos		encoder counts                     BBBB.        B=byte S=signextend }
{ desposf	fractional encoder counts               BBB0    B=byte S=signextend }
{ velocity	8.24 counts per sample 		   SSSB.BBB     (127 max motor counts per sample) }
{ velocityf	is the fractional part of vel         0.000BB }
{ accel		8.24 counts per sample per sample     B.BBB }
{ accelf		is the fractional part of accel       0.000BB }
{ jerk		added to accel.accelf each sample     S.SBBBB }
{ avgvel		8.8 velocity units }
{ pwm		8.8 signed number, only integer part used for output }
{ TYPES (contents of ram address) }
{ 	<blank>	number of bits is hardware dependent	 }
{ 	byte	8 bit unsigned value }
{ 	ptr	10 bit address pointer }
{ 	flag	16 bit value 0 is false, nonzero is true }
{ 	mask	16 bit mask bit true enables }
{ 	uint	16 bit unsigned value 0..65535 }
{ 	int	16 bit signed value -32768..32767 }
{ 	ulong	32 bit unsigned value 0..4294967295 }
{ 	long	32 bit signed value -2147483648..2147483647 }
{ 	double	64 bit signed value -1.8E19..1.8E19 }
{ PARAMETER	VALUE	TYPE	FUNCTION }
nulldLoc                 =      0;              { (double) 32bit empty location }
nullLoc                  =      0;              { (ptr) uninitialized pointers point to dummy }
dummyLoc                 =      0;              { (uint) default pointers point here }
dummyhiLoc               =      1;              { (uint) default 32bit pointers point here  }
goLoc                    =      2;              { (flag) set true to start move }
pidLoc                   =      3;              { (flag) set true to enable pid  }
profileLoc               =      4;              { (uint) 0=off, 1=trapezoidal profile, 2=host profile }
distLoc                  =      5;              { (int) used by profile5 }
decelLoc                 =      5;              { (flag) true when decel }
dirinvLoc                =      6;              { (flag) set true to invert motor drive polarity }
filterblockLoc           =      7;              { (ptr) pointer to filterblock }
{ profileblock	8	%ptr	pointer to profileblock }
homeLoc                  =      9;              { (flag) becomes true when home has occured }
motionLoc                =      10;             { (flag) becomes false when velocity = 0 }
slewLoc                  =      11;             { (flag) true when maximum velocity is reached }
errorLoc                 =      12;             { (uint) non-zero when excessive position, or drive error }
errormaskLoc             =      13;             { (mask) mask for error, default enabled }
eventsLoc                =      14;             { (uint) number of events, 24 max }
maxpwmLoc                =      15;             { (uint) pwm limited to this value }
avgvelLoc                =      16;             { (int) average velocity 8.8 }
exposerrLoc              =      17;             { (uint) excessive position error limit <32767 }
maxnegerrLoc             =      18;             { (int) max negative error }
maxposerrLoc             =      19;             { (int) max positive error }
driveerrorLoc            =      20;             { (uint) variable to count, }
posencLoc                =      21;             { (ptr) pointer to position encoder }
velencLoc                =      22;             { (ptr) pointer to velocity encoder }
actvelLoc                =      23;             { (int) actual velocity }
bnderrLoc                =      24;             { (int) bounded (@follow-@posenc) }
extvelocityLoc           =      25;             { (ptr) pointer to actvel, for external velocity }
followLoc                =      26;             { (ptr) pointer to desired position }
pwmLoc                   =      27;             { (int) pwm value }
{ multiphase }
phaseaiLoc               =      28;             { (uint) max current, 21845/amp hi current (65535/amp lo) }
phasebiLoc               =      29;             { (uint) max current, 21845/amp hi current (65535/amp lo) }
offsetiLoc               =      30;             { (uint) offset current (to remove dead zone in driver) }
encodercntLoc            =      31;             { (uint) counts per rev, use smallest integer for accuracy }
encfactorLoc             =      32;             { (uint) (sinetablesize * #poles * 256) / encodercnt }
slipkLoc                 =      33;             { (int) add to phaselead (for induction motors) }
phaseshiftLoc            =      34;             { (flag) set true to invert one motor phase }
openloopLoc              =      35;             { (flag) when true use despos, pid must be on, default on }
{ 32bit user parameters }
homepospLoc              =      36;             { (long) position loaded when primary index occurs }
homepossLoc              =      38;             { (long) position loaded when seconday index occurs }
phasekLoc                =      40;             { (long) phase konstant }
phaseaLoc                =      42;             { (long) phase accumulator, phasek is added to phasea each sample }
encpLoc                  =      44;             { (long) primary encoder, read only }
encsLoc                  =      46;             { (long) secondary encoder, read only }
desvelLoc                =      48;             { (long) desired velocity,  }
{ 				value set by slewlimit sign set by direction of move }
{ filter param }
filterstart              =      50;             { begining of filter block }
{ kk		50	%int	pwm offset, initial pwm value }
{ kff		51	%uint	friction in the direction of motion }
{ kp		52	%uint	kpd*error added to pwm }
{ kd		53 	%uint	kdd*actualvelocity added to pwm }
{ ka		54	%uint	unused accel error }
{ ki		55	%ulong	ki*error added to integralq each sample, high word added to pwm }
{ kih		56	%uint	high word of ki not used }
{ kil		57 	%uint	high word limit of ki, 32767 max }
{ kf0		58	%uint	(unimplemented) spring }
{ kf1		59	%uint	velocity ff }
{ kf2		60	%uint	accel ff }
{ kf3		61	%uint	phasor velocity feedforward unused }
{ kdfil		62	%uint	amount of filtering }
{ driveplus	63	%uint	amount added to driveerror if maxpwm, generates error if overflow }
{ driveminus	64	%uint	amount subtracted from driveerror if not maxpwm, bounded at 0 }
{ nextfilblock	65	%ptr	pointer to next filter block }
{ profile parameters with breakpoint registers }
profilestart             =      66;             { beginning of motion block }
desposdLoc               =      66;             { (double) 32.32 profile position }
desposfLoc               =      66;             { (long) .32 fractional part of profile position }
desposLoc                =      68;             { (long) 32. profile position }
velocityLoc              =      70;             { (long) profile velocity		 }
accelfLoc                =      72;             { (int) fractional part of accel for jerk }
accelLoc                 =      73;             { (long) acceleration, if 0 then no motion }
jerkLoc                  =      75;             { (long) added to accel each sample }
breakpointLoc            =      77;             { (long) block breakpoint value }
nextproblockLoc          =      79;             { (ptr) pointer to next profile block }
nextposLoc               =      80;             { (long) where we want to go next }
slewlimitLoc             =      82;             { (long) slew speed limit, 2^23-1 max for kf1,kf2 }
{ multiphase motor parameters internal use only }
phaseleadLoc             =      84;             { (int) lead angle }
motorangleLoc            =      85;             { (uint) sintablesize / angle between phases }
motorphaseLoc            =      86;             { (uint) encp mod encodercnt }
homeoffsetLoc            =      87;             { (int) offset from home position }
{ internal use only }
calcaccelLoc             =      88;             { (long) used for determining accel inflection point }
deltaLoc                 =      90;             { (long) velq - velocityq }
fvelocityLoc             =      92;             { (uint) .16 velocity }
flastvelocityLoc         =      93;             { (uint) .16 old velocity }
flagxorLoc               =      94;             { (uint) wait for flag xor invert }
flagandLoc               =      95;             { (uint) wait for flag and mask  }
fractionaccelLoc         =      96;             { (long) accel / n  }
halfaccelLoc             =      96;             { (long) accel / n  }
fixupLoc                 =      98;             { (long) profile generator error }
ouraccelLoc              =      100;            { (long) start with half accel  }
stopathomeLoc            =      102;            { (flag) if true clear desvel and go during home }
velocityfLoc             =      103;            { (int) fractional part of velocity for jerk }
{ 48bit number internal use only }
integralLoc              =      104;            { (long) integral error accumulator }
integralovfLoc           =      106;            { (int) overflow for integral }
{ 16bit internal use only }
resetLoc                 =      107;            { (flag) true when axis is reset }
olddistLoc               =      108;            { (int)  }
accelnLoc                =      108;            { (uint) n for accelfract	 }
lastposLoc               =      109;            { (uint) last actual position low half }
oldgoLoc                 =      110;            { (flag) internal }
oldpidLoc                =      111;            { (flag) internal }
{ user ram }
firsteventLoc            =      112;            { (uint)  }
eventfirstLoc            =      112;            { (uint)  }
event1Loc                =      112;            { (uint)  }
event2Loc                =      118;            { (uint)  }
event3Loc                =      124;            { (uint)  }
event4Loc                =      130;            { (uint)  }
event5Loc                =      136;            { (uint)  }
event6Loc                =      142;            { (uint)  }
event7Loc                =      148;            { (uint)  }
event8Loc                =      154;            { (uint)  }
event9Loc                =      160;            { (uint)  }
event10Loc               =      166;            { (uint)  }
event11Loc               =      172;            { (uint)  }
event12Loc               =      178;            { (uint)  }
event13Loc               =      184;            { (uint)  }
event14Loc               =      190;            { (uint)  }
event15Loc               =      196;            { (uint)  }
event16Loc               =      202;            { (uint)  }
event17Loc               =      208;            { (uint)  }
event18Loc               =      214;            { (uint)  }
event19Loc               =      220;            { (uint)  }
event20Loc               =      226;            { (uint)  }
event21Loc               =      232;            { (uint)  }
event22Loc               =      238;            { (uint)  }
event23Loc               =      244;            { (uint)  }
event24Loc               =      250;            { (uint)  }
eventlastLoc             =      250;            { (uint)  }
lasteventLoc             =      250;            { (uint)  }
endofaxisram             =      255;            
{ global ram }
firstgeventLoc           =      256;            { (uint)  }
geventfirstLoc           =      256;            { (uint)  }
gevent1Loc               =      256;            { (uint) host events }
gevent2Loc               =      262;            { (uint)  }
gevent3Loc               =      268;            { (uint)  }
gevent4Loc               =      274;            { (uint)  }
gevent5Loc               =      280;            { (uint)  }
gevent6Loc               =      286;            { (uint)  }
gevent7Loc               =      292;            { (uint)  }
gevent8Loc               =      298;            { (uint)  }
gevent9Loc               =      304;            { (uint)  }
gevent10Loc              =      310;            { (uint)  }
gevent11Loc              =      316;            { (uint)  }
gevent12Loc              =      322;            { (uint)  }
gevent13Loc              =      328;            { (uint)  }
gevent14Loc              =      334;            { (uint)  }
gevent15Loc              =      340;            { (uint)  }
gevent16Loc              =      346;            { (uint)  }
gevent17Loc              =      352;            { (uint)  }
gevent18Loc              =      358;            { (uint)  }
gevent19Loc              =      364;            { (uint)  }
gevent20Loc              =      370;            { (uint)  }
gevent21Loc              =      376;            { (uint)  }
gevent22Loc              =      382;            { (uint)  }
gevent23Loc              =      388;            { (uint)  }
gevent24Loc              =      394;            { (uint)  }
gevent25Loc              =      400;            { (uint)  }
gevent26Loc              =      406;            { (uint)  }
gevent27Loc              =      412;            { (uint)  }
gevent28Loc              =      418;            { (uint)  }
gevent29Loc              =      424;            { (uint)  }
gevent30Loc              =      430;            { (uint)  }
gevent31Loc              =      436;            { (uint)  }
gevent32Loc              =      442;            { (uint)  }
gevent33Loc              =      448;            { (uint)  }
gevent34Loc              =      454;            { (uint)  }
gevent35Loc              =      460;            { (uint)  }
gevent36Loc              =      466;            { (uint)  }
geventlastLoc            =      466;            { (uint)  }
lastgeventLoc            =      466;            { (uint)  }
endofglobalram           =      471;            
{ these locations are reserved, do not use }
greservedstart           =      472;            
greservedend             =      495;            
ledaxisLoc               =      496;            { (ptr) axis for leds to monitor }
ledLoc                   =      497;            { (ptr) parameter for leds to monitor, if not zero }
beeperLoc                =      498;            { (ptr) beep uses what this points to, if not zero }
proctimerLoc             =      499;            { (uint) max ???read proctimer here }
timeoutLoc               =      500;            { (uint) incremented each time we haven't finished before the next sample }
geventsLoc               =      501;            { (uint) number of global events 36 max }
axisLoc                  =      502;            { (ptr) the current axis }
syncLoc                  =      503;            { (flag) set before host, cleared after }
gphasekLoc               =      504;            { (long) gphase konstant }
gphaseaLoc               =      506;            { (long) gphase accumulator, gphasek is added to gphasea each sample }
gphasefLoc               =      508;            { (flag) set true on carry of gphasea }
cputypeLoc               =      509;            { (uint) CPU type }
controltypeLoc           =      510;            { (uint) number of motor phases }
swrevisionLoc            =      511;            { (uint) majorrev hibyte minorrev lobyte }
const
{ filter param }
{ filterstart	50	%ptr	begining of filter block }
kkLoc                    =      50;             { (int) pwm offset, initial pwm value }
kffLoc                   =      51;             { (uint) friction in the direction of motion }
kpLoc                    =      52;             { (uint) kpd*error added to pwm }
kdLoc                    =      53;             { (uint) kdd*actualvelocity added to pwm }
kaLoc                    =      54;             { (uint) unused accel error }
kiLoc                    =      55;             { (ulong) ki*error added to integralq each sample, high word added to pwm }
kihLoc                   =      56;             { (uint) high word of ki }
kilLoc                   =      57;             { (uint) high word limit of ki, 32767 max }
kf0Loc                   =      58;             { (uint) (unimplemented) spring }
kf1Loc                   =      59;             { (uint) velocity ff }
kf2Loc                   =      60;             { (uint) accel ff }
kf3Loc                   =      61;             { (uint) unused }
kdfilLoc                 =      62;             { (uint) amount of filtering 0..32767 }
driveplusLoc             =      63;             { (uint) amount added to drive error if maxpwm, generates error if overflow }
driveminusLoc            =      64;             { (uint) amount subtracted from drive error if not maxpwm, bounded at 0 }
nextfilblockLoc          =      65;             { (ptr) pointer to next filter block }
{ filtersize	16	%uint	size of filter block }
