{ NEW USING INTERFCE}
{$I eventlow}
var
Sysclk: longint;
const
TwoToThe31 = 2147483647;
TwoToThe32 = 4294967296.0;
VelocityConstant = $01000000; { 2^24 }
DefaultSysClk = 50000000;
ClrIRQBit : word = $4000;

procedure WaitforMoveDone(axis : byte);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,GoLoc);
  until (temp = 0);
end;

procedure Move(axis : byte;nextpos : longint; acc : longint; maxv : longint);
begin
  WriteParamword(axis,MaxNegErrLoc,0);
  WriteParamword(axis,MaxPosErrLoc,0);
  WriteParam(axis,NextPosLoc,nextpos);
  WriteParam(axis,AccelLoc,acc);
  WriteParam(axis,SlewLimitLoc,maxv);
  WriteParamWord(axis,GoLoc,TrueF);
  WaitForMoveDone(axis);
end;

procedure VMove(axis : byte; acc : longint; maxv : longint);
begin
  {Move in velocity mode}
  WriteParamword(axis,MaxNegErrLoc,0);
  WriteParamword(axis,MaxPosErrLoc,0);
  WriteParam(axis,AccelLoc,acc);
  WriteParam(axis,DesvelLoc,maxv);
end;

procedure WaitforTrue(axis : byte; flag : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,flag);
  until (temp <> 0);
end;

procedure WaitforFalse(axis : byte; flag : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,flag);
  until (temp = 0);
end;


procedure WaitTillStopped(axis : byte);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,MotionLoc);
  until (temp = 0);
end;

procedure WaitforMoveDoneWithStats(axis : word);
var
temp : word;
cyctime,maxcyc : word;
begin
  { wait for motors to be done and sample loop time statistics}
  maxcyc := 0;
  repeat
    cyctime := ReadParamWord(0,ProcTimerLoc);
    if (cyctime > maxcyc) then maxcyc := cyctime;
    temp := ReadParamWord(axis,GoLoc);
  until ((temp and $00FF) = 0);  { check low byte for done-a-tude }
  writeln('Maximum cycle time = ',maxcyc*1e6*(1/SysClk):4:0,'uS');
  writeln('MaxNegErr = ',Integer(ReadParamWord(axis,MaxNegErrLoc)),' MaxPosErr = ',ReadParamWord(axis,MaxPosErrLoc));
end;

(*
procedure ResetAxis(axis : byte);
begin
  WriteParamWord(axis,ResetLoc,FalseF);
  while ReadParamWord(axis,ResetLoc) = 0 do;
end;
*)

function HomeQ(axis: byte) : boolean;
begin
 HomeQ:= (ReadParamWord(axis,HomeLoc) <> 0);
end;

procedure ClearHome(Axis : byte);
begin
 WriteParamWord(axis,HomeLoc,0);
end;

procedure SetHomePos(axis:byte);
begin
  ClearHome(axis);
  WriteParamWord(axis,PIDLoc,FalseF); { turn off PID loop whilst futzing }
  WriteParam(axis,DesVelLoc,0); { stop any motion }
  WriteParamWord(axis,GoLoc,FalseF);    { turn off profile whilst futzing }
  WriteParam(axis,HomePosPLoc,0);  { clear home location}

  WriteParamWord(axis,CntClrPLoc,$FFFF); {clear}

(*  WriteParam(axis,DesPosLoc,0);  { clear Desired Pos reg }
  WriteParam(axis,NextPosLoc,0); { clear Next Pos reg }
  WriteParam(axis,LastPosLoc,0); { clear Last Pos reg }
  WriteParam(axis,EncPLoc,0);    { clear software encoder counter } *)
  WriteParamWord(axis,ErrorLoc,0); { clear any expe }
  WriteParamWord(axis,PIDLoc,TrueF); { re-enable PID }
  WriteParamWord(axis,EnaLoc,TrueF); { re-enable }
  {while not HomeQ(axis) do; }
  end;

procedure SeekHomePos(axis:byte;nextpos : longint; acc : longint; maxv : longint);
begin
  WriteParamWord(axis,CntCntlPLoc,CCFilterBit or CCClrOnIDXBit); {Quad filter and clear-on-index}
  { You need to set the CCIdxPol bit if you want rising edge }
  { index detection instead of falling edge detection }
  WriteParam(axis,HomePosPLoc,0);   { home is 0 }
  WriteParamWord(axis,HomeLoc,FalseF); { clear the home flag }
  Move(axis,nextpos,acc,maxv);
  WaitForTrue(axis,HomeLoc);
  WriteParamWord(axis,HomeLoc,FalseF); { now that we're done, reset the home flag }
  WriteParam(axis,DesVelLoc,0); { controlled stop }
  WaitForFalse(axis,MotionLoc);
end;


function IndexHighQ(axis: byte;indexhigh : boolean) : boolean;
var
temp : word;
begin
 temp := ReadParamWord(axis,CntCntlPLoc);
 if (temp and CCidxbit) <> 0 then IndexHighQ := indexhigh else IndexHighQ := not indexhigh;
end;

procedure SetCOI(Axis : byte;indexhigh: boolean);
var temp : word;
begin
 temp := CCFilterBit or CCclrOnIDXBit or CCcntclroncebit;
 if indexhigh then temp := temp or CCIDXPolBit;
 WriteParamWord(axis,CntCntlPLoc,temp);
 ClearHome(Axis);
end;

procedure ClearCOI(Axis : byte);
begin
 WriteParamWord(axis,CntCntlPLoc,CCFilterBit);
end;

procedure WaitTillHome(axis : word);
var
temp : word;
begin
  repeat
    temp := ReadParamWord(axis,HomeLoc);
  until (temp <> 0);
end;

procedure SetStopAtHome(axis : byte);
begin
  WriteParamWord(axis,StopAtHomeLoc,$FFFF);
end;

procedure ForceHome(axis : byte);
begin
  SetCOI(axis,true);
  WriteParamWord(axis,CntCntlPLoc,CCFilterBit); {quad filter}
  WriteParamWord(axis,CntClrPLoc,$FFFF); {clear}
end;

procedure Stop(axis:byte);
begin
  WriteParamWord(axis,GoLoc,FalseF);
  WriteParam(axis,desvelloc,0);
  WaitTillStopped(axis);
end;

procedure QuickStop(axis:byte;acc :longint);
begin
  WriteParam(axis,AccelLoc,acc);  { set accel up to stop quick }
  Stop(Axis);
end;

procedure RecoverFromExpe(axis:word);
var
realpos : longint;
begin
  if ReadParamWord(axis,ErrorLoc) <> 0 then
  begin
    writeln('Axis ',Axis,' stopped due to position error > ',ReadParam(Axis,MaxPosErrLoc));
    RealPos := ReadParam(Axis,EncPLoc); { get current actual position }
    writeln('Setting DesPos = Real Position: ',RealPos:12);
    WriteParam(Axis,DesPosLoc,RealPos);  { store it into desired Pos reg }
    WriteParam(Axis,LastPosLoc,RealPos); { store it into Last Pos reg so we dont  }
                                         { so we dont get a large KD generated thunk }
                                         { when we re-enable the PID loop }
    WriteParam(Axis,IntegralLoc,0);      { clear accumulated error (anti-thunk) }
    writeln('Clearing error and re-enabling PID on stopped channel');
    WriteParamWord(Axis,ErrorLoc,0);
    WriteParamWord(Axis,PIDLoc,1);
  end;
end;

function ReadError(Axis:byte): word;
begin
  ReadError := ReadParamWord(axis,ErrorLoc);
end;

function ReadRealPosition(Axis:byte): longint;
begin
  ReadRealPosition := ReadParam(axis,EncPLoc);
end;

function ReadFixup(Axis:byte): longint;
begin
  ReadFixup := ReadParam(axis,FixupLoc);
end;

function ReadDesVelocity(Axis:byte): longint;
begin
  ReadDesVelocity := ReadParam(axis,DesVelLoc);
end;

function ReadVelocity(Axis:byte): longint;
begin
  ReadVelocity := ReadParam(axis,VelocityLoc);
end;

function ReadDesPosition(Axis:byte): longint;
begin
  ReadDesPosition := ReadParam(axis,DesPosLoc);
end;

function ReadRealPositionShort(Axis:byte): integer;
begin
  ReadRealPositionShort := ReadParamWord(axis,EncPLoc);
end;

function ReadDesPositionShort(Axis:byte): integer;
begin
  ReadDesPositionShort := ReadParamWord(axis,DesPosLoc);
end;

function ReadDrive(Axis:byte): integer;
begin
  ReadDrive := ReadParamWord(axis,PWMLoc);
end;

function ReadNegError(axis : byte) : word;
begin
  ReadNegError := ReadParamWord(axis,MaxNegErrLoc);
end;

function ReadPosError(axis : byte) : word;
begin
  ReadPosError := (ReadParamWord(axis,MaxPosErrLoc));
end;

function ReadMotorAngle(axis : byte) : word;
begin
  ReadMotorAngle := (ReadParamWord(axis,MotorAngleLoc));
end;

function ReadMotorPhaseLead(axis : byte) : integer;
begin
  ReadMotorPhaseLead := (ReadParamWord(axis,PhaseLeadLoc));
end;

function ReadMotorType : word;
begin
  ReadMotorType := (ReadParamWord(0,ControlTypeLoc));
end;

procedure ClearPosErrs(axis: byte);
begin
  WriteParamWord(axis,MaxPosErrLoc,0);
  WriteParamWord(axis,MaxNegErrLoc,0);
end;

procedure LoadKP(Axis:byte;kp:word);
begin
  WriteParamWord(axis,KPLOC,kp);
end;

procedure LoadKD(Axis:byte;kd:word);
begin
  WriteParamWord(axis,KDLOC,kd);
end;

procedure LoadKDFIL(Axis:byte;kdfil:word);
begin
  WriteParamWord(axis,KDFILLOC,kdfil);
end;

procedure LoadKK(Axis:byte;kk:word);
begin
  WriteParamWord(axis,KKLOC,kk);
end;

procedure LoadKT(Axis:byte;kt:word);
begin
{$IFDEF EIGHTC20}
  WriteParamWord(axis,SpareLOC,kt);
{$ENDIF}
end;

procedure LoadKFF(Axis:byte;kff:word);
begin
  WriteParamWord(axis,KFFLOC,kff);
end;

procedure LoadKI(Axis:byte;ki:longint);
begin
  WriteParam(axis,KILOC,ki);
end;

procedure LoadKIL(Axis:byte;kil:word);
begin
  WriteParamWord(axis,KILLOC,kil);
end;

procedure LoadKF1(Axis:byte;kf1:word);
begin
  WriteParamWord(axis,KF1LOC,kf1);
end;

procedure LoadKF2(Axis:byte;kf2:word);
begin
  WriteParamWord(axis,KF2LOC,kf2);
end;

procedure LoadPostScale(sint : word);
begin
  WriteParamWord(0,PostScaleLoc,sint);
end;

procedure LoadPreScale(sint : word);
begin
  WriteParamWord(0,PreScaleLoc,sint);
end;

procedure LoadPosition(axis:byte;pos:longint);
begin
  WriteParam(axis,NextPosLoc,pos);
end;

procedure LoadVelocity(axis:byte;velo:longint);
begin
  WriteParam(axis,SlewLimitLoc,velo);
end;

procedure LoadAcceleration(axis:byte;accel:longint);
begin
  WriteParam(axis,AccelLoc,accel);
end;

procedure ProfileOff(axis: byte);
begin
  WriteParamWord(axis,ProfileLoc,FalseF);
end;

procedure ProfileOn(axis: byte);
begin
  WriteParamWord(axis,ProfileLoc,TrapezoidalMode);
end;

procedure PIDOff(axis : byte);
begin
  WriteParamWord(axis,PIDLoc,FalseF);
end;

procedure PIDOn(axis : byte);
begin
  WriteParamWord(axis,PIDLoc,TrueF);
end;

function ProfileOnQ(axis : byte): boolean;
begin
  if ReadParamWord(axis,ProFileLoc) <> 0 then ProfileOnQ := true else ProfileOnQ := false;
end;

procedure TurnOffMotor(axis:byte);
begin
  WriteParamWord(axis,EnaLoc,FalseF);
  WriteParamWord(axis,PIDLoc,FalseF);
  WriteParamWord(axis,ProfileLoc,FalseF);
end;

procedure TurnOnMotor(axis:byte);
begin
  WriteParamWord(axis,EnaLoc,TrueF);
  WriteParamWord(axis,PIDLoc,TrueF);
  ProfileOn(axis);
end;

procedure LoadDirectionFlag(axis:byte;flag:word);
begin
  WriteParamWord(axis,DirInvloc,flag);
end;

procedure LoadProctimer(val:word);
begin
  WriteParamWord(0,ProcTimerLoc,val);
end;

function ReadProctimer :word;
begin
  ReadProcTimer := ReadParamWord(0,ProcTimerLoc);
end;

procedure LoadTimeout(val:word);
begin
  WriteParamWord(0,TimeOutLoc,val);
end;

function ReadTimeout :word;
begin
  ReadTimeOut := ReadParamWord(0,TimeOutLoc);
end;

procedure StartTrajectory(axis:byte);
begin
  WriteParamWord(axis,GoLoc,TrueF);
end;

procedure ResetMot(Mot : byte);
begin
  TurnOffMotor(Mot);
end;

procedure LoadPosErrForStop(axis: byte;pos:longint);
begin
  WriteParamWord(axis,ExPosErrLoc,pos);
end;

function ReadMinorSWVersion: byte;
begin
  ReadMinorSWVersion := lo(ReadParamWord(0,SWRevisionloc));
end;

function ReadMajorSWVersion: byte;
begin
  ReadMajorSWVersion := hi(ReadParamWord(0,SWRevisionloc));
end;

function ReadSysClockFreq: longint;
begin
  ReadSysClockFreq := (ReadParam(0,SysClkLoc));
end;

function ReadHWVersion: word;
begin
  ReadHWVersion := ReadParamWord(0,HWRevisionLoc) and $00FF;
end;

function ReadNaxis: word;
begin
  ReadNaxis := ReadParamWord(0,NaxisLoc);
end;

function HardwareThere : boolean;
var idcode : string;
begin
  HardWareThere := false;
  case ProtocolType of
    Bus:
    begin
      portw[ROMAddPort] := ROMSize1 + SignatureOffset + ProcResetBit;
      if portw[ROMDataPort] = Signature then
      begin
        HardwareThere := true;
        portw[ROMAddPort] := 0; { remove reset }
        Delay(20); { wait for softdmc processor to init }
      end;
    end;

    Hex:
    begin
{$IFDEF DSPIC}
      SerListen(0);
{$ENDIF}
      if SerSync then
      begin
        idcode := InquireID;
        if idcode = '7I60' then
        begin
          CardType := SevenI60;
          HardwareThere := true;
        end;
        if idcode = '8C20' then
        begin
          CardType := EightC20;
          HardwareThere := true;
        end;
        if idcode = '3C20' then
        begin
          CardType := ThreeC20;
          HardwareThere := true;
        end;
      end;
    end;

    LBP:
    begin
      if LBPSync(message) then
      begin
        LBPInitSoftDMC(DefaultLBPBasePort);
        HardwareThere := true;
        CardType := SevenI43;
      end;
    end;
  end;
end;

procedure LEDs(Axis : byte; Param : word);
begin
  writeParamWord(0,LEDAxisLoc,Axis);
  writeParamWord(0,LEDLoc,Param);
end;

