{ Copyright (C) 2006 MESA Electronics.  All rights reserved. }
{ bitsd.inc }
const
majorrev                 =      64;             { (byte) updated when parameters change, hi byte }
minorrev                 =      2;              { (byte) lo byte }
truef                    =      65535;          { (flag) value for flag types }
falsef                   =      0;              { (flag) value for flag types }
{ profile modes }
noprofile                =      0;              { (unit) value for profile_uint }
trapezoidalmode          =      1;              { (uint) value for profile_uint }
externalprofile          =      2;              { (unit) value for profile_uint }
IFF                      =      $8000;          { Immediate Command/data FIFO full flag }
IFH                      =      $4000;          { Immediate Command/data FIFO half full flag }
QFF                      =      $2000;          { Queued Command/data FIFO full flag }
QFH                      =      $1000;          { Queued Command/data FIFO half full flag }
IRE                      =      $800;           { Immediate Readback FIFO empty flag }
IRH                      =      $400;           { Immediate Readback FIFO half full flag }
QRE                      =      $200;           { Queued Readback FIFO empty flag }
QRH                      =      $100;           { Queued Readback FIFO half full flag }
{ parammask	03FFh }
{ ************************* EVENT BLOCK ************************************** }
{ register offsets }
eventopcode              =      0;              { opcode }
eventsource1             =      1;              { (ptr) type:pointer to operand }
eventsource2             =      2;              { (ptr) pointer to second operand }
eventxor                 =      2;              { polarity }
eventsource2xor          =      2;              { alias for either }
eventand                 =      3;              { mask }
eventfree1               =      3;              { for arithmetic events }
eventor                  =      4;              { or }
eventfree2               =      3;              { for arithmetic events }
event2directlo           =      3;              { space for source2 }
event2directhi           =      4;              { space for source2 }
eventdest                =      5;              { (ptr) destination pointer }
eventblocksize           =      6;              { size of event block }
{ low byte }
eventresultcarryxor      =      $1;             
eventresultzeroxor       =      $2;             
{ hibyte }
eventresultcarryand      =      $100;           
eventresultzeroand       =      $200;           
{ logical events }
eventzero                =      $200;           { zeroand }
eventnotzero             =      $202;           { zeroand | zeroxor }
{ 1-2 }
eventcarry               =      $100;           { carryand  }
eventnotcarry            =      $101;           { carryand | carryxor }
eventgt                  =      $303;           { carryand | carryxor | zeroand | zeroxor }
eventlt                  =      $100;           { carryand }
eventgteq                =      $101;           { carryand | carryxor }
eventlteq                =      $300;           { carryand | zeroand }
eventeq                  =      $200;           { zeroand			 }
eventneq                 =      $202;           { zeroand  | zeroxor }
eventdisable             =      $0;             
{ eventopcode0            1000H	see initd.asm }
{ eventopcode1            2000H }
{ eventopcode2            4000H }
{ flags }
eventalways              =      $8000;          { always event (not if) }
eventedge                =      $800;           { edge event (del) }
eventsize0               =      $4;             { 32 bit operation }
eventsize1               =      $8;             { 64 bit operation }
eventhistory             =      $80;            { old result stored here }
{ conditional }
EventAddIf               =      $0;             
EventAdd32If             =      $4;             
EventSubIf               =      $1000;          
EventSub32If             =      $1004;          
EventMul16x16to16If      =      $2000;          
EventCopyIf              =      $5000;          
EventLogicalIf           =      $6000;          
{ change events (Del) }
EventAddIfDel            =      $800;           
EventAdd32IfDel          =      $804;           
EventSubIfDel            =      $1800;          
EventSub32IfDel          =      $1804;          
EventMul16x16to16IfDel   =      $2800;          
EventCopyIfDel           =      $5800;          
EventLogicalIfDel        =      $6800;          
{ always }
EventAdd                 =      $8000;          
EventAdd32               =      $8004;          
EventSub                 =      $9000;          
EventSub32               =      $9004;          
EventMul16x16to16        =      $A000;          
EventCopy                =      $D000;          
EventLogical             =      $E000;          
{ ************************* QUAD COUNTER CONSTANTS *************************** }
{ cntcntl register }
CCinputabit              =      $1;             { read only input a  }
CCinputbbit              =      $2;             { read only input b  }
CCidxbit                 =      $4;             { read only index input }
CCidxpolbit              =      $8;             { index polarity }
CCclronidxbit            =      $10;            { clear counter at index if set }
CCclrdflagbit            =      $20;            { set if count has been cleared (a 0 write will clear flag) }
CCfilterbit              =      $40;            { set for filter  }
CCcntdirbit              =      $100;           { set for reverse count direction }
CCcntclroncebit          =      $200;           { if set clear once }
{ status register }
samplebit                =      1;              { lsb }
commandpending           =      2;              
{ ***************************** BLOCK OFFSETS ******************************** }
{ profilesize	18		size of block }
{ profilestart	56		beginning of motion block }
{ filtersize	16		size of filter block }
{ filterstart	40		begining of filter block }
{ ***************************** ERROR BITS ******************************** }
excessiveposition        =      1;              { (err)  }
drivelimit               =      2;              { (err)  }
{ ***************************** I\O BITS ******************************** }
in0                      =      $1;             { (mask)  }
in1                      =      $2;             { (mask)  }
inlimit                  =      $8000;          { (mask)  }
out0                     =      $1;             { (mask)  }
out1                     =      $2;             { (mask)  }
{ ***************************** MOTOR ************************************ }
onephasemotor            =      1;              { (byte) software control type }
{ ***************************** BAUDRATES ******************************** }
baud110                  =      0;              { (byte)  }
baud150                  =      1;              { (byte)  }
baud300                  =      2;              { (byte)  }
baud600                  =      3;              { (byte)  }
baud1200                 =      4;              { (byte)  }
baud2400                 =      5;              { (byte)  }
baud4800                 =      6;              { (byte)  }
baud9600                 =      7;              { (byte)  }
baud19200                =      8;              { (byte)  }
baud38400                =      9;              { (byte)  }
baud57600                =      10;             { (byte)  }
baud115200               =      11;             { (byte)  }
baud230400               =      12;             { (byte)  }
baud460800               =      13;             { (byte)  }
baud921600               =      14;             { (byte)  }
baud1843200              =      15;             { (byte)  }
