const
{ Copyright (C) 2007 MESA Electronics.  All rights reserved. }
{ bits5.inc }
{ for rev 30 or greater hardware }
majorrev                 =      4;              { (byte) updated when parameters change, hi byte }
minorrev                 =      106;            { (byte) lo byte }
truef                    =      65535;          { (flag) value for flag types }
falsef                   =      0;              { (flag) value for flag types }
{ profile modes }
noprofile                =      0;              { (uint) value for profile_uint }
trapezoidalmode          =      1;              { (uint) value for profile_uint }
externalprofile          =      2;              { (uint) value for profile_uint }
fiforead                 =      0;              { (offset)  }
fiforeadcount            =      1;              { (offset)  }
fifoparamcount           =      2;              { (offset)  }
fifoaxis                 =      3;              { (offset)  }
fifowrite                =      4;              { (offset)  }
fifowritecount           =      5;              { (offset)  }
{ External constants }
ICDFIFO                  =      0;              { offset from hardware base address }
QCDFIFO                  =      4;              
STATUSA                  =      8;              
STATUSB                  =      12;             
IFF                      =      $8000;          { Immediate Command/data FIFO full flag }
IFH                      =      $4000;          { Immediate Command/data FIFO half full flag }
QFF                      =      $2000;          { Queued Command/data FIFO full flag }
QFH                      =      $1000;          { Queued Command/data FIFO half full flag }
IRE                      =      $800;           { Immediate Readback FIFO empty flag }
IRH                      =      $400;           { Immediate Readback FIFO half full flag }
QRE                      =      $200;           { Queued Readback FIFO empty flag }
QRH                      =      $100;           { Queued Readback FIFO half full flag }
parammask                =      $3FF;           
{ ************************* EVENT BLOCK ************************************** }
{ register offsets }
eventopcode              =      0;              { opcode }
eventsource1             =      1;              { (ptr) type:pointer to operand }
eventsource2             =      2;              { (ptr) pointer to second operand }
eventxor                 =      2;              { polarity }
eventsource2xor          =      2;              { alias for either }
eventand                 =      3;              { mask }
eventfree1               =      3;              { for arithmetic events }
eventor                  =      4;              { or }
eventfree2               =      3;              { for arithmetic events }
event2directlo           =      3;              { space for source2 }
event2directhi           =      4;              { space for source2 }
eventdest                =      5;              { (ptr) destination pointer }
eventblocksize           =      6;              { size of event block }
{ low byte }
eventresultcarryxor      =      $1;             
eventresultzeroxor       =      $2;             
{ hibyte }
eventresultcarryand      =      $100;           
eventresultzeroand       =      $200;           
{ logical events }
eventzero                =      $200;           { zeroand }
eventnotzero             =      $202;           { zeroand | zeroxor }
{ 1-2 }
eventcarry               =      $100;           { carryand  }
eventnotcarry            =      $101;           { carryand | carryxor }
eventgt                  =      $303;           { carryand | carryxor | zeroand | zeroxor }
eventlt                  =      $100;           { carryand }
eventgteq                =      $101;           { carryand | carryxor }
eventlteq                =      $300;           { carryand | zeroand }
eventeq                  =      $200;           { zeroand			 }
eventneq                 =      $202;           { zeroand  | zeroxor }
eventdisable             =      $0;             
{ eventopcode0            1000H	see init4.asm }
{ eventopcode1            2000H }
{ eventopcode2            4000H }
{ flags }
eventalways              =      $8000;          { always event (not if) }
eventedge                =      $800;           { edge event (del) }
eventsize0               =      $4;             { 32 bit operation }
eventsize1               =      $8;             { 64 bit operation }
eventhistory             =      $80;            { old result stored here }
{ conditional }
EventAddIf               =      $0;             
EventAdd32If             =      $4;             
EventSubIf               =      $1000;          
EventSub32If             =      $1004;          
EventMul16x16to16If      =      $2000;          
EventMul32x32LoIf        =      $2004;          
EventMul32x32HiIf        =      $2008;          
EventMul32x32to64If      =      $200C;          
EventDivIf               =      $3000;          
EventSqRootIf            =      $4000;          
EventCopyIf              =      $5000;          
EventLogicalIf           =      $6000;          
{ change events (Del) }
EventAddIfDel            =      $800;           
EventAdd32IfDel          =      $804;           
EventSubIfDel            =      $1800;          
EventSub32IfDel          =      $1804;          
EventMul16x16to16IfDel   =      $2800;          
EventMul32x32LoIfDel     =      $2804;          
EventMul32x32HiIfDel     =      $2808;          
EventMul32x32to64IfDel   =      $280C;          
EventDivIfDel            =      $3800;          
EventSqRootIfDel         =      $4800;          
EventCopyIfDel           =      $5800;          
EventLogicalIfDel        =      $6800;          
{ always }
EventAdd                 =      $8000;          
EventAdd32               =      $8004;          
EventSub                 =      $9000;          
EventSub32               =      $9004;          
EventMul16x16to16        =      $A000;          
EventMul32x32Lo          =      $A004;          
EventMul32x32Hi          =      $A008;          
EventMul32x32to64        =      $A00C;          
EventDiv                 =      $B000;          
EventSqRoot              =      $C000;          
EventCopy                =      $D000;          
EventLogical             =      $E000;          
{ ************************* QUAD COUNTER CONSTANTS *************************** }
{ cntcntl register }
CCinputabit              =      $1;             { read only input a  }
CCinputbbit              =      $2;             { read only input b  }
CCidxbit                 =      $4;             { read index }
CCclrbit                 =      $4;             { set to clear counter doesn't stick }
CCidxpolbit              =      $8;             { index polarity }
CCclronidxbit            =      $10;            { clear counter at index if set }
CCclrdflagbit            =      $20;            { set if count has been cleared (a 0 write will clear flag) }
CCfilterbit              =      $40;            { set for filter  }
CCudmodebit              =      $80;            { set for U/D (1X) mode clear for quad (4X) mode }
CCcntdirbit              =      $100;           { set for reverse count direction }
CCcntclroncebit          =      $200;           { if set clear once }
{ status register }
samplebit                =      1;              { lsb }
commandpending           =      2;              
{ irqreg register }
whichirq                 =      $0;             { four least sig bits }
irqdrvena                =      $10;            { true to enable driver }
imask                    =      $40;            { true to drive }
irqstatus                =      $80;            { true for irq }
{ ***************************** BLOCK OFFSETS ******************************** }
profilesize              =      18;             { size of block }
{ offsets from profilestart }
{ desposf_offsetdouble	0 }
{ despos_offsetlong	2 }
{ velocity_offsetlong	4 }
{ accelf_offsetint	6 }
{ accel_offsetlong	7 }
{ jerk_offsetlong		9 }
{ breakpoint_offsetlong	11 }
{ nextproblockoffsetptr	13 }
{ nextpos_offsetlong	14 }
{ slewlimit_offsetlong	16 }
filtersize               =      16;             { size of filter block }
{ offsets from filterstart }
kk_offset                =      0;              
kff_offset               =      1;              
kp_offset                =      2;              
kd_offset                =      3;              
ka_offset                =      4;              
ki_offsetulong           =      5;              
kih_offset               =      6;              
kil_offset               =      7;              
kf0_offset               =      8;              
kf1_offset               =      9;              
kf2_offset               =      10;             
kf3_offset               =      11;             
kdfil_offset             =      12;             
driveplus_offset         =      13;             
driveminus_offset        =      14;             
nextfilblock_offset      =      15;             
{ ***************************** ERROR BITS ******************************** }
excessiveposition        =      1;              { (err)  }
drivelimit               =      2;              { (err)  }
{ ***************************** MOTOR ************************************ }
onephasemotor            =      1;              { (byte) software control type }
twophasemotor            =      2;              { (byte) software control type }
threephasemotor          =      3;              { (byte) software control type }
sinetablesize            =      1024;           { sine lookup table size }
{ ***************************** 4I34 HOST ************************************ }
immediate                =      $200;           { (ptr)  }
queued                   =      $208;           { (ptr)  }
