{ mesa fpga UART }
const

{ registers }
MesaUARTBaseAdd      = $220; { card dependent }

MesaUARTIndex        = $02; { 3 lsb's select port, msb is setup }
MesaUARTTxData1      = $04; { 1 byte push }
MesaUARTTxData2      = $06; { 2 byte push }
MesaUARTTxFIFOCount  = $08;
MesaUARTTxMode       = $0A;

MesaUARTIOPort0      = $0C; { 12 bit port }
MesaUARTIOPort1      = $0E;

MesaUARTRxData1      = $14; { 1 byte pop }
MesaUARTRxData2      = $16; { 2 byte pop }
MesaUARTRxFIFOCount  = $18;
MesaUARTRxMode       = $1A;
MesaUARTIrqStatus    = $1E;

{ setup mode register map }
MesaUARTTxBitRate    = $04;
MesaUARTIOPort0Ddr   = $0C;
MesaUARTIOPort1Ddr   = $0E;
MesaUARTRxBitRate    = $14;
MesaUARTIrqSelect    = $1C;
MesaUARTIrqMask      = $1E;

MesaUARTClock        = 48000000.0;
MesaUARTRxFIFOSize   = 16; { bytes }
MesaUARTTxFIFOSize   = 16; { slots }
MesaUARTNumUARTs     = 8;
MesaUARTFIFOMask     = $1F;

{ bits }
MesaUARTDriveEnableAuto  = $0010;
MesaUARTDriveEnableBit   = $0020;
MesaUARTModeSetupBit     = $8000; { bit 1 for setup }

function BrAccumval(br,bm : real) : word;
var  baud : real;
begin
  baud := br * 65536.0;
  baud := baud / bm;
  baud := baud / MesaUARTClock;
  BrAccumval := round(baud);
end;

procedure MesaSerTossChars(comport : word);
begin
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport;
  portw[MesaUARTBaseAdd+MesaUARTRxFIFOCount] := 0; { clear Rx FIFO}
end;

procedure MesaUARTSetBitrate(comPort : word; bitrate : word);
begin
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport + MesaUARTModeSetupBit;
  portw[MesaUARTBaseAdd+MesaUARTTxBitRate] := bitrate;
  portw[MesaUARTBaseAdd+MesaUARTRxBitRate] := bitrate;
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport;
end;

procedure MesaUARTGetBitrate(comport : word; var bitrate : word);
begin
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport + MesaUARTModeSetupBit;
  bitrate := portw[MesaUARTBaseAdd+MesaUARTTxBitRate];
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport;
end;

procedure MesaUARTSetBaud(comport : word;br,bm : real);
begin
  MesaUARTSetBitrate(comport,BrAccumval(br,bm));
end;

function MesaBaudRateValid(br,bm : real) : boolean;
var ourbaud,testbaud,ratio : real;
value : real;
begin
  MesaBaudRateValid := true;
  ourbaud := br / bm;
  value := BrAccumval(br,bm);
  testbaud := MesaUARTClock * value / 65536.0;
  ratio := ourbaud / testbaud;
  if (ratio > 1.0) and (ratio > 1.03) then MesaBaudRateValid := false;
  if (ratio < 1.0) and (ratio < 0.97) then MesaBaudRateValid := false;
end;

function MesaSerRecvChar(var c : char) : boolean;
var timeout : longint;
begin
  timeout := CharTimeout;
  while ((portw[MesaUARTBaseAdd+MesaUARTRxFIFOCount] = 0) and (timeout <> 0)) do timeout := timeout -1;
  if timeout <> 0 then
  begin
    c := char(portw[MesaUARTBaseAdd+MesaUARTRxData1]);
    MesaSerRecvChar := true;
  end
  else MesaSerRecvChar := false;
end;

function MesaSerRecvString(n : integer;var s : string) : boolean;
var
count : integer;
is : string;
timeout : longint;
begin
  timeout := CharTimeout;
  MesaSerRecvString := false;
  is := '';
  for count := 1 to n do
  begin
    while ((portw[MesaUARTBaseAdd+MesaUARTRxFIFOCount] = 0) and (timeout <> 0)) do timeout := timeout -1;
    if timeout <> 0 then is := is + char(portw[MesaUARTBaseAdd+MesaUARTRxData1]);
  end;
  if timeout <> 0 then MesaSerRecvString := true;
  s := is;
end;

procedure MesaSerSendChar(c : char);
begin
  while MesaUARTTxFIFOSize = portw[MesaUARTBaseAdd+MesaUARTTxFIFOCount] do;
  portw[MesaUARTBaseAdd+MesaUARTTxData1] := word(byte(c));
end;

procedure MesaUARTSendString(s : string);
var len,i : integer;
slots,fifocnt : word;
data : word;
begin
  len := length(s);
  i := 1;
  while i < (len+1) do
  begin
    fifocnt := (portw[MesaUARTBaseAdd+MesaUARTTxFIFOCount] and $1f);
    slots := MesaUARTTxFIFOSize - fifocnt;
    while (slots <> 0) and (i < (len+1)) do
    begin
      if len-i > 0 then
      begin
        WordRec(data).LowByte := byte(s[i]);
        i := i + 1;
        WordRec(data).HighByte := byte(s[i]);
        i := i + 1;
        portw[MesaUARTBaseAdd+MesaUARTTxData2] := data;
        slots := slots-1;
        {delay(1);} {write('send2 ');}
      end
      else
      begin
        WordRec(data).LowByte := byte(s[i]);
        i := i + 1;
        portw[MesaUARTBaseAdd+MesaUARTTxData1] := data;
        slots := slots-1;
        {delay(1);} {write('send1 ');}
      end;
    end;
  end;
  {writeln;}
end;

function MesaCOMPortThere(comport : word) : boolean;
var
tdata : word;
bdata : word;
begin
    MesaComportThere := false;
    MesaUARTSetBitrate(comport,$55aa);
    MesaUARTGetBitrate(comport,bdata);
    if bdata = $55aa then MesaComPortThere := true;
end;

procedure MesaSerOpen(comport : word; br,bm : real);
begin
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport;
  portw[MesaUARTBaseAdd+MesaUARTTxMode] := MesaUARTDriveEnableBit + $0; { no delay }
  portw[MesaUARTBaseAdd+MesaUARTTxFIFOCount] := 0; { clear Tx FIFO}
  MesaSerTossChars(comport); { make real sure there are no pending chars }
  MesaUARTSetBaud(comport,br,bm);

  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport + MesaUARTModeSetupBit; { select port }
  portw[MesaUARTBaseAdd+MesaUARTRxMode] := $0000; { full duplex }
  portw[MesaUARTBaseAdd+MesaUARTIndex] := comport
end;

function MesaCanRead(ms : integer) : boolean;
var ctimeout : longint;
begin
  if ms <> 0 then
  begin
    ctimeout := LoopsPermS * longint(ms);
    while ((portw[MesaUARTBaseAdd+MesaUARTRxFIFOCount] = 0) and (ctimeout <> 0)) do ctimeout := ctimeout -1;
    if ctimeout <> 0 then MesaCanRead:= true else MesaCanRead := false;
  end
  else if ((portw[MesaUARTBaseAdd+MesaUARTRxFIFOCount]) <> 0) then MesaCanRead:= true else MesaCanRead := false
end;

