Copyright (C) 2009 MESA Electronics.  All rights reserved.

;************************* PORTS **********************************************
ififoread	512	%uint	immediate fifo
ififoreadcount	513	%uint	count of data
ififoparam	514	%uint	parameter
ififoaxis	515	%uint	axis
ififowrite	516	%uint	
ififowritecount	517	%uint	

qfiforead	520	%uint	queued fifo
qfiforeadcount	521	%uint	
qfifoparam	522	%uint	
qfifoaxis	523	%uint	
qfifowrite	524	%uint	
qfifowritecount	525     %uint	

cntcntlp	531	%uint	primary counter control reg
cntcntls	533	%uint	secondary counter control reg

prescale	534	%uint	pwm rate = 50mhz/256*(65536/prescale), write only
postscale	535	%uint	sample rate = pwm rate/postscale, write only

cntclrp		536	%uint	write to clear primary counter
cntclrs		537	%uint	write to clear secondary counter

clrclrdp	538	%uint	clear count cleared bit
clrclrds	539	%uint	clear count cleared bit

pwmgena		544	%uint	pwm generator per axis msbyte of word
pwmgenb		545	%uint	pwm generator per axis msbyte of word
pwmgenc		546	%uint	pwm generator per axis msbyte of word
dira		547	%uint	per axis msbit of word
dirb		548	%uint	per axis msbit of word
dirc		549	%uint	per axis msbit of word

ena		550	%uint	per axis pwm enable

;ports are 12 bits wide 
porta		560	%uint	
portaddr	561	%uint	bit is 1 for output
portb		562     %uint
portbddr	563	%uint	bit is 1 for output
portc		564	%uint	
portcddr	565	%uint	bit is 1 for output
portd		566	%uint	
portdddr	567	%uint	bit is 1 for output
porte		568	%uint	
porteddr	569	%uint	bit is 1 for output
portf		570	%uint	
portfddr	571	%uint	bit is 1 for output

irqsetupreg	573  	%uint	irq setup reg
irqcause	574	%uint	write identifier to set 

;multiplier hardware
mula		576	%int	signed multiplier read/write
mulb		577	%uint	unsigned multiplier read/write
hprod		578	%long	32bit signed product read only
hprodh		580	%uint	16bit unsigned product hi word read only
hprodmid	581	%uint	16bit unsigned product mid word 8.8
hacc		582	%long	r/w, adds signed prod when write to hprod,
;				unsigned prod when write to hprodh

hmula		584	%long	32*32=64
hmulb		586	%long
hlprod		584	%double
hmulcnt		591	%uint

hdividend	592	%double	64/32=32
hdivisor	596	%long
hquotient	592	%long
hremainder	594	%long
hdivcnt		599	%uint

hradicand	600	%double sqrt(64)=32
hroot		600	%long
hsqrtcnt	607	%uint

lookupadd	608	%uint	sine lookup table address r/w 0..511
lookupdata	609	%uint	sine lookup table data r/w left justified
lookupantidata	610	%uint	sine lookup table data r/w antiphase left justified

pfd0		612	%uint	7i32 mode bit
pfd1		613	%uint	7i32 mode bit
AltIndexbit	614	%uint	read alternate index bit for 7I32

quadoutrate	616	%uint	rate register
quadoutcount	617	%uint	input pulse count 8 bit
quadoutmode	618	%uint	bit0: output enable, bit1: freerun mode

leds		624	%uint	byte 
beep		625	%uint	msb

;hardware constants	
sysclk		628	%long	CPU clock frequency
zero		632	%int	constant
one		640	%int	constant
false		632	%flag	constant
minusone	633	%int	
true		633	%flag

naxis		634	%uint	number of axis's in hardware
hwrevision	635	%uint	hwtype in hi byte revision in low byte
icdfifosize	636	%uint	immediate command\data fifo size 
qcdfifosize	637	%uint	queued command\data fifo size 
irbfifosize	638	%uint	immediate readback fifo size
qrbfifosize	639	%uint	queued readback fifo size



