Copyright (C) 2006 MESA Electronics.  All rights reserved.
;The functional interface to the motor controller is done by a dual port ram
;sample:	the time between iterations of the pid loop, see prescale and postscale
;counts:	encoder counts ppr*4

;UNITS
;despos		encoder counts                     BBBB.        B=byte S=signextend
;desposf	fractional encoder counts               BBB0    B=byte S=signextend
;velocity	8.24 counts per sample 		   SSSB.BBB     (127 max motor counts per sample)
;velocityf	8.24 counts per sample 		      0.000BB   (127 max motor counts per sample)
;accel		8.24 counts per sample per sample     B.BBB
;accelf		is the fractional part of accel       0.000BB
;jerk		added to accel.accelf each sample     S.SBBBB
;avgvel		8.8 velocity units
;pwm		8.8 signed number, only integer part used for output

;TYPES (contents of ram address)
;	<blank>	number of bits is hardware dependent	
;	byte	8 bit unsigned value
;	ptr	10 bit address pointer
;	flag	16 bit value 0 is false, nonzero is true
;	mask	16 bit mask bit true enables
;	uint	16 bit unsigned value 0..65535
;	int	16 bit signed value -32768..32767
;	ulong	32 bit unsigned value 0..4294967295
;	long	32 bit signed value -2147483648..2147483647
;	double	64 bit signed value -1.8E19..1.8E19
;	ebyte	8 bit unsigned value in eeprom

;PARAMETER	VALUE	TYPE	FUNCTION
null		0	%ptr	uninitialized pointers point to dummy
dummy		0	%uint	default 16bit pointers point here 
dummyhi		1	%uint	default 32bit pointers point here 
go		2	%flag	set true to start move
pid		3	%flag	set true to enable pid 
profile		4	%uint	0=off, 1=trapezoidal profile, 2=host profile
drivemode	5	%flag	false for voltage control, true for current control
dirinv		6	%flag	set true to invert motor drive polarity
proctimer	7	%uint	read sample timer
stepdir		8	%flag	true for step/direction inputs
home		9	%flag	becomes true when home has occured
motion	        10	%flag	becomes false when velocity = 0
slew		11 	%flag	true when maximum velocity is reached
error		12 	%uint	non-zero when excessive position, or drive error
errormask	13	%mask	mask for error, default enabled
events		14	%uint	number of events, 24 max
maxpwm		15	%uint	pwm limited to this value
avgvel		16	%int	average velocity 8.8
exposerr	17 	%uint	excessive position error limit <32767
maxnegerr	18 	%int	max negative error
maxposerr	19 	%int	max positive error
driveerror	20	%uint	variable to count,
posenc		21	%ptr	pointer to position encoder
velenc		22	%ptr	pointer to velocity encoder
actvel		23	%int	actual velocity
bnderr		24	%int	bounded (@follow-@posenc)
extvelocity	25	%ptr	pointer to actvel, for external velocity
follow		26	%ptr	pointer to desired position
pwm		27	%int	pwm value

;32bit user parameters
homeposp	28	%long	position loaded when primary index occurs
phasek		30	%long	phase konstant
phasea		32	%long	phase accumulator, phasek is added to phasea each sample
encp		34	%long	primary encoder, read only
desvel		36 	%long	desired velocity, set by slewlimit

;16bit user parameters
timeout		38	%uint	incremented each time we haven't finished before the next sample
sync		39	%flag	set before host, cleared after

;filter param
kk		40	%int	pwm offset, initial pwm value
kff		41	%uint	friction in the direction of motion
kp		42	%uint	kpd*error added to pwm
kd		43 	%uint	kdd*actualvelocity added to pwm
ka		44	%uint	unused accel error
ki		45	%ulong	ki*error added to integralq each sample, high word added to pwm
kih		46	%uint	high word of ki not used
kil		47 	%uint	high word limit of ki, 32767 max
kf0		48	%uint	(unimplemented) spring
kf1		49	%uint	velocity ff
kf2		50	%uint	accel ff
kf3		51	%uint	phasor velocity feedforward unused
kdfil		52	%uint	amount of filtering
driveplus	53	%uint	amount added to driveerror if maxpwm, generates error if overflow
driveminus	54	%uint	amount subtracted from driveerror if not maxpwm, bounded at 0

;profile parameters with breakpoint registers
desposd		56 	%double	32.32 profile position
desposf		56 	%long	fractional part of profile position
despos		58	%long	integer part of profile position
velocity	60 	%long	profile velocity		
accelf		62	%int	fractional part of accel for jerk
accel		63	%long	acceleration, if 0 then no motion
jerk		65	%long	added to accel each sample
breakpoint	67	%long	block breakpoint value
nextproblock	69	%ptr	pointer to next profile block
nextpos		70	%long	where we want to go next
slewlimit	72	%long	slew speed limit, 2^23-1 max for kf1,kf2

;32bit internal use only
startpos	74	%long	begining of move
delta		76	%long	velq - velocityq 
velocityf	78	%int	fractional part of velocity
;free		79	%uint	
checkpos	80 	%long	checking position for done
decelpos	82  	%long	position to start decel
fixup		84	%long	profile generator error
preslewvel	86 	%long	velocity before slew starts or maximum velocity
preslewpos	88  	%long	position before slew starts or maximum velocity

;48bit number internal use only
integral	90  	%long	integral error accumulator
integralovf	92  	%int	overflow for integral

;16bit internal use only
stopathome	93  	%flag	if true desvel and go are cleared at home
skip		94	%flag	skip position update once only
lastpos		95	%uint	last actual position low half
lastvelocity	96	%int	old velocity

gphasef		97	%flag	set true on carry of gphasea
gphasek		98	%long	gphase konstant
gphasea		100	%long	gphase accumulator, gphasek is added to gphasea each sample

prescale	102	%uint	samplerate is sysclk/prescale 
slow		103	%flag	set true for dot 32 velocity
flagxor		104	%uint	wait for flag xor invert
flagand		105	%uint	wait for flag and mask 
userstatus	106	%uint	low byte read by read status command

;************************* PORTS *********************************************
cntcntlp	107	%uint	counter control register
cntclrp		108	%flag	set true to clear counter

pwmgena		109	%uint	motor pwm
motori		110	%uint	motor current limit
dira		111	%uint	motor direction
ena		112	%uint	motor on

outport		113	%uint
inport		114	%uint	user port

analog0		115	%uint	analog inputs
analog1		116	%uint	analog inputs
analog2		117	%uint	analog inputs

;user ram
eventfirst	118	%uint	
event1		118	%uint	
event2		124	%uint	
event3		130	%uint	
event4		135	%uint	
event5		142	%uint	
event6		148	%uint	
event7		154	%uint	
event8		160	%uint	
event9 		166	%uint	
event10		172	%uint	
event11		178	%uint	
event12		184	%uint	
event13		190	%uint	
event14		196	%uint	
event15		202	%uint	
event16		208	%uint	
event17		214	%uint	
event18		220	%uint	
event19		226	%uint	
event20		232	%uint	
eventlast	232	%uint	

;************************* FIFOS **********************************************
icdfifocount	238	%uint	count of data in icdfifo
irbfifocount	239	%uint	count of data in irbfifo
ififowrite	0400h	%uint	marker for event logic

qcdfifocount	240	%uint	
qrbfifocount	241	%uint	
qfifowrite	0800h	%uint	marker for event logic

icdfifosize	242	%uint	immediate command\data fifo size 
qcdfifosize	243	%uint	queued command\data fifo size 
irbfifosize	244	%uint	immediate readback fifo size 
qrbfifosize	245	%uint	queued readback fifo size 

;************************* SYSTEM CONSTANTS **********************************
;software constants
cputype		246	%uint	CPU type
controltype	247	%uint	number of motor phases
swrevision	248	%uint	majorrev hibyte minorrev lobyte

;hardware constants
naxis		249	%uint	1
zero		250	%int	0
false		250	%flag	false
one		251	%int	1
true		252	%flag	true
minusone	252	%int	-1
sysclk		253	%long	CPU clock frequency
hwrevision	255	%uint	hwtype in hi byte revision in low byte

;******************* BOGUS STUFF FOR DCMTUNE *******************************
;ififoread	0	%uint	immediate fifo
ififoreadcount	238	%uint	count of data
;ififoparam	0	%uint	parameter
;ififoaxis	0	%uint	axis
ififowritecount	239	%uint	

;qfiforead	0	%uint	queued fifo
qfiforeadcount	240	%uint	
;qfifoparam	0	%uint	
;qfifoaxis	0	%uint	
qfifowritecount	241     %uint	

;multiphase motor parameters internal use only
phaselead	0	%int	lead angle
motorangle	0	%uint	sintablesize / angle between phases
motorphase	0	%uint	encp mod encodercnt
homeoffset	0	%int	offset from home position

postscale	0	%uint	sample rate = pwm rate/postscale, write only

ledaxis		0	%ptr	axis for leds to monitor
led		0	%ptr	parameter for leds to monitor, if not zero

gevents		0	%uint	number of global events 36 max

;global ram
firstgevent	0     	%uint
geventfirst	0	%uint	
gevent1		0	%uint

geventlast	0	%uint	
lastgevent      0     	%uint

endofglobalram	0

address		1	%ebyte
baudsel		2	%ebyte
serialmode	3	%ebyte
loadparam	6	%ebyte
stepdirena	7	%ebyte
