Copyright (C) 2005 MESA Electronics.  All rights reserved.
;The functional interface to the motor controller is done by a dual port ram
;sample:	the time between iterations of the pid loop, see prescale and postscale
;counts:	encoder counts ppr*4

;UNITS
;despos		encoder counts                     BBBB.        B=byte S=signextend
;desposf	fractional encoder counts               BBB0    B=byte S=signextend
;velocity	8.24 counts per sample 		   SSSB.BBB     (127 max motor counts per sample)
;velocityf	is the fractional part of vel         0.000BB
;accel		8.24 counts per sample per sample     B.BBB
;accelf		is the fractional part of accel       0.000BB
;jerk		added to accel.accelf each sample     S.SBBBB
;avgvel		8.8 velocity units
;pwm		8.8 signed number, only integer part used for output

;TYPES (contents of ram address)
;	<blank>	number of bits is hardware dependent	
;	byte	8 bit unsigned value
;	ptr	10 bit address pointer
;	flag	16 bit value 0 is false, nonzero is true
;	mask	16 bit mask bit true enables
;	uint	16 bit unsigned value 0..65535
;	int	16 bit signed value -32768..32767
;	ulong	32 bit unsigned value 0..4294967295
;	long	32 bit signed value -2147483648..2147483647
;	double	64 bit signed value -1.8E19..1.8E19

;PARAMETER	VALUE	TYPE	FUNCTION
nulld		0	%double	32bit empty location
null		0	%ptr	uninitialized pointers point to dummy
dummy		0	%uint	default pointers point here
dummyhi		1	%uint	default 32bit pointers point here 
go		2	%flag	set true to start move
pid		3	%flag	set true to enable pid 
profile		4	%uint	0=off, 1=trapezoidal profile, 2=host profile
dist		5	%int	used by profile5
decel		5	%flag	true when decel
dirinv		6	%flag	set true to invert motor drive polarity
filterblock	7	%ptr	pointer to filterblock
;profileblock	8	%ptr	pointer to profileblock
home		9	%flag	becomes true when home has occured
motion	        10	%flag	becomes false when velocity = 0
slew		11 	%flag	true when maximum velocity is reached
error		12 	%uint	non-zero when excessive position, or drive error
errormask	13	%mask	mask for error, default enabled
events		14	%uint	number of events, 24 max
maxpwm		15	%uint	pwm limited to this value
avgvel		16	%int	average velocity 8.8
exposerr	17 	%uint	excessive position error limit <32767
maxnegerr	18 	%int	max negative position error to PID
maxposerr	19 	%int	max positive position error to PID
driveerror	20	%uint	variable to count
posenc		21	%ptr	pointer to position encoder
velenc		22	%ptr	pointer to velocity encoder
actvel		23	%int	actual velocity
bnderr		24	%int	bounded (@follow-@posenc)
extvelocity	25	%ptr	pointer to actvel, for external velocity
follow		26	%ptr	pointer to desired position
pwm		27	%int	pwm value

;multiphase
phaseai		28	%uint	max current, 21845/amp hi current (65535/amp lo)
phasebi		29	%uint	max current, 21845/amp hi current (65535/amp lo)
offseti		30	%uint	offset current (to remove dead zone in driver)
encodercnt	31	%uint	counts per rev, use smallest integer for accuracy
encfactor	32	%uint	(sinetablesize * #poles * 256) / encodercnt
slipk		33	%int	add to phaselead (for induction motors)
phaseshift	34	%flag	set true to invert one motor phase
openloop	35	%flag	when true use despos, pid must be on, default on

;32bit user parameters
homeposp	36	%long	position loaded when primary index occurs
homeposs	38	%long	position loaded when seconday index occurs
phasek		40	%long	phase konstant
phasea		42	%long	phase accumulator, phasek is added to phasea each sample
encp		44	%long	primary encoder, read only
encs		46	%long	secondary encoder, read only
desvel		48 	%long	desired velocity, 
;				value set by slewlimit sign set by direction of move

;filter param
filterstart	50		begining of filter block
;kk		50	%int	pwm offset, initial pwm value
;kff		51	%uint	friction in the direction of motion
;kp		52	%uint	kpd*error added to pwm
;kd		53 	%uint	kdd*actualvelocity added to pwm
;ka		54	%uint	unused accel error
;ki		55	%ulong	ki*error added to integralq each sample, high word added to pwm
;kih		56	%uint	high word of ki not used
;kil		57 	%uint	high word limit of ki, 32767 max
;kf0		58	%uint	(unimplemented) spring
;kf1		59	%uint	velocity ff
;kf2		60	%uint	accel ff
;kf3		61	%uint	phasor velocity feedforward unused
;kdfil		62	%uint	amount of filtering
;driveplus	63	%uint	amount added to driveerror if maxpwm, generates error if overflow
;driveminus	64	%uint	amount subtracted from driveerror if not maxpwm, bounded at 0
;nextfilblock	65	%ptr	pointer to next filter block

;profile parameters with breakpoint registers
profilestart	66		beginning of motion block
desposd		66 	%double	32.32 profile position
desposf		66 	%long	.32 fractional part of profile position
despos		68	%long	32. profile position
velocity	70 	%long	profile velocity		
accelf		72	%int	fractional part of accel for jerk
accel		73	%long	acceleration, if 0 then no motion
jerk		75	%long	added to accel each sample
breakpoint	77	%long	block breakpoint value
nextproblock	79	%ptr	pointer to next profile block
nextpos		80	%long	where we want to go next
slewlimit	82	%long	slew speed limit, 2^23-1 max for kf1,kf2

;multiphase motor parameters internal use only
phaselead	84	%int	lead angle
motorangle	85	%uint	sintablesize / angle between phases
motorphase	86	%uint	encp mod encodercnt
homeoffset	87	%int	offset from home position

;internal use only
calcaccel	88	%long	used for determining accel inflection point
delta		90	%long	velq - velocityq
fvelocity	92	%uint	.16 velocity
flastvelocity	93	%uint	.16 old velocity
flagxor		94	%uint	wait for flag xor invert
flagand		95	%uint	wait for flag and mask 
fractionaccel	96  	%long	accel / n 
halfaccel	96  	%long	accel / n 
fixup		98	%long	profile generator error
ouraccel	100	%long	start with half accel 

stopathome	102 	%flag	if true clear desvel and go during home
velocityf	103	%int	fractional part of velocity for jerk

;48bit number internal use only
integral	104 	%long	integral error accumulator
integralovf	106 	%int	overflow for integral

;16bit internal use only
reset		107	%flag	true when axis is reset
olddist		108 	%int	
acceln		108 	%uint	n for accelfract	
lastpos		109	%uint	last actual position low half
oldgo		110	%flag	internal
oldpid		111 	%flag	internal
 
;user ram
firstevent	112	%uint
eventfirst	112	%uint
event1		112	%uint
event2		118	%uint
event3		124	%uint
event4		130	%uint
event5		136	%uint
event6		142	%uint
event7		148	%uint
event8		154	%uint
event9		160	%uint
event10		166	%uint
event11		172	%uint
event12		178	%uint
event13		184	%uint
event14		190	%uint
event15		196	%uint
event16		202	%uint
event17		208	%uint
event18		214	%uint
event19		220	%uint
event20		226	%uint
event21		232	%uint
event22		238	%uint
event23		244	%uint
event24		250	%uint
eventlast	250	%uint
lastevent	250     %uint

endofaxisram	255

;global ram
firstgevent	256     %uint
geventfirst	256	%uint
gevent1		256	%uint		host events
gevent2		262	%uint
gevent3		268	%uint
gevent4		274	%uint
gevent5		280	%uint
gevent6		286	%uint
gevent7		292	%uint
gevent8		298	%uint
gevent9		304	%uint
gevent10	310	%uint
gevent11	316	%uint
gevent12	322	%uint
gevent13	328	%uint
gevent14	334	%uint
gevent15	340	%uint
gevent16	346	%uint
gevent17	352	%uint
gevent18	358	%uint
gevent19	364	%uint
gevent20	370	%uint
gevent21	376	%uint
gevent22	382	%uint
gevent23	388	%uint
gevent24	394	%uint
gevent25	400	%uint
gevent26	406	%uint
gevent27	412	%uint
gevent28	418	%uint
gevent29	424	%uint
gevent30	430	%uint
gevent31	436	%uint
gevent32	442	%uint
gevent33	448	%uint
gevent34	454	%uint
gevent35	460	%uint
gevent36	466	%uint
geventlast	466	%uint
lastgevent      466     %uint

endofglobalram	471

;these locations are reserved, do not use
greservedstart	472
greservedend	495 

ledaxis		496	%ptr	axis for leds to monitor
led		497	%ptr	parameter for leds to monitor, if not zero
beeper		498	%ptr	beep uses what this points to, if not zero
proctimer	499	%uint	max ???read proctimer here
timeout		500	%uint	incremented each time we haven't finished before the next sample
gevents		501	%uint	number of global events 36 max
axis		502	%ptr	the current axis
sync		503	%flag	set before host, cleared after

gphasek		504	%long	gphase konstant
gphasea		506	%long	gphase accumulator, gphasek is added to gphasea each sample
gphasef		508	%flag	set true on carry of gphasea

cputype		509	%uint	CPU type
controltype	510	%uint	number of motor phases
swrevision	511	%uint	majorrev hibyte minorrev lobyte
