{$N+}
{$R-}
{$Q-}
program WriteEvent;

{$IFDEF WINDOWS}
uses synaser,dos,wincrt;
var TheComPort : string;
    ser:TBlockSerial;
{$ELSE}
uses dos,crt;
var TheComPort : word;
{$ENDIF}
const
CEMask = $FC7C; { to drop modifier and history bits }
ModMask = $0303; { to drop all but mod bits }

var
Message : string;
EventNum : byte;
Retcode : integer;
GEV : boolean;
ParmLoc : integer;
ParmName : string;
TheEventSymbol : string;
TheEventValue : word;

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP}
{$I SELECTPR}
{$I Interfce}

{$I eventlow }

var
TheEvent : Event;
Parmtype : ParameterType;
TheEventSymbolType : ESymbolType;

procedure Error(err : integer);
begin
  writeln(errorrecord[err].errstr);
  halt(2);
end;

procedure Usage;
begin
  writeln('Usage: EVENT OPCODE [MODIFIER] SRC1 SRC2 FREE1 FREE1 DEST NUM G|A [AXIS]');
  writeln('( For Arithmetic events)');
  writeln('Usage: EVENT OPCODE [MODIFIER] SRC1 XORMASK ANDMASK ORMASK DEST NUM G|A [AXIS]');
  writeln('( For Logical events)');
  writeln;
  halt(2);
end;

procedure HexBumOut(s : string);
begin
  writeln('Unable to parse ',s,' as a 16 bit Hex constant');
  halt(2);
end;

function FindParm(aname : string) : boolean;
var
index : integer;
cname : string;
offset : word;
retcode : integer;
begin
  cname := StripTillChar(aname,'+');
  offset := 0;
  if length(aname) >0 then
  begin
    val(aname,offset,retcode);
    if retcode <> 0 then BumOut('Can''t parse offset');
  end;
  index := 1;
  while (upstring(cname) <> upstring(SDMCParams[index].ParmName)) and (index <= LastParm) do index := index +1;
  ParmLoc := SDMCParams[index].ParmLoc + offset;
  ParmType := SDMCParams[index].ParmType;
  ParmName := SDMCParams[index].ParmName; {so it will have the cannonical name}
  if index > LastParm then FindParm := false else findparm := true;
end;

function FindParmBin(aloc : word) : boolean;
var index : integer;
begin
  index := 1;
  while (aloc <> SDMCParams[index].ParmLoc) and (index <= LastParm) do index := index +1;
  ParmType := SDMCParams[index].ParmType;
  ParmName := SDMCParams[index].ParmName; {so it will have the cannonical name}
  if index > LastParm then FindParmBin := false else FindParmBin := true;
end;

function FindEventSymb(aname : string) : boolean;
var index : integer;
begin
  index := 1;
  while (upstring(aname) <> upstring(EventSymbols[index].EventSymb)) and (index <= LastParm) do index := index +1;
  TheEventSymbolType := EventSymbols[index].ESymbType;
  TheEventValue := EventSymbols[index].ESymbVal;
  TheEventSymbol := EventSymbols[index].EventSymb; {so it will have the cannonical name}
  if index > LastSymb then FindEventSymb := false else FindEventSymb := true;
end;

function FindEventOpcode(opcode : word) : boolean;
var index : integer;
begin
  index := 1;
  while (opcode <> EventSymbols[index].Esymbval) and (index <= LastParm) do index := index +1;
  TheEventSymbolType := EventSymbols[index].ESymbType;
  TheEventSymbol := EventSymbols[index].EventSymb; {so it will have the cannonical name}
  if index > LastSymb then FindEventOpcode := false else FindEventOpCode := true;
end;

procedure Pause;
var foo : string;
begin
  writeln;
  write('Press return to continue');
  readln(foo);
end;

procedure ShowParameters(s : string);
var index,lc : integer;
begin
  writeln('No such parameter: '+s);
  writeln('Valid parameters are: ');
  lc := 0;
  for index := 1 to LastParm do
  begin
    if (index mod 4) = 0 then
    begin
      writeln;
      lc := lc +1;
    end;
    if lc > 19 then
    begin
      Pause;
      lc := 0;
    end;
    write(PadWithSpaces(SDMCParams[index].ParmName,19));
  end;
  writeln;
  halt(2);
end;

procedure ShowEventSymbols(s : string);
var index,sc : integer;
begin
  writeln('No such EventSymbol '+s);
  writeln('Valid EventSymbols are: ');
  index := 1;
  sc := 1;
  while index <= LastSymb  do
  begin
    if (sc mod 3) = 0 then writeln;
    if (EventSymbols[index].EsymbType = CE) or (EventSymbols[index].EsymbType = UE)
    or (EventSymbols[index].EsymbType = CL) or (EventSymbols[index].EsymbType = UL) then
    begin
      write(PadWithSpaces(EventSymbols[index].EventSymb,25));
      sc := sc +1;
    end;
    index := index + 1;
  end;
  writeln;
  halt(2);
end;

procedure ShowEventSymbolModifiers(s : string);
var index,sc : integer;
begin
  writeln('No such Event Conditional modifier '+s);
  writeln('Valid Event modifiers are: ');
  index := 1;
  sc := 0;
  while index <= LastSymb do
  begin
    if (sc mod 3) = 0 then writeln;
    if (EventSymbols[index].EsymbType = LM) or (EventSymbols[index].EsymbType = SM) then
    begin
      write(PadWithSpaces(EventSymbols[index].EventSymb,25));
      sc := sc +1;
    end;
    index := index + 1;
  end;
  writeln;
  halt(2);
end;

procedure PrintEvent(anevent : Event);
var
petype : ESymbolType;
begin
  with anevent do
  begin
    if not FindEventOpcode(ER_Opcode and CEMask) then Bumout('Can''t decode event opcode');
    petype := TheEventSymbolType;
    if (petype = CL) or (petype = UL) then  writeln ('Logical Event:') else writeln('Arithmetic event:');{ logical types }
    write('OpCode  = ',TheEventSymbol);
    if (TheEventSymbolType = CE) or (TheEventSymbolType = CL) then
    begin
      if not FindEventOpCode(ER_Opcode and ModMask) then Bumout('Can''t decode conditional modifier');
      writeln(' & ',TheEventSymbol);
    end
    else writeln;
    if not FindParmBin(ER_Src1) then Bumout('Source 1 doesn''t seem to be a valid parameter address');
    writeln('Source1 = ',ParmName);
    if (petype = CL) or (petype = UL) then  { logical types }
    begin
      writeln('XORMask = ',HexString(ER_SRC2,4));
      writeln('ANDMask = ',HexString(ER_LogAnd,4));
      writeln('ORMask  = ',HexString(ER_LogOr,4));
    end
    else
    begin
      if not FindParmBin(ER_Src2) then Bumout('Source 2 doesn''t seem to be a valid parameter address');
      writeln('Source2 = ',ParmName);
      writeln('FREE1   = ',HexString(ER_LogAnd,4));
      writeln('FREE2   = ',HexString(ER_LogOr,4));
    end;
    if not FindParmBin(ER_Dest) then Bumout('Source 2 doesn''t seem to be a valid parameter address');
    writeln('Dest    = ',ParmName);
  end;
end;

procedure ParseLine;
var
petype : ESymbolType;
pindex : word;
hval : word;
begin
  if ParamCount < 1 then usage;
  GetOurEnv;
  pindex := 1;
  if not FindEventSymb(ParamStr(pindex)) then ShowEventSymbols(ParamStr(pindex));
  TheEvent.ER_Opcode := TheEventValue;
  petype := TheEventSymbolType;
  if (petype = SM) or (petype = LM) then ShowEventSymbols(ParamStr(pindex));
  if (petype = CE) or (petype = CL) then  { Conditional events need modifier }
  begin
    pindex := pindex +1;
    if not FindEventSymb(ParamStr(pindex)) then ShowEventSymbolModifiers(ParamStr(pindex));
    if (TheEventSymbolType = LM) or (TheEventSymbolType = SM) then
    begin
      TheEvent.ER_Opcode := TheEvent.ER_Opcode or TheEventValue;
    end
    else
    begin
      ShowEventSymbolModifiers(ParamStr(pindex));
    end;
  end;
  pindex := pindex +1;
  if not FindParm(ParamStr(pindex)) then ShowParameters(ParamStr(pindex)); { this is the source address }
  TheEvent.ER_Src1 := ParmLoc;
  pindex := pindex +1;
  if (petype = CL) or (petype = UL) then { logical events SRC2 is LOGXOR }
  begin
    if not HexWordRead(ParamStr(pindex),hval) then HexBumout(ParamStr(pindex));
    TheEvent.ER_Src2 := hval;
  end
  else
  begin   { Arithmetic events SRC2 is a parameter address }
    if not FindParm(ParamStr(pindex)) then ShowParameters(ParamStr(pindex)); { this is the source address }
    TheEvent.ER_Src2 := ParmLoc;
  end;
  pindex := pindex +1;
  if not HexWordRead(ParamStr(pindex),hval) then HexBumout(ParamStr(pindex));
  TheEvent.ER_Logand := hval;
  pindex := pindex +1;
  if not HexWordRead(ParamStr(pindex),hval) then HexBumout(ParamStr(pindex));
  TheEvent.ER_Logor := hval;
  pindex := pindex+1;
  if not FindParm(ParamStr(pindex)) then ShowParameters(ParamStr(pindex)); { this is the source address }
  TheEvent.ER_Dest := ParmLoc;
  pindex := pindex +1;
  val(ParamStr(pindex),EventNum,retcode);
  if retcode <> 0 then Bumout('Can''t parse event number');
  pindex := pindex +1;
  if (UpString(ParamStr(pindex)) <> 'G') and (UpString(ParamStr(pindex)) <> 'A') then Bumout('Global or Axis event???');
  if UpString(ParamStr(pindex)) = 'G' then GEV := true else GEV := false;
  pindex := pindex +1;
  Axis := 0;
  if Length(ParamStr(pindex)) > 0 then val(ParamStr(pindex),Axis,retcode);
  if retcode <> 0 then Bumout('Can''t parse Axis number');
  if GEV then
  begin
    writeln('Installing global event ',EventNum);
    PrintEvent(TheEvent);
    if not GlobalEvent(Axis,TheEvent) then Bumout('Invalid global event number');
  end
  else
  begin
    writeln('Installing Axis event ',EventNum,' for axis ',Axis);
    PrintEvent(TheEvent);
    if not AxisEvent(Axis,EventNum,TheEvent) then Bumout('Invalid axis event number');
  end;
end;

begin
  GetOurEnv;
  if not InitializeInterface(Message) then bumout(Message);
  ClearFifos;
  ParseLine;
  halt(0);
end.
