{DEMO SOFTWARE - FILTER PARAMETER ADJUST PROGRAM FOR 4I34/7I60/4I65/5I20 MOTOR CONTROLLER }
{ BUGS perhaps if you type too soon the profile is broken }


{$R-}
{$Q-}
{ choose one }
{DEFINE SOFTDMC} { for SOFTDMC}
{DEFINE THREEC20} { for 3C20 }
{DEFINE EIGHTC20} { for 8C20 }
{DEFINE EIGHTI20} { for 8I20 }
{DEFINE SEVENI64} { for 7I64 }
{$DEFINE FIFO}

{$DEFINE COPROC}
{$IFDEF COPROC}
{$N+}
{$ELSE}
{$N-}
{$ENDIF}

{$IFDEF THREEC20}
{$DEFINE DSPIC}
{$ENDIF}
{$IFDEF EIGHTI20}
{$DEFINE DSPIC}
{$ENDIF}

{$IFDEF EIGHTC20}
{DEFINE DSPIC}
{$ENDIF}

{$IFDEF WINDOWS}
uses synaser,graph,wincrt,dos;
var
GraphDriver : smallint;
TheComPort : string;
ser:TBlockSerial;
{$ELSE}
uses graph,crt,dos;

var
GraphDriver : integer;
TheComPort : word;
{$ENDIF}

GraphicsOn : boolean;
initok : boolean;
lastaxis : byte;
Naxis : byte;
Message : string;

{$I SELECTC}
{$I SELECTIO}
{$I SELECTP}
{$I INTERFCE}
{$IFDEF EIGHTC20}
{$ENDIF}

{$I MOTLOW4}

const
NTimes = 8;
type point = record
  X : integer;
  Y : integer;
end;

type box = record
 Start : point;
 Size : point;
end;

type title = string[10];

type labeledbox = record
  TitleBox : box;
  ValueBox : box;
  Title : string;
end;

type menuindextype =  (KPI,KDI,KDFILI,KII,ILI,IKF1,IKF2,IKFF,IKK,IEC,SII,STP,VEL,ACC,MTR,TIM);
type menuboxestype = array[KPI..TIM] of labeledbox;
type menutitlestype = array[KPI..TIM] of string[10];
type menuspeed = (DownFast,DownSlow,UpFast,UpSlow,Zero,Max,NoChange);
timeperdivtype = array [1..NTimes] of word;

type AxisInfo = record
  StepSize : longint;
  Velocity : longint;
  Acceleration : longint;
  KP :  word;
  KD :  word;
  KDFIL : word;
  KI :  longint;
  KIL : word;
  KF1 : word;
  KF2 : word;
  KFF : word;
  KK : integer;
  EC : word;
  Prescale : word;
  PostScale : byte;
  PWMRate : word;
  tDiv : word;
end;

type AIFile = file of AxisInfo;
     AListFile = text;
     TraceFIle = text;

const
TheAIFileName = 'Motors.rec';
TheAListFileName = 'Motors.lst';
TheTraceFileName = 'MotTrace.lst';

MenuTitles : menutitlestype = ('KP','KD','KDFIL','KI','IL','KF1','KF2',
                               'KFF','KK','ENC LINES','PRE/POST','STEP SIZE','VELOCITY',
                               'ACCEL.','MOTOR','TIME / DIV');
FirstMenuIndex = KPI;
LastMenuIndex = TIM;
Times : timeperdivtype = (1,2,5,10,20,50,100,200);
MaxSamples = 2048; { maximum per variable }
ParamsPerSample = 3;
EncoderLines = 500;

TrigVal = EventLastLoc +1;        { trigger value to set Go}
SampleCnt = EventLastLoc +2;      { internal sample count }
TestData = EventLastLoc +3;
PseudoGoloc = EventLastLoc +4;
DAQFlag = GPhaseFLoc;   { our DAQFlag }

HDivsPerScreen = 10;
VDivsPerScreen = 8;
BusModeSamplesPerVariable = 1024;
SerModeSamplesPerVariable = 80;
LBPModeSamplesPerVariable = 330;

var
StepParameters : array[0..7] of AxisInfo;
SavedParameters : AxisInfo;
ScreenBox : labeledbox;
MainBox : labeledbox;
VariablesBox : labeledbox;
GraphBox : labeledbox;
MessageBox : labeledbox;

MenuIndex : menuindextype;
MenuBoxes : menuboxestype;
MenuCount : integer;
BoxColor : word;
TitleColor : word;
ProfileColor : word;
DriveColor : word;
ErrorColor : word;
ValueTextColor : word;
TitleTextColor : word;
ValueColor : word;
TimeDivIndex : word;
ArrowSize : word;
ResponseTable : array[0..MaxSamples] of Integer;
ProfileTable : array[0..MaxSamples] of Integer;
DriveTable : array[0..MaxSamples] of Integer;
SamplesPerScreen : word;
SPSValid : boolean;
SamplesPerVariable : word;
TheAIFile : AIFile;
TheAListFile : AListFile;
TheTraceFile : TraceFile;

function OpenForRead(var fp: AIFile; name: string): boolean;
begin
  Assign(fp,Name);
  {$I-}
  Reset(fp);
  {$I+}
  OpenForRead := IOResult = 0;
end { Open };

function OpenForWrite(var fp: AIFile; name: string): boolean;
begin
  Assign(fp,Name);
  {$I-}
  Rewrite(fp);
  {$I+}
  OpenForWrite := IOResult = 0;
end { Open };

function OpenForWriteChar(var fp: text; name: string): boolean;
begin
  Assign(fp,Name);
  {$I-}
  Rewrite(fp);
  {$I+}
  OpenForWriteChar := IOResult = 0;
end { Open };

procedure BoxInBox(refBox : labeledbox; var newBox : labeledbox; begX : real; begY : real; endX : real; endY : real);
var
sDelX : integer;
sDelY : integer;
eDelX : integer;
eDelY : integer;
begin
  with refBox.ValueBox do
  begin
    sDelX := round(begX * Size.X);
    sDelY := round(begY * Size.Y);
    eDelX := round((1-endX) * Size.X);
    eDelY := round((1-endY) * Size.Y);
    newBox.ValueBox.Start.X := Start.X + sDelX;
    newBox.ValueBox.Start.Y := Start.Y + sDelY;
    newBox.ValueBox.Size.X := Size.X - (sDelX + eDelX);
    newBox.ValueBox.Size.Y := Size.Y - (sDelY + eDelY);
  end;
end;

procedure FillBox(aBox : box; pattern : word; color : word);
begin
  SetFillStyle(pattern,color);
  with aBox do
  Bar(Start.X +1,Start.Y+ 1,Start.X + Size.X-1,Start.y + Size.y-1);
end;

procedure CenterOfBox(theBox : box; var center : point);
begin
  center.X := theBox.Start.X + (theBox.Size.X div 2);
  center.Y := theBox.Start.Y + (theBox.Size.Y div 2);
end;

procedure DrawBox(theBox : box);
begin
  with theBox do
  begin
    rectangle(Start.X,Start.Y,Start.X+Size.X,Start.Y+Size.Y);
  end;
end;

procedure CenterTextInBox(theBox : box; text : string);
var
center : point;
begin
  CenterOfBox(theBox,center);
  SetTextJustify(CenterText,CenterText);
  OutTextXY(center.X,center.Y+1,text);
end;

procedure WriteTextValue(theBox : labeledBox; value : string);
begin
  FillBox(theBox.ValueBox,SolidFill,ValueColor);
  SetColor(ValueTextColor);
  CenterTextInBox(theBox.ValueBox,value);
end;

procedure ClearValueBox(theBox : labeledBox);
begin
  FillBox(theBox.ValueBox,SolidFill,ValueColor);
end;

procedure WriteTitle(theBox : labeledbox; title : string);
begin
  FillBox(theBox.TitleBox,SolidFill,TitleColor);
  SetColor(TitleTextColor);
  CenterTextInBox(theBox.TitleBox,title);
end;

procedure WriteNumberValue(var theBox : labeledBox; value : longint);
var
textValue : string;
begin
  Str(value,textValue);
  WriteTextValue(theBox,textValue);
end;

procedure MakeLabeledBox(var theBox : labeledBox; theTitle : string);
var
theTextHeight : word;
textInfo : TextSettingsType;
begin
  GetTextSettings(textInfo);
  theTextHeight := textInfo.CharSize * 8;
  with theBox do
  begin
    TitleBox.Start.X := ValueBox.Start.X;
    TitleBox.Start.Y := ValueBox.Start.Y;
    TitleBox.Size.X := ValueBox.Size.X ;
    TitleBox.Size.Y := theTextHeight + 2;
    ValueBox.Start.Y := ValueBox.Start.Y + TitleBox.Size.Y;
    ValueBox.Size.Y := ValueBox.Size.Y - TitleBox.Size.Y;
  end;
  WriteTitle(theBox,theTitle);
  SetColor(BoxColor);
  DrawBox(theBox.TitleBox);
  DrawBox(theBox.ValueBox);
end;

procedure InitColors;
begin
  if GraphDriver <> HercMono then
  begin
    BoxColor := White;
    TitleColor := White;
    ValueTextColor := Yellow;
    ErrorColor := LightRed{LightMagenta};
    ValueColor := Blue;  {Background}
    TitleTextColor := Black;
    ProfileColor := LightGreen;
    DriveColor := LightGray{LightRed};
  end
  else
  begin
    BoxColor := White;
    TitleColor := White;
    ValueTextColor := White;
    ErrorColor := White;
    ValueColor := Black;
    TitleTextColor := Black;
    ProfileColor := White;
    DriveColor := EGALightRed;
  end;
end;

procedure InitMenu;
var
begX,begY,endX,stepY,sizeY : real;
menuIndex : menuIndextype;
begin
  MenuCount :=0;
  for menuIndex := FirstMenuIndex to LastMenuIndex do
  begin
    MenuCount := MenuCount +1;
  end;
  begX := 0;
  endX := 1;
  begY := 0;
  stepY := 1/MenuCount;
  sizeY := stepY *0.9;
  for menuIndex := FirstMenuIndex to LastMenuIndex do
  begin
    BoxInBox(VariablesBox,MenuBoxes[menuIndex],begX,begY,endX,begY+sizeY);
    MakeLabeledBox(MenuBoxes[menuIndex],MenuTitles[menuIndex]);
    begY := begY + stepY;
  end;

end;

procedure Arrow(x : word; y : word; color : word);
begin
  Setcolor(color);
  Line(x-ArrowSize,y,x,y);
  Line(x-ArrowSize div 4 ,y+ArrowSize div 4 ,x,y);
  Line(x-ArrowSize div 4 ,y-ArrowSize div 4 ,x,y);
end;

procedure ArrowAtBox(theBox : labeledbox; color : word);
var
xArrow,yArrow : word;
begin
  with theBox.ValueBox do
  begin
    xArrow := Start.X-1;
    yArrow := Start.Y;
  end;
  Arrow(xArrow,yArrow,color);
end;

procedure MarkBox(theBox : Labeledbox);
begin
  ArrowAtBox(theBox,ValueTextColor);
end;

procedure UnMarkBox(theBox : Labeledbox);
begin
  ArrowAtBox(theBox,ValueColor);
end;

procedure MenuIndexUp;
begin
  UnMarkBox(MenuBoxes[MenuIndex]);
  if MenuIndex > FirstMenuIndex then MenuIndex := Pred(MenuIndex);
  MarkBox(MenuBoxes[MenuIndex]);
end;

procedure MenuIndexDown;
begin
  UnMarkBox(MenuBoxes[MenuIndex]);
  if MenuIndex < LastMenuIndex then MenuIndex := Succ(MenuIndex);
  MarkBox(MenuBoxes[MenuIndex]);
end;

procedure InitScreen;
begin
  with ScreenBox.ValueBox do
  begin
    Start.X :=0;
    Start.Y :=0;
    Size.X :=GetMaxX;
    Size.Y :=GetMaxY;
    ArrowSize := Size.X div 25;
  end;
  BoxInBox(ScreenBox,MainBox,0.01,0.01,0.99,0.99);
  MakeLabeledbox(MainBox,'Motor tuning program');
  WriteTextValue(MainBox,' ');
  BoxInBox(MainBox,VariablesBox,0.05,0.02,0.2,0.98);
  BoxInBox(MainBox,GraphBox,0.22,0.02,0.98,0.90);
  MakeLabeledBox(GraphBox,'Graph Box');
  BoxInBox(MainBox,MessageBox,0.22,0.92,0.98,0.99);
  MakeLabeledBox(MessageBox,'Message Box');
  WriteTextValue(MessageBox,'');
  InitMenu;
  MenuIndex := FirstMenuIndex;
  MenuIndexUp;                                 { forces refresh of arrow }
end;

Function GetPWMRate : real;
begin
  with StepParameters[Axis] do
    begin
      if CardType = ThreeC20 then GetPWMRate := 14400
      else if CardType = EightC20 then GetPWMRate := 0
      else GetPWMRate := (Sysclk/256)*(PreScale/65536);
    end; { with }
end;

function GetSampleRate : real;
begin
  with StepParameters[Axis] do
    begin
      if CardType = ThreeC20 then GetSampleRate := Sysclk/PreScale
      else if CardType = EightC20 then GetSampleRate := Sysclk/PreScale
      else GetSampleRate := (Sysclk/256)*(PreScale/65536)/PostScale;
    end; { with }
end;

procedure BumpEC(var parameter : word; speed : menuspeed;limit : word);
var
newparameter : word;
bump : integer;
begin
  case speed of
    DownFast : bump := -10;
    DownSlow : bump := -1;
    UpFast : bump := 10;
    UpSlow : bump := 1;
    Zero,Max,NoChange : bump := 0;
  end; {case}
  newparameter := parameter +bump;
  if parameter = newparameter then             { if it did't change... }
  begin
    if bump >0 then newparameter := parameter + 1;{ increment by one }
    if (bump < 0)  and (parameter > 0) then newparameter := parameter - 1;{ or decrement by one }
  end;
  if parameter = newparameter then             { if it did't change... }
  if newparameter >limit then newparameter := limit;
  if newparameter <0 then newparameter := 0;
  if speed = Max then newparameter := limit;
  if speed = Zero then newparameter := 0;
  parameter := newparameter;
end;

procedure BumpWordParameter(var parameter : word; speed : menuspeed;limit : word);
var
newparameter : longint;
bump : real;
begin
  case speed of
    DownFast : bump := -0.1;
    DownSlow : bump := -0.01;
    UpFast : bump := 0.1;
    UpSlow : bump := 0.01;
    Zero,Max,NoChange : bump := 0;
  end; {case}
  newparameter := round(parameter * (1 +bump));
  if parameter = newparameter then             { if it did't change... }
  begin
    if bump >0 then newparameter := parameter + 1;{ increment by one }
    if (bump < 0)  and (parameter > 0) then newparameter := parameter - 1;{ or decrement by one }
  end;
  if newparameter >limit then newparameter := limit;
  if newparameter <0 then newparameter := 0;
  if speed = Max then newparameter := limit;
  if speed = Zero then newparameter := 0;
  parameter := newparameter;
end;

procedure BumpIntParameter(var parameter : integer; speed : menuspeed;limit : integer);
var
newparameter : longint;
bump : real;
begin
  case speed of
    DownFast : bump := -0.1;
    DownSlow : bump := -0.01;
    UpFast : bump := 0.1;
    UpSlow : bump := 0.01;
    Zero,Max,NoChange : bump := 0;
  end; {case}
  if parameter > 0 then newparameter := round(parameter * (1 +bump));
  if parameter <= 0 then newparameter := round(parameter * (1 -bump));
  if parameter = newparameter then             { if it did't change... }
  begin
    if bump >0 then newparameter := parameter + 1;{ increment by one }
    if (bump < 0)  and (parameter > -32767) then newparameter := parameter - 1;{ or decrement by one }
  end;
  if newparameter >limit then newparameter := limit;
  if newparameter < -32767 then newparameter := -32767;
  if speed = Max then newparameter := limit;
  if speed = Zero then newparameter := 0;
  parameter := newparameter;
end;

procedure BumpLongintParameter(var parameter : longint; speed : menuspeed; limit:longint);
var
newparameter : longint;
bump : real;
begin
  case speed of
    DownFast : bump := -0.1;
    DownSlow : bump := -0.01;
    UpFast : bump := 0.1;
    UpSlow : bump := 0.01;
    Zero,Max,NoChange : bump := 0;
  end; {case}
  newparameter := round(parameter * (1 +bump));
  if parameter = newparameter then             { if it did't change... }
  begin
    if bump >0 then newparameter := newparameter + 1;{ increment by one }
    if (bump < 0)  and (newparameter > 0) then newparameter := newparameter - 1;{ or decrement by one }
  end;
  if newparameter >limit then newparameter := limit;
  if newparameter <0 then newparameter := 0;
  if speed = Max then newparameter := limit;
  if speed = Zero then newparameter := 0;
  parameter := newparameter;
end;

procedure DisplayTimeDiv;
var
nString : string;
begin
  Str(Times[TimeDivIndex],nString);
  WriteTextValue(MenuBoxes[TIM],nString + ' MS');
end;

function MotorStatusStr : string;
var
tstr : string;
begin
  if ReadParamWord(Axis,ProfileLoc) <> 0 then tstr := 'PRO' else tstr := '   ';
  if ReadParamWord(Axis,PIDLoc) <> 0 then tstr := tstr + ' PID';
  MotorStatusStr := tstr;
end;

procedure TogglePID;
begin
  if ReadParamWord(Axis,PIDLoc) <> 0 then PIDOff(Axis) else PIDOn(Axis);
end;

procedure ToggleProfile;
begin
  if ReadParamWord(Axis,ProfileLoc) <> 0 then ProfileOff(Axis) else ProfileOn(Axis);
end;

procedure RefreshDisplayNumbers;
var prestr,poststr,axisstr: string;
begin
  with StepParameters[Axis] do
  begin
    WriteNumberValue(MenuBoxes[KPI],KP);
    WriteNumberValue(MenuBoxes[KDI],KD);
    WriteNumberValue(MenuBoxes[KDFILI],KDFIL);
    WriteNumberValue(MenuBoxes[KII],KI);
    WriteNumberValue(MenuBoxes[ILI],KIL);
    WriteNumberValue(MenuBoxes[IKF1],KF1);
    WriteNumberValue(MenuBoxes[IKF2],KF2);
    WriteNumberValue(MenuBoxes[IKFF],KFF);
    WriteNumberValue(MenuBoxes[IKK],KK);
    WriteNumberValue(MenuBoxes[IEC],EC);
    str(PreScale,prestr);
    str(PostScale,poststr);
    WriteTextValue(MenuBoxes[SII],prestr+'/'+poststr);
    WriteNumberValue(MenuBoxes[STP],StepSize);
    WriteNumberValue(MenuBoxes[VEL],Velocity);
    WriteNumberValue(MenuBoxes[ACC],Acceleration);
    str(Axis,axisstr);
    WriteTextValue(MenuBoxes[MTR],axisstr+' '+MotorStatusStr);

{    WriteNumberValue(MenuBoxes[MTR],Axis);}
    TimeDivIndex := TDiv;
    DisplayTimeDiv;
    SPSValid := false;
  end;
end;

procedure BumpFilterParameters(bump : menuspeed);
var
ecstr,kdfstr,dampstr : string;
kdf : real;
begin
  with StepParameters[Axis] do
  begin
    case MenuIndex of
      KPI :
      begin
        BumpWordParameter(KP,bump,$FFFF);
        LoadKP(Axis,KP);
        WriteNumberValue(MenuBoxes[MenuIndex],KP);
      end;
      KDI :
      begin
        BumpWordParameter(KD,bump,$FFFF);
        LoadKD(Axis,KD);
        WriteNumberValue(MenuBoxes[MenuIndex],KD);
        kdf :=1/(1-(KDFIL/(65536)));
        str(kdf:5:2,kdfstr);
        str(kdf*KD:5:2,dampstr);
        WriteTextValue(MessageBox,'KDF: '+kdfstr+' Damping: '+dampstr);
      end;
      KDFILI :
      begin
        BumpWordParameter(KDFIL,bump,65535);
        LoadKDFIL(Axis,KDFIL);
        WriteNumberValue(MenuBoxes[MenuIndex],KDFIL);
        kdf :=1/(1-(KDFIL/(65536)));
        str(kdf:5:2,kdfstr);
        str(kdf*KD:5:2,dampstr);
      end;
      KII :
      begin
        BumpLongIntParameter(KI,bump,$6FFFFFFF);
        LoadKI(Axis,KI);
        WriteNumberValue(MenuBoxes[MenuIndex],KI);
      end;
      ILI :
      begin
        BumpWordParameter(KIL,bump,$7FFF);
        LoadKIL(Axis,KIL);
        WriteNumberValue(MenuBoxes[MenuIndex],KIL);
      end;
      IKF1 :
      begin
        BumpWordParameter(KF1,bump,$FFFF);
        LoadKF1(Axis,KF1);
        WriteNumberValue(MenuBoxes[MenuIndex],KF1);
      end;
      IKF2 :
      begin
        BumpWordParameter(KF2,bump,$FFFF);
        LoadKF2(Axis,KF2);
        WriteNumberValue(MenuBoxes[MenuIndex],KF2);
      end;
      IKFF :
      begin
        BumpWordParameter(KFF,bump,$7FFF);
        LoadKFF(Axis,KFF);
        WriteNumberValue(MenuBoxes[MenuIndex],KFF);
      end;
      IKK :
      begin
        BumpIntParameter(KK,bump,$7FFF);
        LoadKK(Axis,KK);
        WriteNumberValue(MenuBoxes[MenuIndex],KK);
      end;
      IEC :
      begin
        BumpEC(EC,bump,$FFFF);
        WriteNumberValue(MenuBoxes[MenuIndex],EC);
        str(EC*4,ecstr);
        WriteTextValue(MessageBox,'Encoder counts per revolution ' +ecstr);
      end;
    end; {case}
  end; {with}
end;

procedure BumpPre(bump : menuspeed);
var
anumber : word;
poststr,prestr,pwmstr,sampstr : string;
begin
  with StepParameters[Axis] do
  begin
    anumber := PreScale;
    case bump of
      DownSlow : if anumber >100 then anumber := anumber -100;
      UpSlow : if anumber < 64535 then anumber := anumber +100;
    end;{case}
    PreScale := anumber;
    LoadPreScale(PreScale);
    str(PreScale,prestr);
    str(PostScale,postStr);
    WriteTextValue(MenuBoxes[SII],prestr+'/'+poststr);
(*    str((Sysclk/256)*(PreScale/65536):6:2,pwmstr);
    str((Sysclk/256)*(PreScale/65536)/PostScale:5:2,sampstr); *)
    str(GetPWMRate:6:2,pwmstr);
    str(GetSampleRate:5:2,sampstr);
    WriteTextValue(MessageBox,'PWM rate: '+pwmstr+' Sample rate: '+sampstr);
  end; {with}
end;

procedure BumpPost(bump : menuspeed);
var
anumber : word;
prestr,poststr,pwmstr,sampstr : string;
begin
  with StepParameters[Axis] do
  begin
    anumber := PostScale;
    case bump of
      DownFast : if anumber >1 then anumber := anumber -1;
      UpFast : if anumber <32 then anumber := anumber +1;
    end;{case}
    LoadPostScale(anumber);
    PostScale := anumber;
    if CardType = ThreeC20 then PostScale := 1;
    if CardType = EightC20 then PostScale := 1;
    str(PreScale,prestr);
    str(PostScale,poststr);
    WriteTextValue(MenuBoxes[SII],prestr+'/'+poststr);
  (*  str((Sysclk/256)*(PreScale/65536):6:2,pwmstr);
    str((Sysclk/256)*(PreScale/65536)/PostScale:5:2,sampstr); *)
    str(GetPWMRate:6:2,pwmstr);
    str(GetSampleRate:5:2,sampstr);
    WriteTextValue(MessageBox,'PWM rate: '+pwmstr+' Sample rate: '+sampstr);
  end; {with}
end;

procedure BumpStep(bump : menuspeed);
begin
  with StepParameters[Axis] do
  begin
    case bump of
      DownSlow,DownFast :
      begin
        case StepSize of
           100 : StepSize := -100;
          -100 : StepSize := -200;
          -200 : StepSize := -500;
          -500 : StepSize := -1000;
          -1000 : StepSize := -2000;
          -2000 : StepSize := -5000;
          -5000 : Stepsize := -10000;
          -10000 : Stepsize := -20000;
          200 : StepSize := 100;
          500 : StepSize := 200;
          1000 : StepSize := 500;
          2000 : StepSize := 1000;
          5000 : StepSize := 2000;
          10000 : StepSize := 5000;
          20000 : Stepsize := 10000;
        end;{case StepSize}
      end;{down}
      UpSlow,UpFast :
      begin
        case StepSize of
          -100 : StepSize := 100;
          -200 : StepSize := -100;
          -500 : StepSize := -200;
          -1000 : StepSize := -500;
          -2000 : StepSize := -1000;
          -5000 : Stepsize := -2000;
          -10000 : Stepsize := -5000;
          -20000 : Stepsize := -10000;
          100 : StepSize := 200;
          200 : StepSize := 500;
          500 : StepSize := 1000;
          1000 : StepSize := 2000;
          2000 : StepSize := 5000;
          5000 : StepSize := 10000;
          10000 : StepSize := 20000;
        end;{case StepSize}
      end;{up}
    end;{case bump}
    WriteNumberValue(MenuBoxes[STP],StepSize);
  end;{with}
end;

procedure BumpVel(bump : menuspeed);
var
countstr,rpmstr,cpsampstr : string;
rate,cps,cpsamp,rps,rpm : real;
begin
  with StepParameters[Axis] do
  begin
    BumpLongintParameter(Velocity,bump,$6FFFFFFF);
    LoadVelocity(Axis,Velocity);
    rate :=(Sysclk/256)*(PreScale/65536)/PostScale;
    cps := rate*(Velocity/$00FFFFFF);
    cpsamp := cps/rate;
    rps := cps/(EC*4);
    rpm := rps*60;
    str(rpm:4:4,rpmstr);
    str(cps:6:0,countstr);
    str(cpsamp:2:4,cpsampstr);

    WriteTextValue(MessageBox,'C/Sec = '+countstr+' C/Samp = '+cpsampstr+' RPM = '+rpmstr);

    WriteNumberValue(MenuBoxes[VEL],Velocity);
  end;
end;

procedure BumpAcc(bump : menuspeed);
var
rpmstr : string;
rate,cps2,rps2,rpm2 : real;
begin
  with StepParameters[Axis] do
  begin
    BumpLongintParameter(Acceleration,bump,$6FFFFFFF);
    LoadAcceleration(Axis,Acceleration);
    WriteNumberValue(MenuBoxes[ACC],Acceleration);
    rate :=(Sysclk/256)*(PreScale/65536)/PostScale;
    cps2 := rate*rate*(Acceleration/$01000000);
    rps2 := cps2/(EC*4);
    rpm2 := rps2*60;
    str(rpm2:4:4,rpmstr);
    WriteTextValue(MessageBox,'RPM/S = '+rpmstr);
  end;
end;

procedure DeSelectMotor(motor : word );
begin
{  TurnOffMotor(Axis); }
end;

procedure SelectMotor(motor : word );
begin
{$IFDEF THREEC20}
   SerListen(motor);
{$ELSE}
  {TurnOnMotor(Axis);}
  LEDs(motor,EncPLoc); { let LEDS monitor the primary encoder}
{$ENDIF}
end;

procedure BumpMtr(bump : menuspeed);
var
newMotor : word;
begin
  newMotor := Axis;
  case bump of
    DownFast : if Axis >0 then newMotor := Axis -1;
    UpFast : if Axis <(Naxis-1) then newMotor := Axis +1;
    DownSlow : TogglePID;
    UpSlow : ToggleProfile;
  end;{case}
  If newMotor <> Axis then
  begin
    DeSelectMotor(Axis);
    SelectMotor(NewMotor);
    Axis := newMotor;
    with StepParameters[Axis] do
    begin
      LoadPreScale(PreScale);
      LoadPostScale(PostScale);
    end;
  end;
  RefreshDisplayNumbers;
end;

procedure UpTimeIndex;
begin
 if TimeDivIndex < 8 then TimeDivIndex := TimeDivIndex + 1;
end;

procedure DownTimeIndex;
begin
  if TimeDivIndex > 1 then TimeDivIndex := TimeDivIndex -1;
end;

procedure BumpTime(bump : menuspeed);
begin
  case bump of
    DownFast,DownSlow : DownTimeIndex;
    UpFast,UpSlow : UpTimeIndex;
  end;{case}
  StepParameters[Axis].TDiv := TimeDivIndex;
  DisplayTimeDiv;
  SPSValid := false;
end;

procedure BumpOtherParameters(bump : menuspeed);
begin
  case MenuIndex of
    SII :
        case bump of
          UpFast,DownFast : BumpPost(bump);
          UpSlow,DownSlow : BumpPre(bump);
          NoChange :
          begin
            BumpPost(bump);
            BumpPre(bump);
          end;
        end;
    STP :  BumpStep(bump);
    VEL :  BumpVel(bump);
    ACC :  BumpAcc(bump);
    MTR :  BumpMtr(bump);
    TIM :  BumpTime(bump);
  end; {case}
end;

procedure BumpMenuItem(bump : menuspeed);
begin
  case MenuIndex of
    KPI..IEC : BumpFilterParameters(bump);
    SII..TIM : BumpOtherParameters(bump);
  end; {case}
end;

procedure InitFilterParameters(Axis: byte);
var psreal : real;
begin
  with StepParameters[axis] do
  begin
    KP := 5;                                 { relatively low gain }
    KI := 0;                                   { integrated error }
    KD := 0;                                  { some value for damping }
    KDFIL := 0;
    KIL := 0;                                  { low integration limit for now }
    KF1 := 0;
    KF2 := 0;
    KFF := 0;
    KK := 0;
    EC := EncoderLines;
    if CardType = ThreeC20 then
    begin
      PWMRate := 144; { * 100}
      psreal :=(SysClk/4000);
      PostScale := 1;
    end
     else
       if CardType = EightC20 then
       begin
         psreal :=(SysClk/10000);
        PostScale := 1;
       end
       else
     begin
       PWMRate := 200;
       psreal := PWMRate*65536;
       psreal := 256.0*psreal/(SysClk/100);
       PostScale := 5;
     end;
    PreScale := word(round(psreal));
    TDiv := 4; {for 10 ms/div};
    { now that we have loaded the record, update the hardware }
    LoadKP(axis,KP);
    LoadKI(axis,KI);
    LoadKD(axis,KD);
    LoadKDFIL(axis,KDFIL);
    LoadKIL(axis,KIL);
    LoadKF1(axis,KF1);
    LoadKF2(axis,KF2);
    LoadKFF(axis,KFF);
    LoadKK(axis,KK);
    LoadPreScale(PreScale);
    LoadPostScale(PostScale);
    LoadDirectionFlag(axis,TrueF);
    LoadPosErrForStop(Axis,30000);
    StepSize := 1000;
    Velocity :=     80000000;                    { infinitely quick! }
    Acceleration := 80000000;                    { almost infinitely quick! }
    LoadAcceleration(Axis,Acceleration);
    LoadVelocity(Axis,Velocity);
    TurnOnMotor(Axis);
  end; {with}
end;

procedure RefreshHardWare(index : byte);
begin
  with StepParameters[index] do
  begin
    LoadKP(index,KP);
    LoadKI(index,KI);
    LoadKD(index,KD);
    LoadKDFIL(index,KDFIL);
    LoadKIL(index,KIL);
    LoadKF1(index,KF1);
    LoadKF2(index,KF2);
    LoadKFF(index,KFF);
    LoadKK(index,KK);
    LoadKT(index,EC);
    LoadAcceleration(index,Acceleration);
    LoadVelocity(index,Velocity);
    if index = 0 then
    begin
      LoadPreScale(PreScale);
      LoadPostScale(PostScale);
    end;
  end; {with}
end;

{$F+}
function InitGraphics : boolean;
var
{$IFDEF WINDOWS}
GraphMode : smallint;
{$ELSE}
GraphMode : integer;
{$ENDIF}
ErrorCode : integer;
begin
  GraphDriver := Detect;
  InitGraph(GraphDriver,GraphMode,'');
  ErrorCode := GraphResult;
  if ErrorCode = GrOk then  InitGraphics := true else InitGraphics := false;
end;

function DetectVGA256 : integer;
{ Detects VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if DetectedDriver = VGA then
  begin
(*    Writeln('Which video mode would you like to use?');
    Writeln('  2) 640x480x256');
 {   Writeln('  3) 800x600x256'); BROKEN? }
    Writeln('  4) 1024x768x256');
    Writeln('  6) 1280x1024x256');
    Write('> ');
    Readln(SuggestedMode);
    DetectVGA256 := SuggestedMode; *)
    DetectVGA256 := 2; { hardwired }
  end
  else
    DetectVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }

function InitVGA256Graphics : boolean;
var
  AutoDetectPointer : pointer;

{$IFDEF WINDOWS}
GraphMode : smallint;
{$ELSE}
GraphMode : integer;
{$ENDIF}
ErrorCode : integer;
begin
{$IFNDEF WINDOWS}
  AutoDetectPointer := @DetectVGA256;
  GraphDriver := InstallUserDriver('Svga256',AutoDetectPointer);
{$ENDIF}
  GraphDriver := Detect;
  InitGraph(GraphDriver,GraphMode,'');
  ErrorCode := GraphResult;
  if ErrorCode = GrOk then  InitVGA256Graphics := true else InitVGA256Graphics := false;
end;
{$F-}

procedure ShowGrid;
var
index: word;
step : real;
istep : word;
begin
  Setcolor(TitleColor);
  SetLineStyle(UserBitLn,$8888,NormWidth);
  with GraphBox.ValueBox do
  begin
    SetViewPort(Start.X,Start.Y,Start.X+Size.X,Start.Y+Size.Y,ClipOn);
    for index := 1 to HDivsPerScreen -1 do
    begin
        step := Size.X/HDivsPerScreen * index;
        istep := trunc(step + 0.5);
        Line(istep,1,istep,Size.Y-1);
    end;
    for index := 1 to VDivsPerScreen -1 do
    begin
        step := Size.Y/VDivsPerScreen * index;
        istep := trunc(step + 0.5);
        Line(1,istep,Size.X-1,istep);
    end;
  end;
  SetLineStyle(SolidLn,0,NormWidth);
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipOn);
end;

procedure ClearGraph;
begin
  ClearValueBox(GraphBox);
  ShowGrid;
end;

procedure DisplayGraph;
var
index : word;
sindex : word;
scaledData : real;
scaleFactor : real;
escalefactor : real;
drScaleFactor : real;
xscalefactor : real;
offset : real;
droffset : real;
fixedDrive : integer;
begin
  with GraphBox.ValueBox, StepParameters[Axis] do
  begin
  scaleFactor := (Size.Y / StepSize) *0.80;
  escaleFactor := ((Size.Y) / (VDivsPerScreen *10));
  drScaleFactor := (Size.Y / 65536) *0.80;
  offset := (Size.Y / 10);
  droffset := (Size.Y / 2);
    xscalefactor := (SamplesPerScreen/(Size.X));
    SetViewPort(Start.X+1,Start.Y+1,Start.X+Size.X-1,Start.Y+Size.Y-1,ClipOn);
    for index := 1 to Size.X -1 do
    begin
      sindex := 1 + trunc(index*xscalefactor);
      scaledData := ResponseTable[sindex] * ScaleFactor;
      scaledData := (Size.Y - round(offset) - scaledData);
      PutPixel(index,round(scaledData),ValueTextColor);
      scaledData := (ProfileTable[sindex] - ResponseTable[sindex]) * escaleFactor;
      scaledData := (Size.Y - round(droffset) - scaledData);
      PutPixel(index,round(scaledData),ErrorColor);
      scaledData := ProfileTable[sindex] * ScaleFactor;
      scaledData := (Size.Y - round(offset) - scaledData);
      PutPixel(index,round(scaledData),ProfileColor);
      FixedDrive := DriveTable[sindex];
      scaledData := fixedDrive * drScaleFactor;
      scaledData := (Size.Y - round(droffset) - scaledData);
      PutPixel(index,round(scaledData),DriveColor);
    end;
  end;
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipOn);
end;

{$IFDEF COPROC}
procedure StartRateGen(rate : real);
var
samplerate,phaser : real;
phasec : comp;
phasek : longint;
begin
  { setup the phase accumulator to generate the desired DAQ rate }
  with StepParameters[Axis] do
  begin
   samplerate := GetSampleRate;
  end;
  phaser := (rate * TwoToThe32/samplerate)+0.5; { cannot round real }
  phasec := phaser;
  phasek := DoubleLongRec(phasec).Long0;
  WriteParam(0,GPhaseKLoc,phasek);
end;

{$ELSE}
procedure StartRateGen(rate : real);
var
samplerate,phaser : real;
phasec : comp;
phasek : longint;
begin
  { setup the phase accumulator to generate the desired DAQ rate }
  with StepParameters[Axis] do
  begin
   samplerate := GetSampleRate;
  end;
  phaser := rate * TwoToThe32/samplerate;
  phasek := trunc(phaser);
  WriteParam(0,GPhaseKLoc,phasek);
end;
{$ENDIF}

procedure StartRateGenMax;
begin
  { if we cant sample at the desired rate }
  { setup the phase accumulator to toggle once per sample }
  WriteParam(0,GPhaseKLoc,-1);
end;

procedure DisableAxisEvents(axis : byte);
begin
  WriteParamWord(axis,EventsLoc,0);
end;

procedure EnableAxisEvents(axis : byte;nevents : byte);
begin
  WriteParamWord(axis,EventsLoc,nevents);
end;

procedure StopRateGen;
begin
  WriteParam(0,GPhaseKLoc,0);      { set rate to 0 }
  Writeparam(0,GPhaseALoc,0);      { clear the phase acc}
  WriteParamWord(0,GPhaseFLoc,0);  { clear flag }
end;

procedure SetupDAQEvents(laxis : byte;div1trig: word);
var daqevent : Event;
begin
  with daqevent do
  begin
    DisableAxisEvents(laxis);
    WriteParamWord(laxis,TrigVal,div1trig);        { Setup up our first division trigger value }
    { first install 4 events to acquire realpos,despos, drive}
    { when the DAQ sample flag is set }
    ER_opcode := EventLogical;   { our Data sample flag }
    ER_Src1 := DAQFlag;      { looking for true }
    ER_Src2 := $0000;           { xor = 0000 = true }
    ER_logand := $FFFF;         { any old bit is ok}
    ER_logor := $0000;          { no or }
    ER_dest := NullLoc;         { toss result }
    AxisEvent(laxis,1,daqevent); { install test event for following conditionals}

    ER_opcode := EventLogicalIf or EventNotZero;
    ER_Src1 := EncPLoc;       { Real position}
    ER_Src2 := $0000;         { xor = no }
    ER_logand := $FFFF;       { leave src1 alone}
    ER_logor  := $0000;       { leave src1 alone }
    ER_dest := QFIFOWriteLoc;  { push on QRB FIFO }
    AxisEvent(laxis,2,daqevent); { install encoder store event }

    ER_Src1 := DesPosLoc; { source data for 2nd sample is DesPos}
    AxisEvent(laxis,3,daqevent); { install event to push DesPos }


    ER_Src1 := PWMLoc;           { source data for 3rd sample is Drive }
    AxisEvent(laxis,4,daqevent); { install event to push Drive }

    { Set Go when we have collected one division worth of data  }
    ER_Opcode  := EventAddIf or EventNotZero; { increment samplecnt every time DAQ is set}
    ER_Src1 := SampleCnt;
    ER_Src2 := OneLoc;
    ER_dest := SampleCnt;
    AxisEvent(laxis,5,daqevent);

    ER_Opcode  := EventSub; { Always }
    ER_Src1 := SampleCnt;
    ER_Src2 := TrigVal;
    ER_dest := Nullloc;         { toss result, we only want the flags }
    AxisEvent(laxis,6,daqevent);

    ER_Opcode := EventLogicalIfDel or EventGTEQ;
    ER_Src1   := NullLoc;       { Always }
    ER_Src2   := $0000;         { dont care }
    ER_logand := $0000;         { dont care}
    ER_logor := 5678;
    ER_Dest := GoLoc;
    AxisEvent(laxis,7,daqevent);

    ER_opcode := EventLogical;{ our Data sample flag }
    ER_Src1 := NullLoc;      { source = dont care }
    ER_Src2 := $0000;        { xor = dont care }
    ER_logand := $0000;      { and = 0000}
    ER_logor := $0000;       { or = 0000}
    ER_dest := DAQFlag;   { clear DAQFlag }
    AxisEvent(laxis,8,daqevent); { install test event for following conditionals}
    EnableAxisEvents(laxis,8);
  end;
end;

procedure ShutDown;
var laxis: word;
begin
  StopRateGen;
  for laxis := 0 to Naxis -1 do
  begin
    DisableAxisEvents(laxis);
   { TurnOffMotor(laxis);}
  end;
  if CardType = ThreeC20 then SerListen(255);
 CloseGraph;
 halt(2);
end;

procedure Bail;
begin
 if protocoltype = HEX then CloseSerialPort;
 if protocoltype = LBP then CloseSerialPort;
 CloseGraph;
 halt(2);
end;

procedure Error(err : integer);
begin
   if GraphicsOn then
   begin
     WriteTextValue(MessageBox,errorrecord[err].errstr);
     delay(2000);
   end
   else Writeln(errorrecord[err].errstr);
   bail;
end;

procedure AcquireStepResponseData;
var
index : word;
innerindex : word;
innerloops : word;
rpt: real;
timeperchar,timeperword,timepergroup,serdaqrate,sersamples : real;
samplerate,daqrate,timeperscreen : real;
samplesperdiv : word;
perrstr,nerrstr,dString,rString,ptstr,tostr: string;
savedpolltimeout : longint;
begin
  savedpolltimeout := PollTimeout;
  PollTimeOut := 5*PollTimeout;

  if ReadError(Axis) <> 0 then
  begin
    WriteTextValue(MessageBox,'Excessive Position Error, Re-homing');
    SetHomePos(Axis);
    delay(1000);
  end;
  StopRateGen; { just in case it happens to be on }
  delay(10);
  with StepParameters[Axis] do
  begin
    samplerate := GetSampleRate;
    timeperscreen := Times[TDiv]/1000 * HDivsPerScreen;  { in seconds }
  end;
  if ProtocolType = Bus then
  begin
    daqrate := SamplesPerVariable/timeperscreen;
  end
  else
  begin
    timeperchar := 10 /TheBaudRate*TheBaudRateMul;
    timeperword := timeperchar * 4 {chars per hex word};
    timepergroup := timeperword * ParamsPerSample;
    timepergroup := timepergroup * 1.2; {margin}
    serdaqrate := 1/timepergroup;
    sersamples := serdaqrate * timeperscreen;
    sersamples := sersamples + (ReadQRBFIFOSize div (2 * ParamsPerSample));
    if sersamples >512 then sersamples := 512; { don't overflow sample buffer }
    daqrate := round(sersamples / timeperscreen);
  end;
  LoadProcTimer(0);
  LoadTimeOut(0);
  ClearPosErrs(Axis);
  LoadPosition(Axis,StepParameters[Axis].StepSize);
  if daqrate > samplerate then
  begin
    { if the desired DAQ sample rate is greater than the DMC sample rate   }
    { best we can do is to sample at the DMC sample rate: So calculate the }
    { number of samples per screen accordingly }
    SamplesPerScreen := trunc(samplerate*timeperscreen);
  end
  else
  begin
    SamplesPerScreen := trunc(daqrate*timeperscreen);
  end;
  WriteParamWord(Axis,SampleCnt,0); { clear the sample count before starting }
  samplesperdiv := SamplesPerScreen div HDivsPerScreen;
  ClearQRBFIFO; {just in case we triggered some event whilst messing about }
  SetupDAQEvents(Axis,samplesperdiv);
  WriteTextValue(MessageBox,'Acquiring data');
  if daqrate > samplerate then
  begin
    daqrate := samplerate;
    StartRateGenMax;
    { if we can't sample fast enough, set the rate generator to one }
    { DAQ sample per DMC sample, start the rate generator, and away we go! }
  end
  else StartRateGen(daqrate);
    { start the rate generator at the desired rate and away we go! }
  case Protocoltype of
    Bus:
    begin
      innerloops := ReadQRBFIFOSize div (2*ParamsPerSample);
    end;
    Hex:
    begin
      innerloops := ReadQRBFIFOSize div (2*ParamsPerSample);
      if (innerloops * ParamsPerSample) > 255  then innerloops := 255 div ParamsPerSample; { for readmultiple }
    end;
    LBP:
    begin
      innerloops := ReadQRBFIFOSize div (2*ParamsPerSample);
      innerloops := innerloops div 64;
      innerloops := innerloops * 64;
    end;
  end;
  index := 1;
  while index < (SamplesPerScreen +1) do
  begin
    WaitForQRBFIFOHalfFull;
    case ProtocolType of
      Bus:
      begin
        for innerindex := 0 to innerloops-1 do
        begin
          if index < (SamplesPerScreen +1) then
          begin
            ResponseTable[index] := BusReadQFIFO;
            ProfileTable[index] :=  BusReadQFIFO;
            DriveTable[index] :=  BusReadQFIFO;
            index := index + 1;
          end;
        end;
      end; {bus}
      Hex:
      begin
        SerReadQFIFOMultiple(innerloops*ParamsPerSample,@DataBuffer);
        for innerindex := 0 to innerloops-1 do
        begin
          ResponseTable[index] := DataBuffer[innerindex*ParamsPerSample+0];
          ProfileTable[index] :=  DataBuffer[innerindex*ParamsPerSample+1];
          DriveTable[index] :=  Databuffer[innerindex*ParamsPerSample+2];
          index := index + 1;
        end;
      end; {hex}
      LBP:
      begin
        LBPReadQFIFO64N(ParamsPerSample*(innerloops div 64),@LBPDataBuffer);
        for innerindex := 0 to innerloops-1 do
        begin
          ResponseTable[index] := LBPDataBuffer[innerindex*ParamsPerSample+0];
          ProfileTable[index] :=  LBPDataBuffer[innerindex*ParamsPerSample+1];
          DriveTable[index] :=  LBPDatabuffer[innerindex*ParamsPerSample+2];
          index := index + 1;
        end;
      end; {lbp}
    end; { case}
  end;
  DisableAxisEvents(Axis);
  StopRateGen;
  str(ReadPosError(Axis),perrstr);
  str(integer(ReadNegError(Axis)),nerrstr);
  WriteTextValue(MessageBox,'Stopping..........');
  delay(200);
  Stop(Axis);
  WriteTextValue(MessageBox,'Stopped!');
  str(ReadRealPositionShort(Axis),rString);
  str(ReadDesPositionShort(Axis),dString);
{$IFDEF THREEC20}
  rpt := 1e6*ReadProcTimer/SysClk;
{$ELSE}
  {$IFDEF EIGHTC20}
  rpt := 1e6*ReadProcTimer/SysClk;
  {$ELSE}

  rpt := 1e6*ReadProcTimer*2/SysClk;
  {$ENDIF}
{$ENDIF}

  str(rpt:2:2,ptstr);
  str(ReadTimeOut,tostr);
  ShowGrid;
  DisplayGraph;
  if not SerialCheck then
  begin
    WriteTextValue(MessageBox,' Serial NAK Error');
    delay(4000);
  end;
  LoadPosition(Axis,0);          { return home... }
  WriteTextValue(MessageBox,'Returning home ');
  StartTrajectory(Axis);
  WaitForMoveDone(Axis);
  WriteTextValue(MessageBox,'DP = '+dString+' RP= '+ rString+' PE= '+perrstr+' NE= '+nerrstr+' PT= '+ptstr+' uS, TO= '+tostr);
  SPSValid := true;
  PollTimeout := savedpolltimeout;
  lastaxis := axis;
end;

procedure StepGraph;
begin
  if ProfileOnQ(Axis) then AcquireStepResponseData
  else
  WriteTextValue(MessageBox,'Profile disabled - no motion possible');
end;

procedure ReInitParameters;
begin
  InitFilterParameters(Axis);
  RefreshDisplayNumbers;
end;


procedure ExportSettings;
var index : byte;
begin
  If OpenForWrite(TheAIFile,TheAIFileName) then
  begin
    for index := 0 to Naxis -1 do
    begin
      write(TheAIFile,StepParameters[index]);
    end;
    close(TheAIFile);
    WriteTextValue(MessageBox,'Settings exported successfully');
  end
  else
  begin
    WriteTextValue(MessageBox,'Unable to export settings');
  end;
end;

procedure UnListSettings;
begin
end;

procedure ListSettings;
var index : byte;
begin
  If OpenForWriteChar(TheAlistFile,TheAlistFileName) then
  begin
    for index := 0 to Naxis -1 do
    begin
      writeln;
      writeln(TheAListFile,'************************************************');
      writeln(TheAlistFile,'Axis ',index);
      with StepParameters[index] do
      begin
        writeln(TheAlistFile,'StepSize ',StepSize);
        writeln(TheAlistFile,'Velocity ',Velocity);
        writeln(TheAlistFile,'Acceleration ',Acceleration);
        writeln(TheAlistFile,'KP ',KP);
        writeln(TheAlistFile,'KD ',KD);
        writeln(TheAlistFile,'KDFIL ',KDFIL);
        writeln(TheAlistFile,'KI ',KI);
        writeln(TheAlistFile,'KIL ',KIL);
        writeln(TheAlistFile,'KF1 ',KF1);
        writeln(TheAlistFile,'KF2 ',KF2);
        writeln(TheAlistFile,'KFF ',KFF);
        writeln(TheAlistFile,'KK ',KK);
        writeln(TheAlistFile,'EC ',EC);
        writeln(TheAlistFile,'Prescale ',Prescale);
        writeln(TheAlistFile,'PostScale ',PostScale);
      end;
    end;
    close(TheAListFile);
    WriteTextValue(MessageBox,'Settings printed to '+TheAlistFileName);
  end
  else
  begin
    WriteTextValue(MessageBox,'Unable to list settings');
  end;
end;

procedure WriteTrace;
var
index : word;
tstring : string;
oldprof : integer;
favedrive : real;
avedrive : integer;
avecount : longint;
avevalid : boolean;
const
avetimes = 25;
begin
  oldprof := 0;

  if SPSValid = true then
  begin
    if OpenForWriteChar(TheTraceFile,TheTraceFileName) then
    begin
      avecount := 0;
      favedrive := 0;
      avevalid := false;
      writeln(TheTraceFile,'SAMPLE    PROFILE   DELTA     RESPONSE  ERROR     DRIVE    AVEDRIVE');
      for index  := 1 to SamplesPerScreen do
      begin
        str(index,tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        str(ProfileTable[index],tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        str(ProfileTable[index]-oldprof,tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        oldprof := ProfileTable[index];
        str(ResponseTable[index],tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        str(ResponseTable[index]-ProfileTable[index],tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        str(DriveTable[index],tstring);
        tstring := PadWithSpaces(tstring,10);
        write(TheTraceFile,tstring);
        favedrive := favedrive + DriveTable[index];
        avecount := avecount +1;
        if avecount = avetimes then
        begin
           avecount := 0;
           avevalid := true;
           avedrive := round(favedrive/avetimes);
           favedrive := 0;
        end;
        str(avedrive,tstring);
        if not avevalid then tstring := 'Unknown';
        writeln(TheTraceFile,tstring);
      end;
      WriteTextValue(MessageBox,'Trace file Written');
      Close(TheTraceFile);
    end
    else
    begin
      WriteTextValue(MessageBox,'Unable to write trace file');
    end;
  end
  else
  begin
    WriteTextValue(MessageBox,'Invalid sample data');
  end;

end;

procedure ImportSettings;
var index : byte;
begin

  If OpenForRead(TheAIFile,TheAIFileName) then
  begin
    for index := 0 to Naxis -1 do
    begin
      read(TheAIFile,StepParameters[index]);
    end;
    close(TheAIFile);
    RefreshDisplayNumbers;
    for index := 0 to Naxis -1 do
    begin
      RefreshHardWare(index);
    end;
    WriteTextValue(MessageBox,'Settings imported successfully');
  end
  else
  begin
    WriteTextValue(MessageBox,'Unable to import file!');
  end;
end;

procedure SaveSettings;
begin
  SavedParameters := StepParameters[Axis];
  WriteTextValue(MessageBox,'Saving settings');
end;

procedure RecallSettings;
begin
  StepParameters[Axis] := SavedParameters;
  WriteTextValue(MessageBox,'Recalling saved settings');
  RefreshDisplayNumbers;
  RefreshHardWare(axis);
end;

procedure KeyLoop;
var
keyChar : char;
done : boolean;

begin
  done := false;
  repeat
    KeyChar := ReadKey;
    case KeyChar of
      'R','r'   : RecallSettings;
      'S','s'   : SaveSettings;
      'E','e'   : ExportSettings;
      'I','i'   : ImportSettings;
      'L','l'   : ListSettings;
      'T','t'   : WriteTrace;
      'U','u'   : UnlistSettings;
      'Z','z'   : BumpMenuItem(Zero);
      'M','m'   : BumpMenuItem(Max);
      'Q','q'   : done := true;
      #0 :
      begin
        KeyChar := ReadKey;
        case KeyChar of
          #75  : BumpMenuItem(DownFast);
          #79  : BumpMenuItem(DownSlow);
          #81  : BumpMenuItem(UpSlow);
          #77  : BumpMenuItem(UpFast);
          #82  : StepGraph;
          #83  : ClearGraph;
          #119 : ReInitParameters;
{         #73  : ShowGrid;}
          #72  : begin
                   MenuIndexUp;
                   BumpMenuItem(NoChange);
                 end;
          #80  : begin
                   MenuIndexDown;
                   BumpMenuItem(NoChange);
                 end;
          #45  : done := true;
        end; {function key case}
      end; {any key case}
    end;
  until done = true;
end;

procedure InitializeMot;
var
nString : string;
screentitle,hrev,majrev,minrev,naxstr,clkstr,phasestr,errorstr,cardtypestr: string;
hrevnum,majrevnum,minrevnum,phases: word;
begin
  if ProtocolType = LBP then LBPSetupReadQFIFO64N;
  if not HardwareThere then
  begin
    WriteTextValue(MessageBox,'No Hardware signature... Bail out!');
    delay(5000); { wait for graph init }
    Bail;
  end;
  if CardType = PC104 then cardtypestr := 'PC104 ';
  if CardType = PCI then cardtypestr := 'PCI ';
  if CardType = SevenI60 then cardtypestr := '7I60 ';
  if CardType = EightC20 then cardtypestr := '8C20 ';
  if CardType = SevenI43 then cardtypestr := '7I43 ';
  if CardType = ThreeC20 then cardtypestr := '3C20 ';
  WriteTextValue(MessageBox,cardtypestr + 'Controller reset... proceeding with set-up');
  delay(1000);

  hrevnum := ReadHWVersion;
  if hrevnum < 20 then
  begin
    WriteTextValue(MessageBox,'SOFTDMC HARDWARE REVISION TOO LOW');
    delay(3000);
    Bail;
  end;
  majrevnum := ReadMajorSWVersion;
  minrevnum := ReadMinorSWVersion;
  if majrevnum <> MajorRev then
  begin
    WriteTextValue(MessageBox,'SOFTDMC FIRMWARE REVISION MISMATCH');
    delay(3000);
    Bail;
  end;

  Sysclk := DefaultSysClk;
  phases := ReadMotorType;
  if hrevnum >26 then SysClk := ReadSysClockFreq;
  Str(majrevnum,majrev);
  Str(minrevnum,minrev);
  Str(hrevnum,hrev);
  Str(SysClk,clkstr);
  Str(phases,phasestr);
  screentitle := 'Code Rev. '+ majrev+'.'+minrev+' HW Rev. '+ Hrev+' CLK: '+clkstr+'  '+ phasestr+ ' Phase';

  WriteTitle(MainBox,screentitle);
  delay(1000);

 Naxis := ReadNaxis;  { probe detects number of axis's }
  case ProtocolType of
    Bus: SamplesPerVariable := BusModeSamplesPerVariable;
    Hex:
    begin
      SamplesPerVariable := SerModeSamplesPerVariable;
{$IFDEF THREEC20}
      ExitOnTimeout := false; { dont leave }
      Naxis := 0;
      if SerProbe(0) then
      begin
        Naxis := Naxis +1;
        if SerProbe(1) then
        begin
          Naxis := Naxis +1;
          if SerProbe(2) then
            begin
            Naxis := Naxis +1;
            if SerProbe(3) then
            begin
              Naxis := Naxis +1;
              if SerProbe(4) then
              begin
                Naxis := Naxis +1;
                if SerProbe(5) then
                begin
                  Naxis := Naxis +1;
                  if SerProbe(6) then
                  begin
                    Naxis := Naxis +1;
                   if SerProbe(7) then Naxis := Naxis +1;
                  end;
                end;
              end;
            end;
          end;
        end;
      end;
      SerError := false; { clear probe errors }
      ExitOnTimeout := true;
{$ENDIF}
    end; {endcase}
    LBP: SamplesPerVariable := LBPModeSamplesPerVariable;
  end;
  Str(Naxis,naxstr);
  if (Naxis > 8) or (Naxis < 1) then
  begin
    WriteTextValue(MessageBox,'Ridiculous # of Axis: '+naxstr+' -- Bailout!');
    delay(3000);
    Bail;
  end;
  for Axis := 0 to Naxis-1 do
  begin
    SelectMotor(Axis);
{$IFDEF THREEC20}
    ClearFifos; { do each axis for 3C20 }
{$ENDIF THREEC20}
    ResetMot(Axis);
    InitFilterParameters(Axis);
    SetHomePos(Axis);
    SavedParameters := StepParameters[0];
    Str(Axis,nString);
    if SerError then errorstr := ' Serial Error' else errorstr := '';
    WriteTextValue(MessageBox,'Motor '+nString+' initialized' + errorstr);
    delay(500);
  end;
  screentitle := 'SoftDMC ' +naxstr+' axis tuning program -- Code Rev. '+ majrev+'.'+minrev+' HW Rev. '+ hrev;
  WriteTitle(MainBox,screentitle);
  Axis := 0;                             { start out with motor 0 }
  SelectMotor(Axis);
  ClearGraph; {so our grid will be there}
  SPSValid := false;
end;

{*****************************************************************************}
begin                                          {main}
  GraphicsOn := false;
  GetOurEnv;
  initok := InitializeInterface(message);
  Writeln(message);
  delay(1000);
  if not initok then Bail;
  ClearFifos;
  if not InitVGA256Graphics then
  begin
    writeln('DMCTUNE must be run on a system with graphics capability');
    writeln('BGI driver missing? ');
    Bail;
  end;
  GraphicsOn := true;
  InitColors;
  InitScreen;
  InitializeMOT;
  RefreshDisplayNumbers;
  WriteTextValue(MessageBox,'READY');
  KeyLoop;
  Shutdown;
  writeln('that''s all folks...');
end.

{ used phasef to avoid 3 events }
{ 4-11-07 }
{ used baudratemul to allow higher than 115200 }
{ reset sererr for DSPIC after probe }
{ added cardtype display during controller reset }
{ added stop(axis) after initfilterparams in case motor is moving }
{ added if busintfc = false then CloseSerialPort; for bailouts }
{ added stoprategen and disableaxisevents in shutdown }
{ added check for array overflow for bus }
{ if revisions wrong bail }
{ changed drive to light gray }
{ added cominit }
{ DisableAxisEvents(Axis); StopRateGen; missing in setupdaq 12-1-2009}
{ Reduced error Y limits to avoid drawing over box 12-14-2009 }
{ Acquire extra sample to avoid fencepost when drawing 12-14-2009 }
