;Copyright (C) 2006 MESA Electronics.  All rights reserved.
;bitsd.inc

majorrev	64	%byte	updated when parameters change, hi byte
minorrev	2	%byte	lo byte

truef		65535	%flag	value for flag types
falsef		0	%flag	value for flag types

;profile modes
noprofile	0	%unit	value for profile_uint
trapezoidalmode	1	%uint	value for profile_uint
externalprofile	2	%unit	value for profile_uint

IFF		8000h	Immediate Command/data FIFO full flag
IFH		4000h	Immediate Command/data FIFO half full flag
QFF		2000h	Queued Command/data FIFO full flag
QFH		1000h	Queued Command/data FIFO half full flag
IRE		0800h	Immediate Readback FIFO empty flag
IRH		0400h	Immediate Readback FIFO half full flag
QRE		0200h	Queued Readback FIFO empty flag
QRH		0100h	Queued Readback FIFO half full flag

;parammask	03FFh

;************************* EVENT BLOCK **************************************
;register offsets
eventopcode		0		opcode
eventsource1		1	%ptr	type:pointer to operand
eventsource2		2	%ptr	pointer to second operand
eventxor		2		polarity
eventsource2xor		2		alias for either
eventand		3		mask
eventfree1		3		for arithmetic events
eventor			4		or
eventfree2		3		for arithmetic events
event2directlo		3		space for source2
event2directhi		4		space for source2
eventdest		5	%ptr	destination pointer

eventblocksize		6		size of event block

;low byte
eventresultcarryxor	0001H
eventresultzeroxor	0002H

;hibyte
eventresultcarryand	0100H
eventresultzeroand	0200H

;logical events
eventzero		0200H	zeroand
eventnotzero		0202H	zeroand | zeroxor

;1-2
eventcarry		0100H	carryand 
eventnotcarry		0101H	carryand | carryxor
eventgt			0303H 	carryand | carryxor | zeroand | zeroxor
eventlt			0100H	carryand
eventgteq		0101H	carryand | carryxor
eventlteq		0300H	carryand | zeroand
eventeq			0200H	zeroand			
eventneq		0202H	zeroand  | zeroxor
eventdisable		0000H

;eventopcode0            1000H	see initd.asm
;eventopcode1            2000H
;eventopcode2            4000H

;flags
eventalways		8000H	always event (not if)
eventedge		0800H	edge event (del)
eventsize0		0004h	32 bit operation
eventsize1		0008h	64 bit operation
eventhistory		0080H	old result stored here

;conditional
EventAddIf		0000H
EventAdd32If		0004H
EventSubIf		1000H
EventSub32If		1004H
EventMul16x16to16If	2000H
EventCopyIf		5000H
EventLogicalIf		6000H

;change events (Del)
EventAddIfDel		0800H
EventAdd32IfDel		0804H
EventSubIfDel		1800H
EventSub32IfDel		1804H
EventMul16x16to16IfDel	2800H
EventCopyIfDel		5800H
EventLogicalIfDel	6800H

;always
EventAdd		8000H
EventAdd32		8004H
EventSub		9000H
EventSub32		9004H
EventMul16x16to16	A000H
EventCopy		D000H
EventLogical		E000H

;************************* QUAD COUNTER CONSTANTS ***************************
;cntcntl register

CCinputabit	01h		read only input a 
CCinputbbit	02h		read only input b 
CCidxbit	04h		read only index input
CCidxpolbit	08h		index polarity
CCclronidxbit	10h		clear counter at index if set
CCclrdflagbit	20h		set if count has been cleared (a 0 write will clear flag)
CCfilterbit	40h		set for filter 

CCcntdirbit	100h		set for reverse count direction
CCcntclroncebit	200h		if set clear once

;status register
samplebit	1		lsb
commandpending	2

;***************************** BLOCK OFFSETS ********************************
;profilesize	18		size of block
;profilestart	56		beginning of motion block

;filtersize	16		size of filter block
;filterstart	40		begining of filter block

;***************************** ERROR BITS ********************************
excessiveposition	1	%err
drivelimit		2	%err
isaturated		4	%err
;***************************** I\O BITS ********************************
in0		0001H	%mask
in1		0002H	%mask
inlimit		8000H	%mask

out0		0001H	%mask
out1		0002H	%mask

;***************************** MOTOR ************************************
onephasemotor		1	%byte	software control type

;***************************** BAUDRATES ********************************
baud110		0	%byte
baud150		1	%byte
baud300		2	%byte
baud600		3	%byte
baud1200	4	%byte
baud2400	5	%byte
baud4800	6	%byte
baud9600	7	%byte
baud19200	8	%byte
baud38400	9	%byte
baud57600	10	%byte
baud115200	11	%byte
baud230400	12	%byte
baud460800	13	%byte
baud921600	14	%byte
baud1843200	15	%byte
