;Copyright (C) 2007 MESA Electronics.  All rights reserved.
;bits5.inc

;for rev 30 or greater hardware

majorrev	4	%byte	updated when parameters change, hi byte
minorrev	106	%byte	lo byte

truef		65535	%flag	value for flag types
falsef		0	%flag	value for flag types

;profile modes
noprofile	0	%uint	value for profile_uint
trapezoidalmode	1	%uint	value for profile_uint
externalprofile	2	%uint	value for profile_uint

fiforead	0	%offset
fiforeadcount	1	%offset
fifoparamcount	2	%offset
fifoaxis	3	%offset
fifowrite	4	%offset
fifowritecount	5	%offset

;External constants
ICDFIFO		0	offset from hardware base address
QCDFIFO		4
STATUSA		8
STATUSB		12

IFF		8000h	Immediate Command/data FIFO full flag
IFH		4000h	Immediate Command/data FIFO half full flag
QFF		2000h	Queued Command/data FIFO full flag
QFH		1000h	Queued Command/data FIFO half full flag
IRE		0800h	Immediate Readback FIFO empty flag
IRH		0400h	Immediate Readback FIFO half full flag
QRE		0200h	Queued Readback FIFO empty flag
QRH		0100h	Queued Readback FIFO half full flag

parammask	03FFh

;************************* EVENT BLOCK **************************************
;register offsets
eventopcode		0		opcode
eventsource1		1	%ptr	type:pointer to operand
eventsource2		2	%ptr	pointer to second operand
eventxor		2		polarity
eventsource2xor		2		alias for either
eventand		3		mask
eventfree1		3		for arithmetic events
eventor			4		or
eventfree2		3		for arithmetic events
event2directlo		3		space for source2
event2directhi		4		space for source2
eventdest		5	%ptr	destination pointer

eventblocksize		6		size of event block

;low byte
eventresultcarryxor	0001H
eventresultzeroxor	0002H

;hibyte
eventresultcarryand	0100H
eventresultzeroand	0200H

;logical events
eventzero		0200H	zeroand
eventnotzero		0202H	zeroand | zeroxor

;1-2
eventcarry		0100H	carryand 
eventnotcarry		0101H	carryand | carryxor
eventgt			0303H 	carryand | carryxor | zeroand | zeroxor
eventlt			0100H	carryand
eventgteq		0101H	carryand | carryxor
eventlteq		0300H	carryand | zeroand
eventeq			0200H	zeroand			
eventneq		0202H	zeroand  | zeroxor
eventdisable		0000H

;eventopcode0            1000H	see init4.asm
;eventopcode1            2000H
;eventopcode2            4000H

;flags
eventalways		8000H	always event (not if)
eventedge		0800H	edge event (del)
eventsize0		0004h	32 bit operation
eventsize1		0008h	64 bit operation
eventhistory		0080H	old result stored here

;conditional
EventAddIf		0000H
EventAdd32If		0004H
EventSubIf		1000H
EventSub32If		1004H
EventMul16x16to16If	2000H
EventMul32x32LoIf	2004H
EventMul32x32HiIf	2008H
EventMul32x32to64If	200CH
EventDivIf		3000H
EventSqRootIf		4000H
EventCopyIf		5000H
EventLogicalIf		6000H

;change events (Del)
EventAddIfDel		0800H
EventAdd32IfDel		0804H
EventSubIfDel		1800H
EventSub32IfDel		1804H
EventMul16x16to16IfDel	2800H
EventMul32x32LoIfDel	2804H
EventMul32x32HiIfDel	2808H
EventMul32x32to64IfDel	280CH
EventDivIfDel		3800H
EventSqRootIfDel	4800H
EventCopyIfDel		5800H
EventLogicalIfDel	6800H

;always
EventAdd		8000H
EventAdd32		8004H
EventSub		9000H
EventSub32		9004H
EventMul16x16to16	A000H
EventMul32x32Lo		A004H
EventMul32x32Hi		A008H
EventMul32x32to64	A00CH
EventDiv		B000H
EventSqRoot		C000H
EventCopy		D000H
EventLogical		E000H

;************************* QUAD COUNTER CONSTANTS ***************************
;cntcntl register

CCinputabit	01h		read only input a 
CCinputbbit	02h		read only input b 
CCidxbit	04h		read index
CCclrbit	04h		set to clear counter doesn't stick
CCidxpolbit	08h		index polarity
CCclronidxbit	10h		clear counter at index if set
CCclrdflagbit	20h		set if count has been cleared (a 0 write will clear flag)
CCfilterbit	40h		set for filter 
CCudmodebit	80h		set for U/D (1X) mode clear for quad (4X) mode
CCcntdirbit	100h		set for reverse count direction
CCcntclroncebit	200h		if set clear once

;status register
samplebit	1		lsb
commandpending	2

;irqreg register
whichirq	00h		four least sig bits
irqdrvena	10h		true to enable driver
imask		40h		true to drive
irqstatus	80h		true for irq

;***************************** BLOCK OFFSETS ********************************
profilesize	18		size of block

;offsets from profilestart
;desposf_offsetdouble	0
;despos_offsetlong	2
;velocity_offsetlong	4
;accelf_offsetint	6
;accel_offsetlong	7
;jerk_offsetlong		9
;breakpoint_offsetlong	11
;nextproblockoffsetptr	13
;nextpos_offsetlong	14
;slewlimit_offsetlong	16

filtersize	16		size of filter block
;offsets from filterstart
kk_offset		0
kff_offset		1
kp_offset		2
kd_offset		3
ka_offset		4
ki_offsetulong		5
kih_offset		6
kil_offset		7
kf0_offset		8
kf1_offset		9
kf2_offset		10
kf3_offset		11
kdfil_offset		12
driveplus_offset	13
driveminus_offset	14
nextfilblock_offset	15

;***************************** ERROR BITS ********************************
excessiveposition	1	%err
drivelimit		2	%err

;***************************** MOTOR ************************************

onephasemotor		1	%byte	software control type
twophasemotor		2	%byte	software control type
threephasemotor		3	%byte	software control type

sinetablesize		1024		sine lookup table size

;***************************** 4I34 HOST ************************************
immediate	200h	%ptr
queued		208h	%ptr
