{for fifo'ed 7I60 and 3C20}

type
buffer = array[1..FlashBlockSize] of byte; { is this needed ? }
bufptr = ^buffer;
DataBuffertype = array[0..255] of word;
DataBuffPtr = ^DataBuffertype;

var
DataBuffer : DataBuffertype;

function SerialInit : boolean;
begin
  {Writeln('Attempt to open serial port: ',TheComPort); }
  ser:=TBlockserial.Create;
  {ser.RaiseExcept:=True;}
  ser.Connect(TheComPort);
  ser.Config(TheBaudrate,8,'N',0,false,false);
  if ser.LastError = 0 then SerialInit := true else SerialInit := false;
end;

procedure SerMesaStart;
var
sstring : string;
begin
  ser.RTS := true;
  sstring := CR {sync} + SerMesaStartCom + CR;
  ser.SendString(sstring);
end;

procedure SerMesaStop;
var
sstring : string;
begin
  ser.RTS := true;
  sstring := SerMesaStopCom + CR;
  ser.SendString(sstring);
end;

procedure SerListen(addr : byte);
var
sstring : string;
begin
  sstring := SerListenCom + HexString(addr,2) + CR;
  ser.SendString(sstring);
end;

function InquireID : string;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerInquireIDCom +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  InquireID := sstring;
end;

function SerProbe(addr : byte) : boolean;
var
tout : longint;
sstring : string;
begin
  tout := CharTimeOut; { save CharTimeOut }
  CharTimeOut := 3;
  SerProbe := false;
  SerListen(addr);
  sstring := InquireID;
  CharTimeOut := tout;
  if sstring = '3C20' then SerProbe := true else SerError := false;
end;

procedure CloseSerialPort;
begin
{$IFDEF DSPIC}
  SerMesaStop;
{$ENDIF}
  ser.free;
end;


procedure SerWriteDirectWord(address:byte; data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWritedirectWordCom+HexString(address,2)+HexString(data,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteDirectByte(address:byte; data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWritedirectByteCom+HexString(address,2)+HexString(data,2)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;


procedure WriteGroup( group : byte;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteGroupCom+ HexString(group,4)+CR;
  ser.SendString(sstring);
  for index := 1 to GroupSize do ser.SendString(HexString(ourbuffer^[index],2));
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function SerReadIFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadIFIFOCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadIFIFO := data;
end;

procedure SerReadQFIFOMultiple(n : word; bufptr : DataBuffPtr);
var
data : word;
index : byte;
sstring : string;
retchar : char;
begin
  sstring := SerReadQFIFOMultipleCom + HexString(n,2) + CR;
  ser.SendString(sstring);
  for index := 0 to n-1 do
  begin
    HexWordRead(ser.RecvbufferStr(4,CharTimeOut),data);
    bufptr^[index] := data;
  end;
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
end;

function SerReadQFIFO : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReadQFIFOCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadQFIFO := data;
end;

function SerReadDirectWord(address: byte) : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerReaddirectWordCom + HexString(address,2) +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadDirectWord := data;
end;

function SerReadDirectByte(address: byte) : byte;
var
data : byte;
sstring : string;
retchar : char;
begin
  sstring := SerReaddirectByteCom + HexString(address,2) +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(2,CharTimeOut);  { get 2 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexByteRead(sstring,data);
  SerReadDirectByte := data;
end;


function SerReadParamWord(command:word) : word;
var
data : word;
sstring : string;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  sstring := SerReadIFIFOCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadParamWord := data;
end;

function SerReadParam(command:word) : longint;
var
sstring : string;
rlstring : string;
rhstring : string;
ldata : longint;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerReadIFIFOCom + CR;
  ser.SendString(sstring);
  rlstring := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  rhstring := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexLongRead(rhstring+rlstring,ldata);
  SerReadParam := ldata;
end;

function SerReadParamDouble(command:word) : comp;
var
sstring : string;
r0string,r1string,r2string,r3string : string;
cdata : comp;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerReadIFIFOCom + CR;
  ser.SendString(sstring);
  r0string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r1string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r2string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r3string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexLongRead(r1string+r0string,DoubleLongRec(cdata).Long0);
  HexLongRead(r3string+r2string,DoubleLongRec(cdata).Long1);
  SerReadParamDouble := cdata;
end;

procedure SerWriteParamWord(command:word;data:word);
var
sstring : string;
begin
  sstring := SerWriteIFIFOCom+HexString(command,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom+HexString(data,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteWaitToken(command:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom+HexString(command,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteWaitTokenQ(command:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom+HexString(command,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteParam(command: word;ldata:longint);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4)+ CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(LongIntRec(ldata).LowWord,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(LongIntRec(ldata).HighWord,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteParamDouble(command: word;cdata:comp);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteIFIFOCom + HexString(command,4)+ CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word0,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word1,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word2,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteIFIFOCom + HexString(DoubleIntRec(cdata).Word3,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function SerReadParamWordQ(command:word) : word;
var
data : word;
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  sstring := SerReadQFIFOCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char hex string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  HexWordRead(sstring,data);
  SerReadParamWordQ := data;
end;

function SerReadParamQ(command:word) : longint;
var
sstring : string;
rlstring : string;
rhstring : string;
ldata : longint;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerReadQFIFOCom + CR;
  ser.SendString(sstring);
  rlstring := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  rhstring := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexLongRead(rhstring+rlstring,ldata);
  SerReadParamQ := ldata;
end;

function SerReadParamDoubleQ(command:word) : comp;
var
sstring : string;
r0string,r1string,r2string,r3string : string;
cdata : comp;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerReadQFIFOCom + CR;
  ser.SendString(sstring);
  r0string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r1string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r2string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  ser.SendString(sstring);
  r3string := ser.RecvBufferStr(4,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexLongRead(r0string+r1string,DoubleLongRec(cdata).Long0);
  HexLongRead(r2string+r3string,DoubleLongRec(cdata).Long1);
  SerReadParamDoubleQ := cdata;
end;

procedure SerWriteParamWordQ(command:word;data:word);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom+HexString(command,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom+HexString(data,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteParamQ(command: word;ldata:longint);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4)+ CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(LongIntRec(ldata).LowWord,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(LongIntRec(ldata).HighWord,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerWriteParamDoubleQ(command: word;cdata:comp);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteQFIFOCom + HexString(command,4)+ CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word0,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word1,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word2,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  sstring := SerWriteQFIFOCom + HexString(DoubleIntRec(cdata).Word3,4) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure ReadGroup( group : byte;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadGroupCom+ HexString(group,4)+CR;
  ser.SendString(sstring);
  for index := 1 to GroupSize do
  begin
    HexByteRead(ser.RecvBufferStr(2,CharTimeOut),ourbuffer^[index]);
  end;
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure ClearChecksum;
var
sstring : string;
retchar : char;
begin
  sstring := SerEraseChecksumCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function ReadChecksum : byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerReadChecksumCom + CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(2,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexbyteRead(sstring,data);
  ReadChecksum := data;
end;

procedure SerUnlock;
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteProtectCom+'00'+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerLock;
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteProtectCom+ 'FF'+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerPicGo(address:word);
var
sstring : string;
retchar : char;
begin
  SerUnlock;
  sstring := SerPicGoCom+HexString(address,4)+CR;
  ser.SendString(sstring);
 { if SerReceiveChar(CharTimeOut) <> CR then SerError := true;}
end;

procedure SerClearICDFIFO;
var
sstring : string;
begin
  sstring := SerClearICDFIFOCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerClearQCDFIFO;
var
sstring : string;
begin
  sstring := SerClearQCDFIFOCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerClearIRBFIFO;
var
sstring : string;
begin
  sstring := SerClearIRBFIFOCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure SerClearQRBFIFO;
var
sstring : string;
begin
  sstring := SerClearQRBFIFOCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;


procedure WriteFlashBlock(block : word;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteFlashCom + HexString(block,2)+CR;
  ser.SendString(sstring);
  for index := 1 to FlashBlockSize do
  begin
    ser.SendString(HexString(ourbuffer^[index],2))
  end;
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure WriteNewFlashBlock(block : word; size : word; ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerWriteFlashCom+ HexString(block,4)+CR;
  ser.SendString(sstring);
  for index := 1 to size do
  begin
    ser.SendString(HexString(ourbuffer^[index],2));
  end;
  SerReceiveChar(CharTimeOut);
  if ser.LastError <> 0 then SerError := true;
end;

procedure EraseFlashBlock(block : byte);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerEraseFlashCom+ HexString(block,2)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure ReadFlashBlock(block : word;ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadFlashCom+ HexString(block,2)+CR;
  ser.SendString(sstring);
  for index := 1 to FlashBlockSize do
  begin
    HexByteRead(ser.RecvBufferStr(2,CharTimeOut),ourbuffer^[index]);
  end;
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure ReadNewFlashBlock(block : word; size : word; ourbuffer : bufptr);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerReadFlashCom+ HexString(block,4)+CR;
  ser.SendString(sstring);
  for index := 1 to size do
  begin
    HexByteRead(ser.RecvBufferStr(2,CharTimeOut),ourbuffer^[index]);
  end;
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function InquireRev:byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerInquireRevCom +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(2,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexbyteRead(sstring,data);
  InquireRev := data;
end;

procedure WriteEEPROM(addr: byte;data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteEEPROMCom + HexString(addr,2)+ HexString(data,2) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function ReadEEPROM(add:byte) : byte;
var
sstring : string;
data : byte;
retchar : char;
begin
  sstring := SerReadEEPROMCom +HexString(add,2)+ CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(2,CharTimeOut);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
  HexbyteRead(sstring,data);
  ReadEEPROM := data;
end;

procedure EraseGroup(block : byte);
var
sstring : string;
retchar : char;
index : word;
begin
  sstring := SerEraseGroupCom+ HexString(block,4)+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure WritePLL(data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerWriteOscCom + HexString(data,2) + CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

procedure ConfigureFPGA;
var
sstring : string;
retchar : char;
begin
  sstring := SerConfigCom+CR;
  ser.SendString(sstring);
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true;
end;

function SerReadPPMStatus : string[4];
var
sstring : string;
retchar : char;
begin
  sstring := SerReadStatusCom +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(4,CharTimeOut);  { get 4 char status string }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  SerReadPPMStatus := sstring;
end;

function SerReadPPMAnalogData : string[79];
var
sstring : string;
retchar : char;
begin
  sstring := SerReadAnalogCom +CR;
  ser.SendString(sstring);
  sstring := ser.RecvBufferStr(79,CharTimeOut);  { get 79 character data }
  if SerReceiveChar(CharTimeOut) <> CR then SerError := true; { get CR }
  SerReadPPMAnalogData := sstring;
end;

procedure SelectPPM(data:byte);
var
sstring : string;
retchar : char;
begin
  sstring := SerSelectChanCom+HexString(data,2)+CR;
  ser.SendString(sstring);
end;


procedure TossChars;
var
achar: char;
begin
  repeat
    delay(5);
    if ser.WaitingData <> 0 then
    begin
      achar := SerReceiveChar(CharTimeOut);
    end;
    delay(5);
 until ser.WaitingData = 0;
end;

function SerSync : boolean;
var
retchar : char;
sstring : string;
begin
  SerSync := false;
  ser.RTS := true;
  ser.SendByte(88); { send invalid command or data }
  ser.SendByte(byte(CR));
  SerReceiveChar(CharTimeOut);
  TossChars;
  ser.SendByte(88); { send invalid command or data }
  ser.SendByte(byte(CR));
  retchar := SerReceiveChar(CharTimeOut);
  TossChars;
  if char(retchar) = '?' then
  begin
    sstring := SerInquireRevCom + CR;
    ser.SendString(sstring);
    sstring := ser.RecvBufferStr(2,CharTimeOut);  { get 2 character data }
    if SerReceiveChar(CharTimeOut) = CR then
    begin
      SerSync := true;
      SerError := false;
    end;
  end;
end;


function SerialCheck : boolean;
begin
  SerialCheck := true;
  if SerError then
  begin
    SerialCheck := false;
    SerSync;
  end;
end;
