typedef enum
{
    BYTE,
    PTR,
    FLAG,
    MASK,
    UINT,
    INT,
    ULONG,
    LONG,
    DOUBLE
} ParameterType;

typedef struct
{
    char ParmName[24];
    long ParmLoc;
    ParameterType ParmType;
} SDMCParamRec;

#define LASTPARM 166

SDMCParamRec SDMCParams[LASTPARM] = 
{
    { "null", 0, PTR },
    { "dummy", 0, UINT },
    { "dummyhi", 1, UINT },
    { "go", 2, FLAG },
    { "pid", 3, FLAG },
    { "profile", 4, UINT },
    { "drivemode", 5, FLAG },
    { "dirinv", 6, FLAG },
    { "proctimer", 7, UINT },
    { "stepdir", 8, FLAG },
    { "home", 9, FLAG },
    { "motion", 10, FLAG },
    { "slew", 11, FLAG },
    { "error", 12, UINT },
    { "errormask", 13, MASK },
    { "events", 14, UINT },
    { "maxpwm", 15, UINT },
    { "avgvel", 16, INT },
    { "exposerr", 17, UINT },
    { "maxnegerr", 18, INT },
    { "maxposerr", 19, INT },
    { "driveerror", 20, UINT },
    { "posenc", 21, PTR },
    { "velenc", 22, PTR },
    { "actvel", 23, INT },
    { "bnderr", 24, INT },
    { "extvelocity", 25, PTR },
    { "follow", 26, PTR },
    { "pwm", 27, INT },
    { "homeposp", 28, LONG },
    { "phasek", 30, LONG },
    { "phasea", 32, LONG },
    { "encp", 34, LONG },
    { "desvel", 36, LONG },
    { "timeout", 38, UINT },
    { "sync", 39, FLAG },
    { "kk", 40, INT },
    { "kff", 41, UINT },
    { "kp", 42, UINT },
    { "kd", 43, UINT },
    { "ka", 44, UINT },
    { "ki", 45, ULONG },
    { "kih", 46, UINT },
    { "kil", 47, UINT },
    { "kf0", 48, UINT },
    { "kf1", 49, UINT },
    { "kf2", 50, UINT },
    { "kf3", 51, UINT },
    { "kdfil", 52, UINT },
    { "driveplus", 53, UINT },
    { "driveminus", 54, UINT },
    { "desposd", 56, DOUBLE },
    { "desposf", 56, LONG },
    { "despos", 58, LONG },
    { "velocity", 60, LONG },
    { "accelf", 62, INT },
    { "accel", 63, LONG },
    { "jerk", 65, LONG },
    { "breakpoint", 67, LONG },
    { "nextproblock", 69, PTR },
    { "nextpos", 70, LONG },
    { "slewlimit", 72, LONG },
    { "startpos", 74, LONG },
    { "delta", 76, LONG },
    { "velocityf", 78, INT },
    { "checkpos", 80, LONG },
    { "decelpos", 82, LONG },
    { "fixup", 84, LONG },
    { "preslewvel", 86, LONG },
    { "preslewpos", 88, LONG },
    { "integral", 90, LONG },
    { "integralovf", 92, INT },
    { "stopathome", 93, FLAG },
    { "skip", 94, FLAG },
    { "lastpos", 95, UINT },
    { "lastvelocity", 96, INT },
    { "gphasef", 97, FLAG },
    { "gphasek", 98, LONG },
    { "gphasea", 100, LONG },
    { "prescale", 102, UINT },
    { "slow", 103, FLAG },
    { "flagxor", 104, UINT },
    { "flagand", 105, UINT },
    { "userstatus", 106, UINT },
    { "cntcntlp", 107, UINT },
    { "cntclrp", 108, FLAG },
    { "pwmgena", 109, UINT },
    { "motori", 110, UINT },
    { "dira", 111, UINT },
    { "ena", 112, UINT },
    { "outport", 113, UINT },
    { "inport", 114, UINT },
    { "analog0", 115, UINT },
    { "analog1", 116, UINT },
    { "analog2", 117, UINT },
    { "eventfirst", 118, UINT },
    { "event1", 118, UINT },
    { "event2", 124, UINT },
    { "event3", 130, UINT },
    { "event4", 135, UINT },
    { "event5", 142, UINT },
    { "event6", 148, UINT },
    { "event7", 154, UINT },
    { "event8", 160, UINT },
    { "event9", 166, UINT },
    { "event10", 172, UINT },
    { "event11", 178, UINT },
    { "event12", 184, UINT },
    { "event13", 190, UINT },
    { "event14", 196, UINT },
    { "event15", 202, UINT },
    { "event16", 208, UINT },
    { "event17", 214, UINT },
    { "event18", 220, UINT },
    { "event19", 226, UINT },
    { "event20", 232, UINT },
    { "eventlast", 232, UINT },
    { "icdfifocount", 238, UINT },
    { "irbfifocount", 239, UINT },
    { "ififowrite", 0x400, UINT },
    { "qcdfifocount", 240, UINT },
    { "qrbfifocount", 241, UINT },
    { "qfifowrite", 0x800, UINT },
    { "icdfifosize", 242, UINT },
    { "qcdfifosize", 243, UINT },
    { "irbfifosize", 244, UINT },
    { "qrbfifosize", 245, UINT },
    { "cputype", 246, UINT },
    { "controltype", 247, UINT },
    { "swrevision", 248, UINT },
    { "naxis", 249, UINT },
    { "zero", 250, INT },
    { "false", 250, FLAG },
    { "one", 251, INT },
    { "true", 252, FLAG },
    { "minusone", 252, INT },
    { "sysclk", 253, LONG },
    { "hwrevision", 255, UINT },
    { "ififoread", 0, UINT },
    { "ififoreadcount", 0, UINT },
    { "ififoparam", 0, UINT },
    { "ififoaxis", 0, UINT },
    { "ififowritecount", 0, UINT },
    { "qfiforead", 0, UINT },
    { "qfiforeadcount", 0, UINT },
    { "qfifoparam", 0, UINT },
    { "qfifoaxis", 0, UINT },
    { "qfifowritecount", 0, UINT },
    { "phaselead", 0, INT },
    { "motorangle", 0, UINT },
    { "motorphase", 0, UINT },
    { "homeoffset", 0, INT },
    { "postscale", 0, UINT },
    { "ledaxis", 0, PTR },
    { "led", 0, PTR },
    { "gevents", 0, UINT },
    { "firstgevent", 0, UINT },
    { "geventfirst", 0, UINT },
    { "gevent1", 0, UINT },
    { "geventlast", 0, UINT },
    { "lastgevent", 0, UINT },
    { "address", 1, EBYTE },
    { "baudsel", 2, EBYTE },
    { "serialmode", 3, EBYTE },
    { "loadparam", 6, EBYTE },
    { "stepdirena", 7, EBYTE }
} ;
