type
ESymbolType = (LM,SM,CE,CL,UE,UL); {logical modifier, Subtract Modifier}
                                   {Conditional Event, Unconditional Event}
EventSymbolRec =
record
 EventSymb : string[24];
 ESymbVal : word;
 EsymbType : ESymbolType;
end;

const
LastSymb = 47;
EventSymbols : array[1 .. LastSymb] of EventSymbolRec =
((EventSymb : 'EventZero' ; ESymbVal : $0200 ; ESymbType : LM),
 (EventSymb : 'EventNotZero' ; ESymbVal : $0202 ; ESymbType : LM),
 (EventSymb : 'EventCarry' ; ESymbVal : $0100 ; ESymbType : SM),
 (EventSymb : 'EventNotCarry' ; ESymbVal : $0101 ; ESymbType : SM),
 (EventSymb : 'EventGT' ; ESymbVal : $0303 ; ESymbType : SM),
 (EventSymb : 'EventLT' ; ESymbVal : $0100 ; ESymbType : SM),
 (EventSymb : 'EventGTEQ' ; ESymbVal : $0101 ; ESymbType : SM),
 (EventSymb : 'EventLTEQ' ; ESymbVal : $0300 ; ESymbType : SM),
 (EventSymb : 'EventEQ' ; ESymbVal : $0200 ; ESymbType : SM),
 (EventSymb : 'EventNEQ' ; ESymbVal : $0202 ; ESymbType : SM),
 (EventSymb : 'EventDisable' ; ESymbVal : $0000 ; ESymbType : SM),
 (EventSymb : 'EventAddIf' ; ESymbVal : $0000 ; ESymbType : CE),
 (EventSymb : 'EventAdd32If' ; ESymbVal : $0004 ; ESymbType : CE),
 (EventSymb : 'EventSubIf' ; ESymbVal : $1000 ; ESymbType : CE),
 (EventSymb : 'EventSub32If' ; ESymbVal : $1004 ; ESymbType : CE),
 (EventSymb : 'EventMul16x16to16If' ; ESymbVal : $2000 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32LoIf' ; ESymbVal : $2004 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32iIf' ; ESymbVal : $2008 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32to64If' ; ESymbVal : $200C ; ESymbType : CE),
 (EventSymb : 'EventDivIf' ; ESymbVal : $3000 ; ESymbType : CE),
 (EventSymb : 'EventSqRootIf' ; ESymbVal : $4000 ; ESymbType : CE),
 (EventSymb : 'EventCopyIf' ; ESymbVal : $5000 ; ESymbType : CL),
 (EventSymb : 'EventLogicalIf' ; ESymbVal : $6000 ; ESymbType : CL),
 (EventSymb : 'EventAddIfDel' ; ESymbVal : $0800 ; ESymbType : CE),
 (EventSymb : 'EventAdd32IfDel' ; ESymbVal : $0804 ; ESymbType : CE),
 (EventSymb : 'EventSubIfDel' ; ESymbVal : $1800 ; ESymbType : CE),
 (EventSymb : 'EventSub32IfDel' ; ESymbVal : $1804 ; ESymbType : CE),
 (EventSymb : 'EventMul16x16to16IfDel' ; ESymbVal : $2800 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32LoIfDel' ; ESymbVal : $2804 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32iIfDel' ; ESymbVal : $2808 ; ESymbType : CE),
 (EventSymb : 'EventMul32x32to64IfDel' ; ESymbVal : $280C ; ESymbType : CE),
 (EventSymb : 'EventDivIfDel' ; ESymbVal : $3800 ; ESymbType : CE),
 (EventSymb : 'EventSqRootIfDel' ; ESymbVal : $4800 ; ESymbType : CE),
 (EventSymb : 'EventCopyIfDel' ; ESymbVal : $5800 ; ESymbType : CL),
 (EventSymb : 'EventLogicalIfDel' ; ESymbVal : $6800 ; ESymbType : CL),
 (EventSymb : 'EventAdd' ; ESymbVal : $8000 ; ESymbType : UE),
 (EventSymb : 'EventAdd32' ; ESymbVal : $8004 ; ESymbType : UE),
 (EventSymb : 'EventSub' ; ESymbVal : $9000 ; ESymbType : UE),
 (EventSymb : 'EventSub32' ; ESymbVal : $9004 ; ESymbType : UE),
 (EventSymb : 'EventMul16x16to16' ; ESymbVal : $A000 ; ESymbType : UE),
 (EventSymb : 'EventMul32x32Lo' ; ESymbVal : $A004 ; ESymbType : UE),
 (EventSymb : 'EventMul32x32i' ; ESymbVal : $A008 ; ESymbType : UE),
 (EventSymb : 'EventMul32x32to64' ; ESymbVal : $A00C ; ESymbType : UE),
 (EventSymb : 'EventDiv' ; ESymbVal : $B000 ; ESymbType : UE),
 (EventSymb : 'EventSqRoot' ; ESymbVal : $C000 ; ESymbType : UE),
 (EventSymb : 'EventCopy' ; ESymbVal : $D000 ; ESymbType : UL),
 (EventSymb : 'EventLogical' ; ESymbVal : $E000 ; ESymbType : UL));
