
option expr32
option casemap:none

IFNDEF	pcpusrvc_inc
pcpusrvc_inc	EQU		1

; Begin of file ..\include\pcpusrvc.h
; ---------------------------------------------------------------------------
; 
;    "PCPUSRVC.H"
; 
;    Include file containing constants and structures for use with Mesa
; 	 Electronics PMPC-2 CPU card public service functions.
; 
;    Version 1.0, Friday October 23, 1998 -- 23:31:33.
; 
;    Copyright (c) 1998 by Mesa Electronics.
; 
; ---------------------------------------------------------------------------
; 
;    Revision history.
; 
;    1) Version 1.0, Friday October 23, 1998 -- 23:31:33.
; 
;       Code frozen for version 1.0.
; 
; ---------------------------------------------------------------------------
H_PCPUSRVC		TEXTEQU		<>
; ---------------------------------------------------------------------------
;  Enumerations.
; 
;  Function numbers that are used to access the ROMBIOS's public service
; 	 functions.
; 
;  The following are code revision level 0 functions.
; 	
F_PUBSRVCINFOQ		EQU		0t
;  Get code revision level, etc. 
F_PUBSRVCXABLEKB		EQU		1t
;  Xable PC keyboard input. 
F_PUBSRVCXABLESKB		EQU		2t
;  Xable serial keyboard input. 
F_PUBRESERVED1		EQU		3t
;  Reserved function code. 
F_PUBSRVCUSERINFOLENQ		EQU		4t
;  Get number of bytes of user information. 
F_PUBSRVCUSERINFOQ		EQU		5t
;  Get user information. 
F_PUBSRVCNUMCONFIGWORDSQ		EQU		6t
;  Inquire number of user configuration words available. 
F_PUBSRVCCONFIGWORDREAD		EQU		7t
;  Read configuration word. 
F_PUBSRVCCONFIGWORDWRITE		EQU		8t
;  Write configuration word. 
F_PUBSRVCCPUREVQ		EQU		9t
;  Get CPU card revision number. 
F_PUBSRVCATODTYPE		EQU		10t
;  Get local A-to-D converter type. 
F_PUBSRVCATODRAWREAD		EQU		11t
;  Raw read of A-to-D converter channel. 
F_PUBSRVCDISPCONTRAST		EQU		12t
;  Set display contrast. 
F_PUBSRVCDISPCONTRASTQ		EQU		13t
;  Get current display contrast. 
F_PUBSRVCBACKLITEBRITENESS		EQU		14t
;  Set display backlight brightness. 
F_PUBSRVCBACKLITEBRITENESSQ		EQU		15t
;  Get display backlight brightness. 
F_PUBSRVCDISPTIMEOUT		EQU		16t
;  Set backlightshut-off timeout. 
F_PUBSRVCDISPTIMEOUTQ		EQU		17t
;  Get backlightshut shut-off timeout. 
F_PUBSRVCVIDEODEST		EQU		18t
;  Select video output destination. 
F_PUBSRVCVIDEODESTQ		EQU		19t
;  Get video output destination. 
F_PUBSRVCCONSOLEBAUDRATE		EQU		20t
;  Set serial console COM port baud rate. 
F_PUBSRVCCONSOLEBAUDRATEQ		EQU		21t
;  Get serial console COM port baud rate. 
F_PUBSRVCVIDEOVECTORQ		EQU		22t
;  Return entry point for specified video handler. 
NUMPUBSRVCFUNCS		EQU		23t

publicservicefuncs		TYPEDEF		SWORD

;  Basic error codes for public service functions.
; 
E_PUBSRVCERRNONE		EQU		0t
;  No error. 
E_PUBSRVCERRBADFUNC		EQU		1t
;  Invalid function number. 
E_PUBSRVCERRBASE		EQU		2t
;  Base error code number. 

publicserviceerrs		TYPEDEF		SWORD

;  Constants used for specifying membrane keyboard events.
; 
KSTATE_NONE		EQU		0t
;  No event. 
KSTATE_MAKE		EQU		1t
;  Key make event. 
KSTATE_BREAK		EQU		2t
;  Key break event. 
KSTATE_REPEAT		EQU		3t
;  Key repeat event. 
NUMKSTATES		EQU		4t

membraneeventid		TYPEDEF		SWORD

; ---------------------------------------------------------------------------
;  Structures.
; 
;  Structure used to pass a command to, and receive completion status from, a
;      ROMBIOS's public functions.  This structure is always the first element
;      of any public function command structure.
; 
;    When the special functions entry point is called, CX:BX must be loaded
;      with a far pointer to one of the following structures that begins with a
;      pfuncshdr structure.  (CX contains the segment, BX contains the offset.)
; 
;  The command code from the list of syscntrlfuncs. 
;  The result code from the list of syscntrlerrs. 
pfuncshdr		STRUCT 1t
commandCode		WORD		?
errorCode		WORD		?
pfuncshdr		ENDS

;  Structure used to inquire whether the public functions code is available.
;      (pubfuncsavailq.commandHeader.commandCode == F_PUBSRVCINFOQ.)
; 
;  Command/status information. 
;  Gets inverted if there's code to answer. 
;  Code revision level. 
pubfuncsavailq		STRUCT 1t
commandHeader		pfuncshdr		<>
toggleByte		BYTE		?
revisionLevel		WORD		?
pubfuncsavailq		ENDS

;  Structure used to xable keyboard
; 	 input. (pubxablekb.commandHeader.commandCode == F_PUBSRVCXABLEKB,
; 	 F_PUBSRVCXABLESKB.)
; 
;  Command/status information. 
;  Non-zero to get state, zero to set. 
;  Xable flag. (Setting state returns previous state.) 
pubxablekb		STRUCT 1t
commandHeader		pfuncshdr		<>
getSettings		BYTE		?
enableKB		BYTE		?
pubxablekb		ENDS

;  Structure used to read user information length.
;      (pubuserinfolenq.commandHeader.commandCode == F_PUBSRVCUSERINFOLENQ.)
; 
;  Command/status information. 
;  Bytes of storage required for user information. 
pubuserinfolenq		STRUCT 1t
commandHeader		pfuncshdr		<>
userInfoLen		WORD		?
pubuserinfolenq		ENDS

;  Structure used to read user information.
;      (pubuserinfoq.commandHeader.commandCode == F_PUBSRVCUSERINFOQ.)
; 
;  Command/status information. 
;  Number of bytes of user information to read. -1 for all bytes. 
@t_pcpusrvc0		TYPEDEF		FAR PTR BYTE
;  Pointer to user information destination. 
pubuserinfoq		STRUCT 1t
commandHeader		pfuncshdr		<>
bytesToRead		WORD		?
userInfoPtr		@t_pcpusrvc0		?
pubuserinfoq		ENDS

;  Structure used to inquire the number of system configuration words
; 	 available for customer use.
;      (pubconfigwordsq.commandHeader.commandCode == F_PUBSRVCNUMCONFIGWORDSQ.)
; 
;  Command/status information. 
;  Number of available configuration words. 
pubconfigwordsq		STRUCT 1t
commandHeader		pfuncshdr		<>
numWords		WORD		?
pubconfigwordsq		ENDS

;  Structure used to read or write system configuration words.
;      (pubconfigword.commandHeader.commandCode == F_PUBSRVCCONFIGWORDREAD or
;      F_PUBSRVCCONFIGWORDWRITE.)
; 
;    User configuration words are uncommitted non-volatile storage that may be
;      used for customer-specific applications.  Valid configuration word
;      indices are 0 to (pubconfigwordsq.numWords - 1), inclusive.  The
;      specified configuration word is written to non-volatile storage upon
;      invocation of F_PUBSRVCCONFIGWORDWRITE, rather than when the system
;      configuration is saved, so the customer's software must manage wear on
;      those systems that use EEPROM for non-volatile storage.
; 
E_PUBCONFIGWORDINDEX		EQU		2t
;  Invalid configuration word index. 
E_PUBCONFIGWORDSHARE		EQU		3t
;  Shared resource unavailable. Try again. 
E_PUBCONFIGWORDWRITE		EQU		4t
;  Write verification failure. 
NUMPUBCONFIGWORDERRS		EQU		5t

pubconfigworderrs		TYPEDEF		SWORD

;  Command/status information. 
;  The index of the word to be written. 
;  The word. 
pubconfigword		STRUCT 1t
commandHeader		pfuncshdr		<>
wordIndex		WORD		?
theWord		WORD		?
pubconfigword		ENDS

;  Structure used to inquire about the CPU card's hardware revision level.
;      (pubcpurevinfo.commandHeader.commandCode == F_PUBSRVCCPUREVQ.)
; 
;  Command/status information. 
;  0 for rev. A, 1 for rev. B, etc. 
pubcpurevinfo		STRUCT 1t
commandHeader		pfuncshdr		<>
cpuRevNum		BYTE		?
pubcpurevinfo		ENDS

;  Structure used to read the local digital-to-analog converter type.
;      (puba2dtypeinfo.commandHeader.commandCode == F_PUBSRVCATODTYPE.)
; 
;  Command/status information. 
@t_pcpusrvc1		TYPEDEF		FAR PTR SBYTE
;  Pointer to upper case '0'-terminated string containing converter part number. 
;  Number of accessible channels. 
puba2dtypeinfo		STRUCT 1t
commandHeader		pfuncshdr		<>
a2dTypeStringPtr		@t_pcpusrvc1		?
numChannels		BYTE		?
puba2dtypeinfo		ENDS

;  Structure used to read an A-to-D converter channel.
;      (puba2dread.commandHeader.commandCode == F_PUBSRVCATODRAWREAD.
; 
;    Note that setting .isTimeCritical to non-zero will cause the function to
;      return with E_PUBA2DREADTIMEOUT immediately if the A-to-D converter is
; 	 busy.  If .isTimeCritical is set to zero, the function will wait until
; 	 it has access to the converter before returning.
; 
;   All return values are scaled to the range 0...65535 -- for a 10-bit
;     converter, bits 0...5 contain zero; for a 12 bit converter, bits 0...3
; 	contain zero, and for a 16-bit converter all bits are significant.
; 
;  Dedicated A-to-D converter channels.
; 
;  Temperature channel. 
A2DCHANTEMP		EQU		9t
;  VCC voltage channel. 
A2DCHANVCC		EQU		8t
;  Ground channel. 
A2DCHANGROUND		EQU		10t
;  Converter test channel. 
A2DCHANTEST		EQU		11t
E_PUBA2DREADTIMEOUT		EQU		2t
;  The converter is busy. 
E_PUBA2DREADCHANNEL		EQU		3t
;  Invalid converter channel number. 
NUMPUBA2DREADERRS		EQU		4t

puba2dreaderrs		TYPEDEF		SWORD

;  Command/status information. 
;  Non-zero will give up immediately if the A-to-D converter is busy. 
;  Number of the converter channel to be read. 
;  Returned conversion value. 
puba2dread		STRUCT 1t
commandHeader		pfuncshdr		<>
isTimeCritical		BYTE		?
channelNumber		BYTE		?
a2dData		WORD		?
puba2dread		ENDS

;  Structure used to read/write display contrast.
;      (pubdispcontrast.commandHeader.commandCode == F_PUBSRVCDISPCONTRAST or
; 	 F_PUBSRVCDISPCONTRASTQ.)
; 
;  Command/status information. 
;  The display contrast value has a full scale value of 65535 and a minimum
; 	     value of 0.  A contrast setting of 32767 therefore gives a setting of
; 	     about 50 percent full scale.
; 	
pubdispcontrast		STRUCT 1t
commandHeader		pfuncshdr		<>
displayContrastPercent		WORD		?
pubdispcontrast		ENDS

;  Structure used to read/write display backlight brightness.
; 	 (pubbacklightbriteness.commandHeader.commandCode ==
; 	 F_PUBSRVCBACKLITEBRITENESS or F_PUBSRVCBACKLITEBRITENESSQ.)
; 
;  Command/status information. 
;  The display backlight brightness value has a full scale value of 65535 and
; 	     a minimum value of 0.  A contrast setting of 32767 therefore gives a
; 		 setting of about 50 percent full scale.
; 	
pubbacklightbriteness		STRUCT 1t
commandHeader		pfuncshdr		<>
backlightLevelPercent		WORD		?
pubbacklightbriteness		ENDS

;  Structure used to read/write display shut-off timeout.
; 	 (pubdisptimeout.commandHeader.commandCode == F_PUBSRVCDISPTIMEOUT or
; 	 F_PUBSRVCDISPTIMEOUTQ.)
; 
E_PUBDISPTIMEOUT		EQU		2t
;  Invalid timeout. 
NUMPUBDISPTIMEOUTERRS		EQU		3t

pubdisptimeouterrs		TYPEDEF		SWORD

;  Command/status information. 
;  Backlight shutoff timeout in 25.6 second ticks. (1...32.) 
pubdisptimeout		STRUCT 1t
commandHeader		pfuncshdr		<>
timeOut		BYTE		?
pubdisptimeout		ENDS

;  Structure used to inquire about/adjust display output routing.
;     (pubvideodest.commandHeader.commandCode == F_PUBSRVCVIDEODEST or
; 	F_PUBSRVCVIDEODESTQ.)
; 
;  Constants used for specifying various video output destinations.
; 
PUBVIDEODEST_VIDEO		EQU		0t
;  Send video output to standard video. 
PUBVIDEODEST_SERIAL		EQU		1t
;  Send video output to local serial port. 
PUBVIDEODEST_LCD		EQU		2t
;  Send video output to local LCD video. 
PUBVIDEODEST_STUB		EQU		3t
;  Send video output to black hole. 
NUMPUBVIDEODESTS		EQU		4t

pubvideodests		TYPEDEF		SWORD

;  Additional error codes returned by F_PUBSRVCVIDEODEST and
; 	 F_PUBSRVCVIDEODESTQ.
; 
E_PUBVIDDEST		EQU		2t
;  Invalid video destination. 
NUMPUBVIDDESTERRS		EQU		3t

pubvideodesterrs		TYPEDEF		SWORD

;  Command/status information. 
;  Where video output is to go to. (From enum pubvideodests.) 
pubvideodest		STRUCT 1t
commandHeader		pfuncshdr		<>
videoDest		pubvideodests		?
pubvideodest		ENDS

;  Structure used to inquire about/adjust serial console COM port baud rate.
;      (pubconsolebaudrate.commandHeader.commandCode ==
; 	 F_PUBSRVCCONSOLEBAUDRATE or F_PUBSRVCCONSOLEBAUDRATEQ.)
; 
;  Baud rate selectors.
; 
PUBCONSOLEBAUDRATE_110		EQU		0t
;  110 Baud. 
PUBCONSOLEBAUDRATE_150		EQU		1t
PUBCONSOLEBAUDRATE_300		EQU		2t
PUBCONSOLEBAUDRATE_600		EQU		3t
PUBCONSOLEBAUDRATE_1200		EQU		4t
PUBCONSOLEBAUDRATE_1800		EQU		5t
PUBCONSOLEBAUDRATE_2000		EQU		6t
PUBCONSOLEBAUDRATE_2400		EQU		7t
PUBCONSOLEBAUDRATE_3600		EQU		8t
PUBCONSOLEBAUDRATE_4800		EQU		9t
PUBCONSOLEBAUDRATE_7200		EQU		10t
PUBCONSOLEBAUDRATE_9600		EQU		11t
PUBCONSOLEBAUDRATE_19200		EQU		12t
PUBCONSOLEBAUDRATE_38400		EQU		13t
PUBCONSOLEBAUDRATE_57600		EQU		14t
PUBCONSOLEBAUDRATE_115200		EQU		15t
;  115.2 Kbaud. 
NUMPUBCONSOLEBAUDRATES		EQU		16t

pubconsolebaudrates		TYPEDEF		SWORD

;  Additional error codes returned by F_PUBSRVCCONSOLEBAUDRATE and
;      F_PUBSRVCCONSOLEBAUDRATEQ.
; 
E_PUBCONSOLEBAUDRATE		EQU		2t
;  Invalid baud rate selector. 
NUMPUBCONSOLEBAUDRATEERRS		EQU		3t

pubconsolebaudrateerrs		TYPEDEF		SWORD

;  Command/status information. 
;  Baud rate selector. One of enum pubconsolebaudrate. Set returns previous selector. 
pubconsolebaudrate		STRUCT 1t
commandHeader		pfuncshdr		<>
baudSelector		pubconsolebaudrates		?
pubconsolebaudrate		ENDS

;  Structure used to get the specified video code vector.
;      (pubvideovectorq.commandHeader.commandCode == F_PUBSRVCVIDEOVECTORQ.)
; 
;  Video vector selectors.
; 
PUBVIDEOVECTORSELECT_VIDEO		EQU		0t
PUBVIDEOVECTORSELECT_SERIAL		EQU		1t
PUBVIDEOVECTORSELECT_LCD		EQU		2t
PUBVIDEOVECTORSELECT_STUB		EQU		3t
NUMPUBVIDEOVECTORSELECTS		EQU		4t

pubvideovectorselect		TYPEDEF		SWORD

;  Additional error codes returned by F_PUBSRVCVIDEOVECTORQ.
; 
E_PUBVIDEOVECTOR		EQU		2t
;  No such video vector. 
NUMPUBVIDEOVECTORERRS		EQU		3t

pubvideovectorerrs		TYPEDEF		SWORD

;  Command/status information. 
;  Handler specifier. 
@t_pcpusrvc2		TYPEDEF		FAR PTR 
;  Address of the specified video output handler. 0 if the handler is undefined. 
pubvideovectorq		STRUCT 1t
commandHeader		pfuncshdr		<>
whichHandler		pubvideovectorselect		?
codeEntryPoint		@t_pcpusrvc2		?
pubvideovectorq		ENDS

; ---------------------------------------------------------------------------
; End of file ..\include\pcpusrvc.h

ENDIF

