program SC;  { set contrast on PMPCX}
uses dos,crt;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}
{$I PCPUFUNC}
const

{ KB cursor keys }
KeyExit   = #$4F;
KeyOld    = #$47;
KeyUp     = #$48;
KeyDown   = #$50;
KeySave   = #$51;

ContrastStep = 200;
MaxContrast = $FFFE - ContrastStep;
MinContrast = $8000;

var

OldContrast : word;
Contrast : word;

procedure KeyLoop;
var
done : boolean;
begin
  done := false;
  ClrScr;
  writeln('Use up/down keys to set contrast');
  writeln('HOME = Restore old contrast value');
  writeln('END = Exit program');
  writeln('PGDN = Save current settings');
  write(chr(13),'  Cont = ',Contrast,'  ');
  while not done do
  begin
    while readkey <> #0 do { wait for special char };
    case readkey of
      KeyExit :
      begin
        done := true;
      end;
      KeyOld :
      begin
        Contrast := OldContrast;
        SetContrast(Contrast);
        write(chr(13),'  Cont = ',Contrast,'  ');
      end;
      KeyUp   :
      begin
        if Contrast < MaxContrast then Contrast := Contrast + ContrastStep;
        if Contrast > MaxContrast then Contrast := MaxContrast;
        SetContrast(Contrast);
        write(chr(13),'  Cont = ',Contrast,'  ');
      end;
      KeyDown :
      begin
        if Contrast > MinContrast then Contrast := Contrast - ContrastStep;
        if Contrast < MinContrast then Contrast := MinContrast;
        SetContrast(Contrast);
        write(chr(13),'  Cont = ',Contrast,'  ');
      end;
      KeySave :
      begin
        SaveSetup ;
        write(chr(13),'  Saved!','      ');
      end;
    end;
  end;
end;

begin          {main}
  If MesaPubFuncsAvailQ('MESAPMPC2') then
  begin
    DirectVideo := false;
    OldContrast := GetContrast;
    Contrast := OldContrast;
    KeyLoop;
  end
  else Writeln('Public funcs not available on this CPU..');
end.
