program ReadAD; { for PMPC2}
uses CRT;

{$I PCPUFUNC}           { ReadAToD function }

const
VRef = 3.75;
Scale = 65536;
var
DummyChar : char;

procedure ADSetup;
var adata : word;
begin
  { This should be unecessary since the BIOS is supposed to do this }
  adata := ReadAToD(0);  { dummy read to get address started }
  adata := ReadAToD(0);  { select a channel }
  adata := ReadAToD(14); { set power down mode to avoid chip bug }
end;

procedure ReadLoop;
var
chan : byte;
adata : word;
sx,sy : byte;
begin
  for chan := 0 to 11 do
  begin
    adata := ReadAToD(chan);  { read data + start next conversion }
    sy := (chan div 2) +1;
    if (chan and 1) = 0 then sx := 1 else sx := 13;
    GoToXY(sx,sy);
    case chan of
      8: write('V =  ',(adata*VRef*2)/scale:2:2);
      9: write('T =  ',(0.660-(adata*VRef/scale))/0.0022:2:2);
      10: write('G =  ',adata div 16:4);
      11: write('CK = ',adata div 16:4);
      else write('Ch',chan:2,'=',adata div 16:4);
    end;
  end;
end;

begin {main}
  If MesaPubFuncsAvailQ('MESAPMPC2') then
  begin
    ClrScr;
    ADSetup;
    while not keypressed do
    begin
      readloop;
    end;
    DummyChar := readkey;
  end
  else writeln('This is not a PMPC2!');
end.
