
{$I biosid}
{$I pcpusrvc}

type

GPtrRec = record
  Ofs : word;
  Smt : word;
end;

procedure PCPUfunc(p: pointer);
var
  idptr : ^ROMBIOSID;
  svcptr : pointer;
begin
  GPtrRec(idptr).Smt := ROMBIOSIDSEG;
  GPtrRec(idptr).Ofs := ROMBIOSIDOFF;
  svcptr := @(idptr^.jmp2PublicServices);
  asm
    mov cx,GPtrRec[p].Smt
    mov bx,GPtrRec[p].Ofs
    call dword [svcptr]
  end;
end;

procedure PrivCPUfunc(p: pointer);
var
  idptr : ^ROMBIOSID;
  svcptr : pointer;
begin
  GPtrRec(idptr).Smt := ROMBIOSIDSEG;
  GPtrRec(idptr).Ofs := ROMBIOSIDOFF;
  svcptr := @(idptr^.jmp2Services);
  asm
    mov cx,GPtrRec[p].Smt
    mov bx,GPtrRec[p].Ofs
    call dword [svcptr]
  end;
end;

function ReadAtoD(channel : byte) : word;
var
atodrec : PubA2DRead;
begin
  with atodrec do
  begin
    CommandHeader.CommandCode := F_PUBSRVCATODRAWREAD;
    ChannelNumber := channel;
    IsTimeCritical := 0; { no, wait if busy}
    { could be busy if background LCD tempco contrast adjust }
    PCPUFunc(@atodrec);
    ReadAtoD := A2DData;
  end;
end;

procedure ConsBaudRateSelect(selector : byte);
var brec : PubConsoleBaudRate;
begin
  brec.CommandHeader.CommandCode := F_PUBSRVCCONSOLEBAUDRATE;
  brec.PubConsoleBaudRates := selector;
  PCPUFunc(@brec);
end;

function GetConsBaudRateSelect : byte;
var brec : PubConsoleBaudRate;
begin
  brec.CommandHeader.CommandCode := F_PUBSRVCCONSOLEBAUDRATEQ;
  PCPUFunc(@brec);
  GetConsBaudRateSelect := brec.PubConsoleBaudRates;
end;

function SetConsBaudRate(br : longint) : boolean;
var
index : byte;
foundit : boolean;
begin
  foundit := false;
  for index := 0 to LastConsoleBaudRate do
  begin
    if ConsBaudRates[index] = br then
    begin
      ConsBaudRateSelect(index);
      foundit := true;
    end;
  end;
  SetConsBaudRate := foundit;
end;


function GetContrast : word;
var DispContrastInfo : PubDispContrast;
begin
  DispContrastInfo.CommandHeader.CommandCode := F_PUBSRVCDISPCONTRASTQ;
  PCPUFunc(@DispContrastInfo);
  GetContrast := DispContrastInfo.DisplayContrastPercent;
end;

procedure SetContrast(contrast : word);
var DispContrastInfo : PubDispContrast;
begin
  DispContrastInfo.DisplayContrastPercent := Contrast;
  DispContrastInfo.CommandHeader.CommandCode := F_PUBSRVCDISPCONTRAST;
  PCPUFunc(@DispContrastInfo);
end;

function GetBrightness : word;
var BrightnessInfo : PubBacklightBriteness;
begin
  BrightnessInfo.CommandHeader.CommandCode := F_PUBSRVCBACKLITEBRITENESSQ;
  PCPUFunc(@BrightnessInfo);
  GetBrightness := BrightnessInfo.BacklightLevelPercent;
end;

procedure SetBrightness(Brightness : word);
var BrightnessInfo : PubBacklightBriteness;
begin
  BrightnessInfo.CommandHeader.CommandCode := F_PUBSRVCBACKLITEBRITENESS;
  BrightnessInfo.BacklightLevelPercent := brightness;
  PCPUFunc(@BrightnessInfo);
end;

function GetDispTimeout : byte;
var DispTimeoutInfo : PubDispTimeout;
begin
  DispTimeoutInfo.CommandHeader.CommandCode := F_PUBSRVCDISPTIMEOUTQ;
  PCPUFunc(@DispTimeoutInfo);
  GetDispTimeout := DispTimeoutInfo.Timeout;
end;

procedure SetDispTimeout(DispTimeout : byte);
var DispTimeoutInfo : PubDispTimeout;
begin
  DispTimeoutInfo.CommandHeader.CommandCode := F_PUBSRVCDISPTIMEOUT;
  DispTimeoutInfo.Timeout :=  DispTimeout;
  PCPUFunc(@DispTimeoutInfo);
end;

procedure SaveSetup;
var CommandInfo : pfuncshdr;
begin
  CommandInfo.CommandCode := F_SYSSETUPSAVE;
  PrivCPUFunc(@CommandInfo);
end;

function MesaPubFuncsAvailq(CPUName : string) : boolean;
var
  idptr : ^ROMBIOSID;
  funcsavail : PubFuncsAvailQ;
  NameArr : array[0..16] of char;
  tempstr : string;
  index : byte;
begin
  GPtrRec(idptr).Smt := ROMBIOSIDSEG;
  GPtrRec(idptr).Ofs := ROMBIOSIDOFF;
  tempstr :='';
  for index := 0 to length(CPUName)-1 do
  begin
    tempstr :=  tempstr +idptr^.SysMsg[index];
  end;
  { Good idea to make sure system functions are available }
  { before diving in...}
  MesaPubFuncsAvailq := false;
  if tempstr = CPUName then
  begin
    funcsavail.CommandHeader.CommandCode := F_PUBSRVCINFOQ;
    funcsavail.ToggleByte := $55;
    PCPUFunc(@funcsavail);
    if funcsavail.ToggleByte = $AA then
    MesaPubFuncsAvailq := true;
  end;
end;
