{---------------------------------------------------------------------------}
{
   "PCPUSRVC.H"

   Include file containing constants and structures for use with Mesa
	 Electronics PMPC-2 CPU card public service functions.

   Version 1.0, Friday October 23, 1998 -- 23:31:33.

   Copyright (c) 1998 by Mesa Electronics.
}
{---------------------------------------------------------------------------}
{
   Revision history.

   1) Version 1.0, Friday October 23, 1998 -- 23:31:33.

      Code frozen for version 1.0.
}
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}

{ Enumerations.
}

{ Function numbers that are used to access the ROMBIOS's public service
	 functions.
}
const
{ publicservicefuncs }
	{ The following are code revision level 0 functions.}

F_PUBSRVCINFOQ = 0;               { Get code revision level, etc. }
F_PUBSRVCXABLEKB = 1;             { Xable PC keyboard input. }
F_PUBSRVCXABLESKB = 2;            { Xable serial keyboard input. }
F_PUBRESERVED1 = 3;               { Reserved function code. }
F_PUBSRVCUSERINFOLENQ = 4 ;       { Get number of bytes of user information. }
F_PUBSRVCUSERINFOQ = 5;           { Get user information. }
F_PUBSRVCNUMCONFIGWORDSQ = 6;     { Inquire number of user configuration words available. }
F_PUBSRVCCONFIGWORDREAD = 7;      { Read configuration word. }
F_PUBSRVCCONFIGWORDWRITE = 8;     { Write configuration word. }
F_PUBSRVCCPUREVQ = 9;             { Get CPU card revision number. }
F_PUBSRVCATODTYPE = 10;           { Get local A-to-D converter type. }
F_PUBSRVCATODRAWREAD = 11;        { Raw read of A-to-D converter channel. }
F_PUBSRVCDISPCONTRAST = 12;       { Set display contrast. }
F_PUBSRVCDISPCONTRASTQ = 13;      { Get current display contrast. }
F_PUBSRVCBACKLITEBRITENESS = 14;  { Set display backlight brightness. }
F_PUBSRVCBACKLITEBRITENESSQ = 15; { Get display backlight brightness. }
F_PUBSRVCDISPTIMEOUT = 16;        { Set backlightshut-off timeout. }
F_PUBSRVCDISPTIMEOUTQ = 17;       { Get backlightshut shut-off timeout. }
F_PUBSRVCVIDEODEST = 18;          { Select video output destination. }
F_PUBSRVCVIDEODESTQ = 19;         { Get video output destination. }
F_PUBSRVCCONSOLEBAUDRATE = 20;    { Set serial console COM port baud rate. }
F_PUBSRVCCONSOLEBAUDRATEQ = 21;   { Get serial console COM port baud rate. }
F_PUBSRVCVIDEOVECTORQ = 22;       { Return entry point for specified video handler. }
NUMPUBSRVCFUNCS = 23;


{ Basic error codes for public service functions.
}
{ publicserviceerrs }

E_PUBSRVCERRNONE = 0; { No error. }
E_PUBSRVCERRBADFUNC = 1;  { Invalid function number. }
E_PUBSRVCERRBASE = 2;     { Base error code number. }


{ Constants used for specifying membrane keyboard events.
}
{membraneeventid}

KSTATE_NONE = 0; { No event. }
KSTATE_MAKE = 1;     { Key make event. }
KSTATE_BREAK = 2;    { Key break event. }
KSTATE_REPEAT = 3;   { Key repeat event. }
NUMKSTATES = 4;

{---------------------------------------------------------------------------}

{ Structures.
}
{ Structure used to pass a command to = ; and receive completion status from = ; a
     ROMBIOS's public functions.  This structure is always the first element
     of any public function command structure.

   When the special functions entry point is called, CX:BX must be loaded
     with a far pointer to one of the following structures that begins with a
     pfuncshdr structure.  (CX contains the segment, BX contains the offset.)
}
type

pfuncshdr =
record
  commandCode : word; { The command code from the list of syscntrlfuncs. }
  errorCode : word;   { The result code from the list of syscntrlerrs. }
end;


{ Structure used to inquire whether the public functions code is available.
     (pubfuncsavailq.commandHeader.commandCode == F_PUBSRVCINFOQ.)
}
pubfuncsavailq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  toggleByte : byte;     { Gets inverted if there's code to answer. }
  revisionLevel : word; { Code revision level. }
end;

{ Structure used to xable keyboard
	 input. (pubxablekb.commandHeader.commandCode == F_PUBSRVCXABLEKB,
	 F_PUBSRVCXABLESKB.)
}
pubxablekb =
record
  commandHeader : pfuncshdr  ; { Command/status information. }
  getSettings : byte ; { Non-zero to get state, zero to set. }
  enableKB : byte ;    { Xable flag. (Setting state returns previous state.) }
end;

{ Structure used to read user information length.
     (pubuserinfolenq.commandHeader.commandCode == F_PUBSRVCUSERINFOLENQ.)
}
pubuserinfolenq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  userInfoLen : word ; { Bytes of storage required for user information. }
end;


{ Structure used to read user information.
     (pubuserinfoq.commandHeader.commandCode == F_PUBSRVCUSERINFOQ.)
}
pubuserinfoq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  bytesToRead : word;     { Number of bytes of user information to read. -1 for all bytes. }
  userInfoPtr : pointer; { Pointer to user information destination. }
end;


{ Structure used to inquire the number of system configuration words
	 available for customer use.
     (pubconfigwordsq.commandHeader.commandCode == F_PUBSRVCNUMCONFIGWORDSQ.)
}
pubconfigwordsq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  numWords : word ; { Number of available configuration words. }
end;


{ Structure used to read or write system configuration words.
     (pubconfigword.commandHeader.commandCode == F_PUBSRVCCONFIGWORDREAD or
     F_PUBSRVCCONFIGWORDWRITE.)

   User configuration words are uncommitted non-volatile storage that may be
     used for customer-specific applications.  Valid configuration word
     indices are 0 to (pubconfigwordsq.numWords - 1), inclusive.  The
     specified configuration word is written to non-volatile storage upon
     invocation of F_PUBSRVCCONFIGWORDWRITE, rather than when the system
     configuration is saved, so the customer's software must manage wear on
     those systems that use EEPROM for non-volatile storage.
}
const

	E_PUBCONFIGWORDINDEX = E_PUBSRVCERRBASE;   { Invalid configuration word index. }
	E_PUBCONFIGWORDSHARE = E_PUBSRVCERRBASE+1; { Shared resource unavailable. Try again. }
	E_PUBCONFIGWORDWRITE = E_PUBSRVCERRBASE+2; { Write verification failure. }
	NUMPUBCONFIGWORDERRS = 3;

type

pubconfigword =
record
  commandHeader : pfuncshdr; { Command/status information. }
  wordIndex : word; { The index of the word to be written. }
  theWord : word;   { The word. }
end;

{ Structure used to inquire about the CPU card's hardware revision level.
     (pubcpurevinfo.commandHeader.commandCode == F_PUBSRVCCPUREVQ.)
}
pubcpurevinfo=
record
  commandHeader : pfuncshdr; { Command/status information. }
  cpuRevNum : byte; { 0 for rev. A, 1 for rev. B, etc. }
end;

{ Structure used to read the local digital-to-analog converter type.
     (puba2dtypeinfo.commandHeader.commandCode == F_PUBSRVCATODTYPE.)
}
puba2dtypeinfo =
record
  commandHeader : pfuncshdr; { Command/status information. }
  a2dTypeStringPtr : pointer ; { Pointer to upper case '\0'-terminated string containing converter part number. }
  numChannels : byte ;  { Number of accessible channels. }
end;

{ Structure used to read an A-to-D converter channel.
     (puba2dread.commandHeader.commandCode == F_PUBSRVCATODRAWREAD.

   Note that setting .isTimeCritical to non-zero will cause the function to
     return with E_PUBA2DREADTIMEOUT immediately if the A-to-D converter is
	 busy.  If .isTimeCritical is set to zero, the function will wait until
	 it has access to the converter before returning.

  All return values are scaled to the range 0...65535 -- for a 10-bit
    converter, bits 0...5 contain zero; for a 12 bit converter, bits 0...3
	contain zero, and for a 16-bit converter all bits are significant.
}

{ Dedicated A-to-D converter channels.
}
const
A2DCHANTEMP =  9;  { Temperature channel. }
A2DCHANVCC  =  8;  { VCC voltage channel. }
A2DCHANGROUND = 10; { Ground channel. }
A2DCHANTEST =  11; { Converter test channel. }

E_PUBA2DREADTIMEOUT = E_PUBSRVCERRBASE; { The converter is busy. }
E_PUBA2DREADCHANNEL = E_PUBSRVCERRBASE+1; { Invalid converter channel number. }
NUMPUBA2DREADERRS = 2;

type

puba2dread =
record
  commandHeader : pfuncshdr; { Command/status information. }
  isTimeCritical : byte; { Non-zero will give up immediately if the A-to-D converter is busy. }
  channelNumber : byte ;  { Number of the converter channel to be read. }
  a2dData : word;       { Returned conversion value. }
end;


{ Structure used to read/write display contrast.
     (pubdispcontrast.commandHeader.commandCode == F_PUBSRVCDISPCONTRAST or
	 F_PUBSRVCDISPCONTRASTQ.)
}
pubdispcontrast =
record
  commandHeader : pfuncshdr; { Command/status information. }
	{ The display contrast value has a full scale value of 65535 and a minimum
	     value of 0.  A contrast setting of 32767 therefore gives a setting of
	     about 50 percent full scale.
	}
  displayContrastPercent : word;
end;

{ Structure used to read/write display backlight brightness.
	 (pubbacklightbriteness.commandHeader.commandCode ==
	 F_PUBSRVCBACKLITEBRITENESS or F_PUBSRVCBACKLITEBRITENESSQ.)
}
pubbacklightbriteness =
record
  commandHeader : pfuncshdr; { Command/status information. }

	{ The display backlight brightness value has a full scale value of 65535 and
	     a minimum value of 0.  A contrast setting of 32767 therefore gives a
		 setting of about 50 percent full scale.
	}
  backlightLevelPercent : word;
end;

{ Structure used to read/write display shut-off timeout.
	 (pubdisptimeout.commandHeader.commandCode == F_PUBSRVCDISPTIMEOUT or
	 F_PUBSRVCDISPTIMEOUTQ.)
}
const
E_PUBDISPTIMEOUT = E_PUBSRVCERRBASE; { Invalid timeout. }
NUMPUBDISPTIMEOUTERRS = 1;
type

pubdisptimeout =
record
  commandHeader : pfuncshdr; { Command/status information. }
  timeOut : byte ; { Backlight shutoff timeout in 25.6 second ticks. (1...32.) }
end;


{ Structure used to inquire about/adjust display output routing.
    (pubvideodest.commandHeader.commandCode == F_PUBSRVCVIDEODEST or
	F_PUBSRVCVIDEODESTQ.)
}

{ Constants used for specifying various video output destinations.
}
const
PUBVIDEODEST_VIDEO = 0;    { Send video output to standard video. }
PUBVIDEODEST_SERIAL =1;    { Send video output to local serial port. }
PUBVIDEODEST_LCD =2;       { Send video output to local LCD video. }
PUBVIDEODEST_STUB =3;      { Send video output to black hole. }
NUMPUBVIDEODESTS =4;

{ Additional error codes returned by F_PUBSRVCVIDEODEST and
	 F_PUBSRVCVIDEODESTQ.
}
E_PUBVIDDEST = E_PUBSRVCERRBASE; { Invalid video destination. }
NUMPUBVIDDESTERRS = 1;

type

pubvideodest =
record
  commandHeader : pfuncshdr; { Command/status information. }
  pubvideodests : byte;      { Where video output is to go to.}
end;


{ Structure used to inquire about/adjust serial console COM port baud rate.
     (pubconsolebaudrate.commandHeader.commandCode ==
	 F_PUBSRVCCONSOLEBAUDRATE or F_PUBSRVCCONSOLEBAUDRATEQ.)
}

{ Baud rate selectors.
}
const
ConsBaudRates : array[0..15] of longint =
(110,150,300,600,1200,1800,2000,2400,3600,4800,7200,9600,19200,38400,57600,115200);
LastConsoleBaudRate = 15;

{ Additional error codes returned by F_PUBSRVCCONSOLEBAUDRATE and
     F_PUBSRVCCONSOLEBAUDRATEQ.
}

E_PUBCONSOLEBAUDRATE = E_PUBSRVCERRBASE; { Invalid baud rate selector. }
NUMPUBCONSOLEBAUDRATEERRS = 1;

type

pubconsolebaudrate =
record
  commandHeader : pfuncshdr; { Command/status information. }
  pubconsolebaudrates : byte; { Baud rate selector. Set returns previous selector. }
end;


{ Structure used to get the specified video code vector.
     (pubvideovectorq.commandHeader.commandCode == F_PUBSRVCVIDEOVECTORQ.)
}

{ Video vector selectors.
}
const

PUBVIDEOVECTORSELECT_VIDEO = 0;
PUBVIDEOVECTORSELECT_SERIAL = 1;
PUBVIDEOVECTORSELECT_LCD = 2;
PUBVIDEOVECTORSELECT_STUB = 3;
NUMPUBVIDEOVECTORSELECTS = 4;

{ Additional error codes returned by F_PUBSRVCVIDEOVECTORQ.
}
E_PUBVIDEOVECTOR = E_PUBSRVCERRBASE; { No such video vector. }
NUMPUBVIDEOVECTORERRS = 1;

type

pubvideovectorq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  pubvideovectorselect : byte ; { Handler specifier. }
  codeEntryPoint : pointer;  {address of the specified video output handler. 0 if the handler is undefined. }
end;

{---------------------------------------------------------------------------}
