{---------------------------------------------------------------------------}
{
   "BIOSID.H"

   Include file defining the ROMBIOS I.D. structure.

   Version 1.0, Wednesday November 12, 1997 -- 22:59:53.

   Copyright (c) 1997 by Mesa Electronics.
}
{---------------------------------------------------------------------------}
{
   Revision history.

   1) Version 1.0, Wednesday November 12, 1997 -- 22:59:53.

	  Code frozen for version 1.0.
}
{---------------------------------------------------------------------------}


{---------------------------------------------------------------------------}

{constants}
const
ROMBIOSIDSEG = $F000; { Segment of ROMBIOS I.D. structure. }
ROMBIOSIDOFF = $FF00; { Offset of ROMBIOS I.D. structure in segment ROMBIOSIDSEG. }
IDSTRUCTREV = 0; { Version number of the ROMBIOSID structure. }

{---------------------------------------------------------------------------}

{Structures.}

{ ROMBIOS I.D. structure.  The ROMBIOS contains a structure of this type at
	 location ROMBIOSIDSEG:ROMBIOSIDOFF.
}

type

ROMBIOSID =  record
	sysMsg : array [0..16] of char; { System I.D. message for utilities. }
	hdrVers : byte;  { Header version. }
        rbRevMS : byte;  { ROMBIOS version number high byte. }
	rbRevLS : byte;  { ROMBIOS version number low byte. }
	rbRevSfx : byte; { ROMBIOS version number suffix. }

	biosLength : longint;     { Number of bytes of BIOS object code. }
	biosROMLength : byte; { Size of BIOS ROM in Kbytes. }

	CPUhZ : longint ; { CPU clock frequency in cycles per second. (If implemented by ROMBIOS.) }

	baudList : array[0..15] of word; { Baud rate divisor table for CPUs with non-standard clock frequencies. }

	userIntNum : byte; { User NMI interrupt vector number. (If implemented by ROMBIOS.) }

	tickPrescale : byte; { System tick prescale value. (If implemented by ROMBIOS.) }

	rbBlurb: array [0..82] of char; { OEM blurb area. }
	rbNoticearray: array [0..82] of char; { Copyright notice area. }

	jmp2Services : array [0..2] of byte;       { Near jump to CPU-specific private services handler entry point. }
	jmp2PublicServices : array [0..2] of byte; { Near jump to CPU-specific public services handler entry point. }
end;

{---------------------------------------------------------------------------}

