/*---------------------------------------------------------------------------*/
/*
   "SRVCDEMO.C"

   Demo to show how to access PMPC2 ROMBIOS public access service functions.

   Version 1.0, Wednesday December 31, 1997 -- 11:32:30.

   Copyright (c) 1997 by Mesa Electronics.
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Wednesday December 31, 1997 -- 11:32:30.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <time.h>
#include <dos.h>
#include "biosid.h"
#include "pcpusrvc.h"

/*---------------------------------------------------------------------------*/

/* Function: pubservicecall
   Purpose: Call special ROMBIOS public access service functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static signed pubservicecall(void far *parmptr)

{
	static unsigned char far *servicevec = MK_FP(ROMBIOSIDSEG, (ROMBIOSIDOFF + offsetof(rombiosid, jmp2PublicServices))) ;


	asm {
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far pointer.
				call	dword ptr [servicevec]	// Call the CPU public services code.
				cld								// (Just in case.)
	}
	return (((((pfuncshdr far *)parmptr) -> errorCode) != E_PUBSRVCERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: iscpuq
   Purpose: Determine whether or not the installed CPU supports public
     access service functions.
   Used by: Anyone.
   Returns: status information.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static int iscpuq(void)

{
	static const char *idmsg = BIOSIDMSG ;

	unsigned i ;

	rombiosid const far *idptr = MK_FP(ROMBIOSIDSEG, ROMBIOSIDOFF) ;


	for(i = 0 ; ; i++)
	{
		if(idmsg[i] == '\0')
		{
			return !0 ;
		}
		if(idmsg[i] != (idptr -> sysMsg[i]))
		{
			return !!0 ;
		}
	}
}

/*---------------------------------------------------------------------------*/

/* Function: pubfuncsavailableq
   Purpose: Determine whether or not the installed ROMBIOS supports public
	 access service functions.
   Used by: Anyone.
   Returns: Locked/unlocked/failure status information.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static int pubfuncsavailableq(void)

{
	pubfuncsavailq s ;


	(s . commandHeader . commandCode) = F_PUBSRVCINFOQ ;
	(s . toggleByte) = 0x55 ;
	return ((pubservicecall(&s) >= 0) && ((s . toggleByte) == 0xAA)) ;
}

/*---------------------------------------------------------------------------*/

/* Function: kblockedq
   Purpose: Get the current PC keyboard lock state.
   Used by: Anyone.
   Returns: Locked/unlocked status information.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static int kblockedq(void)

{
	pubxablekb s ;


	(s . commandHeader . commandCode) = F_PUBSRVCXABLEKB ;
	(s . getSettings) = !0 ; /* Get. */
	if(pubservicecall(&s) < 0)
	{
		fprintf(stderr, "\n\aCan't determine keyboard lock status.\n") ;

		exit(1) ;
	}
	return !(s . enableKB) ;
}

/*---------------------------------------------------------------------------*/

/* Function: xlockkb
   Purpose: Lock or unlock the PC keyboard.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static void xlockkb(int lockit)

{
	pubxablekb s ;


	(s . commandHeader . commandCode) = F_PUBSRVCXABLEKB ;
	(s . getSettings) = !!0 ; /* Set. */
	(s . enableKB) = !lockit ;
	if(pubservicecall(&s) < 0)
	{
		fprintf(stderr, "\n\aCan't lock/unlock keyboard.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: dispkblockstate
   Purpose: Display the current lock state of the PC keyboard.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static void dispkblockstate(void)

{
	printf("\nThe keyboard is %s.", (kblockedq() ? "locked" : "unlocked")) ;
}

/*---------------------------------------------------------------------------*/

/* Function: waitawhile
   Purpose: Give the user something to look at and wait a while.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static void waitawhile(void)

{
	unsigned seconds ;

	time_t t ;


	putchar('\n') ;
	for(seconds = 15 ; seconds > 0 ; seconds--)
	{
		printf("\r%-2u", seconds) ;
		t = time(0) ;
		while(t == time(0))
		{
			;
		}
	}
	printf("\r0 ") ;
}

/*---------------------------------------------------------------------------*/

/* Function: kblockdemo
   Purpose: Run the keyboard locking demo.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
	 1) Wednesday December 31, 1997 -- 11:32:30.
*/

static void kblockdemo(void)

{
	dispkblockstate() ;
	xlockkb(!0) ; /* Lock it. */
	dispkblockstate() ;
	waitawhile() ;
	xlockkb(!!0) ; /* Unlock it. */
	dispkblockstate() ;
}

/*---------------------------------------------------------------------------*/

int main(unsigned argc, char *argv[])

{
	if(!iscpuq())
	{
		fprintf(stderr, "\n\aThis isn't a 4C27 CPU card.\n") ;

		exit(1) ;
	}
	if(!pubfuncsavailableq())
	{
		fprintf(stderr, "\n\aThis 4C27's ROMBIOS doesn't support public access service functions.\n") ;

		exit(1) ;
	}

	kblockdemo() ; /* Demonstrate keyboard lock/unlock. */

	putchar('\n') ;

	return 0 ;
}

/*---------------------------------------------------------------------------*/
