/*---------------------------------------------------------------------------*/
/*
   "SINT1A.H"

   Include file containing constants and structures for use with interrupt
	 0x1A functions.

   Version 1.5, Monday November 6, 1995 - 17:13:22.

   Copyright (c) 1993 - 1995 by Mesa Electronics.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Tuesday December 7, 1993 - 22:59:19.

      Code frozen for version 1.0.


   2) Version 1.1, Monday February 14, 1994 - 22:28:16.

	  Changes from version 1.0:
	  1) Level-0 function F_SYSSCUBAUDSELQ added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL).


   3) Version 1.2, Wednesday April 13, 1994 - 00:14:47.

	  Changes from version 1.1:
	  1) Level-0 function F_SYSVIDEOHOOK added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL).  Structure sysvideohook added for use by
		 F_SYSVIDEOHOOK.

	  2) Level-0 function F_SYSCPUREV added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL).  Structure cpurevinfo added for use by F_SYSCPUREV.


   4) Version 1.3, Monday February 6, 1995 - 13:41:13.

	  Changes from version 1.2:
	  1) Level-1 function F_SYSSCANINFO added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL).

	  2) Level-1 function F_SYSSCANINFOQ added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL).

	  3) Enumeration membraneeventid added.

	  4) Structure sysmembranescaninfo added.

	  5) #defines M_MEMBBAKLITEONREQ and M_MEMBBEEPONREQ added.


   5) Version 1.4, Sunday May 7, 1995 - 16:18:19.

	  Changes from version 1.3:
	  1) Structure member sysmembranescaninfo.reservedPtr deleted and
		 replaced by .keyHoldTime and .reserved[].


   6) Version 1.5, Monday November 6, 1995 - 17:13:22.

	  Changes from version 1.4:
	  1) Level-2 function F_SYSATODTYPE added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL), structure sysa2dtypeinfo added.

	  2) Level-2 function F_SYSATODRAWREAD added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL), structure sysa2dread added.

	  3) Level-2 function F_SYSTEMPSENSE added to enum syscntrlfuncs (AH ==
		 F_SPCLSYSCNTRL), structure syscardtemp added.

	  4) E_SYSERRTIMEOUT added to enum syscntrlerrs.
*/
/*---------------------------------------------------------------------------*/

#if !defined H_SINT1A
#define H_SINT1A

/*---------------------------------------------------------------------------*/

/* #defines.
*/
#define SPCLSYSFBASE 135 /* Base number for special system functions. */

/* Masks for use by membrane keyboard event handlers.
*/
#define M_MEMBBAKLITEONREQ (0x1 << 0) /* Backlight turn-on request mask. */
#define M_MEMBBEEPONREQ    (0x1 << 1) /* Membrane keyclick control mask. */

/*---------------------------------------------------------------------------*/

/* Enumerations.
*/

/* Function numbers that are passed in register AH upon invocation of
     interrupt 0x1A in order to invoke Mesa-specific functions.
*/
typedef enum sysfuncsx
{	F_SPCLSYSCNTRL = SPCLSYSFBASE, /* Control-related functions. */
	F_SYSSETUP,                    /* Mesa internal use. */

	MAXSYSFUNC
} sysfuncsx ;


/* Function numbers that are used to access the functions selected by
     sysfuncsx.F_SPCLSYSCNTRL.  (Control-related functions.)
*/
typedef enum syscntrlfuncs
{	/* The following are code revision level 0 functions.
	*/
	F_SYSCNTRLINFOQ = 0, /* Get system control code revision level, etc. */
	F_SYSKBSOURCEQ,      /* Inquire about keyboard source. */
	F_SYSKBREROUTE,      /* Select keyboard source. */
	F_SYSVIDEOSOURCEQ,   /* Inquire about video destination. */
	F_SYSVIDEOREROUTE,   /* Select video destination. */
	F_SYSSCUBAUDSEL,     /* Set V40 SCU baud rate. */
	F_SYSSCUBAUDSELQ,    /* Get current V40 SCU baud rate. */
	F_SYSVIDEOHOOK,      /* Get video code entry point address. */
	F_SYSCPUREV,         /* Get CPU card revision number. */
	F_SYSSHAREDINFO,     /* Mesa internal use. */

	/* The following are code revision level 1 functions.
	*/
	F_SYSSCANINFO,       /* Set membrane keyboard event handler address. */
	F_SYSSCANINFOQ,      /* Get current membrane keyboard event handler address. */

	/* The following are code revision level 2 functions.
	*/
	F_SYSATODTYPE,       /* Get local A-to-D converter type. */
	F_SYSTEMPSENSE,      /* Get current card temperature sensor readout. */
	F_SYSATODRAWREAD,    /* Raw read of A-to-D converter channel. */

	NUMSYSCNTRLFUNCS
} syscntrlfuncs ;


/* Baud rate specifiers used by F_SYSSCUBAUDSEL.
*/
typedef enum sysscubaudrates
{	BAUDSEL_110 = 0, /* 110 baud. */
	BAUDSEL_150,
	BAUDSEL_300,
	BAUDSEL_600,
	BAUDSEL_1200,
	BAUDSEL_1800,
	BAUDSEL_2000,
	BAUDSEL_2400,
	BAUDSEL_3600,
	BAUDSEL_4800,
	BAUDSEL_7200,
	BAUDSEL_9600,
	BAUDSEL_19200,
	BAUDSEL_38400,
	BAUDSEL_57600,
	BAUDSEL_115200,  /* 115.2 Kbaud. */

	NUMBAUDSELS
} sysscubaudrates ;


/* Error codes returned by the functions selected by
     sysfuncsx.F_SPCLSYSCNTRL.  (Control-related functions.)
*/
typedef enum syscntrlerrs
{	E_SYSERRNONE = 0, /* No error. */
	E_SYSERRBADFUNC,  /* Invalid subfunction number. */
	E_SYSERRBADPARM,  /* Invalid parameter. */
	E_SYSERRTIMEOUT,  /* Timeout, probably due to system resource conflict. */

	NUMSYSCNTRLERRS
} syscntrlerrs ;


/* Constants used for specifying various keyboard sources.
*/
typedef enum kbsourceid
{	KBSRC_KEYBOARD = 0,	/* Take input from PC keyboard. */
	KBSRC_SERIAL,       /* Take input from local serial channel. */
	KBSRC_OFF,          /* Turn off serial and PC keyboard input. */

	NUMKBSOURCES
} kbsourceid ;


/* Constants used for specifying various video output destinations.
*/
typedef enum viddestid
{	VIDDEST_VIDEO = 0, /* Send video output to standard video. */
	VIDDEST_SERIAL,    /* Send video output to local serial channel. */
	VIDDEST_LCD,       /* Send video output to local LCD display. */
	VIDDEST_STUB,      /* Send video output to black hole. */

	NUMVIDEODESTS
} viddestid ;


/* Constants used for specifying membrane keyboard events.
*/
typedef enum membraneeventid
{	KSTATE_NONE = 0, /* No event. */
	KSTATE_MAKE,     /* Key make event. */
	KSTATE_BREAK,    /* Key break event. */
	KSTATE_REPEAT,   /* Key repeat event. */

	NUMKSTATES
} membraneeventid ;

/*---------------------------------------------------------------------------*/

/* Structures.
*/

/* Structure used to pass a command to, and receive completion status from,
     sysfuncsx interrupt functions.  This structure is always the first
     element of any interrupt 01AH special function command structure.

   When interrupt 0x1A is invoked, AH must be loaded with a function number
     defined by enumeration sysfuncsx, and CX:BX is loaded with a far pointer
     to one of the following structures that begins with an int1Acmndhdr
     structure.  (CX contains the segment, BX contains the offset.)
*/
typedef struct int1acmndhdr
{	unsigned char commandCode ; /* The command code from the list of syscntrlfuncs. */
	unsigned char errorCode ;   /* The result code from the list of syscntrlerrs. */
} int1acmndhdr ;


/* Structure used to inquire whether the special system control functions
     code is available.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     sysfuncsavailq.commandHeader.commandCode == F_SYSCNTRLINFOQ.)
*/
typedef struct sysfuncsavailq
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char toggleByte ;     /* Gets inverted if there's code to answer. */
	unsigned short revisionLevel ; /* Code revision level. */
} sysfuncsavailq ;


/* Structure used to inquire about keyboard routing and to reroute keyboard
     input.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     syskbreroute.commandHeader.commandCode == F_SYSKBSOURCEQ or
     F_SYSKBREROUTE.)
*/
typedef struct syskbreroute
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char kbSource ;    /* Where keyboard input is to come from. (From enum kbsourceid.) */
	unsigned char membraneToo ; /* Non-zero if input is to be merged with the membrane keyboard. */
} syskbreroute ;


/* Structure used to inquire about display output routing and to reroute
     display output.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     sysvidreroute.commandHeader.commandCode == F_SYSVIDEOSOURCEQ or
     F_SYSVIDEOREROUTE.)
*/
typedef struct sysvidreroute
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char videoDest ;   /* Where video output is to go to. (From enum viddestid.) */
} sysvidreroute ;


/* Structure used to inquire about the current SCU baud rate and select an
     SCU baud rate.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     syssetscubaud.commandHeader.commandCode == F_SYSSCUBAUDSEL or
     F_SYSSCUBAUDSELQ.)
*/
typedef struct syssetscubaud
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char baudSelector ; /* Baud rate selector. One of enum sysscubaudrates. */
} syssetscubaud ;


/* Structure used to get code address of the specified interrupt 0x10 display
     output handler.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     sysvideohook.commandHeader.commandCode == F_SYSVIDEOHOOK.)
*/
typedef struct sysvideohook
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char videoHandler ; /* The video output handler whose address is to be returned. (From enum viddestid.) */
	void far *codeEntryPoint ;   /* The address of the specified video output handler. */
} sysvideohook ;


/* Structure used to inquire about the CPU card's hardware revision level.
     (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     cpurevinfo.commandHeader.commandCode == F_SYSCPUREV.)
*/
typedef struct cpurevinfo
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned char cpuRevNum ; /* 0 for rev. A, 1 for rev. B, etc. */
} cpurevinfo ;


/* Structure used to get and set membrane keyboard scan parameters.
     (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     sysmembranescaninfo.commandHeader.commandCode == F_SYSSCANINFO or
     F_SYSSCANINFOQ.)
*/
typedef struct sysmembranescaninfo
{	int1acmndhdr commandHeader ;      /* Command/status information. */

	unsigned char clickEnable ;       /* Enable generation of key clicks by default (ROMBIOS-resident) scan event handler. */
	unsigned short clickTicks ;       /* Duration of system-generated key click beeps. */
	unsigned short clickDivisor ;     /* Key click beep divisor for system-generated clicks. */

	unsigned short debounceTicks ;    /* Debounce time. */
	unsigned short repeatRateTicks ;  /* Repeat event generation rate. */
	unsigned short repeatDelayTicks ; /* Initial repeat event generation delay. */

	void far *codeEntryPoint ;        /* Address of membrane event handler. */

	unsigned short numKeys ;          /* Number of keys in scan matrix. This field is read-only. */

	unsigned char keyHoldTime ;       /* Key up recognition delay time. (Noise filter.) */

	unsigned char reserved[3] ;       /* Currently unused/reserved. */
} sysmembranescaninfo ;


/* Structure used to read the local digital-to-analog converter type.
     (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
     sysa2dtypeinfo.commandHeader.commandCode == F_SYSATODTYPE.
*/
typedef struct sysa2dtypeinfo
{	int1acmndhdr commandHeader ; /* Command/status information. */

	char far *a2dTypeStringPtr ; /* Pointer to upper case '\0'-terminated string containing converter part number. */
	unsigned short numChannels ; /* Number of accessible channels. */
} sysa2dtypeinfo ;


/* Structure used to read the card temperature sensor.  (Interrupt 0x1A
     register AH == F_SPCLSYSCNTRL,
     syscardtemp.commandHeader.commandCode == F_SYSTEMPSENSE.
*/
typedef struct syscardtemp
{	int1acmndhdr commandHeader ; /* Command/status information. */

	unsigned short cardTemp ;    /* The temperature sensor reading. */
} syscardtemp ;


/* Structure used to read the card temperature sensor.  (Interrupt 0x1A
     register AH == F_SPCLSYSCNTRL,
     sysa2dread.commandHeader.commandCode == F_SYSATODRAWREAD.

   Note that setting .isTimeCritical to non-zero will cause the function to
     return with E_SYSERRTIMEOUT immediately if the A-to-D converter is busy.
     If .isTimeCritical is set to zero, the function will wait until it has
     access to the converter before returning.  All return values are scaled
     to the range 0...65535 -- for a 10-bit converter, bits 0...5 contain
     zero; for a 12 bit converter, bits 0...3 contain zero, and for a 16-bit
     converter all bits are significant.
*/
typedef struct sysa2dread
{	int1acmndhdr commandHeader ;   /* Command/status information. */

	unsigned char isTimeCritical ; /* Non-zero will give up immediately if the A-to-D converter is busy. */

	unsigned char channelNumber ;  /* The converter channel number to be read. */
	unsigned short a2dData ;       /* Returned conversion value. */
} sysa2dread ;

/*---------------------------------------------------------------------------*/

#endif
