/*---------------------------------------------------------------------------*/
/*
   "LINEDEMO.C"

   Demonstration program for the Mesa Electronics 4C22 when used with a
     liquid crystal display.  Draws some lines on the LCD display.

   Version 1.0, Wednesday December 8, 1993 - 17:46:45.
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Wednesday December 8, 1993 - 17:46:45.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <dos.h>
#pragma option -a- /* (Structures must be byte-aligned.) */
#include "sint1a.h"
#include "sint10.h"

/*---------------------------------------------------------------------------*/

#define LINES2DRAW 50 /* Number of lines to draw during demo. */
#define BLINKMOD   12 /* Each BLINKMODth line will blink. */

#define PIXPERLINE 128 /* Number of pixels per image line. */
#define NUMLINES   64  /* Number of image lines. */

/*---------------------------------------------------------------------------*/

/* Function: sint10ctrlcall
   Purpose: Call special interrupt 0x10 control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

signed sint10ctrlcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLVIDCNTRL
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		010H					// Invoke the function.
	}
	return (((((int10cmndhdr far *)parmptr) -> errorCode) != E_DISPNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: sint10grfxcall
   Purpose: Call special interrupt 0x10 control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

signed sint10grfxcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLVIDGRFX
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		010H					// Invoke the function.
	}
	return (((((int10cmndhdr far *)parmptr) -> errorCode) != E_GRFXNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: sint1actrlcall
   Purpose: Call special interrupt 0x1A control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

signed sint1actrlcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLSYSCNTRL
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		01AH					// Invoke the function.
	}
	return (((((int1acmndhdr far *)parmptr) -> errorCode) != E_SYSERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: havespecialint10codeq
   Purpose: Determine whether or not interrupt 0x10 special function code is
     avaible to the programmer.
   Used by: Anyone.
   Returns: Available/not available status.
   Notes:
     -In general, this function need not be called if the CPU is known to
	    support the special interrupt 0x10 functions.
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

int havespecialint10codeq(void)

{	ctrlavailqinfo availinfo ;


	(availinfo . commandHeader . commandCode) = F_DISPCNTRLINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint10ctrlcall(&availinfo) < 0)
	{	return !!0 ; /* Error - code not available. */
	}
	else if((availinfo . toggleByte) != 0xAA)
	{	return !!0 ; /* No toggle of toggle byte - code not available. */
	}
	else
	{	return !0 ; /* Code available. */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: havespecialint1acodeq
   Purpose: Determine whether or not interrupt 0x1A special function code is
     avaible to the programmer.
   Used by: Anyone.
   Returns: Available/not available status.
   Notes:
     -In general, this function need not be called if the CPU is known to
	    support the special interrupt 0x1A functions.
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

int havespecialint1acodeq(void)

{	sysfuncsavailq availinfo ;


	(availinfo . commandHeader . commandCode) = F_SYSCNTRLINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint1actrlcall(&availinfo) < 0)
	{	return !!0 ; /* Error - code not available. */
	}
	else if((availinfo . toggleByte) != 0xAA)
	{	return !!0 ; /* No toggle of toggle byte - code not available. */
	}
	else
	{	return !0 ; /* Code available. */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: drawlines
   Purpose: Draw some lines on the display.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

static void drawlines(void)

{	unsigned i ;

	sysvidreroute rerouteinfo ;

	dispavailqinfo availinfo ;

	drawline1info lineinfo ;


	/* First, see if we have access to the special interrupt 0x1A functions that
	     we need to reroute video.  (In an environment known to support the
	     special interrupt 0x1A functions, this check need not be performed.)
	*/
	if(!havespecialint1acodeq())
	{	fprintf(stderr, "\n\aSpecial interrupt 0x1A function code is not available.\n") ;

		exit(1) ;
	}

	/* Video rerouting is available; try connecting video output to LCD output. */
	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
	(rerouteinfo . videoDest) = VIDDEST_LCD ; /* Video --> LCD. */
	if(sint1actrlcall(&rerouteinfo) < 0)
	{	fprintf(stderr, "\n\aCouldn't reroute video output to LCD display.\n") ;

		exit(1) ;
	}

	/* Video output functions were successfully rerouted to LCD output functions.
	     We must now determine whether we have access to the functions we want.
	     (In an environment known to support the special interrupt 0x10
	     functions, this check need not be performed.)
	*/
	if(!havespecialint10codeq())
	{	/* Oops!  Our video output functions don't seem to be available.  We must now
		     switch back to standard video output in order to be able to report the
		     error condition to the user.
		*/
		(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ; /* (Redundant.) */
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ; /* We hope this works, as there's no other way out of this mess. */

		fprintf(stderr, "\n\aSpecial interrupt 0x10 function code is not available.\n") ;

		exit(1) ;
	}

	/* See if the LCD display is active and available. */
	(availinfo . commandHeader . commandCode) = F_GRFXDISPINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint10grfxcall(&availinfo) < 0)
	{	/* This should never happen. */
		(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aCan't determine display availability.\n") ;

		exit(1) ;
	}
	if((availinfo . toggleByte) != 0xAA)
	{	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aGraphics code doesn't respond to queries.\n") ;

		exit(1) ;
	}
	if(!(availinfo . isAvailable))
	{	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aDisplay isn't available.\n") ;

		exit(1) ;
	}

	/* The LCD display is active and available; draw some lines. */
	(lineinfo . commandHeader . commandCode) = F_GRFXDRAWLINE ;
	(lineinfo . skipFirstDot) = !!0 ;
	(lineinfo . skipLastDot) = !!0 ;
	(lineinfo . lineColor) = !0 ;
	(lineinfo . planeMask) = 0x00 ; /* All planes. */
	for(i = LINES2DRAW ; i > 0 ; i--)
	{	(lineinfo . startPoint . x) = random(PIXPERLINE) ; /* (0...PIXPERLIN-1.) */
		(lineinfo . startPoint . y) = random(NUMLINES) ; /* (0...NUMLINES-1.) */
		(lineinfo . endPoint . x) = random(PIXPERLINE) ;
		(lineinfo . endPoint . y) = random(NUMLINES) ;
		if((i % BLINKMOD) == 0)
		{	(lineinfo . rasterOp) = (RASTEROP_XOR | M_RASTEROPBLINK) ;
		}
		else
		{	(lineinfo . rasterOp) = RASTEROP_XOR ;
		}
		sint10grfxcall(&lineinfo) ; /* (We don't bother to check for errors.) */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: main
   Purpose: Program entry point.
   Used by: Program launcher.
   Returns: Never.
   Notes:
   Revision history:
     1) Wednesday December 8, 1993 - 17:46:45.
*/

int main(unsigned argc, char *argv[])

{	drawlines() ;

	exit(0) ;
}

/*---------------------------------------------------------------------------*/
