/*---------------------------------------------------------------------------*/
/*
   "CHARDEMO.C"

   Demonstration program for the Mesa Electronics 4C22 when used with a
     liquid crystal display.  Draws some text on the LCD display.

   Version 1.0, Sunday January 9, 1994 - 16:36:16.
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Sunday January 9, 1994 - 16:36:16.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <dos.h>
#pragma option -a- /* (Structures must be byte-aligned.) */
#include "sint1a.h"
#include "sint10.h"

/*---------------------------------------------------------------------------*/

#define PIXPERLINE 128 /* Number of pixels per image line. */
#define NUMLINES   64  /* Number of image lines. */

/*---------------------------------------------------------------------------*/

/* Local externals.
*/
static char TheMessage[] = "Gort! Klaatu borada nicto." ;

/*---------------------------------------------------------------------------*/

/* Function: sint10ctrlcall
   Purpose: Call special interrupt 0x10 control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

signed sint10ctrlcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLVIDCNTRL
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		010H					// Invoke the function.
	}
	return (((((int10cmndhdr far *)parmptr) -> errorCode) != E_DISPNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: sint10grfxcall
   Purpose: Call special interrupt 0x10 control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

signed sint10grfxcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLVIDGRFX
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		010H					// Invoke the function.
	}
	return (((((int10cmndhdr far *)parmptr) -> errorCode) != E_GRFXNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: sint1actrlcall
   Purpose: Call special interrupt 0x1A control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

signed sint1actrlcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLSYSCNTRL
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		01AH					// Invoke the function.
	}
	return (((((int1acmndhdr far *)parmptr) -> errorCode) != E_SYSERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: havespecialint10codeq
   Purpose: Determine whether or not interrupt 0x10 special function code is
     avaible to the programmer.
   Used by: Anyone.
   Returns: Available/not available status.
   Notes:
     -In general, this function need not be called if the CPU is known to
	    support the special interrupt 0x10 functions.
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

int havespecialint10codeq(void)

{	ctrlavailqinfo availinfo ;


	(availinfo . commandHeader . commandCode) = F_DISPCNTRLINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint10ctrlcall(&availinfo) < 0)
	{	return !!0 ; /* Error - code not available. */
	}
	else if((availinfo . toggleByte) != 0xAA)
	{	return !!0 ; /* No toggle of toggle byte - code not available. */
	}
	else
	{	return !0 ; /* Code available. */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: havespecialint1acodeq
   Purpose: Determine whether or not interrupt 0x1A special function code is
     avaible to the programmer.
   Used by: Anyone.
   Returns: Available/not available status.
   Notes:
     -In general, this function need not be called if the CPU is known to
	    support the special interrupt 0x1A functions.
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

int havespecialint1acodeq(void)

{	sysfuncsavailq availinfo ;


	(availinfo . commandHeader . commandCode) = F_SYSCNTRLINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint1actrlcall(&availinfo) < 0)
	{	return !!0 ; /* Error - code not available. */
	}
	else if((availinfo . toggleByte) != 0xAA)
	{	return !!0 ; /* No toggle of toggle byte - code not available. */
	}
	else
	{	return !0 ; /* Code available. */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: drawchars
   Purpose: Draw some characters on the display.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

static void drawchars(void)

{	unsigned i, l ;

	sysvidreroute rerouteinfo ;

	dispavailqinfo availinfo ;

	drawcharinfo charinfo ;

	attachfontinfo fontinfo ;


	/* First, see if we have access to the special interrupt 0x1A functions that
	     we need to reroute video.  (In an environment known to support the
	     special interrupt 0x1A functions, this check need not be performed.)
	*/
	if(!havespecialint1acodeq())
	{	fprintf(stderr, "\n\aSpecial interrupt 0x1A function code is not available.\n") ;

		exit(1) ;
	}

	/* Video rerouting is available; try connecting video output to LCD output. */
	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
	(rerouteinfo . videoDest) = VIDDEST_LCD ; /* Video --> LCD. */
	if(sint1actrlcall(&rerouteinfo) < 0)
	{	fprintf(stderr, "\n\aCouldn't reroute video output to LCD display.\n") ;

		exit(1) ;
	}

	/* Video output functions were successfully rerouted to LCD output functions.
	     We must now determine whether we have access to the functions we want.
	     (In an environment known to support the special interrupt 0x10
	     functions, this check need not be performed.)
	*/
	if(!havespecialint10codeq())
	{	/* Oops!  Our video output functions don't seem to be available.  We must now
		     switch back to standard video output in order to be able to report the
		     error condition to the user.
		*/
		(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ; /* (Redundant.) */
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ; /* We hope this works, as there's no other way out of this mess. */

		fprintf(stderr, "\n\aSpecial interrupt 0x10 function code is not available.\n") ;

		exit(1) ;
	}

	/* See if the LCD display is active and available. */
	(availinfo . commandHeader . commandCode) = F_GRFXDISPINFOQ ;
	(availinfo . toggleByte) = 0x55 ;
	if(sint10grfxcall(&availinfo) < 0)
	{	/* This should never happen. */
		(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aCan't determine display availability.\n") ;

		exit(1) ;
	}
	if((availinfo . toggleByte) != 0xAA)
	{	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aGraphics code doesn't respond to queries.\n") ;

		exit(1) ;
	}
	if(!(availinfo . isAvailable))
	{	(rerouteinfo . commandHeader . commandCode) = F_SYSVIDEOREROUTE ;
		(rerouteinfo . videoDest) = VIDDEST_VIDEO ; /* Video --> video. */
		sint1actrlcall(&rerouteinfo) ;

		fprintf(stderr, "\n\aDisplay isn't available.\n") ;

		exit(1) ;
	}
	if((availinfo . revisionLevel) < 1)
	{	/* The ROMBIOS graphics code is pre-level 1; since F_GRFXDRAWCHAR is a level
		     1 function, we can't perform the operation.
		*/
		fprintf(stderr, "\n\aGraphics code doesn't doesn't support level 1 functions.\n") ;

		exit(1) ;
	}

	/* The LCD display is active and available; draw some characters.

	   Note that we use the default non-TTY font that was selected when the LCD
	     display was initialized.
	*/
	(fontinfo . commandHeader . commandCode) = F_GRFXNTFONTINFOGET ; /* Non-TTY font information. */
	sint10grfxcall(&fontinfo) ; /* (We don't bother to check for errors.) */

	(charinfo . commandHeader . commandCode) = F_GRFXDRAWCHAR ;
	(charinfo . planeMask) = 0x00 ; /* All planes. */
	(charinfo . destPoint . x) = 0 ;
	(charinfo . destPoint . y) = 0 ;
	for(l = i = 0 ; ; i++)
	{	(charinfo . theChar) = TheMessage[i] ;
		if((charinfo . theChar) == '\0')
		{	break ;
		}
		else if((charinfo . theChar) == ' ')
		{	l++ ;
			(charinfo . destPoint . x) = 0 ;
			(charinfo . destPoint . y) = (l * (fontinfo . charHeight)) ;
		}
		else
		{	(charinfo . rasterOp) = RASTEROP_REP ;
			sint10grfxcall(&charinfo) ; /* (We don't bother to check for errors.) */

			(charinfo . destPoint . x) += (unsigned short)(fontinfo . charWidth) ;
			(charinfo . destPoint . y) += 2 ;
		}
	}
}

/*---------------------------------------------------------------------------*/

/* Function: main
   Purpose: Program entry point.
   Used by: Program launcher.
   Returns: Never.
   Notes:
   Revision history:
     1) Sunday January 9, 1994 - 16:36:16.
*/

int main(unsigned argc, char *argv[])

{	drawchars() ;

	exit(0) ;
}

/*---------------------------------------------------------------------------*/
