/*---------------------------------------------------------------------------*/
/*
   "BKLTDEMO.C"

   Mesa Electronics FPXX backlight/contrast control demo.

   Version 1.0, Friday December 19, 1997 -- 13:38:27.
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Friday December 19, 1997 -- 13:38:27.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <limits.h>
#include <dos.h>
#include "biosid.h"
#include "pcpusrvc.h"

/*---------------------------------------------------------------------------*/

/* Function: pubservicecall
   Purpose: Call our public services code.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static signed pubservicecall(void far *parmptr)

{
	static unsigned char far *servicevec = MK_FP(ROMBIOSIDSEG, (ROMBIOSIDOFF + offsetof(rombiosid, jmp2PublicServices))) ;


	asm {
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far pointer.
				call	dword ptr [servicevec]	// Call the CPU public services code.
				cld								// (Just in case.)
	}
	return (((((pfuncshdr far *)parmptr) -> errorCode) != E_PUBSRVCERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: checkcpu
   Purpose: Determine whether we're running on the required CPU card.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void checkcpu(void)

{
	static const char *idmsg = BIOSIDMSG ;

	unsigned i ;

	rombiosid const far *idptr = MK_FP(ROMBIOSIDSEG, ROMBIOSIDOFF) ;


	for(i = 0 ; ; i++)
	{
		if(idmsg[i] == '\0')
		{
			break ;
		}
		if(idmsg[i] != (idptr -> sysMsg[i]))
		{
			fprintf(stderr, "\n\aIncorrect CPU card.\n") ;

			exit(1) ;
		}
	}
}

/*---------------------------------------------------------------------------*/

/* Function: publicapicheck
   Purpose: Make sure that the system ROMBIOS supports public API functions.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void publicapicheck(void)

{
	pubfuncsavailq funcsinfo ;


	(funcsinfo . toggleByte) = 0x55 ;
	(funcsinfo . commandHeader . commandCode) = F_PUBSRVCINFOQ ;
	if(pubservicecall(&funcsinfo) < 0)
	{
		fprintf(stderr, "\n\aPublic services code not supported.\n") ;

		exit(1) ;
	}
	if((funcsinfo . toggleByte) != 0xAA)
	{
		fprintf(stderr, "\n\aPublic services code doesn't respond.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: check4lcddisplay
   Purpose: Make sure the LCD display is operational.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void waitticks(unsigned howlong)

{
	unsigned long currtime, prevtime, stoptime ;

	static const unsigned long far *ticktimerptr = MK_FP(0x0040, 0x006C) ;


	disable() ;
	prevtime = *ticktimerptr ;
	stoptime = (prevtime + (unsigned long)howlong) ;
	for( ; ; )
	{
		disable() ;
		currtime = *ticktimerptr ;
		if(currtime < prevtime)
		{
			if(stoptime < 1573040UL)
			{
				break ;
			}
			stoptime -= 1573040UL ;
		}
		enable() ;

		if(currtime >= stoptime)
		{
			break ;
		}

		prevtime = currtime ;
	}

	enable() ;
}

/*---------------------------------------------------------------------------*/

/* Function: getcontrast
   Purpose: Read the current display contrast setting.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static unsigned short getcontrast(void)

{
	pubdispcontrast contrastinfo ;


	(contrastinfo . commandHeader . commandCode) = F_PUBSRVCDISPCONTRASTQ ;
	if(pubservicecall(&contrastinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't read display contrast.\n") ;

		exit(1) ;
	}

	return (contrastinfo . displayContrastPercent) ;
}

/*---------------------------------------------------------------------------*/

/* Function: setcontrast
   Purpose: Set the display contrast.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void setcontrast(unsigned short contrast)

{
	pubdispcontrast contrastinfo ;


	(contrastinfo . commandHeader . commandCode) = F_PUBSRVCDISPCONTRAST ;
	(contrastinfo . displayContrastPercent) = contrast ;
	if(pubservicecall(&contrastinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't set display contrast.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: gettimeout
   Purpose: Read the current display timeout.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static unsigned short gettimeout(void)

{
	pubdisptimeout timeoutinfo ;


	(timeoutinfo . commandHeader . commandCode) = F_PUBSRVCDISPTIMEOUTQ ;
	if(pubservicecall(&timeoutinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't read display timeout.\n") ;

		exit(1) ;
	}

	return (timeoutinfo . timeOut) ;
}

/*---------------------------------------------------------------------------*/

/* Function: settimeout
   Purpose: Set the display timeout.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void settimeout(unsigned short timeout)

{
	pubdisptimeout timeoutinfo ;


	(timeoutinfo . commandHeader . commandCode) = F_PUBSRVCDISPTIMEOUT ;
	(timeoutinfo . timeOut) = timeout ;
	if(pubservicecall(&timeoutinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't set display timeout.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: adjuststuff
   Purpose: Make some display adjustments.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

static void adjuststuff(void)

{
	unsigned long timeout ;

	unsigned short contrast, newcontrast ;


	/* Display current backlight settings.
	*/
	contrast = getcontrast() ;
	timeout = (unsigned long)gettimeout() ;
	printf("\nCurrent contrast: %hu", contrast) ;
	printf("\nCurrent timeout:  %lu ticks(s)\n", timeout) ;

	/* Adjust display-related settings.
	*/
	newcontrast = (contrast - (contrast / 33)) ;

	if((timeout += (1092 + 1)) > USHRT_MAX)
	{
		timeout = USHRT_MAX ;
	}
	settimeout((unsigned short)timeout) ;
	printf("\nTimeout set to %lu tick(s).", timeout) ;

	printf("\nSetting contrast to %hu...", newcontrast) ;
	setcontrast(newcontrast) ; /* Change the contrast. */
	waitticks(73) ;
	printf("\nRestoring contrast to %hu...", contrast) ;
	setcontrast(contrast) ; /* Restore the contrast. */
	waitticks(73) ;
}

/*---------------------------------------------------------------------------*/

/* Function: main
   Purpose: Program entry point.
   Used by: Program launcher.
   Returns: Never.
   Notes:
   Revision history:
     1) Friday December 19, 1997 -- 13:38:27.
*/

int main(unsigned argc, char *argv[])

{
	checkcpu() ;
	publicapicheck() ;

	adjuststuff() ;

	printf("\n\nThat's all, folks.\n") ;

	exit(0) ;
}

/*---------------------------------------------------------------------------*/
