/*---------------------------------------------------------------------------*/
/*
   "A2DDEMO.C"

   Demonstration program for the Mesa Electronics FPCX.  Demonstrates usage
	 of A-to-D converter API functions.

   Version 1.0, Tuesday April 30, 1996 -- 13:53:02.

   (Tabs == 4.)
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Tuesday April 30, 1996 -- 13:53:02.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#pragma option -a- /* (Structures must be byte-aligned.) */
#include "sint1a.h"

/*---------------------------------------------------------------------------*/

/* Function: sint1actrlcall
   Purpose: Call interrupt 0x1A CPU control functions.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Tuesday April 30, 1996 -- 13:53:02.
*/

static signed sint1actrlcall(void far *parmptr)

{	asm {
				mov		ah,F_SPCLSYSCNTRL
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far ptr.
				int		01AH					// Invoke the function.
	}
	return (((((int1acmndhdr far *)parmptr) -> errorCode) != E_SYSERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: a2dchannelsq
   Purpose: Determine the number of A-to-D converter channels.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
	 -Failure status is most likely caused by use of a pre-version 1.0a
		ROMBIOS.
   Revision history:
     1) Tuesday April 30, 1996 -- 13:53:02.
*/

static signed a2dchannelsq(unsigned *numchannels)

{
	sysa2dtypeinfo a2dinfo ;


	(a2dinfo . commandHeader . commandCode) = F_SYSATODTYPE ;
	if(sint1actrlcall(&a2dinfo) >= 0)
	{
		*numchannels = (a2dinfo . numChannels) ;

		return 0 ; /* Success. */
	}
	else
	{
		return -1 ; /* Bummer. */
	}
}

/*---------------------------------------------------------------------------*/

/* Function: reada2d
   Purpose: Read the specified A-to-D converter channel.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
     -Failure status is most likely caused by an invalid channel number.
   Revision history:
     1) Tuesday April 30, 1996 -- 13:53:02.
*/

static signed reada2d(unsigned char channel, unsigned short *conv)

{
	sysa2dread readinfo ;


	(readinfo . commandHeader . commandCode) = F_SYSATODRAWREAD ;
	(readinfo . isTimeCritical) = !!0 ; /* Wait for however long it takes. */
	(readinfo . channelNumber) = channel ;
	if(sint1actrlcall(&readinfo) >= 0)
	{
		*conv = (readinfo . a2dData) ;

		return 0 ; /* Success. */
	}
	else
	{
		return -1 ; /* Bummer. */
	}
}

/*---------------------------------------------------------------------------*/

int main(int argc, char *argv[])

{
	unsigned short conversion ;

	unsigned
		i,
		linemod,
		numchannels ;


	printf("\nA-to-D converter read API demo.") ;

	/* Get the number of converter channels.
	*/
	if(a2dchannelsq(&numchannels) < 0)
	{
		printf("\n\aCan't determine number of A-to-D converter channels.\n") ;

		return 1 ;
	}

	/* Display A-to-D conversions until the user types control-C.
	*/
	printf("\nType control-C to quit.") ;

	linemod = (numchannels / 3) ;
	for(i = 0 ; ; i++)
	{
		if((i %= numchannels) == 0)
		{
			putchar('\n') ;
		}
		if((i % linemod) == 0)
		{
			putchar('\n') ;
		}

		if(reada2d(i, &conversion) < 0)
		{
			printf("\n\aConverter channel %u read failed.\n", i) ;

			return 1 ;
		}
		else
		{
			printf("%2u: %-6hu", i, conversion) ;
		}
	}

	return 0 ;
}

/*---------------------------------------------------------------------------*/
