
option expr32
option casemap:none

IFNDEF	sint1a_inc
sint1a_inc	EQU		1

; Begin of file ..\include\sint1a.h
; ---------------------------------------------------------------------------
; 
;    "SINT1A.H"
; 
;    Include file containing constants and structures for use with interrupt
; 	 0x1A functions.
; 
;    Version 1.4, Sunday May 7, 1995 - 16:18:19.
; 
;    Copyright (c) 1993 - 1995 by Mesa Electronics.
; 
; ---------------------------------------------------------------------------
; 
;    Revision history.
; 
;    1) Version 1.0, Tuesday December 7, 1993 - 22:59:19.
; 
;       Code frozen for version 1.0.
; 
; 
;    2) Version 1.1, Monday February 14, 1994 - 22:28:16.
; 
; 	  Changes from version 1.0:
; 	  1) Level-0 function F_SYSSCUBAUDSELQ added to enum syscntrlfuncs (AH ==
; 		 F_SPCLSYSCNTRL).
; 
; 
;    3) Version 1.2, Wednesday April 13, 1994 - 00:14:47.
; 
; 	  Changes from version 1.1:
; 	  1) Level-0 function F_SYSVIDEOHOOK added to enum syscntrlfuncs (AH ==
; 		 F_SPCLSYSCNTRL).  Structure sysvideohook added for use by
; 		 F_SYSVIDEOHOOK.
; 
; 	  2) Level-0 function F_SYSCPUREV added to enum syscntrlfuncs (AH ==
; 		 F_SPCLSYSCNTRL).  Structure cpurevinfo added for use by F_SYSCPUREV.
; 
; 
;    4) Version 1.3, Monday February 6, 1995 - 13:41:13.
; 
; 	  Changes from version 1.2:
; 	  1) Level-1 function F_SYSSCANINFO added to enum syscntrlfuncs (AH ==
; 		 F_SPCLSYSCNTRL).
; 
; 	  2) Level-1 function F_SYSSCANINFOQ added to enum syscntrlfuncs (AH ==
; 		 F_SPCLSYSCNTRL).
; 
; 	  3) Enumeration membraneeventid added.
; 
; 	  4) Structure sysmembranescaninfo added.
; 
; 	  5) #defines M_MEMBBAKLITEONREQ and M_MEMBBEEPONREQ added.
; 
; 
;    5) Version 1.4, Sunday May 7, 1995 - 16:18:19.
; 
; 	  Changes from version 1.3:
; 	  1) Structure member sysmembranescaninfo.reservedPtr deleted and
; 		 replaced by .keyHoldTime and .reserved[].
; 
; ---------------------------------------------------------------------------
H_SINT1A		TEXTEQU		<>
; ---------------------------------------------------------------------------
;  #defines.
; 
;  Base number for special system functions. 
SPCLSYSFBASE		EQU		135t
;  Masks for use by membrane keyboard event handlers.
; 
;  Backlight turn-on request mask. 
M_MEMBBAKLITEONREQ		EQU		000000001h
;  Membrane keyclick control mask. 
M_MEMBBEEPONREQ		EQU		000000002h
; ---------------------------------------------------------------------------
;  Enumerations.
; 
;  Function numbers that are passed in register AH upon invocation of
;      interrupt 0x1A in order to invoke Mesa-specific functions.
; 
F_SPCLSYSCNTRL		EQU		135t
;  Control-related functions. 
F_SYSSETUP		EQU		136t
;  Mesa internal use. 
MAXSYSFUNC		EQU		137t

sysfuncsx		TYPEDEF		SWORD

;  Function numbers that are used to access the functions selected by
;      sysfuncsx.F_SPCLSYSCNTRL.  (Control-related functions.)
; 
;  The following are code revision level 0 functions.
; 	
F_SYSCNTRLINFOQ		EQU		0t
;  Get system control code revision level, etc. 
F_SYSKBSOURCEQ		EQU		1t
;  Inquire about keyboard source. 
F_SYSKBREROUTE		EQU		2t
;  Select keyboard source. 
F_SYSVIDEOSOURCEQ		EQU		3t
;  Inquire about video destination. 
F_SYSVIDEOREROUTE		EQU		4t
;  Select video destination. 
F_SYSSCUBAUDSEL		EQU		5t
;  Set V40 SCU baud rate. 
F_SYSSCUBAUDSELQ		EQU		6t
;  Get current V40 SCU baud rate. 
F_SYSVIDEOHOOK		EQU		7t
;  Get video code entry point address. 
F_SYSCPUREV		EQU		8t
;  Get CPU card revision number. 
F_SYSSHAREDINFO		EQU		9t
;  Mesa internal use. 
;  The following are code revision level 1 functions.
; 	
F_SYSSCANINFO		EQU		10t
;  Set membrane keyboard event handler address. 
F_SYSSCANINFOQ		EQU		11t
;  Get current membrane keyboard event handler address. 
NUMSYSCNTRLFUNCS		EQU		12t

syscntrlfuncs		TYPEDEF		SWORD

;  Baud rate specifiers used by F_SYSSCUBAUDSEL.
; 
BAUDSEL_110		EQU		0t
;  110 baud. 
BAUDSEL_150		EQU		1t
BAUDSEL_300		EQU		2t
BAUDSEL_600		EQU		3t
BAUDSEL_1200		EQU		4t
BAUDSEL_1800		EQU		5t
BAUDSEL_2000		EQU		6t
BAUDSEL_2400		EQU		7t
BAUDSEL_3600		EQU		8t
BAUDSEL_4800		EQU		9t
BAUDSEL_7200		EQU		10t
BAUDSEL_9600		EQU		11t
BAUDSEL_19200		EQU		12t
BAUDSEL_38400		EQU		13t
BAUDSEL_57600		EQU		14t
BAUDSEL_115200		EQU		15t
;  115.2 Kbaud. 
NUMBAUDSELS		EQU		16t

sysscubaudrates		TYPEDEF		SWORD

;  Error codes returned by the functions selected by
;      sysfuncsx.F_SPCLSYSCNTRL.  (Control-related functions.)
; 
E_SYSERRNONE		EQU		0t
;  No error. 
E_SYSERRBADFUNC		EQU		1t
;  Invalid subfunction number. 
E_SYSERRBADPARM		EQU		2t
;  Invalid parameter. 
NUMSYSCNTRLERRS		EQU		3t

syscntrlerrs		TYPEDEF		SWORD

;  Constants used for specifying various keyboard sources.
; 
KBSRC_KEYBOARD		EQU		0t
;  Take input from PC keyboard. 
KBSRC_SERIAL		EQU		1t
;  Take input from local serial channel. 
KBSRC_OFF		EQU		2t
;  Turn off serial and PC keyboard input. 
NUMKBSOURCES		EQU		3t

kbsourceid		TYPEDEF		SWORD

;  Constants used for specifying various video output destinations.
; 
VIDDEST_VIDEO		EQU		0t
;  Send video output to standard video. 
VIDDEST_SERIAL		EQU		1t
;  Send video output to local serial channel. 
VIDDEST_LCD		EQU		2t
;  Send video output to local LCD display. 
VIDDEST_STUB		EQU		3t
;  Send video output to black hole. 
NUMVIDEODESTS		EQU		4t

viddestid		TYPEDEF		SWORD

;  Constants used for specifying membrane keyboard events.
; 
KSTATE_NONE		EQU		0t
;  No event. 
KSTATE_MAKE		EQU		1t
;  Key make event. 
KSTATE_BREAK		EQU		2t
;  Key break event. 
KSTATE_REPEAT		EQU		3t
;  Key repeat event. 
NUMKSTATES		EQU		4t

membraneeventid		TYPEDEF		SWORD

; ---------------------------------------------------------------------------
;  Structures.
; 
;  Structure used to pass a command to, and receive completion status from,
;      sysfuncsx interrupt functions.  This structure is always the first
;      element of any interrupt 01AH special function command structure.
; 
;    When interrupt 0x1A is invoked, AH must be loaded with a function number
;      defined by enumeration sysfuncsx, and CX:BX is loaded with a far pointer
;      to one of the following structures that begins with an int1Acmndhdr
;      structure.  (CX contains the segment, BX contains the offset.)
; 
;  The command code from the list of syscntrlfuncs. 
;  The result code from the list of syscntrlerrs. 
int1acmndhdr		STRUCT 1t
commandCode		BYTE		?
errorCode		BYTE		?
int1acmndhdr		ENDS

;  Structure used to inquire whether the special system control functions
;      code is available.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      sysfuncsavailq.commandHeader.commandCode == F_SYSCNTRLINFOQ.)
; 
;  Command/status information. 
;  Gets inverted if there's code to answer. 
;  Code revision level. 
sysfuncsavailq		STRUCT 1t
commandHeader		int1acmndhdr		<>
toggleByte		BYTE		?
revisionLevel		WORD		?
sysfuncsavailq		ENDS

;  Structure used to inquire about keyboard routing and to reroute keyboard
;      input.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      syskbreroute.commandHeader.commandCode == F_SYSKBSOURCEQ or
;      F_SYSKBREROUTE.)
; 
;  Command/status information. 
;  Where keyboard input is to come from. (From enum kbsourceid.) 
;  Non-zero if input is to be merged with the membrane keyboard. 
syskbreroute		STRUCT 1t
commandHeader		int1acmndhdr		<>
kbSource		BYTE		?
membraneToo		BYTE		?
syskbreroute		ENDS

;  Structure used to inquire about display output routing and to reroute
;      display output.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      sysvidreroute.commandHeader.commandCode == F_SYSVIDEOSOURCEQ or
;      F_SYSVIDEOREROUTE.)
; 
;  Command/status information. 
;  Where video output is to go to. (From enum viddestid.) 
sysvidreroute		STRUCT 1t
commandHeader		int1acmndhdr		<>
videoDest		BYTE		?
sysvidreroute		ENDS

;  Structure used to inquire about the current SCU baud rate and select an
;      SCU baud rate.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      syssetscubaud.commandHeader.commandCode == F_SYSSCUBAUDSEL or
;      F_SYSSCUBAUDSELQ.)
; 
;  Command/status information. 
;  Baud rate selector. One of enum sysscubaudrates. 
syssetscubaud		STRUCT 1t
commandHeader		int1acmndhdr		<>
baudSelector		BYTE		?
syssetscubaud		ENDS

;  Structure used to get code address of the specified interrupt 0x10 display
;      output handler.  (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      sysvideohook.commandHeader.commandCode == F_SYSVIDEOHOOK.)
; 
;  Command/status information. 
;  The video output handler whose address is to be returned. (From enum viddestid.) 
@t_sint1a0		TYPEDEF		FAR PTR 
;  The address of the specified video output handler. 
sysvideohook		STRUCT 1t
commandHeader		int1acmndhdr		<>
videoHandler		BYTE		?
codeEntryPoint		@t_sint1a0		?
sysvideohook		ENDS

;  Structure used to inquire about the CPU card's hardware revision level.
;      (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      cpurevinfo.commandHeader.commandCode == F_SYSCPUREV.)
; 
;  Command/status information. 
;  0 for rev. A, 1 for rev. B, etc. 
cpurevinfo		STRUCT 1t
commandHeader		int1acmndhdr		<>
cpuRevNum		BYTE		?
cpurevinfo		ENDS

;  Structure used to get and set membrane keyboard scan parameters.
;      (Interrupt 0x1A register AH == F_SPCLSYSCNTRL,
;      sysmembranescaninfo.commandHeader.commandCode == F_SYSSCANINFO or
;      F_SYSSCANINFOQ.)
; 
;  Command/status information. 
;  Enable generation of key clicks by default (ROMBIOS-resident) scan event handler. 
;  Duration of system-generated key click beeps. 
;  Key click beep divisor for system-generated clicks. 
;  Debounce time. 
;  Repeat event generation rate. 
;  Initial repeat event generation delay. 
@t_sint1a1		TYPEDEF		FAR PTR 
;  Address of membrane event handler. 
;  Number of keys in scan matrix. This field is read-only. 
;  Key up recognition delay time. (Noise filter.) 
;  Currently unused/reserved. 
sysmembranescaninfo		STRUCT 1t
commandHeader		int1acmndhdr		<>
clickEnable		BYTE		?
clickTicks		WORD		?
clickDivisor		WORD		?
debounceTicks		WORD		?
repeatRateTicks		WORD		?
repeatDelayTicks		WORD		?
codeEntryPoint		@t_sint1a1		?
numKeys		WORD		?
keyHoldTime		BYTE		?
reserved		BYTE		3t DUP (?)
sysmembranescaninfo		ENDS

; ---------------------------------------------------------------------------
; End of file ..\include\sint1a.h

ENDIF

