
option expr32
option casemap:none

IFNDEF	sint10_inc
sint10_inc	EQU		1

; Begin of file ..\include\sint10.h
; ---------------------------------------------------------------------------
; 
;    "SINT10.H"
; 
;    Include file containing rasterop constants and structures for use with
; 	 interrupt 0x10 functions.
; 
;    Version 1.4, Monday February 6, 1995 - 13:21:07.
; 
;    Copyright (c) 1993 - 1995 by Mesa Electronics.
; 
; ---------------------------------------------------------------------------
; 
;    Revision history.
; 
;    1) Version 1.0, Tuesday December 7, 1993 - 22:59:19.
; 
;       Code frozen for version 1.0.
; 
; 
;    2) Version 1.1, Saturday January 8, 1994 - 23:39:44.
; 
; 	  Changes from version 1.0:
; 	  1) Level-1 functions added to enum grfxfuncs (AH == F_SPCLVIDGRFX):
; 		 a) F_GRFXATTACHNTFONT uses the existing attachfontinfo structure to
; 			specify the font to be used as the non-TTY font.
; 
; 		 b) F_GRFXDRAWCHAR uses the newly-added drawcharinfo structure to
; 			draw the specified character from the non-TTY font at the
; 			specified absolute pixel coordinate on the LCD screen.
; 
; 		 c) F_GRFXSAVEREGNSIZEQ uses the newly-added dispregnsavesize
; 			structure to inquire how much memory is required to save the
; 			specified region of the LCD display.
; 
; 		 d) F_GRFXSAVEREGN uses the newly-added dispregnsave structure to
; 			save the specified region of the LCD display to the specified
; 			memory buffer.
; 
; 		 e) F_GRFXUNSAVEREGN uses the newly-added dispregnunsave structure to
; 			restore a previously-saved region of the LCD display.
; 
; 
;    3) Version 1.2, Tuesday April 12, 1994 - 12:13:04.
; 
; 	  Changes from version 1.1:
; 	  1) Level-2 functions added to enum grfxfuncs (AH == F_SPCLVIDGRFX):
; 		 a) F_GRFXSHOWPLANE switches the display to show only a specific
; 		    plane.
; 
; 
;    4) Version 1.3, Sunday January 29, 1995 - 14:59:08.
; 
;       Changes from version 1.2:
; 	  1) bitbltinfo comment header updated.
; 	  2) unbitbltinfo structure added.
; 
; 
;    5) Version 1.4, Monday February 6, 1995 - 13:21:07.
; 
;       Changes from version 1.3:
; 	  1) Level-3 functions added to enum grfxfuncs (AH == F_SPCLVIDGRFX):
; 		 a) F_GRFXUNBITBLTB is an alternate function number for
; 			F_GRFXUNBITBLT, but is classified as a level-3 function, so user
; 			code can use F_GRFXDISPINFOQ to check for its presence rather
; 			than having to run a test on F_GRFXUNBITBLT.
; 
; 		 b) F_GRFXTTYCHARLOCQ translates a TTY region-relative rectangular
; 		    region location into absolute pixel coordinates.
; 
; ---------------------------------------------------------------------------
H_SINT10		TEXTEQU		<>
; ---------------------------------------------------------------------------
;  #defines.
; 
;  Base number for special video functions. 
SPCLVIDFBASE		EQU		000000080h
;  Blink flag for rasterops fields. 
M_RASTEROPBLINK		EQU		000000080h
; ---------------------------------------------------------------------------
;  Enumerations.
; 
;  Function numbers that are passed in register AH upon invocation of
;      interrupt 0x10 in order to invoke Mesa-specific functions.
; 
F_SPCLVIDCNTRL		EQU		128t
;  Interrupt 0x10 control-related function selector. 
F_SPCLVIDGRFX		EQU		129t
;  Interrupt 0x10 graphics-related function selector. 
MAXVIDFUNC		EQU		130t

vidfuncsx		TYPEDEF		SWORD

;  Function numbers that are used to access the functions selected by
;      vidfuncsx.F_SPCLVIDCNTRL.  (Control-related functions.)
; 
;  The following are code revision level 0 functions.
; 	
F_DISPCNTRLINFOQ		EQU		0t
;  Get display control code revision level, etc. 
F_DISPCHECKSETUP		EQU		1t
;  Validate setup parameters. 
F_DISPRSVD0		EQU		2t
;  Reserved. 
F_DISPINIT		EQU		3t
;  Activate the LCD display. 
F_DISPMODEGET		EQU		4t
;  Get display operating modes information. 
F_DISPMODESET		EQU		5t
;  Set display operating mode. 
F_DISPRSVD1		EQU		6t
;  Reserved. 
F_DISPRSVD2		EQU		7t
F_DISPRSVD3		EQU		8t
F_DISPRSVD4		EQU		9t
F_DISPGETBUFPTR		EQU		10t
;  Get segment of display buffer. 
F_DISPSETBUFPTR		EQU		11t
;  Set segment of display buffer. 
F_DISPSTATEGET		EQU		12t
;  Get display on/off state information. 
F_DISPSTATESET		EQU		13t
;  Set display on/off state. 
F_DISPBKLTSTATEGET		EQU		14t
;  Get display backlight on/off state. 
F_DISPBKLTSTATESET		EQU		15t
;  Set display backlight on/off state. 
F_DISPCONTRASTGET		EQU		16t
;  Get current display contrast setting. 
F_DISPCONTRASTSET		EQU		17t
;  Set display contrast. 
NUMDISPCNTRLFUNCS		EQU		18t

dispcntrlfuncs		TYPEDEF		SWORD

;  Error codes returned by the functions selected by
;      vidfuncsx.F_SPCLVIDCNTRL.  (Control-related functions.)
; 
E_DISPNONE		EQU		0t
;  No error. 
E_DISPBADFUNC		EQU		1t
;  Invalid subfunction number. 
E_DISPBADPARM		EQU		2t
;  Invalid parameter. 
NUMDISPCNTRLERRS		EQU		3t

spcldisperrs		TYPEDEF		SWORD

;  Function numbers that are used to access the functions selected by
;      vidfuncsx.F_SPCLVIDGRFX.  (Graphics-related functions.)
; 
;  The following are code revision level 0 functions.
; 	
F_GRFXDISPINFOQ		EQU		0t
;  Get graphics code revision level, etc. 
F_GRFXDISPDIMQ		EQU		1t
;  Get display dimensions. 
F_GRFXTTYINFOGET		EQU		2t
;  Get TTY region information. 
F_GRFXTTYINFOSET		EQU		3t
;  Set TTY region information. 
F_GRFXCRSRXABLQ		EQU		4t
;  Get cursor xable state information. 
F_GRFXCRSRXABL		EQU		5t
;  Xable cursor display. 
F_GRFXTTYPATGET		EQU		6t
;  Get TTY region fill pattern. 
F_GRFXTTYPATSET		EQU		7t
;  Set TTY region fill pattern. 
F_GRFXPATGET		EQU		8t
;  Get non-TTY region fill pattern. 
F_GRFXPATSET		EQU		9t
;  Set non-TTY region fill pattern. 
F_GRFXERASEREGN		EQU		10t
;  Erase a rectangular region. 
F_GRFXDRAWDOT		EQU		11t
;  Draw a dot. 
F_GRFXDRAWLINE		EQU		12t
;  Draw a single-pixel line. 
F_GRFXBITBLT		EQU		13t
;  BitBLT to rectangular screen region. 
F_GRFXUNBITBLT		EQU		14t
;  BitBLT from rectangular screen region. 
F_GRFXERASETTY		EQU		15t
;  Erase the TTY region. 
F_GRFXERASENONTTY		EQU		16t
;  Erase the non-TTY region. 
F_GRFXSETTTYDIM		EQU		17t
;  Set TTY region location/dimensions by point and size. 
F_GRFXFONTINFOGET		EQU		18t
;  Get information about ROMBIOS-resident TTY fonts. 
F_GRFXATTACHFONT		EQU		19t
;  Specify the font to be used as the TTY font. 
F_GRFXSELFONT		EQU		20t
;  Select TTY font by number. 
F_GRFXSETTTYLOC		EQU		21t
;  Set TTY region location/dimensions by rectangular region. 
;  The following are code revision level 1 functions.
; 	
F_GRFXTFONTINFOGET		EQU		22t
;  Get information about the current TTY font. 
F_GRFXNTFONTINFOGET		EQU		23t
;  Get information about the current non-TTY font. 
F_GRFXATTACHNTFONT		EQU		24t
;  Specify the font to be the non-TTY font. 
F_GRFXDRAWCHAR		EQU		25t
;  Draw a character from the non-TTY font at the specified pixel coordinate. 
F_GRFXSAVEREGNSIZEQ		EQU		26t
;  Get size of buffer required to save the specified LCD display region image. 
F_GRFXSAVEREGN		EQU		27t
;  Save specified LCD display region image to buffer. 
F_GRFXUNSAVEREGN		EQU		28t
;  Restore saved LCD display region from buffer to display. 
;  The following are code revision level 2 functions.
; 	
F_GRFXSHOWPLANE		EQU		29t
;  Display specific plane. 
;  The following are code revision level 3 functions.
; 	
F_GRFXUNBITBLTB		EQU		30t
;  Alternate access to F_GRFXUNBITBLT, which was unimplemented before level 3. 
F_GRFXTTYCHARLOCQ		EQU		31t
;  Translate from TTY character region to absolute pixel coordinates. 
NUMGRFXFUNCS		EQU		32t

grfxfuncs		TYPEDEF		SWORD

;  Error codes returned by the functions selected by vidfuncsx.F_SPCLVIDGRFX.
;      (Graphics-related functions.)
; 
E_GRFXNONE		EQU		0t
;  No error. 
E_GRFXBADFUNC		EQU		1t
;  Invalid subfunction number. 
E_GRFXBADPARM		EQU		2t
;  Invalid parameter. 
E_GRFXBADCOORD		EQU		3t
;  One or more invalid coordinates. 
E_GRFXBADPLANE		EQU		4t
;  Invalid plane. 
NUMGRFXERRS		EQU		5t

spclgrfxerrs		TYPEDEF		SWORD

;  Constants used for specifying the various rasterops.
; 
RASTEROP_REP		EQU		0t
;  Replace. 
RASTEROP_NREP		EQU		1t
;  Invert and replace. 
RASTEROP_AND		EQU		2t
;  AND. 
RASTEROP_NAND		EQU		3t
;  Invert and AND. 
RASTEROP_OR		EQU		4t
;  OR. 
RASTEROP_NOR		EQU		5t
;  Invert and OR. 
RASTEROP_XOR		EQU		6t
;  XOR. 
RASTEROP_NXOR		EQU		7t
;  Invert and XOR. 
NUMRASTEROPS		EQU		8t

rasterop		TYPEDEF		SWORD

; ---------------------------------------------------------------------------
;  Structures.
; 
;  Structure used to represent a point on the coordinate plane.
; 
;    Note that coordinates are numbered such that (0, 0) is the upper left-hand
;      corner of the screen, and (XMax, YMax) is the lower right-hand corner of
;      the screen.  Tough luck, purists.
; 
;  X coordinate. 
;  Y coordinate. 
point		STRUCT 1t
x		WORD		?
y		WORD		?
point		ENDS

;  Structure used to represent a rectangular region on the coordinate plane.
; 
;  Minimum coordinate. 
;  Maximum coordinate. 
rect		STRUCT 1t
minCoord		point		<>
maxCoord		point		<>
rect		ENDS

;  Structure used to pass a command to, and receive completion status from,
;      vidfuncsx interrupt functions.  This structure is always the first
;      element of any interrupt 010H special function command structure.
; 
;    When interrupt 0x10 is invoked, AH must be loaded with a function number
;      defined by enumeration vidfuncsx, and CX:BX is loaded with a far pointer
;      to one of the following structures that begins with an int10cmndhdr
;      structure.  (CX contains the segment, BX contains the offset.)
; 
;  The command code. 
;  The error code. 
int10cmndhdr		STRUCT 1t
commandCode		BYTE		?
errorCode		BYTE		?
int10cmndhdr		ENDS

;  Structure used to inquire whether the special control functions code is
;      available.  (Interrupt 0x10 register AH == F_SPCLVIDCNTRL,
;      ctrlavailqinfo.commandHeader.commandCode == F_DISPCNTRLINFOQ.)
; 
;  Command/status information. 
;  Gets inverted if there's code to answer. 
;  Code revision level. 
ctrlavailqinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
toggleByte		BYTE		?
revisionLevel		WORD		?
ctrlavailqinfo		ENDS

;  Structure used to validate a display configuration inquiry.  (Interrupt
;      0x10 register AH == F_SPCLVIDCNTRL,
;      dispsetupchk.commandHeader.commandCode == F_DISPCHECKSETUP.)
; 
;  Command/status information. 
;  Number of nybbles per display line. (Input.) 
;  Number of lines on the display. (Input.) 
;  Number of planes to use. (1 or 2.) 
;  Number of paragraphs required for image buffer. (Output.) 
dispsetupchk		STRUCT 1t
commandHeader		int10cmndhdr		<>
nybblesPerLine		WORD		?
displayLines		WORD		?
numPlanes		BYTE		?
paragraphsReq		WORD		?
dispsetupchk		ENDS

;  Structure used to initialize the display.  (Interrupt 0x10 register AH ==
;      F_SPCLVIDCNTRL, dispinit.commandHeader.commandCode == F_DISPINIT.)
; 
;  Command/status information. 
;  Display dimensions in pixels. 
;  Number of nybbles per display line. 
;  Starting nybble of CL1 from start of each line. 
;  Ending nybble of CL1 from start of each line. 
;  Nybble offset of start of FLM from start of display buffer. 
;  Nybble offset of last byte of FLM from start of display buffer. 
;  Number of planes to use. (1 or 2.) 
;  The size of the buffer required to hold the entire LCD display image must
; 	     be determined by invoking interrupt 0x10 function number F_SPCLVIDCNTRL,
; 	     subfunction F_DISPCHECKSETUP (which uses structure dispsetupchk) and
; 	     examining the number returned in dispsetupchk.paragraphsReq.
; 	     Multiplying that number by 16 yields the number of bytes required to
; 	     contain the LCD display buffer.  The display buffer referenced by
; 	     .baseParagraph must be paragraph aligned in system memory.
; 	
;  Base paragraph of video buffer to be used. 
;  Invert the display. 
dispinit		STRUCT 1t
commandHeader		int10cmndhdr		<>
displayDim		point		<>
nybblesPerLine		WORD		?
cl1Start		WORD		?
cl1End		WORD		?
flmStartOffset		WORD		?
flmEndOffset		WORD		?
numPlanes		BYTE		?
baseParagraph		WORD		?
invertDisp		BYTE		?
dispinit		ENDS

;  Structure used to get and set the LCD display contrast.  (Interrupt 0x10
;      register AH == F_SPCLVIDCNTRL, contrastinfo.commandHeader.commandCode ==
;      F_DISPCONTRASTGET or F_DISPCONTRASTSET.)
; 
;  Command/status information. 
;  The display contrast value has a full scale value of 65535 and a minimum
; 	     value of 0.  A contrast setting of 32767 therefore gives a setting of
; 	     about 50 percent full scale.
; 	
;  The contrast value. 
contrastinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
displayContrast		WORD		?
contrastinfo		ENDS

;  Structure used to get and set the LCD display backlight state.  (Interrupt
;      0x10 register AH == F_SPCLVIDCNTRL,
;      backlitestateinfo.commandHeader.commandCode == F_DISPBKLTSTATEGET or
;      F_DISPBKLTSTATESET.)
; 
;  Command/status information. 
;  Non-zero for on. 
backlitestateinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
backliteOn		BYTE		?
backlitestateinfo		ENDS

;  Structure used to inquire whether or not the display is active and
;      available.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      dispavailqinfo.commandHeader.commandCode == F_GRFXDISPINFOQ.)
; 
;    Note that attempting to use any functions that access the display or
;      display hardware will probably result in undefined (i.e. system
;      crash-like) behavior if an invocation of function F_GRFXDISPINFOQ would
;      return with .isAvailable set to 0.  Before attempting to access the
;      display, interrupt 0x10 function number F_SPCLVIDCNTRL, subfunction
;      F_DISPINIT (which uses structure dispinit) should be called to ensure
;      that the LCD display is on-line.
; 
;  Command/status information. 
;  Gets inverted if there's code to answer. 
;  Availability flag - non-zero if the display is active. 
;  Code revision level. 
dispavailqinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
toggleByte		BYTE		?
isAvailable		BYTE		?
revisionLevel		WORD		?
dispavailqinfo		ENDS

;  Structure used to inquire about graphic display dimensions.  (Interrupt
;      0x10 register AH == F_SPCLVIDGRFX,
;      dispdimqinfo.commandHeader.commandCode == F_GRFXDISPDIMQ.)
; 
;  Command/status information. 
;  Maximum X, Y coordinates. 
;  Number of display planes. (Blink uses 2 planes.) 
dispdimqinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
dispDim		point		<>
numPlanes		BYTE		?
dispdimqinfo		ENDS

;  Structure used to get and set TTY region information.  (Interrupt 0x10
;      register AH == F_SPCLVIDGRFX, ttyregninfo.commandHeader.commandCode ==
;      F_GRFXTTYINFOGET or F_GRFXTTYINFOSET.)
; 
;  Command/status information. 
;  Upper left corner of the TTY region on the display. 
;  TTY region dimensions. 
;  The following information can refer to a user-supplied font somewhere in
; 	     system memory, or it can refer to one of the ROMBIOS-resident TTY fonts.
; 	     Information about ROMBIOS-resident TTY fonts can be obtained by invoking
; 	     interrupt 0x10 function number F_SPCLVIDCNTRL, subfunction
; 	     F_GRFXFONTINFO (which uses structure ttyfontinfo).
; 	
;  Width of a TTY character cell in pixels. 
;  Height of a TTY character cell in pixels. 
;  Number of bytes in a TTY character raster line. 
;  Number of bytes per TTY character. 
;  Number of characters in the TTY font. Must be at least 255 for TTY use. 
@t_sint100		TYPEDEF		FAR PTR BYTE
;  Pointer to the monospaced font to be used for TTY region. 
ttyregninfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
ttyUpperLeft		point		<>
ttyDim		point		<>
charWidth		BYTE		?
charHeight		BYTE		?
bytesPerLine		BYTE		?
bytesPerChar		BYTE		?
charsInFont		WORD		?
fontPtr		@t_sint100		?
ttyregninfo		ENDS

;  Structure used to get and set the TTY and graphics region fill patterns.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      fillpatinfo.commandHeader.commandCode == F_GRFXTTYPATGET,
;      F_GRFXTTYPATSET, F_GRFXPATGET, or F_GRFXPATSET.)
; 
;  Command/status information. 
@t_sint101		TYPEDEF		FAR PTR BYTE
;  Pointer to the 8-byte pattern buffer. 
fillpatinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
patPtr		@t_sint101		?
fillpatinfo		ENDS

;  Structure used to erase a rectangular region of the display.  (Interrupt
;      0x10 register AH == F_SPCLVIDGRFX, eraseinfo.commandHeader.commandCode
;      == F_GRFXERASEREGN.)  The erased region is filled with the fill pattern
;      set by interrupt 0x10 function F_SPCLVIDGRFX, subfunction F_GRFXPATSET
;      (which uses structure fillpatinfo).
; 
;  Command/status information. 
;  The region to be erased. 
eraserectinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
theRegion		rect		<>
eraserectinfo		ENDS

;  Structure used to inquire about and set the cursor display xable state.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      crsrxableinfo.commandHeader.commandCode == F_GRFXCRSRXABLQ or
;      F_GRFXCRSRXABL.)  Setting the cursor xable state also returns the
;      current setting of the cursor xable state in .cursorEnable.
; 
;  Command/status information. 
;  Cursor state flag. 
crsrxableinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
cursorEnable		BYTE		?
crsrxableinfo		ENDS

;  Structure used to draw a single dot on the display.  (Interrupt 0x10
;      register AH == F_SPCLVIDGRFX, drawdotinfo.commandHeader.commandCode ==
;      F_GRFXDRAWDOT.)
; 
;    .planeMask contains the mask of plane to be drawn to.  Setting bit 0 draws
;      to plane 0, setting bit 1 draws to plane 1, etc.  If no bits are set,
;      drawing is performed on all planes.  If a non-existent plane is
;      specified, an error is reported.
; 
;    Using M_RASTEROPBLINK to set the blink bit of .rasterOp will cause blink,
;      but only if more than one display plane is available and .planeMask is
;      set to 0x00 or specifies all planes.  The blink bit of .rasterOp is
;      ignored if only one display plane is available or .planeMask specifies
;      other than all planes.
; 
;  Command/status information. 
;  One point. 
;  The dot "color". (Non-zero for on, zero for off.) 
;  The rasterop (from enum rasterop) to be used. 
;  Drawing plane mask. 
drawdotinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
thePoint		point		<>
dotColor		BYTE		?
rasterOp		BYTE		?
planeMask		BYTE		?
drawdotinfo		ENDS

;  Structure used to draw a single dot-width line on the display.  (Interrupt
;      0x10 register AH == F_SPCLVIDGRFX,
;      drawline1info.commandHeader.commandCode == F_GRFXDRAWLINE.)
; 
;    .planeMask contains the mask of plane to be drawn to.  Setting bit 0 draws
;      to plane 0, setting bit 1 draws to plane 1, etc.  If no bits are set,
;      drawing is performed on all planes.  If a non-existent plane is
;      specified, an error is reported.
; 
;    Using M_RASTEROPBLINK to set the blink bit of .rasterOp will cause blink,
;      but only if more than one display plane is available and .planeMask is
;      set to 0x00 or specifies all planes.  The blink bit of .rasterOp is
;      ignored if only one display plane is available or .planeMask specifies
;      other than all planes.
; 
;  Command/status information. 
;  One point. 
;  The other point. 
;  The line "color". (Non-zero for on, zero for off.) 
;  Non-zero to skip drawing first dot. 
;  Non-zero to skip srawing last dot. 
;  The rasterop (from enum rasterop) to be used. 
;  Drawing plane mask. 
drawline1info		STRUCT 1t
commandHeader		int10cmndhdr		<>
startPoint		point		<>
endPoint		point		<>
lineColor		BYTE		?
skipFirstDot		BYTE		?
skipLastDot		BYTE		?
rasterOp		BYTE		?
planeMask		BYTE		?
drawline1info		ENDS

;  Structure used to bitBLT information from system memory to the LCD display
;      screen.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      bitbltinfo.commandHeader.commandCode == F_GRFXBITBLT.)
; 
;    .planeMask contains a mask that selects the LCD display destination plane.
;      Setting bit 0 draws to plane 0, setting bit 1 draws to plane 1, etc.  If
;      no bits are set, drawing is performed on all planes.  If a non-existent
;      plane is specified, an error is reported.
; 
;    Using M_RASTEROPBLINK to set the blink bit of .rasterOp will cause the
;      resulting image to blink, but only if more than one display plane is
;      available and .planeMask is set to 0x00 or specifies all planes.  The
;      blink bit of .rasterOp is ignored if only one display plane is available
;      or .planeMask specifies other than all planes.
; 
;    The following members must be initalized: .sourceRect, .sourcePitch,
;      .sourcePtr, .destPoint, .rasterOp, .planeMask.  .destPitch and .destPtr
;      are obsolete and exist only to maintain structure member alignment.
; 
;  Command/status information. 
;  The source region. 
;  Number of bytes per raster line in source. 
@t_sint102		TYPEDEF		FAR PTR BYTE
;  Pointer to source image. 
;  Upper left corner of destination region. 
;  (Obsolete.) 
@t_sint103		TYPEDEF		FAR PTR BYTE
;  (Obsolete.) 
;  The rasterop (from enum rasterop) to be used for the BLT. 
;  Drawing plane mask. 
bitbltinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
sourceRect		rect		<>
sourcePitch		WORD		?
sourcePtr		@t_sint102		?
destPoint		point		<>
destPitch		WORD		?
destPtr		@t_sint103		?
rasterOp		BYTE		?
planeMask		BYTE		?
bitbltinfo		ENDS

;  Structure used to bitBLT information from the LCD display screen to system
;      memory.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      unbitbltinfo.commandHeader.commandCode == F_GRFXUNBITBLT or
;      F_GRFXUNBITBLTB.)
; 
;    .planeMask contains the mask of the LCD display source plane.  Setting bit
;      0 reads from plane 0, setting bit 1 reads from plane 1, etc.  If no bits
;      are set, more that one bit is set, or if a non-existent plane is
;      specified, an error is reported.
; 
;    For F_GRFXUNBITBLT, the M_RASTEROPBLINK bit of .rasterOp is ignored.
; 
;  Command/status information. 
;  The destination region. 
;  Number of bytes per raster line in destination. 
@t_sint104		TYPEDEF		FAR PTR BYTE
;  Pointer to destination image. 
;  Upper left corner of source region. 
;  The rasterop (from enum rasterop) to be used for the BLT. 
;  Drawing plane mask. 
unbitbltinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
destRect		rect		<>
destPitch		WORD		?
destPtr		@t_sint104		?
sourcePoint		point		<>
rasterOp		BYTE		?
planeMask		BYTE		?
unbitbltinfo		ENDS

;  Structure used to erase the TTY or non-TTY regions of the screen.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      erasedispinfo.commandHeader.commandCode == F_GRFXERASETTY or
;      F_GRFXERASENONTTY.)
; 
;  Command/status information. 
erasedispinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
erasedispinfo		ENDS

;  Structure used to set the dimensions and location of the TTY region only.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      erasedispinfo.commandHeader.commandCode == F_GRFXSETTTYDIM.)
; 
;  Command/status information. 
;  Upper left corner of the TTY region on the display. 
;  TTY region dimensions. 
ttydiminfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
ttyUpperLeft		point		<>
ttyDim		point		<>
ttydiminfo		ENDS

;  Structure used to obtain information about the ROMBIOS-resident TTY fonts.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      ttyfontinfo.commandHeader.commandCode == F_GRFXFONTINFOGET.)
; 
;    The procedure for enumerating the TTY fonts is to initialize .fontNumber
;      to 0, and call interrupt 0x10 with AH == F_SPCLVIDGRFX and CX:BX
;      pointing to a ttyfontinfo structure.  After each successful call to
;      interrupt 0x10, .fontNumber is incremented and interrupt 0x10 is called
;      again.  When .commandHeader.errorCode == E_GRFXBADPARM, information for
;      each of the available ROMBIOS-resident fonts has been returned and
;      .fontNumber contains the number of ROMBIOS-resident fonts.
; 
;  Command/status information. 
;  Number of font for which information is to be returned. 
;  Returned width of a TTY character cell in pixels. 
;  Returned height of a TTY character cell in pixels. 
;  Returned number of bytes in a TTY character raster line. 
;  Returned number of bytes per TTY character. 
;  Returned number of characters in the TTY font. 
@t_sint105		TYPEDEF		FAR PTR BYTE
;  Returned pointer to the monospaced TTY font. 
ttyfontinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
fontNumber		BYTE		?
charWidth		BYTE		?
charHeight		BYTE		?
bytesPerLine		BYTE		?
bytesPerChar		BYTE		?
charsInFont		WORD		?
fontPtr		@t_sint105		?
ttyfontinfo		ENDS

;  Structure used to specify or inquire about the particulars of a TTY or
;      non-TTY font.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      attachfontinfo.commandHeader.commandCode == F_GRFXATTACHFONT,
;      F_GRFXATTACHNTFONT, F_GRFXTFONTINFOGET, or F_GRFXNTFONTINFOGET.)
; 
;    Note that a font being specified for TTY use (F_GRFXATTACHFONT) must
;      contain at least 256 character images (i.e. the entire IBM extended
;      ASCII character set).  A font being specified for non-TTY use
;      (F_GRFXATTACHNTFONT) can contain any non-zero number of character
;      images, provided the entire font image is no larger than 65520 bytes.
; 
;  Command/status information. 
;  Width of a character cell in pixels. 
;  Height of a character cell in pixels. 
;  Number of bytes in a character raster line. 
;  Number of bytes per character. 
;  Number of characters in the font. 
@t_sint106		TYPEDEF		FAR PTR BYTE
;  Pointer to the monospaced font. 
attachfontinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
charWidth		BYTE		?
charHeight		BYTE		?
bytesPerLine		BYTE		?
bytesPerChar		BYTE		?
charsInFont		WORD		?
fontPtr		@t_sint106		?
attachfontinfo		ENDS

;  Structure used to select a ROMBIOS-resident TTY font by its number.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      selfontinfo.commandHeader.commandCode == F_GRFXSELFONT.)
; 
;      When .commandHeader.errorCode == E_DISPBADPARM, .fontNumber contains the
;        number of ROMBIOS-resident fonts.
; 
;  Command/status information. 
;  Number of font for which information is to be returned. 
selfontinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
fontNumber		BYTE		?
selfontinfo		ENDS

;  Structure used to set the dimensions and location of the TTY region only.
;      (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      ttylocinfo.commandHeader.commandCode == F_GRFXSETTTYLOC.)
; 
;  Command/status information. 
;  The rectangular region of the display to be used as the TTY region. 
ttylocinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
ttyRegion		rect		<>
ttylocinfo		ENDS

;  Structure used to draw a non-TTY character at the specified pixel
;      coordinate.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      drawcharinfo.commandHeader.commandCode == F_GRFXDRAWCHAR.)
; 
;    .planeMask contains the mask of plane to be drawn to.  Setting bit 0 draws
;      to plane 0, setting bit 1 draws to plane 1, etc.  If no bits are set,
;      drawing is performed on all planes.  If a non-existent plane is
;      specified, an error is reported.
; 
;    Using M_RASTEROPBLINK to set the blink bit of .rasterOp will cause blink,
;      but only if more than one display plane is available and .planeMask is
;      set to 0x00 or specifies all planes.  The blink bit of .rasterOp is
;      ignored if only one display plane is available or .planeMask specifies
;      other than all planes.
; 
;    If an invalid character number is specified for the current non-TTY font,
;      the first character of that font is used as a slug.
; 
;  Command/status information. 
;  Upper left corner coordinate of character cell. 
;  Number of the character from the non-TTY font. 
;  The rasterop (from enum rasterop) to be used. 
;  Drawing plane mask. 
drawcharinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
destPoint		point		<>
theChar		WORD		?
rasterOp		BYTE		?
planeMask		BYTE		?
drawcharinfo		ENDS

;  Structure used to inquire how large a memory buffer is required to save
;      the specified region of the LCD display.  (Interrupt 0x10 register AH ==
;      F_SPCLVIDGRFX, dispregnsavesize.commandHeader.commandCode ==
;      F_GRFXSAVEREGNSIZEQ.)
; 
;  Command/status information. 
;  The region of interest. 
;  Number of bytes in the region to be saved. 
dispregnsavesize		STRUCT 1t
commandHeader		int10cmndhdr		<>
theRegion		rect		<>
regnSaveBufSize		DWORD		?
dispregnsavesize		ENDS

;  Structure used to save the specified region of the LCD display to a memory
;      buffer.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      dispregnsave.commandHeader.commandCode == F_GRFXSAVEREGN.)
; 
;  Command/status information. 
;  The region to be saved. 
@t_sint107		TYPEDEF		FAR PTR BYTE
;  Pointer to the buffer in which the display region is to be saved. 
dispregnsave		STRUCT 1t
commandHeader		int10cmndhdr		<>
theRegion		rect		<>
regnSavePtr		@t_sint107		?
dispregnsave		ENDS

;  Structure used to restore a region of the LCD display from a memory
;      buffer.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      dispregnunsave.commandHeader.commandCode == F_GRFXUNSAVEREGN.)
; 
;  Command/status information. 
@t_sint108		TYPEDEF		FAR PTR BYTE
;  Pointer to the buffer in which the display image has been saved. 
dispregnunsave		STRUCT 1t
commandHeader		int10cmndhdr		<>
regnSavePtr		@t_sint108		?
dispregnunsave		ENDS

;  Structure used to display a specific video plane.  (Interrupt 0x10
;      register AH == F_SPCLVIDGRFX, showplaneinfo.commandHeader.commandCode ==
;      F_GRFXSHOWPLANE.)
; 
;  Command/status information. 
;  Specific plane number to be displayed. -1 to return to blink mode. 
showplaneinfo		STRUCT 1t
commandHeader		int10cmndhdr		<>
planeNum		SBYTE		?
showplaneinfo		ENDS

;  Structure used to translate from TTY character region to absolute pixel
;      coordinates.  (Interrupt 0x10 register AH == F_SPCLVIDGRFX,
;      xlatettyregion.commandHeader.commandCode == F_GRFXTTYCHARLOCQ.)
; 
;  Command/status information. 
;  The region. Character coordinates input, pixel coordinates output. 
xlatettyregion		STRUCT 1t
commandHeader		int10cmndhdr		<>
theRegion		rect		<>
xlatettyregion		ENDS

; ---------------------------------------------------------------------------
; End of file ..\include\sint10.h

ENDIF

