{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$N-}    {No numeric coprocessor}
{$S-}    {No stack checking}

uses DOS,CRT;                         { must use TP 6 or later! }

{$I Serial.pas}                       { include low level serial routines }
{$I SENDRECV }                        { include common send + recv stuff }
{$I Hread}
{$DEFINE debug }

var
TheBaudRate : longint;
TheComPort : word;
FileLength : longint;
SendPacketRecord : PacketRecordType;
RecvPacketRecord : PacketRecordType;
TheFileName : FileNameString;
CurFile : file;
LongTime : longint;
ShortTime : longint;
RecvIndex : word;
SendBlockNumber : word;

{*****************************************************************************}

{*****************************************************************************}

procedure Bumout(str : string);
begin
  writeln;
  writeln(chr(7),str);
  Halt(2);
end;


function OpenForRead(name: string): boolean;
begin
  Assign(CurFile,name);
  {$I-}
  Reset(CurFile,1);
  {$I+}
  OpenForRead := (IOResult = 0);
end { OpenForRead };


{****************************************************************************}

procedure SendPacket(ptype : PacketType;plength : word; psequence : word);
var
index : word;
echochar : char;
begin
  ShortTime := 10000;
  delay(5); { let a (possibly slow) receiver get ready }
  SendPacketRecord.PType := byte(ptype);
  SendPacketRecord.Plength := plength;
  SendPacketRecord.PSequence := psequence;

  SendPacketRecord.CheckSum := CalcCheckSum(@SendPacketRecord);
  {$IFDEF Debug}
  write('SP: ');
  PrintPacketType(ptype);
  write(' Len = ',plength,' Seq = ',SendPacketRecord.PSequence,' CS = ',SendPacketRecord.CheckSum);
  writeln;
  {$ENDIF}
  for index := 0 to plength + HeaderSize-1 do
  begin
    PolledPutCOMChar(TheCOMPort,char(BufferType(SendPacketRecord)[index]));
    if PolledGetComCharWithTimeout(TheComport,echochar,ShortTime) = 0 then exit;
    if echochar <> AckChar then exit;
  end;
end;

procedure SendFileAvail;
begin
  FileSpecRecordType(SendPacketRecord.Data).FileLength := FileSize(CurFile);
  FileSpecRecordType(SendPacketRecord.Data).FileName := FileSpecRecordType(RecvPacketRecord.Data).FileName;
  SendPacket(FileAvail,FileSpecSize,0);
end;

procedure SendNoCanDo;
begin
  SendPacket(NoCanDo,0,0);
end;

procedure SendDone;
begin
  SendPacket(Done,0,0);
end;

function FileAvailQ : boolean;
begin
  FileAvailQ := false;
  {$IFDEF Debug}
  writeln('File enquiry');
  {$ENDIF}
  if OpenForRead(FileSpecRecordType(RecvPacketRecord.Data).FileName) then
  begin
    FileAvailQ := true;
  {$IFDEF Debug}
    writeln('File is Available');
  {$ENDIF}
  end;
end;

function RecvPacketWait : PacketType;
var
index : word;
newchar : char;
ptype : PacketType;
badchar : boolean;
rcs : word;
begin
  { kludge-o-tron }
  ShortTime := 10000;
  ptype := Bad;
  index := 0;
  { wait indefinately for first char }
  if PolledGetComCharWithKeyAbort(TheComport,newchar) then
  begin
    newchar := ReadKey;
    Bumout('Send aborted by user');
  end;
  BufferType(RecvPacketRecord)[index] := byte(newchar);
  PolledPutCOMChar(TheCOMPort,AckChar);
  index := index + 1;
  while (PolledGetComCharWithTimeout(TheComport,newchar,ShortTime) <> 0)
  and (index < sizeof(RecvPacketRecord)) do
  begin
    BufferType(RecvPacketRecord)[index] := byte(newchar);
    index := index + 1;
    PolledPutCOMChar(TheCOMPort,AckChar);
  end;
  rcs := CalcCheckSum(@RecvPacketRecord);
  ptype := PacketType(RecvPacketRecord.PType);
  if index = 0 then ptype := TimedOut;
  if (rcs <> RecvPacketRecord.CheckSum) and (ptype <> TimedOut) then  ptype := Bad;
  {$IFDEF Debug}
  if ptype = TimedOut then index := HeaderSize;
  write('RP: ');
  PrintPacketType(ptype);
  write(' Len = ',index - HeaderSize,' Seq = ',RecvPacketRecord.PSequence,' CS = ',RecvPacketRecord.CheckSum);
  writeln(' Calc CS = ',rcs);
  {$ENDIF}
  RecvPacketWait := ptype;
end;

procedure SendNewFileBlock;
var readsize : word;
begin
  blockread(CurFile,SendPacketRecord.Data,MaxLength,readsize);
  SendBlockNumber := SendBlockNumber +1;
  SendPacket(DataBlock,readsize,SendBlockNumber);
end;

procedure SendOldFileBlock;
begin
  { just resend old packet with same info}
  SendPacket(DataBlock,SendPacketRecord.PLength,SendPacketRecord.PSequence);
end;

procedure SendFileBlock(recbn : word);
begin
  if recbn > SendBlockNumber then SendNewFileBlock else SendOldFileBlock;
end;

{*****************************************************************************}


procedure SendFiles;
var
ptype : PacketType;
retrys : word;
begin

  ptype := Bad;
  while (ptype <> Quit) and not keypressed do
  begin
    ptype := RecvPacketWait;
    case ptype of
      FileEnq  :
      begin
        if FileAvailQ then SendFileAvail else SendNoCanDo;
        SendBlockNumber := 0;
        retrys := 0;
      end;
      Bad      :
      begin
        { don't answer bad blocks }
      end;
      SendRQ   : if not EOF(Curfile) then SendFileBlock(RecvPacketRecord.PSequence) else SendDone;
      Quit     :
      begin
        close(Curfile);
        if IOResult <> 0 then Writeln('Warning... file close failure',IOResult);
        writeln('File send complete');
        Bumout('Send aborted...');
      end;
      Done     :
      begin
        close(Curfile);
        if IOResult <> 0 then Writeln('Warning... file close failure',IOResult);
      end;
    end; {case}
  end; { while not quit }
end;


function GetParms : boolean;
var
retcode : integer;
begin
  TheBaudRate := 9600;
  GetParms := true;
  if not HexWordRead(ParamStr(1),TheComPort) then GetParms := false;
  if TheComPort > $3FF then GetParms := false;
  if TheComPort < $100 then GetParms := false;
  if length(ParamStr(2)) <> 0 then
  begin
    val(ParamStr(2),TheBaudRate,retcode);
    if retcode <> 0 then GetParms := false;
    if TheBaudRate < 1200 then GetParms := false;
    if TheBaudRate > 116000 then GetParms := false;
  end;
end;

procedure ComInit;
begin
  if ComPortThere(TheComPort) then
  begin
    if ComPortType(TheComPort) = CP16550 then EnableFIFOs(TheComPort);
    DefaultComInit(TheComPort);
    SetBaudRate(TheComPort,TheBaudRate);
  end
  else Bumout('No COM port found at specified address!');
end;

procedure Herald;
begin
  writeln;
  writeln('WSEND server ');
  writeln('Sends files to WRECV client');
  writeln('Press any key to abort...');
end;

procedure Usage;
begin
  writeln;
  writeln('USAGE: WSEND PPP [BR]');
  writeln('Where PPP is a hexadecimal COM port number');
  writeln('And BR is a optional baud rate');
  writeln('FUNCTION: Sends files to WRECV client');
end;

begin { main }
  DirectVideo := false;
  if GetParms then
  begin
    ComInit;
    Herald;
    SendFiles;
  end
  else usage;
end. { main };
