program WRECVCOM;
uses dos;
{$I beepy}
{$I serial}
{$I SENDRECV}
{$I parse}
{$I HREAD}
{{$DEFINE Debug}
const

CantWriteMess  =    'Can''t write file!';
ReceiveFailedMess = 'Receive failed!';

var
ConsoleBaudSelector : byte;
TheBaudRate : longint;
FileLength : longint;
SendPacketRecord : PacketRecordType;
RecvPacketRecord : PacketRecordType;
LocalFileName : FileNameString;
RemoteFileName : FileNameString;
CurFile : file;
LongTime : longint;
ShortTime : longint;
AbortSend : boolean;
SpinChar : char;
RecvBlockNumber : word;
ConOut : boolean;
TheComPort : word;

function OpenForWrite(name: string): boolean;
begin
  Assign(CurFile,name);
  {$I-}
  ReWrite(CurFile,1);
  {$I+}
  OpenForWrite := (IOResult = 0);
end { OpenForWrite };

function NextSpin: char;
begin
  case SpinChar of
    '|' : SpinChar := '/';
    '/' : SpinChar := '-';
    '-' : SpinChar := '\';
    '\' : SpinChar := '|';
    else SpinChar := '|';
  end;
  NextSpin := SpinChar;
end;

procedure HappyBeeps;
begin
  DoBeep(1000,50);
  DoBeep(1200,25);
  DoBeep(800,50);
  DoBeep(1200,25);
  DoBeep(1000,50);
  DoBeep(800,25);
end;

procedure BadBeeps;
begin
  DoBeep(800,50);
  DoBeep(1200,25);
end;

procedure Bumout(str : string);
begin
  writeln;
  writeln(str);
  BadBeeps;
  Halt(2);
end;

procedure ComInit;
begin
  LongTime := 150000;
  ShortTime := 10000;
  DefaultComInit(TheComport);
  SetBaudRate(TheComPort,TheBaudRate);
end;

function RecvPacket : PacketType;
var
index : word;
newchar : char;
ptype : PacketType;
timeout : longint;
badchar : boolean;
rcs : word;
begin
  ptype := Bad;
  index := 0;
  { enter loop with long timeout - to wait for xmit to start }
  timeout := LongTime;
  while (PolledGetCOMCharWithTimeout(TheComPort,newchar,timeout) <> 0 )
  and (index < sizeof(RecvPacketRecord)) do
  begin
    BufferType(RecvPacketRecord)[index] := byte(newchar);
    timeout := ShortTime;
    index := index + 1;
    PolledPutCOMChar(TheComPort,AckChar);
    { once packet receive is underway, shorten timeout }
  end;
  rcs := CalcCheckSum(@RecvPacketRecord);
  ptype := PacketType(RecvPacketRecord.PType);
  if index = 0 then ptype := TimedOut;
  if index = sizeof(RecvPacketRecord) then ptype :=BufferOvr;
  if (rcs <> RecvPacketRecord.CheckSum) and (ptype <> TimedOut) then  ptype := Bad;
  {$IFDEF Debug}
  if ptype = TimedOut then index := HeaderSize;
  write('RP: ');
  PrintPacketType(ptype);
  write(' Len = ',index - HeaderSize,' Seq = ',RecvPacketRecord.PSequence,' CS = ',RecvPacketRecord.CheckSum);
  writeln(' Calc CS = ',rcs);
  {$ENDIF}
  RecvPacket := ptype;
end;

procedure SendPacket(ptype : PacketType;plength : word;psequence : word);
var
index : word;
echochar : char;
begin
  ShortTime :=5000;
  SendPacketRecord.PType := byte(ptype);
  SendPacketRecord.Plength := plength;
  SendPacketRecord.PSequence := psequence;
  SendPacketRecord.CheckSum := CalcCheckSum(@SendPacketRecord);
  {$IFDEF Debug}
  write('SP: ');
  PrintPacketType(ptype);
  write(' Len = ',plength,' Seq = ',SendPacketRecord.PSequence,' CS = ',SendPacketRecord.CheckSum);
  writeln;
  {$ENDIF}
  for index := 0 to plength + HeaderSize-1 do
  begin
    PolledPutCOMChar(TheComPort,char(BufferType(SendPacketRecord)[index]));
    if PolledGetCOMCharWithTimeout(TheComPort,echochar,ShortTime) = 0 then exit;
    if echochar <> AckChar then exit;
  end;
end;

procedure SendFileEnq(fn:FileNameString);
begin
  FileSpecRecordType(SendPacketRecord.Data).FileName   := fn;
  FileSpecRecordType(SendPacketRecord.Data).FileLength := 0;
  SendPacket(FileEnq,FileSpecSize,0);
end;

procedure WriteFileBlock;
begin
  {$I-}
  blockwrite(CurFile,RecvPacketRecord.Data,RecvPacketRecord.Plength);
  RecvBlockNumber := RecvBlockNumber +1;
  if IOResult <> 0 Then Bumout(CantWriteMess);
  {$I+}
end;

procedure AskForData;
begin
  SendPacket(SendRQ,0,RecvBlockNumber);
end;

function RecvFile(rfn,lfn : FileNameString) : boolean;
var
ptype : PacketType;
retrys : word;
dataphase : boolean;

begin
  RecvFile := false;
  ptype := Startup;
  retrys := 0;
  dataphase := false;
  RecvBlockNumber := 0;
  begin
    if OpenForWrite(lfn) then
    begin
      while (ptype <> Done) do
      begin
        case ptype of
        DataBlock :
          begin
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),NextSpin,' ');
           {$ENDIF}
            WriteFileBlock;
            AskForData;
            retrys := 0;
          end;
        FileAvail :
          begin
            RecvBlockNumber := 1;
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),NextSpin,' ');
           {$ENDIF}
            AskForData;
            retrys := 0;
            dataphase := true;
          end;
        Bad:
          begin
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),'#',retrys);
           {$ENDIF}
            if dataphase then AskForData else SendFileEnq(rfn);
            retrys := retrys + 1;
            if retrys > MaxTrys then Bumout(ReceiveFailedMess);
          end;
        BufferOvr:
          begin
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),'B',retrys);
           {$ENDIF}
            if dataphase then AskForData else SendFileEnq(rfn);
            retrys := retrys + 1;
            if retrys > MaxTrys then Bumout(ReceiveFailedMess);
          end;
        NoCanDo:
          begin
            Bumout('File not available');
          end;
        TimedOut:
          begin
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),'T',retrys);
           {$ENDIF}
            if dataphase then AskForData else SendFileEnq(rfn);
            retrys := retrys + 1;
            if retrys > MaxTrys then Bumout(ReceiveFailedMess);
          end;
        Startup:
          begin
           {$IFNDEF Debug}
            if not ConOut then write(chr(13),'S');
           {$ENDIF}
            SendFileEnq(rfn);
          end;
        end {case};
        if ptype <> Done then ptype := RecvPacket;
      end { while ptype <> Done };
      if ptype = Done then
      begin
        RecvFile := true;
        {$I-}
        Close(CurFile);
        if IOResult <> 0 Then Bumout(CantWriteMess);
        {$I+}
        if AbortSend then SendPacket(Quit,0,0) else SendPacket(Done,0,0);
      end;
    end
    else Bumout(CantWriteMess);
  end;
  write(chr(13));
end;

function GetParms : boolean;
var
s : string;
retcode : integer;
begin
  ConOut := false;
  SpinChar := '|';
  AbortSend := false;
  GetParms := false;
  TheBaudRate := 9600;
  if ParamCount >2 then
  begin
    GetParms := true;
    RemoteFileName := ParamStr(1);
    LocalFileName := ParamStr(2);
    if upstring(LocalFileName) = 'CON' then ConOut := true;
    if upstring(LocalFileName) = 'CON:' then ConOut := true;
    if not HexWordRead(ParamStr(3),TheComPort) then GetParms := false;
    if TheComPort > $3FF then GetParms := false;
    if TheComPort < $100 then GetParms := false;
    if length(ParamStr(4)) <> 0 then
    begin
      s := ParamStr(4);
      val(ParamStr(4),TheBaudRate,retcode);
      if retcode = 0 then
      begin
        if TheBaudRate < 1200 then GetParms := false;
        if TheBaudRate > 116000 then GetParms := false;
      end;
      if upcase(s[1]) = 'Q' then AbortSend := true;
    end;
    s := ParamStr(5);
    if length(ParamStr(5)) > 0 then
    begin
      if upcase(s[1]) = 'Q' then AbortSend := true;
    end;
  end;
end;

procedure Usage;
begin
  writeln;
  writeln('USAGE: ');
  writeln('WRECVCOM RF LF PORT');
  writeln('[BR] [Q]');
  writeln('RF is remote file');
  writeln('LF is local file');
  writeln('BR is opt baud rate');
  writeln('Q opt aborts server');
  halt(2);
end;


begin {main}
  if not GetParms then Usage;
  ComInit;
  if RecvFile(RemoteFileName,LocalFileName) then
  begin
    if not ConOut then writeln('Receive OK');
  end
  else Bumout(ReceiveFailedMess);
  HappyBeeps;
end.
