program ADDEMO;  {A-D meter demo }
uses dos;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

{ include our pascal interface shims }
{$I WIDGET }
{$I GENERAL }

procedure DoReading;
const
numchans = 8;
vref = 3.75;
meterscale = 1000;
var
scaledata : real;
meterrect,metergrouprect,MeterBox : RectRec;
mtitle : string;
bgs : array[1..numchans] of BarGraphPtr;
meter : byte;
foochar : word;
begin
  SelectGraphicFontByNumber(0);
  { Start with the full screen rectangle }
  GetDispRect(MeterGrouprect);
  { make meters }
  InsetRect(metergrouprect,metergrouprect,-2,-4);
  InsetEdge(metergrouprect,metergrouprect,Top,-GState.GraphicFontInfo.CharHeight);
  { make room for individual label text on top }
  InsetEdge(metergrouprect,metergrouprect,Right,-GState.GraphicFontInfo.CharWidth*2);
  { make room for scale on right edge of group }
  for meter := 1 to NumChans do
  begin
    DivideRectX(metergrouprect,meterrect,numchans,meter,meter);
    { divide the remaining space between the meters }
    InsetRect(meterrect,meterrect,-1,0);
    { leave horizontal space between meters }
    bgs[meter] := VertBargraphCreate(meterrect,0,4000,1000,true);
    { Create bar graphs from meterrect, range 0 to 4000, tics every 500 }
    str(meter-1,mtitle);
    TitleRect(meterrect,Top,CenterJustify,mtitle);
  end;
  LabelBarGraph(bgs[NumChans], 0,'0V');
  LabelBarGraph(bgs[NumChans], 1,'1V');
  LabelBarGraph(bgs[NumChans], 2,'2V');
  LabelBarGraph(bgs[NumChans], 3,'3V');
  LabelBarGraph(bgs[NumChans], 4,'4V');
  { label every other tic on last meter }
  while not keypressed do
  begin
    for meter := 1 to NumChans do
    begin
      scaledata := ReadAtoD(meter-1);
      scaledata := vref*scaledata/65535; {This gets us to volts}
      BarGraphUpdate(bgs[meter],trunc(scaledata * 1000 + 0.5))
    end;
  end;
  foochar := ReadKey;
end;

begin
  InitGraphics;
  KeyPadOnly;
  DoReading;
  ExitGraphics;
end.
