
F_SPCLSYSCNTRL = 135;
{ Control-related functions.                                           }
F_SYSSETUP = 136;
{ Mesa internal use.                                                   }

{ Masks for use by membrane keyboard event handlers.                   }
M_MEMBBAKLITEONREQ =1;
{ Backlight turn-on request mask.                                      }
M_MEMBBEEPONREQ    =2;
{ Membrane keyclick control mask.                                      }

F_SYSCNTRLINFOQ = 0;
{ Get system control code revision level, etc.                         }
F_SYSKBSOURCEQ = 1;
{ Inquire about keyboard source.                                       }
F_SYSKBREROUTE = 2;
{ Select keyboard source.                                              }
F_SYSVIDEOSOURCEQ = 3;
{ Inquire about video destination.                                     }
F_SYSVIDEOREROUTE = 4;
{ Select video destination.                                            }
F_SYSSCUBAUDSEL = 5;
{ Set V40 SCU baud rate.                                               }
F_SYSSCUBAUDSELQ = 6;
{ Get current V40 SCU baud rate                                        }
F_SYSVIDEOHOOK = 7;
{ Get video code entry point address                                   }
F_SYSCPUREV = 8;
{ Get CPU card revision number                                         }
F_SYSSHAREDINFO = 9;
{ Mesa internal use.                                                   }
{                                                                      }
F_SYSSCANINFO = 10;
{ Set membrane keyboard event handler address. }
F_SYSSCANINFOQ = 11;
{ Get current membrane keyboard event handler address. }

F_SYSATODTYPE = 12;
{ Get local A-to-D converter type. }
F_SYSTEMPSENSE = 13;
{ Get current card temperature sensor readout. }
F_SYSATODRAWREAD = 14;
{ Raw read of A-to-D converter channel. }

F_SYSSCANINFOTP = 15;
{ Set touch panel event handler address, etc. }
F_SYSSCANINFOTPQ = 16;
{ Get current touch panel event handler address, etc.}

BAUDSEL_110 = 0;
{ 110 baud.                                                            }
BAUDSEL_150 = 1;
BAUDSEL_300 = 2;
BAUDSEL_600 = 3;
BAUDSEL_1200 = 4;
BAUDSEL_1800 = 5;
BAUDSEL_2000 = 6;
BAUDSEL_2400 = 7;
BAUDSEL_3600 = 8;
BAUDSEL_4800 = 9;
BAUDSEL_7200 = 10;
BAUDSEL_9600 = 11;
BAUDSEL_19200 = 12;
BAUDSEL_38400 = 13;
BAUDSEL_57600 = 14;
BAUDSEL_115000 = 15;
{ 115 Kbaud.                                                           }

{ Error codes returned by the functions selected by                    }
{ sysfuncsx.F_SPCLSYSCNTRL. (Control-related functions.)               }

E_SYSERRNONE = 0;
{ No error.                                                            }
E_SYSERRBADFUNC = 1;
{ Invalid subfunction number.                                          }
E_SYSERRBADPARM = 2;
{ Invalid parameter.                                                   }
E_SYSERRTIMEOUT = 3;
{ Timeout. probably due to system resource conflict. }

NUMSYSCNTRLERRS = 4;


{ Constants used for specifying various keyboard sources.              }

KBSRC_KEYBOARD = 0;
{ Take input from PC keyboard.                                         }
KBSRC_SERIAL = 1;
{ Take input from local serial channel.                                }
KBSRC_OFF = 2;
{ Turn off serial and PC keyboard input.                               }
NUMKBSOURCES = 3;

{ Constants used for specifying various video output destinations.     }

VIDDEST_VIDEO = 0;
{ Send video output to standard video.                                 }
VIDDEST_SERIAL = 1;
{ Send video output to local serial channel.                           }
VIDDEST_LCD = 2;
{ Send video output to local LCD display.                              }
VIDDEST_STUB = 3;
{ Send video output to black hole.                                     }

KSTATE_NONE = 0;
{ No event. }
KSTATE_MAKE = 1;
{ Key make event. }
KSTATE_BREAK = 2;
{ Key break event. }
KSTATE_REPEAT = 3;
{ Key repeat event. }

F_SYSSETUPINFOQ  =  0;
{  Get setup code revision level, etc.                                 }
F_SYSSETUPUSEDFLTS  =  1;
{  Initialize system configuration image to defaults.                  }
F_SYSSETUPSAVE  =  2;
{  Write system configuration image to non-volatile storage.           }
F_SYSSETUPIMAGEGET  =  3;
{  Get image of system configuration.                                  }
F_SYSSETUPIMAGEPUT  =  4;
{  Put image of system configuration.                                  }
F_SYSSETUPRSVD1  =  5;
{  Reserved.                                                           }
F_SYSSETUPGETPARM  =  6;
{  Get setup parameter.                                                }
F_SYSSETUPSETPARM  =  7;
{  Set setup parameter.                                                }

PARMNUM_DISPTYPE  =  0;
{  LCD display hardware type.                                          }
PARMNUM_DISPMODE  =  1;
{  LCD display visual characteristics.                                 }
PARMNUM_DISPXABLE  =  2;
{  LCD display xable.                                                  }
PARMNUM_DISPCONTRAST  =  3;
{  LCD display contrast.                                               }
